/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.session;

import akka.http.scaladsl.model.headers.HttpCookie;
import akka.http.scaladsl.model.headers.HttpCookie$;
import akka.http.scaladsl.server.AuthorizationFailedRejection$;
import com.softwaremill.session.ClientSessionManager;
import com.softwaremill.session.SessionResult;
import com.softwaremill.session.SessionResult$Corrupt$;
import com.softwaremill.session.SessionResult$Expired$;
import com.softwaremill.session.SessionUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public abstract class ClientSessionManager$class {
    public static HttpCookie createCookie(ClientSessionManager $this, Object data) {
        return $this.createCookieWithValue($this.encode(data));
    }

    public static HttpCookie createCookieWithValue(ClientSessionManager $this, String value) {
        return new HttpCookie($this.config().clientSessionCookieConfig().name(), value, (Option)None$.MODULE$, $this.config().clientSessionCookieConfig().maxAge(), $this.config().clientSessionCookieConfig().domain(), $this.config().clientSessionCookieConfig().path(), $this.config().clientSessionCookieConfig().secure(), $this.config().clientSessionCookieConfig().httpOnly(), HttpCookie$.MODULE$.apply$default$9());
    }

    public static String encode(ClientSessionManager $this, Object data) {
        String serialized = new StringBuilder().append((Object)"x").append((Object)$this.sessionSerializer().serialize(data)).toString();
        String withExpiry = (String)$this.config().clientSessionMaxAgeSeconds().fold((Function0)new Serializable($this, serialized){
            public static final long serialVersionUID = 0L;
            private final String serialized$1;

            public final String apply() {
                return this.serialized$1;
            }
            {
                this.serialized$1 = serialized$1;
            }
        }, (Function1)new Serializable($this, serialized){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientSessionManager $outer;
            private final String serialized$1;

            public final String apply(long maxAge) {
                long expiry = this.$outer.nowMillis() + maxAge * 1000L;
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)expiry), this.serialized$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.serialized$1 = serialized$1;
            }
        });
        String encrypted = $this.config().clientSessionEncryptData() ? $this.crypto().encrypt(withExpiry, $this.config().serverSecret()) : withExpiry;
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.crypto().sign(serialized, $this.config().serverSecret()), encrypted}));
    }

    public static SessionResult decode(ClientSessionManager $this, String data) {
        SessionResult<Nothing$> sessionResult;
        block4: {
            try {
                String[] splitted = data.split("-", 2);
                String decrypted = $this.config().clientSessionEncryptData() ? $this.crypto().decrypt(splitted[1], $this.config().serverSecret()) : splitted[1];
                Tuple2 tuple2 = ClientSessionManager$class.extractExpiry$1($this, decrypted);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    long expiry = tuple2._1$mcJ$sp();
                    String serialized = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)expiry), (Object)serialized);
                    long expiry2 = tuple23._1$mcJ$sp();
                    String serialized2 = (String)tuple23._2();
                    sessionResult = $this.nowMillis() > expiry2 ? SessionResult$Expired$.MODULE$ : (SessionUtil$.MODULE$.constantTimeEquals(splitted[0], $this.crypto().sign(serialized2, $this.config().serverSecret())) ? new SessionResult.DecodedFromCookie($this.sessionSerializer().deserialize(serialized2.substring(1))) : SessionResult$Corrupt$.MODULE$);
                    break block4;
                }
                throw new MatchError((Object)tuple2);
            }
            catch (Throwable throwable) {
                SessionResult$Corrupt$ sessionResult$Corrupt$;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                sessionResult = sessionResult$Corrupt$ = SessionResult$Corrupt$.MODULE$;
            }
        }
        return sessionResult;
    }

    public static AuthorizationFailedRejection$ cookieMissingRejection(ClientSessionManager $this) {
        return AuthorizationFailedRejection$.MODULE$;
    }

    private static final Tuple2 extractExpiry$1(ClientSessionManager $this, String data) {
        return (Tuple2)$this.config().clientSessionMaxAgeSeconds().fold((Function0)new Serializable($this, data){
            public static final long serialVersionUID = 0L;
            private final String data$1;

            public final Tuple2<Object, String> apply() {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE), (Object)this.data$1);
            }
            {
                this.data$1 = data$1;
            }
        }, (Function1)new Serializable($this, data){
            public static final long serialVersionUID = 0L;
            private final String data$1;

            public final Tuple2<Object, String> apply(long maxAge) {
                String[] splitted = this.data$1.split("-", 2);
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(splitted[0])).toLong()), (Object)splitted[1]);
            }
            {
                this.data$1 = data$1;
            }
        });
    }

    public static void $init$(ClientSessionManager $this) {
    }
}

