/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.jox;

import com.softwaremill.jox.CellState;
import com.softwaremill.jox.ContinuationMarker;
import com.softwaremill.jox.Segment;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.LockSupport;

final class Continuation {
    static final int RENDEZVOUS_SPINS;
    private final Thread creatingThread;
    private volatile Object data;
    private final Object payload;
    private static final VarHandle DATA;

    Continuation(Object payload) {
        this.payload = payload;
        this.creatingThread = Thread.currentThread();
    }

    boolean isSender() {
        return this.payload != null;
    }

    boolean tryResume(Object value) {
        boolean result = DATA.compareAndSet(this, null, value);
        LockSupport.unpark(this.creatingThread);
        return result;
    }

    Object await(Segment segment, int cellIndex, boolean isRendezvous) throws InterruptedException {
        int spinIterations;
        int n = spinIterations = isRendezvous ? RENDEZVOUS_SPINS : 0;
        while (this.data == null) {
            if (spinIterations > 0) {
                Thread.onSpinWait();
                --spinIterations;
                continue;
            }
            LockSupport.park();
            if (!Thread.interrupted()) continue;
            if (DATA.compareAndSet(this, null, ContinuationMarker.INTERRUPTED)) {
                boolean isSender = this.isSender();
                segment.setCell(cellIndex, (Object)(isSender ? CellState.INTERRUPTED_SEND : CellState.INTERRUPTED_RECEIVE));
                if (isSender) {
                    segment.cellInterruptedSender();
                } else {
                    segment.cellInterruptedReceiver();
                }
                throw new InterruptedException();
            }
            Thread.currentThread().interrupt();
        }
        return this.data;
    }

    Object getPayload() {
        return this.payload;
    }

    static {
        int nproc = Runtime.getRuntime().availableProcessors();
        RENDEZVOUS_SPINS = nproc == 1 ? 0 : (nproc <= 4 ? 128 : 1024);
        MethodHandles.Lookup l = MethodHandles.lookup();
        try {
            DATA = l.findVarHandle(Continuation.class, "data", Object.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

