/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.jox;

import com.softwaremill.jox.Channel;
import com.softwaremill.jox.ChannelClosed;
import com.softwaremill.jox.ChannelError;
import com.softwaremill.jox.DefaultClause;
import com.softwaremill.jox.RestartSelectMarker;
import com.softwaremill.jox.SelectClause;
import com.softwaremill.jox.SelectInstance;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;

public class Select {
    @SafeVarargs
    public static <U> U select(SelectClause<? extends U> ... clauses) throws InterruptedException {
        Object r = Select.selectOrClosed(clauses);
        if (r instanceof ChannelClosed) {
            ChannelClosed c = (ChannelClosed)r;
            throw c.toException();
        }
        return (U)r;
    }

    @SafeVarargs
    public static <U> Object selectOrClosed(SelectClause<? extends U> ... clauses) throws InterruptedException {
        Object r;
        do {
            if (clauses == null || clauses.length == 0) {
                throw new IllegalArgumentException("No clauses given");
            }
            if (!Arrays.stream(clauses).anyMatch(Objects::isNull)) continue;
            throw new IllegalArgumentException("Null clauses are not supported");
        } while ((r = Select.doSelectOrClosed(clauses)) == RestartSelectMarker.RESTART);
        return r;
    }

    @SafeVarargs
    private static <U> Object doSelectOrClosed(SelectClause<? extends U> ... clauses) throws InterruptedException {
        ChannelError anyError = Select.getAnyChannelInError(clauses);
        if (anyError != null) {
            return anyError;
        }
        boolean allRendezvous = Select.verifyChannelsUnique_getAreAllRendezvous(clauses);
        SelectInstance si = new SelectInstance(clauses.length);
        for (int i = 0; i < clauses.length; ++i) {
            SelectClause<U> clause = clauses[i];
            if (clause instanceof DefaultClause && i != clauses.length - 1) {
                throw new IllegalArgumentException("The default clause can only be the last one.");
            }
            if (!si.register(clause)) break;
        }
        return si.checkStateAndWait(allRendezvous);
    }

    private static boolean verifyChannelsUnique_getAreAllRendezvous(SelectClause<?>[] clauses) {
        boolean allRendezvous = true;
        for (int i = 0; i < clauses.length; ++i) {
            Channel<?> chi = clauses[i].getChannel();
            for (int j = i + 1; j < clauses.length; ++j) {
                if (chi != clauses[j].getChannel()) continue;
                throw new IllegalArgumentException("Channel " + String.valueOf(chi) + " is used in multiple clauses");
            }
            allRendezvous = allRendezvous && (chi == null || chi.isRendezvous);
        }
        return allRendezvous;
    }

    private static ChannelError getAnyChannelInError(SelectClause<?>[] clauses) {
        for (SelectClause<?> clause : clauses) {
            ChannelClosed closedForSend;
            Channel<?> ch = clause.getChannel();
            if (ch == null || !((closedForSend = clause.getChannel().closedForSend()) instanceof ChannelError)) continue;
            ChannelError ce = (ChannelError)closedForSend;
            return ce;
        }
        return null;
    }

    public static <T> SelectClause<T> defaultClause(T value) {
        return Select.defaultClause(() -> value);
    }

    public static <T> SelectClause<T> defaultClause(Supplier<T> callback) {
        return new DefaultClause<T>(callback);
    }
}

