/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.macwire.internals;

import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i4Q\u0001F\u000b\u0003/uAQ\u0001\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001A\u0002\u0013\u0005!\u0006C\u0004/\u0001\u0001\u0007I\u0011A\u0018\t\rU\u0002\u0001\u0015)\u0003,\u0011\u00151\u0004\u0001\"\u00018\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015i\u0007\u0001\"\u0001m\u0011\u00151\u0004\u0001\"\u0003o\u0011\u001d\u0011\bA1A\u0005\n)Baa\u001d\u0001!\u0002\u0013Y\u0003b\u0002;\u0001\u0005\u0004%IA\u000b\u0005\u0007k\u0002\u0001\u000b\u0011B\u0016\t\u000fY\u0004!\u0019!C\u0005U!1q\u000f\u0001Q\u0001\n-Bq\u0001\u001f\u0001C\u0002\u0013%!\u0006\u0003\u0004z\u0001\u0001\u0006Ia\u000b\u0002\u0007\u0019><w-\u001a:\u000b\u0005Y9\u0012!C5oi\u0016\u0014h.\u00197t\u0015\tA\u0012$A\u0004nC\u000e<\u0018N]3\u000b\u0005iY\u0012\u0001D:pMR<\u0018M]3nS2d'\"\u0001\u000f\u0002\u0007\r|Wn\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002+\u0005)\u0011\u000eZ3oiV\t1\u0006\u0005\u0002 Y%\u0011Q\u0006\t\u0002\u0004\u0013:$\u0018!C5eK:$x\fJ3r)\t\u00014\u0007\u0005\u0002 c%\u0011!\u0007\t\u0002\u0005+:LG\u000fC\u00045\u0007\u0005\u0005\t\u0019A\u0016\u0002\u0007a$\u0013'\u0001\u0004jI\u0016tG\u000fI\u0001\u0006CB\u0004H.\u001f\u000b\u0003aaBa!O\u0003\u0005\u0002\u0004Q\u0014aA7tOB\u0019qdO\u001f\n\u0005q\u0002#\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0005y*eBA D!\t\u0001\u0005%D\u0001B\u0015\t\u0011U%\u0001\u0004=e>|GOP\u0005\u0003\t\u0002\na\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011A\tI\u0001\u0006iJ\f7-\u001a\u000b\u0003a)Ca!\u000f\u0004\u0005\u0002\u0004Q\u0014!C<ji\"\u0014En\\2l+\ti\u0015\u000b\u0006\u0002O;R\u0011qJ\u0017\t\u0003!Fc\u0001\u0001B\u0003S\u000f\t\u00071KA\u0001U#\t!v\u000b\u0005\u0002 +&\u0011a\u000b\t\u0002\b\u001d>$\b.\u001b8h!\ty\u0002,\u0003\u0002ZA\t\u0019\u0011I\\=\t\rm;A\u00111\u0001]\u0003\u0015\u0011Gn\\2l!\ry2h\u0014\u0005\u0007s\u001d!\t\u0019\u0001\u001e\u0002\u0015]LG\u000f\u001b*fgVdG/\u0006\u0002aGR\u0011\u0011-\u001b\u000b\u0003E\u0012\u0004\"\u0001U2\u0005\u000bIC!\u0019A*\t\u000b\u0015D\u0001\u0019\u00014\u0002\u00155\u001cxMR1di>\u0014\u0018\u0010\u0005\u0003 O\nl\u0014B\u00015!\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0004\\\u0011\u0011\u0005\rA\u001b\t\u0004?m\u0012\u0017A\u00032fO&t'\t\\8dWR\t\u0001'\u0001\u0005f]\u0012\u0014En\\2l)\r\u0001t\u000e\u001d\u0005\u0007s-!\t\u0019\u0001\u001e\t\u000bE\\\u0001\u0019A\u0016\u0002\u0019\u0011,7/\u001b:fI2+g/\u001a7\u0002\u0017Q\u0013\u0016iQ#`\u0019\u00163V\tT\u0001\r)J\u000b5)R0M\u000bZ+E\nI\u0001\f\t\u0016\u0013UkR0M\u000bZ+E*\u0001\u0007E\u000b\n+vi\u0018'F-\u0016c\u0005%\u0001\u0007O\u001f~cujR0M\u000bZ+E*A\u0007O\u001f~cujR0M\u000bZ+E\nI\u0001\u0006Y\u00164X\r\\\u0001\u0007Y\u00164X\r\u001c\u0011")
public final class Logger {
    private int ident = 0;
    private final int TRACE_LEVEL;
    private final int DEBUG_LEVEL;
    private final int NO_LOG_LEVEL;
    private final int level = System.getProperty("macwire.trace") != null ? this.TRACE_LEVEL() : (System.getProperty("macwire.debug") != null ? this.DEBUG_LEVEL() : this.NO_LOG_LEVEL());

    public int ident() {
        return this.ident;
    }

    public void ident_$eq(int x$1) {
        this.ident = x$1;
    }

    public void apply(Function0<String> msg) {
        this.apply(msg, this.DEBUG_LEVEL());
    }

    public void trace(Function0<String> msg) {
        this.apply(msg, this.TRACE_LEVEL());
    }

    public <T> T withBlock(Function0<String> msg, Function0<T> block) {
        Object object;
        this.apply(msg);
        this.beginBlock();
        try {
            object = block.apply();
        }
        finally {
            this.endBlock();
        }
        return (T)object;
    }

    public <T> T withResult(Function0<T> block, Function1<T, String> msgFactory) {
        Object result = block.apply();
        this.apply((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> (String)msgFactory.apply(result));
        return (T)result;
    }

    public void beginBlock() {
        this.ident_$eq(this.ident() + 1);
    }

    public void endBlock() {
        this.ident_$eq(this.ident() - 1);
    }

    private void apply(Function0<String> msg, int desiredLevel) {
        if (desiredLevel >= this.level()) {
            String prefix = new StringOps(Predef$.MODULE$.augmentString("   ")).$times(this.ident());
            String logLevelName = desiredLevel == this.DEBUG_LEVEL() ? "debug" : "trace";
            Predef$.MODULE$.println((Object)new StringBuilder(3).append(prefix).append("[").append(logLevelName).append("] ").append(msg.apply()).toString());
            return;
        }
    }

    private int TRACE_LEVEL() {
        return this.TRACE_LEVEL;
    }

    private int DEBUG_LEVEL() {
        return this.DEBUG_LEVEL;
    }

    private int NO_LOG_LEVEL() {
        return this.NO_LOG_LEVEL;
    }

    private int level() {
        return this.level;
    }

    public Logger() {
        this.TRACE_LEVEL = 1;
        this.DEBUG_LEVEL = 2;
        this.NO_LOG_LEVEL = 3;
    }
}

