/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.macwire.internals;

import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;

public final class Logger {
    private int ident = 0;
    private final int TRACE_LEVEL;
    private final int DEBUG_LEVEL;
    private final int level;

    public Logger() {
        this.TRACE_LEVEL = 1;
        this.DEBUG_LEVEL = 2;
        int NO_LOG_LEVEL = 3;
        this.level = System.getProperty("macwire.trace") != null ? this.TRACE_LEVEL : (System.getProperty("macwire.debug") != null ? this.DEBUG_LEVEL : NO_LOG_LEVEL);
    }

    public int ident() {
        return this.ident;
    }

    public void ident_$eq(int x$1) {
        this.ident = x$1;
    }

    public void apply(Function0<String> msg) {
        this.apply(msg, this.DEBUG_LEVEL);
    }

    public void trace(Function0<String> msg) {
        this.apply(msg, this.TRACE_LEVEL);
    }

    public <T> T withBlock(Function0<String> msg, Function0<T> block) {
        Object object;
        this.apply(msg);
        this.beginBlock();
        try {
            object = block.apply();
        }
        finally {
            this.endBlock();
        }
        return (T)object;
    }

    public void beginBlock() {
        this.ident_$eq(this.ident() + 1);
    }

    public void endBlock() {
        this.ident_$eq(this.ident() - 1);
    }

    private void apply(Function0<String> msg, int desiredLevel) {
        if (desiredLevel >= this.level) {
            String prefix = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("   "), this.ident());
            String logLevelName = desiredLevel == this.DEBUG_LEVEL ? "debug" : "trace";
            Predef$.MODULE$.println((Object)new StringBuilder(3).append(prefix).append("[").append(logLevelName).append("] ").append(msg.apply()).toString());
            return;
        }
    }
}

