/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.sttp.akkahttp;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.event.LoggingAdapter;
import akka.http.javadsl.model.ContentType;
import akka.http.scaladsl.ClientTransport;
import akka.http.scaladsl.ClientTransport$;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.coding.Deflate$;
import akka.http.scaladsl.coding.Gzip$;
import akka.http.scaladsl.coding.NoCoding$;
import akka.http.scaladsl.model.BodyPartEntity;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpCharsets$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpHeader$;
import akka.http.scaladsl.model.HttpMessage;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethod$;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.Multipart;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.BasicHttpCredentials;
import akka.http.scaladsl.model.headers.Content$minusLength$;
import akka.http.scaladsl.model.headers.Content$minusType$;
import akka.http.scaladsl.model.headers.HttpCredentials;
import akka.http.scaladsl.model.headers.HttpEncoding;
import akka.http.scaladsl.model.headers.HttpEncodings$;
import akka.http.scaladsl.settings.ConnectionPoolSettings;
import akka.http.scaladsl.settings.ConnectionPoolSettings$;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.StreamConverters$;
import akka.util.ByteString;
import akka.util.ByteString$;
import com.softwaremill.sttp.BasicRequestBody;
import com.softwaremill.sttp.BasicResponseAs;
import com.softwaremill.sttp.ByteArrayBody;
import com.softwaremill.sttp.ByteBufferBody;
import com.softwaremill.sttp.FileBody;
import com.softwaremill.sttp.FutureMonad;
import com.softwaremill.sttp.HeaderNames$;
import com.softwaremill.sttp.IgnoreResponse$;
import com.softwaremill.sttp.InputStreamBody;
import com.softwaremill.sttp.MappedResponseAs;
import com.softwaremill.sttp.Method;
import com.softwaremill.sttp.Method$;
import com.softwaremill.sttp.MonadError;
import com.softwaremill.sttp.Multipart;
import com.softwaremill.sttp.MultipartBody;
import com.softwaremill.sttp.NoBody$;
import com.softwaremill.sttp.RequestBody;
import com.softwaremill.sttp.RequestT;
import com.softwaremill.sttp.Response;
import com.softwaremill.sttp.ResponseAs;
import com.softwaremill.sttp.ResponseAsByteArray$;
import com.softwaremill.sttp.ResponseAsFile;
import com.softwaremill.sttp.ResponseAsStream;
import com.softwaremill.sttp.ResponseAsString;
import com.softwaremill.sttp.ResponseMetadata;
import com.softwaremill.sttp.ResponseMetadata$;
import com.softwaremill.sttp.StreamBody;
import com.softwaremill.sttp.StringBody;
import com.softwaremill.sttp.SttpBackend;
import com.softwaremill.sttp.SttpBackendOptions;
import com.softwaremill.sttp.Uri;
import com.softwaremill.sttp.akkahttp.AkkaHttpBackend$;
import com.softwaremill.sttp.akkahttp.AkkaHttpClient;
import com.softwaremill.sttp.internal.SttpFile;
import com.softwaremill.sttp.package$;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\r\u0015d\u0001\u0002\u001a4\u0001qB\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\"A1\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003q\u0011!\u0019\bA!A!\u0002\u0013!\b\"C?\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017)Q!a\u0007\u0001\t5C\u0011\"!\b\u0001\u0005\u0004%Y!a\b\t\u000f\u0005\u0005\u0002\u0001)A\u0005C\"I\u00111\u0005\u0001C\u0002\u0013-\u0011Q\u0005\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002(!I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111\u0007\u0005\b\u0003k\u0001\u0001\u0015!\u0003x\u0011\u001d\t9\u0004\u0001C!\u0003sAq!! \u0001\t\u0003\ny\bC\u0004\u0002\b\u0002!I!!#\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bbBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005;\u0001A\u0011\u0002B\u0010\u0011\u001d\u0011i\u0003\u0001C\u0005\u0005_AqAa\u0011\u0001\t\u0013\u0011)\u0005C\u0004\u0003b\u0001!IAa\u0019\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003z!9!q\u0010\u0001\u0005\n\t\u0005\u0005b\u0002BD\u0001\u0011%!\u0011\u0012\u0005\b\u0005\u001b\u0003A\u0011\u0002BH\u0011\u001d\u0011)\n\u0001C!\u0005/;qAa(4\u0011\u0003\u0011\tK\u0002\u00043g!\u0005!1\u0015\u0005\b\u0003\u0013yB\u0011\u0001BS\u0011\u001d\u00119k\bC\u0005\u0005SCqA!/ \t\u0003\u0011Y\fC\u0005\u0003f~\t\n\u0011\"\u0001\u0003h\"I!Q`\u0010\u0012\u0002\u0013\u0005!q \u0005\n\u0007\u0007y\u0012\u0013!C\u0001\u0007\u000bA\u0011b!\u0003 #\u0003%\taa\u0003\t\u0013\r=q$%A\u0005\u0002\rE\u0001bBB\u000f?\u0011\u00051q\u0004\u0005\n\u0007_y\u0012\u0013!C\u0001\u0005OD\u0011b!\r #\u0003%\tAa@\t\u0013\rMr$%A\u0005\u0002\r\u0015\u0001\"CB\u001b?E\u0005I\u0011AB\u0006\u0011%\u00199dHI\u0001\n\u0003\u0019I\u0004C\u0004\u0004F}!\taa\u0012\t\u0013\rUs$%A\u0005\u0002\t\u001d\b\"CB,?E\u0005I\u0011AB\u0003\u0011%\u0019IfHI\u0001\n\u0003\u0019YFA\bBW.\f\u0007\n\u001e;q\u0005\u0006\u001c7.\u001a8e\u0015\t!T'\u0001\u0005bW.\f\u0007\u000e\u001e;q\u0015\t1t'\u0001\u0003tiR\u0004(B\u0001\u001d:\u00031\u0019xN\u001a;xCJ,W.\u001b7m\u0015\u0005Q\u0014aA2p[\u000e\u00011c\u0001\u0001>\u0007B\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t1\u0011I\\=SK\u001a\u0004B\u0001R#H\u001b6\tQ'\u0003\u0002Gk\tY1\u000b\u001e;q\u0005\u0006\u001c7.\u001a8e!\tA5*D\u0001J\u0015\tQu(\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001T%\u0003\r\u0019+H/\u001e:f!\u0011qUkV/\u000e\u0003=S!\u0001U)\u0002\u0011M\u001c\u0017\r\\1eg2T!AU*\u0002\rM$(/Z1n\u0015\u0005!\u0016\u0001B1lW\u0006L!AV(\u0003\rM{WO]2f!\tA6,D\u0001Z\u0015\tQ6+\u0001\u0003vi&d\u0017B\u0001/Z\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\t\u0003}yK!aX \u0003\u0007\u0005s\u00170A\u0006bGR|'oU=ti\u0016l\u0007C\u00012f\u001b\u0005\u0019'B\u00013T\u0003\u0015\t7\r^8s\u0013\t17MA\u0006BGR|'oU=ti\u0016l\u0017AA3d!\tA\u0015.\u0003\u0002k\u0013\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u001ci\u0016\u0014X.\u001b8bi\u0016\f5\r^8s'f\u001cH/Z7P]\u000ecwn]3\u0011\u0005yj\u0017B\u00018@\u0005\u001d\u0011un\u001c7fC:\fAa\u001c9ugB\u0011A)]\u0005\u0003eV\u0012!c\u0015;ua\n\u000b7m[3oI>\u0003H/[8og\u0006a2-^:u_6\u001cuN\u001c8fGRLwN\u001c)p_2\u001cV\r\u001e;j]\u001e\u001c\bc\u0001 vo&\u0011ao\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005atX\"A=\u000b\u0005i\\\u0018\u0001C:fiRLgnZ:\u000b\u0005Ac(BA?T\u0003\u0011AG\u000f\u001e9\n\u0005}L(AF\"p]:,7\r^5p]B{w\u000e\\*fiRLgnZ:\u0011\t\u0005\r\u0011QA\u0007\u0002g%\u0019\u0011qA\u001a\u0003\u001d\u0005[7.\u0019%uiB\u001cE.[3oi\u00061A(\u001b8jiz\"b\"!\u0004\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\u0002E\u0002\u0002\u0004\u0001AQ\u0001Y\u0004A\u0002\u0005DQaZ\u0004A\u0002!DQa[\u0004A\u00021DQa\\\u0004A\u0002ADQa]\u0004A\u0002QDa!`\u0004A\u0002\u0005\u0005!!A*\u0002\u0005\u0005\u001cX#A1\u0002\u0007\u0005\u001c\b%\u0001\u0007nCR,'/[1mSj,'/\u0006\u0002\u0002(A!\u0011\u0011FA\u0016\u001b\u0005\t\u0016bAA\u0017#\n\t\u0012i\u0019;pe6\u000bG/\u001a:jC2L'0\u001a:\u0002\u001b5\fG/\u001a:jC2L'0\u001a:!\u0003Y\u0019wN\u001c8fGRLwN\u001c)p_2\u001cV\r\u001e;j]\u001e\u001cX#A<\u0002/\r|gN\\3di&|g\u000eU8pYN+G\u000f^5oON\u0004\u0013\u0001B:f]\u0012,B!a\u000f\u0002JQ!\u0011QHA+!\u0011A5*a\u0010\u0011\u000b\u0011\u000b\t%!\u0012\n\u0007\u0005\rSG\u0001\u0005SKN\u0004xN\\:f!\u0011\t9%!\u0013\r\u0001\u00119\u00111J\bC\u0002\u00055#!\u0001+\u0012\u0007\u0005=S\fE\u0002?\u0003#J1!a\u0015@\u0005\u001dqu\u000e\u001e5j]\u001eDq!a\u0016\u0010\u0001\u0004\tI&A\u0001s!!\tY&a\u001d\u0002F\u0005ed\u0002BA/\u0003_rA!a\u0018\u0002n9!\u0011\u0011MA6\u001d\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA4w\u00051AH]8pizJ\u0011AO\u0005\u0003qeJ!AN\u001c\n\u0007\u0005ET'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0014q\u000f\u0002\b%\u0016\fX/Z:u\u0015\r\t\t(\u000e\t\u0004\u0003wBQ\"\u0001\u0001\u0002\u001bI,7\u000f]8og\u0016luN\\1e+\t\t\t\t\u0005\u0003E\u0003\u0007;\u0015bAACk\tQQj\u001c8bI\u0016\u0013(o\u001c:\u0002\u00195,G\u000f[8e)>\f5n[1\u0015\t\u0005-\u0015q\u0013\t\u0005\u0003\u001b\u000b\u0019*\u0004\u0002\u0002\u0010*\u0019\u0011\u0011S>\u0002\u000b5|G-\u001a7\n\t\u0005U\u0015q\u0012\u0002\u000b\u0011R$\b/T3uQ>$\u0007bBAM#\u0001\u0007\u00111T\u0001\u0002[B\u0019A)!(\n\u0007\u0005}UG\u0001\u0004NKRDw\u000eZ\u0001\rE>$\u0017P\u0012:p[\u0006[7.Y\u000b\u0005\u0003K\u000bY\u000b\u0006\u0006\u0002(\u00065\u0016qWAa\u0003/\u0004B\u0001S&\u0002*B!\u0011qIAV\t\u001d\tYE\u0005b\u0001\u0003\u001bBq!a,\u0013\u0001\u0004\t\t,\u0001\u0002seB9A)a-\u0002*\u0006e\u0014bAA[k\tQ!+Z:q_:\u001cX-Q:\t\u000f\u0005e&\u00031\u0001\u0002<\u0006\u0011\u0001N\u001d\t\u0005\u0003\u001b\u000bi,\u0003\u0003\u0002@\u0006=%\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0007bBAb%\u0001\u0007\u0011QY\u0001\u0013G\"\f'o]3u\rJ|W\u000eS3bI\u0016\u00148\u000f\u0005\u0003?k\u0006\u001d\u0007\u0003BAe\u0003#tA!a3\u0002NB\u0019\u00111M \n\u0007\u0005=w(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003'\f)N\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001f|\u0004bBAm%\u0001\u0007\u00111\\\u0001\bQ\u0016\fG-\u001a:t!\r!\u0015Q\\\u0005\u0004\u0003?,$\u0001\u0005*fgB|gn]3NKR\fG-\u0019;b\u0003=AW-\u00193feN4%o\\7BW.\fG\u0003BAs\u0003w\u0004b!a:\u0002r\u0006UXBAAu\u0015\u0011\tY/!<\u0002\u0013%lW.\u001e;bE2,'bAAx\u007f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0018\u0011\u001e\u0002\u0004'\u0016\f\bc\u0002 \u0002x\u0006\u001d\u0017qY\u0005\u0004\u0003s|$A\u0002+va2,'\u0007C\u0004\u0002:N\u0001\r!a/\u0002\u001bI,\u0017/^3tiR{\u0017i[6b)\u0011\u0011\tA!\u0005\u0011\r\t\r!q\u0001B\u0006\u001b\t\u0011)A\u0003\u0002[\u007f%!!\u0011\u0002B\u0003\u0005\r!&/\u001f\t\u0005\u0003\u001b\u0013i!\u0003\u0003\u0003\u0010\u0005=%a\u0003%uiB\u0014V-];fgRDq!a\u0016\u0015\u0001\u0004\u0011\u0019\u0002\r\u0003\u0003\u0016\te\u0001\u0003CA.\u0003g\u00129\"!\u001f\u0011\t\u0005\u001d#\u0011\u0004\u0003\r\u00057\u0011\t\"!A\u0001\u0002\u000b\u0005\u0011Q\n\u0002\u0004?\u0012\n\u0014!\u00045fC\u0012,'o\u001d+p\u0003.\\\u0017\r\u0006\u0003\u0003\"\t-\u0002C\u0002B\u0002\u0005\u000f\u0011\u0019\u0003\u0005\u0004\u0002h\u0006E(Q\u0005\t\u0005\u0003\u001b\u00139#\u0003\u0003\u0003*\u0005=%A\u0003%uiBDU-\u00193fe\"9\u0011\u0011\\\u000bA\u0002\u0005\u0015\u0018a\u0003;sCZ,'o]3Uef,BA!\r\u0003:Q!!1\u0007B\u001e!\u0019\u0011\u0019Aa\u0002\u00036A1\u0011q]Ay\u0005o\u0001B!a\u0012\u0003:\u00119\u00111\n\fC\u0002\u00055\u0003b\u0002B\u001f-\u0001\u0007!qH\u0001\u0002YB1\u0011q]Ay\u0005\u0003\u0002bAa\u0001\u0003\b\t]\u0012!D:fi\n{G-_(o\u0003.\\\u0017\r\u0006\u0005\u0003\u0002\t\u001d#1\u000bB/\u0011\u001d\t9f\u0006a\u0001\u0005\u0013\u0002DAa\u0013\u0003PAA\u00111LA:\u0005\u001b\nI\b\u0005\u0003\u0002H\t=C\u0001\u0004B)\u0005\u000f\n\t\u0011!A\u0003\u0002\u00055#aA0%e!9!QK\fA\u0002\t]\u0013\u0001\u00022pIf\u0004R\u0001\u0012B-\u0003sJ1Aa\u00176\u0005-\u0011V-];fgR\u0014u\u000eZ=\t\u000f\t}s\u00031\u0001\u0003\f\u0005\u0011\u0011M]\u0001\u001ea\u0006\u00148/Z\"p]R,g\u000e\u001e+za\u0016|%oT2uKR\u001cFO]3b[R!!Q\rB7!\u0019\u0011\u0019Aa\u0002\u0003hA!\u0011Q\u0012B5\u0013\u0011\u0011Y'a$\u0003\u0017\r{g\u000e^3oiRK\b/\u001a\u0005\b\u0003/B\u0002\u0019\u0001B8a\u0011\u0011\tH!\u001e\u0011\u0011\u0005m\u00131\u000fB:\u0003s\u0002B!a\u0012\u0003v\u0011a!q\u000fB7\u0003\u0003\u0005\tQ!\u0001\u0002N\t\u0019q\fJ\u001a\u0015\t\t\u0015$1\u0010\u0005\b\u0005{J\u0002\u0019AAc\u0003!\u0019G\u000fS3bI\u0016\u0014\u0018!D5t\u0007>tG/\u001a8u)f\u0004X\rF\u0002m\u0005\u0007CqA!\"\u001b\u0001\u0004\t)0\u0001\u0004iK\u0006$WM]\u0001\u0010SN\u001cuN\u001c;f]RdUM\\4uQR\u0019ANa#\t\u000f\t\u00155\u00041\u0001\u0002v\u0006\u0011B-Z2pI\u0016\f5n[1SKN\u0004xN\\:f)\u0011\tYL!%\t\u000f\tME\u00041\u0001\u0002<\u0006A!/Z:q_:\u001cX-A\u0003dY>\u001cX\r\u0006\u0002\u0003\u001aB\u0019aHa'\n\u0007\tuuH\u0001\u0003V]&$\u0018aD!lW\u0006DE\u000f\u001e9CC\u000e\\WM\u001c3\u0011\u0007\u0005\rqd\u0005\u0002 {Q\u0011!\u0011U\u0001\u0005[\u0006\\W\rF\u0007D\u0005W\u0013iKa,\u00032\nU&q\u0017\u0005\u0006A\u0006\u0002\r!\u0019\u0005\u0006O\u0006\u0002\r\u0001\u001b\u0005\u0006W\u0006\u0002\r\u0001\u001c\u0005\u0007\u0005g\u000b\u0003\u0019\u00019\u0002\u000f=\u0004H/[8og\")1/\ta\u0001i\"1Q0\ta\u0001\u0003\u0003\tQ!\u00199qYf$\"B!0\u0003B\n\r'\u0011\u001bBj)\r\u0019%q\u0018\u0005\bO\n\u0002\n\u0011q\u0001i\u0011!\u0011\u0019L\tI\u0001\u0002\u0004\u0001\b\"\u0003BcEA\u0005\t\u0019\u0001Bd\u0003I\u0019Wo\u001d;p[\"#H\u000f]:D_:$X\r\u001f;\u0011\ty*(\u0011\u001a\t\u0005\u0005\u0017\u0014i-D\u0001|\u0013\r\u0011ym\u001f\u0002\u0017\u0011R$\bo]\"p]:,7\r^5p]\u000e{g\u000e^3yi\"91O\tI\u0001\u0002\u0004!\b\"\u0003BkEA\u0005\t\u0019\u0001Bl\u0003%\u0019Wo\u001d;p[2{w\r\u0005\u0003?k\ne\u0007\u0003\u0002Bn\u0005Cl!A!8\u000b\u0007\t}7+A\u0003fm\u0016tG/\u0003\u0003\u0003d\nu'A\u0004'pO\u001eLgnZ!eCB$XM]\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u001e\u0016\u0004a\n-8F\u0001Bw!\u0011\u0011yO!?\u000e\u0005\tE(\u0002\u0002Bz\u0005k\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t]x(\u0001\u0006b]:|G/\u0019;j_:LAAa?\u0003r\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*\"a!\u0001+\t\t\u001d'1^\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u00111q\u0001\u0016\u0004i\n-\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r5!\u0006\u0002Bl\u0005W\fq\"\u00199qYf$C-\u001a4bk2$H%\u000e\u000b\u000b\u0007'\u0019)ba\u0006\u0004\u001a\rm!f\u00015\u0003l\"1!1W\u0014A\u0002ADqA!2(\u0001\u0004\u00119\rC\u0003tO\u0001\u0007A\u000fC\u0004\u0003V\u001e\u0002\rAa6\u0002!U\u001c\u0018N\\4BGR|'oU=ti\u0016lG\u0003DB\u0011\u0007K\u00199c!\u000b\u0004,\r5BcA\"\u0004$!9q\r\u000bI\u0001\u0002\bA\u0007\"\u00021)\u0001\u0004\t\u0007\u0002\u0003BZQA\u0005\t\u0019\u00019\t\u0013\t\u0015\u0007\u0006%AA\u0002\t\u001d\u0007bB:)!\u0003\u0005\r\u0001\u001e\u0005\n\u0005+D\u0003\u0013!a\u0001\u0005/\f!$^:j]\u001e\f5\r^8s'f\u001cH/Z7%I\u00164\u0017-\u001e7uII\n!$^:j]\u001e\f5\r^8s'f\u001cH/Z7%I\u00164\u0017-\u001e7uIM\n!$^:j]\u001e\f5\r^8s'f\u001cH/Z7%I\u00164\u0017-\u001e7uIQ\n!$^:j]\u001e\f5\r^8s'f\u001cH/Z7%I\u00164\u0017-\u001e7uIU\n!$^:j]\u001e\f5\r^8s'f\u001cH/Z7%I\u00164\u0017-\u001e7uIY\"Bba\u0005\u0004<\ru2qHB!\u0007\u0007BQ\u0001Y\u0017A\u0002\u0005DaAa-.\u0001\u0004\u0001\bb\u0002Bc[\u0001\u0007!q\u0019\u0005\u0006g6\u0002\r\u0001\u001e\u0005\b\u0005+l\u0003\u0019\u0001Bl\u0003-)8/\u001b8h\u00072LWM\u001c;\u0015\u0015\r%3QJB(\u0007#\u001a\u0019\u0006F\u0002D\u0007\u0017Bqa\u001a\u0018\u0011\u0002\u0003\u000f\u0001\u000eC\u0003a]\u0001\u0007\u0011\r\u0003\u0005\u00034:\u0002\n\u00111\u0001q\u0011\u001d\u0019h\u0006%AA\u0002QDa! \u0018A\u0002\u0005\u0005\u0011!F;tS:<7\t\\5f]R$C-\u001a4bk2$HEM\u0001\u0016kNLgnZ\"mS\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003U)8/\u001b8h\u00072LWM\u001c;%I\u00164\u0017-\u001e7uIU\"\"ba\u0005\u0004^\r}3\u0011MB2\u0011\u0015\u0001\u0017\u00071\u0001b\u0011\u0019\u0011\u0019,\ra\u0001a\")1/\ra\u0001i\"1Q0\ra\u0001\u0003\u0003\u0001")
public class AkkaHttpBackend
implements SttpBackend<Future, Source<ByteString, Object>> {
    private final ActorSystem actorSystem;
    private final ExecutionContext ec;
    private final boolean terminateActorSystemOnClose;
    private final SttpBackendOptions opts;
    private final AkkaHttpClient http;
    private final ActorSystem as;
    private final ActorMaterializer materializer;
    private final ConnectionPoolSettings connectionPoolSettings;
    private volatile byte bitmap$init$0;

    public static ExecutionContext usingClient$default$5(ActorSystem actorSystem, SttpBackendOptions sttpBackendOptions, Option<ConnectionPoolSettings> option, AkkaHttpClient akkaHttpClient) {
        return AkkaHttpBackend$.MODULE$.usingClient$default$5(actorSystem, sttpBackendOptions, option, akkaHttpClient);
    }

    public static Option<ConnectionPoolSettings> usingClient$default$3() {
        return AkkaHttpBackend$.MODULE$.usingClient$default$3();
    }

    public static SttpBackendOptions usingClient$default$2() {
        return AkkaHttpBackend$.MODULE$.usingClient$default$2();
    }

    public static SttpBackend<Future, Source<ByteString, Object>> usingClient(ActorSystem actorSystem, SttpBackendOptions sttpBackendOptions, Option<ConnectionPoolSettings> option, AkkaHttpClient akkaHttpClient, ExecutionContext executionContext) {
        return AkkaHttpBackend$.MODULE$.usingClient(actorSystem, sttpBackendOptions, option, akkaHttpClient, executionContext);
    }

    public static ExecutionContext usingActorSystem$default$6(ActorSystem actorSystem, SttpBackendOptions sttpBackendOptions, Option<HttpsConnectionContext> option, Option<ConnectionPoolSettings> option2, Option<LoggingAdapter> option3) {
        return AkkaHttpBackend$.MODULE$.usingActorSystem$default$6(actorSystem, sttpBackendOptions, option, option2, option3);
    }

    public static Option<LoggingAdapter> usingActorSystem$default$5() {
        return AkkaHttpBackend$.MODULE$.usingActorSystem$default$5();
    }

    public static Option<ConnectionPoolSettings> usingActorSystem$default$4() {
        return AkkaHttpBackend$.MODULE$.usingActorSystem$default$4();
    }

    public static Option<HttpsConnectionContext> usingActorSystem$default$3() {
        return AkkaHttpBackend$.MODULE$.usingActorSystem$default$3();
    }

    public static SttpBackendOptions usingActorSystem$default$2() {
        return AkkaHttpBackend$.MODULE$.usingActorSystem$default$2();
    }

    public static SttpBackend<Future, Source<ByteString, Object>> usingActorSystem(ActorSystem actorSystem, SttpBackendOptions sttpBackendOptions, Option<HttpsConnectionContext> option, Option<ConnectionPoolSettings> option2, Option<LoggingAdapter> option3, ExecutionContext executionContext) {
        return AkkaHttpBackend$.MODULE$.usingActorSystem(actorSystem, sttpBackendOptions, option, option2, option3, executionContext);
    }

    public static ExecutionContext apply$default$5(SttpBackendOptions sttpBackendOptions, Option<HttpsConnectionContext> option, Option<ConnectionPoolSettings> option2, Option<LoggingAdapter> option3) {
        return AkkaHttpBackend$.MODULE$.apply$default$5(sttpBackendOptions, option, option2, option3);
    }

    public static Option<LoggingAdapter> apply$default$4() {
        return AkkaHttpBackend$.MODULE$.apply$default$4();
    }

    public static Option<ConnectionPoolSettings> apply$default$3() {
        return AkkaHttpBackend$.MODULE$.apply$default$3();
    }

    public static Option<HttpsConnectionContext> apply$default$2() {
        return AkkaHttpBackend$.MODULE$.apply$default$2();
    }

    public static SttpBackendOptions apply$default$1() {
        return AkkaHttpBackend$.MODULE$.apply$default$1();
    }

    public static SttpBackend<Future, Source<ByteString, Object>> apply(SttpBackendOptions sttpBackendOptions, Option<HttpsConnectionContext> option, Option<ConnectionPoolSettings> option2, Option<LoggingAdapter> option3, ExecutionContext executionContext) {
        return AkkaHttpBackend$.MODULE$.apply(sttpBackendOptions, option, option2, option3, executionContext);
    }

    private ActorSystem as() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/jenkins/agent/workspace/Release/sttp-release/akka-http-backend/src/main/scala/com/softwaremill/sttp/akkahttp/AkkaHttpBackend.scala: 36");
        }
        return this.as;
    }

    private ActorMaterializer materializer() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/jenkins/agent/workspace/Release/sttp-release/akka-http-backend/src/main/scala/com/softwaremill/sttp/akkahttp/AkkaHttpBackend.scala: 37");
        }
        return this.materializer;
    }

    private ConnectionPoolSettings connectionPoolSettings() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/jenkins/agent/workspace/Release/sttp-release/akka-http-backend/src/main/scala/com/softwaremill/sttp/akkahttp/AkkaHttpBackend.scala: 39");
        }
        return this.connectionPoolSettings;
    }

    public <T> Future<Response<T>> send(RequestT<Object, T, Source<ByteString, Object>> r) {
        ConnectionPoolSettings connectionPoolSettings;
        Some some;
        SttpBackendOptions.Proxy p;
        ExecutionContext ec = this.ec;
        Option option = this.opts.proxy();
        if (option instanceof Some && !(p = (SttpBackendOptions.Proxy)(some = (Some)option).value()).ignoreProxy(((Uri)r.uri()).host())) {
            ClientTransport clientTransport;
            Option option2 = p.auth();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                SttpBackendOptions.ProxyAuth proxyAuth = (SttpBackendOptions.ProxyAuth)some2.value();
                clientTransport = ClientTransport$.MODULE$.httpsProxy(p.inetSocketAddress(), (HttpCredentials)new BasicHttpCredentials(proxyAuth.username(), proxyAuth.password()));
            } else if (None$.MODULE$.equals(option2)) {
                clientTransport = ClientTransport$.MODULE$.httpsProxy(p.inetSocketAddress());
            } else {
                throw new MatchError((Object)option2);
            }
            ClientTransport clientTransport2 = clientTransport;
            connectionPoolSettings = this.connectionPoolSettings().withTransport(clientTransport2);
        } else {
            connectionPoolSettings = this.connectionPoolSettings();
        }
        ConnectionPoolSettings connectionPoolSettingsWithProxy = connectionPoolSettings;
        ConnectionPoolSettings settings = connectionPoolSettingsWithProxy.withUpdatedConnectionSettings((Function1 & Serializable)x$2 -> x$2.withIdleTimeout(r.options().readTimeout()));
        return Future$.MODULE$.fromTry(this.requestToAkka(r).flatMap((Function1 & Serializable)x$3 -> this.setBodyOnAkka(r, (RequestBody<Source<ByteString, Object>>)r.body(), (HttpRequest)x$3))).flatMap((Function1 & Serializable)request -> $this.http.singleRequest((HttpRequest)request, settings), ec).flatMap((Function1 & Serializable)hr -> {
            int code = hr.status().intValue();
            String statusText = hr.status().reason();
            Seq<Tuple2<String, String>> headers = this.headersFromAkka((HttpResponse)hr);
            Option charsetFromHeaders = headers.collectFirst((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String string = (String)A1._1();
                        String value = (String)A1._2();
                        String string2 = HeaderNames$.MODULE$.ContentType();
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            object = value;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    Tuple2<String, String> tuple2 = x1;
                    if (tuple2 == null) return false;
                    String string = (String)tuple2._1();
                    String string2 = HeaderNames$.MODULE$.ContentType();
                    String string3 = string;
                    if (string2 != null) {
                        if (!string2.equals(string3)) return false;
                        return true;
                    }
                    if (string3 == null) return true;
                    return false;
                }
            }).flatMap((Function1 & Serializable)ct -> com.softwaremill.sttp.internal.package$.MODULE$.encodingFromContentType(ct));
            ResponseMetadata responseMetadata = ResponseMetadata$.MODULE$.apply(headers, code, statusText);
            Future body = BoxesRunTime.unboxToBoolean((Object)r.options().parseResponseIf().apply((Object)responseMetadata)) ? this.bodyFromAkka(r.response(), this.decodeAkkaResponse((HttpResponse)hr), (Option<String>)charsetFromHeaders, responseMetadata).map((Function1 & Serializable)x$4 -> scala.package$.MODULE$.Right().apply(x$4), ec) : this.bodyFromAkka(package$.MODULE$.asByteArray(), this.decodeAkkaResponse((HttpResponse)hr), (Option<String>)charsetFromHeaders, responseMetadata).map((Function1 & Serializable)x$5 -> scala.package$.MODULE$.Left().apply(x$5), ec);
            return body.map((Function1 & Serializable)x$6 -> new Response(x$6, code, statusText, headers, (List)Nil$.MODULE$), ec);
        }, ec);
    }

    public MonadError<Future> responseMonad() {
        return new FutureMonad(this.ec);
    }

    private HttpMethod methodToAkka(String m) {
        HttpMethod httpMethod;
        String string = m;
        String string2 = Method$.MODULE$.GET();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            httpMethod = HttpMethods$.MODULE$.GET();
        } else {
            String string4 = Method$.MODULE$.HEAD();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                httpMethod = HttpMethods$.MODULE$.HEAD();
            } else {
                String string6 = Method$.MODULE$.POST();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    httpMethod = HttpMethods$.MODULE$.POST();
                } else {
                    String string8 = Method$.MODULE$.PUT();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        httpMethod = HttpMethods$.MODULE$.PUT();
                    } else {
                        String string10 = Method$.MODULE$.DELETE();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            httpMethod = HttpMethods$.MODULE$.DELETE();
                        } else {
                            String string12 = Method$.MODULE$.OPTIONS();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                httpMethod = HttpMethods$.MODULE$.OPTIONS();
                            } else {
                                String string14 = Method$.MODULE$.PATCH();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    httpMethod = HttpMethods$.MODULE$.PATCH();
                                } else {
                                    String string16 = Method$.MODULE$.CONNECT();
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                        httpMethod = HttpMethods$.MODULE$.CONNECT();
                                    } else {
                                        String string18 = Method$.MODULE$.TRACE();
                                        String string19 = string;
                                        httpMethod = !(string18 != null ? !string18.equals(string19) : string19 != null) ? HttpMethods$.MODULE$.TRACE() : HttpMethod$.MODULE$.custom(m);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return httpMethod;
    }

    private <T> Future<T> bodyFromAkka(ResponseAs<T, Source<ByteString, Object>> rr, HttpResponse hr, Option<String> charsetFromHeaders, ResponseMetadata headers) {
        Future future;
        ExecutionContext ec = this.ec;
        ResponseAs<T, Source<ByteString, Object>> responseAs = rr;
        if (responseAs instanceof MappedResponseAs) {
            MappedResponseAs mappedResponseAs = (MappedResponseAs)responseAs;
            BasicResponseAs raw = mappedResponseAs.raw();
            Function2 g = mappedResponseAs.g();
            future = this.bodyFromAkka((ResponseAs<T, Source<ByteString, Object>>)raw, hr, charsetFromHeaders, headers).map((Function1 & Serializable)t -> g.apply(t, (Object)headers), ec);
        } else if (IgnoreResponse$.MODULE$.equals(responseAs)) {
            hr.entity().dataBytes().runWith((Graph)Sink$.MODULE$.ignore(), (Materializer)this.materializer());
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else if (responseAs instanceof ResponseAsString) {
            ResponseAsString responseAsString = (ResponseAsString)responseAs;
            String enc = responseAsString.encoding();
            future = this.asByteArray$1(hr, ec).map((Function1 & Serializable)x$10 -> new String((byte[])x$10, (String)charsetFromHeaders.getOrElse((Function0 & Serializable)() -> enc)), ec);
        } else if (ResponseAsByteArray$.MODULE$.equals(responseAs)) {
            future = this.asByteArray$1(hr, ec);
        } else if (responseAs instanceof ResponseAsStream) {
            ResponseAsStream responseAsStream = (ResponseAsStream)responseAs;
            future = Future$.MODULE$.successful(responseAsStream.responseIsStream().apply((Object)hr.entity().dataBytes()));
        } else if (responseAs instanceof ResponseAsFile) {
            ResponseAsFile responseAsFile = (ResponseAsFile)responseAs;
            SttpFile file = responseAsFile.output();
            boolean overwrite = responseAsFile.overwrite();
            future = this.saved$1(file.toFile(), overwrite, hr).map((Function1 & Serializable)x$11 -> file, ec);
        } else {
            throw new MatchError(responseAs);
        }
        return future;
    }

    private Seq<Tuple2<String, String>> headersFromAkka(HttpResponse hr) {
        Tuple2 ch = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ContentType()), (Object)hr.entity().contentType().toString());
        Option cl = hr.entity().contentLengthOption().map((Function1 & Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ContentLength()), (Object)((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$12))).toString()));
        Seq other = (Seq)hr.headers().map((Function1 & Serializable)h -> new Tuple2((Object)h.name(), (Object)h.value()));
        Tuple2 tuple2 = ch;
        return ((List)cl.toList().$plus$plus((IterableOnce)other)).$colon$colon((Object)tuple2);
    }

    private Try<HttpRequest> requestToAkka(RequestT<Object, ?, Source<ByteString, Object>> r) {
        akka.http.scaladsl.model.Uri x$1 = Uri$.MODULE$.apply(((Uri)r.uri()).toString());
        HttpMethod x$2 = this.methodToAkka(((Method)r.method()).m());
        Seq x$3 = HttpRequest$.MODULE$.apply$default$3();
        RequestEntity x$4 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$5 = HttpRequest$.MODULE$.apply$default$5();
        HttpRequest ar = HttpRequest$.MODULE$.apply(x$2, x$1, x$3, x$4, x$5);
        return this.headersToAkka((Seq<Tuple2<String, String>>)r.headers()).map((Function1 & Serializable)headers -> ar.withHeaders(headers));
    }

    private Try<Seq<HttpHeader>> headersToAkka(Seq<Tuple2<String, String>> headers) {
        Failure failure;
        Seq parsed = (Seq)((IterableOps)((IterableOps)headers.filterNot((Function1 & Serializable)header -> BoxesRunTime.boxToBoolean((boolean)this.isContentType((Tuple2<String, String>)header)))).filterNot((Function1 & Serializable)header -> BoxesRunTime.boxToBoolean((boolean)this.isContentLength((Tuple2<String, String>)header)))).map((Function1 & Serializable)h -> HttpHeader$.MODULE$.parse((String)h._1(), (String)h._2(), HttpHeader$.MODULE$.parse$default$3()));
        Seq errors = (Seq)parsed.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends HttpHeader.ParsingResult, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof HttpHeader.ParsingResult$.Error) {
                    HttpHeader.ParsingResult$.Error error = (HttpHeader.ParsingResult$.Error)A1;
                    ErrorInfo e = error.error();
                    object = e;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(HttpHeader.ParsingResult x1) {
                HttpHeader.ParsingResult parsingResult = x1;
                boolean bl = parsingResult instanceof HttpHeader.ParsingResult$.Error;
                return bl;
            }
        });
        if (errors.isEmpty()) {
            Seq headers2 = (Seq)parsed.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends HttpHeader.ParsingResult, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof HttpHeader.ParsingResult$.Ok) {
                        HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)A1;
                        HttpHeader h = ok.header();
                        object = h;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(HttpHeader.ParsingResult x2) {
                    HttpHeader.ParsingResult parsingResult = x2;
                    boolean bl = parsingResult instanceof HttpHeader.ParsingResult$.Ok;
                    return bl;
                }
            });
            failure = new Success((Object)headers2.toList());
        } else {
            failure = new Failure((Throwable)new RuntimeException(new StringBuilder(22).append("Cannot parse headers: ").append(errors).toString()));
        }
        return failure;
    }

    private <T> Try<Seq<T>> traverseTry(Seq<Try<T>> l) {
        Seq seq;
        Seq fs;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = l.partition((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isSuccess()));
                if (tuple2 == null) break block2;
                Seq ss = (Seq)tuple2._1();
                fs = (Seq)tuple2._2();
                if (!(ss instanceof Seq)) break block2;
                seq = ss;
                if (fs instanceof Seq) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        Seq seq2 = fs;
        Tuple2 tuple2 = new Tuple2((Object)seq, (Object)seq2);
        Tuple2 tuple22 = tuple2;
        Seq ss = (Seq)tuple22._1();
        Seq fs2 = (Seq)tuple22._2();
        return fs2.isEmpty() ? new Success(ss.map((Function1 & Serializable)x$15 -> x$15.get())) : new Failure(((Failure)fs2.head()).exception());
    }

    private Try<HttpRequest> setBodyOnAkka(RequestT<Object, ?, Source<ByteString, Object>> r, RequestBody<Source<ByteString, Object>> body, HttpRequest ar) {
        return this.parseContentTypeOrOctetStream(r).flatMap((Function1 & Serializable)ct -> {
            Success success;
            RequestBody requestBody = body;
            if (NoBody$.MODULE$.equals(requestBody)) {
                success = new Success((Object)ar);
            } else if (requestBody instanceof StringBody) {
                StringBody stringBody = (StringBody)requestBody;
                String b = stringBody.s();
                String encoding = stringBody.encoding();
                success = new Success((Object)ar.withEntity((ContentType)AkkaHttpBackend.ctWithEncoding$1(ct, encoding), b.getBytes(encoding)));
            } else if (requestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)requestBody;
                byte[] b = byteArrayBody.b();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, b)));
            } else if (requestBody instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = (ByteBufferBody)requestBody;
                ByteBuffer b = byteBufferBody.b();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b))));
            } else if (requestBody instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)requestBody;
                InputStream b = inputStreamBody.b();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> b, StreamConverters$.MODULE$.fromInputStream$default$2()))));
            } else if (requestBody instanceof FileBody) {
                FileBody fileBody = (FileBody)requestBody;
                SttpFile b = fileBody.f();
                success = new Success((Object)ar.withEntity((ContentType)ct, b.toPath()));
            } else if (requestBody instanceof StreamBody) {
                StreamBody streamBody = (StreamBody)requestBody;
                Source s = (Source)streamBody.s();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, s)));
            } else if (requestBody instanceof MultipartBody) {
                MultipartBody multipartBody = (MultipartBody)requestBody;
                Seq ps = multipartBody.parts();
                success = this.traverseTry((Seq)ps.map((Function1 & Serializable)mp -> this.toBodyPart$1((Multipart)mp))).map((Function1 & Serializable)bodyParts -> ar.withEntity(Multipart.FormData$.MODULE$.apply(bodyParts).toEntity()));
            } else {
                throw new MatchError((Object)requestBody);
            }
            return success;
        });
    }

    private Try<akka.http.scaladsl.model.ContentType> parseContentTypeOrOctetStream(RequestT<Object, ?, Source<ByteString, Object>> r) {
        return this.parseContentTypeOrOctetStream((Option<String>)r.headers().find((Function1 & Serializable)header -> BoxesRunTime.boxToBoolean((boolean)this.isContentType((Tuple2<String, String>)header))).map((Function1 & Serializable)x$16 -> (String)x$16._2()));
    }

    private Try<akka.http.scaladsl.model.ContentType> parseContentTypeOrOctetStream(Option<String> ctHeader) {
        return (Try)ctHeader.map((Function1 & Serializable)ct -> (Try)ContentType$.MODULE$.parse(ct).fold((Function1 & Serializable)errors -> new Failure((Throwable)new RuntimeException(new StringBuilder(27).append("Cannot parse content type: ").append(errors).toString())), (Function1 & Serializable)x$17 -> new Success(x$17))).getOrElse((Function0 & Serializable)() -> new Success((Object)ContentTypes$.MODULE$.application$divoctet$minusstream()));
    }

    private boolean isContentType(Tuple2<String, String> header) {
        return ((String)header._1()).toLowerCase().contains(Content$minusType$.MODULE$.lowercaseName());
    }

    private boolean isContentLength(Tuple2<String, String> header) {
        return ((String)header._1()).toLowerCase().contains(Content$minusLength$.MODULE$.lowercaseName());
    }

    private HttpResponse decodeAkkaResponse(HttpResponse response) {
        Gzip$ gzip$;
        HttpEncoding httpEncoding = response.encoding();
        HttpEncoding httpEncoding2 = HttpEncodings$.MODULE$.gzip();
        HttpEncoding httpEncoding3 = httpEncoding;
        if (!(httpEncoding2 != null ? !httpEncoding2.equals(httpEncoding3) : httpEncoding3 != null)) {
            gzip$ = Gzip$.MODULE$;
        } else {
            HttpEncoding httpEncoding4 = HttpEncodings$.MODULE$.deflate();
            HttpEncoding httpEncoding5 = httpEncoding;
            if (!(httpEncoding4 != null ? !httpEncoding4.equals(httpEncoding5) : httpEncoding5 != null)) {
                gzip$ = Deflate$.MODULE$;
            } else {
                HttpEncoding httpEncoding6 = HttpEncodings$.MODULE$.identity();
                HttpEncoding httpEncoding7 = httpEncoding;
                if (!(httpEncoding6 != null ? !httpEncoding6.equals(httpEncoding7) : httpEncoding7 != null)) {
                    gzip$ = NoCoding$.MODULE$;
                } else {
                    throw new UnsupportedEncodingException(new StringBuilder(22).append("Unsupported encoding: ").append(httpEncoding).toString());
                }
            }
        }
        Gzip$ decoder = gzip$;
        return (HttpResponse)decoder.decodeMessage((HttpMessage)response);
    }

    public void close() {
        BoxedUnit boxedUnit = this.terminateActorSystemOnClose ? this.actorSystem.terminate() : BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
    }

    private final Future asByteArray$1(HttpResponse hr$1, ExecutionContext ec$2) {
        return hr$1.entity().dataBytes().runFold((Object)ByteString$.MODULE$.apply(""), (Function2 & Serializable)(x$7, x$8) -> x$7.$plus$plus(x$8), (Materializer)this.materializer()).map((Function1 & Serializable)x$9 -> (byte[])x$9.toArray((ClassTag)ClassTag$.MODULE$.Byte()), ec$2);
    }

    private final Future saved$1(File file, boolean overwrite, HttpResponse hr$1) {
        Object object;
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            object = BoxesRunTime.boxToBoolean((boolean)file.createNewFile());
        } else {
            if (!overwrite) {
                throw new IOException(new StringBuilder(37).append("File ").append(file.getAbsolutePath()).append(" exists - overwriting prohibited").toString());
            }
            object = BoxedUnit.UNIT;
        }
        return (Future)hr$1.entity().dataBytes().runWith((Graph)FileIO$.MODULE$.toPath(file.toPath(), FileIO$.MODULE$.toPath$default$2()), (Materializer)this.materializer());
    }

    private static final akka.http.scaladsl.model.ContentType ctWithEncoding$1(akka.http.scaladsl.model.ContentType ct, String encoding) {
        return (akka.http.scaladsl.model.ContentType)HttpCharsets$.MODULE$.getForKey((Object)encoding).map((Function1 & Serializable)hc -> ContentType$.MODULE$.apply(ct.mediaType(), (Function0 & Serializable)() -> hc)).getOrElse((Function0 & Serializable)() -> ct);
    }

    private static final BodyPartEntity entity$1(akka.http.scaladsl.model.ContentType ct, Multipart mp$1) {
        HttpEntity.Strict strict;
        BasicRequestBody basicRequestBody = mp$1.body();
        if (basicRequestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)basicRequestBody;
            String b = stringBody.s();
            String encoding = stringBody.encoding();
            strict = HttpEntity$.MODULE$.apply(AkkaHttpBackend.ctWithEncoding$1(ct, encoding), b.getBytes(encoding));
        } else if (basicRequestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)basicRequestBody;
            byte[] b = byteArrayBody.b();
            strict = HttpEntity$.MODULE$.apply(ct, b);
        } else if (basicRequestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = (ByteBufferBody)basicRequestBody;
            ByteBuffer b = byteBufferBody.b();
            strict = HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b));
        } else if (basicRequestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)basicRequestBody;
            strict = new HttpEntity.IndefiniteLength(ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> inputStreamBody.b(), StreamConverters$.MODULE$.fromInputStream$default$2()));
        } else if (basicRequestBody instanceof FileBody) {
            FileBody fileBody = (FileBody)basicRequestBody;
            SttpFile b = fileBody.f();
            strict = HttpEntity$.MODULE$.fromPath(ct, b.toPath(), HttpEntity$.MODULE$.fromPath$default$3());
        } else {
            throw new MatchError((Object)basicRequestBody);
        }
        return strict;
    }

    private final Try toBodyPart$1(Multipart mp) {
        return this.parseContentTypeOrOctetStream((Option<String>)mp.contentType()).flatMap((Function1 & Serializable)ct -> this.headersToAkka((Seq<Tuple2<String, String>>)mp.additionalHeaders().toList()).map((Function1 & Serializable)headers -> {
            Map dispositionParams = (Map)mp.fileName().fold((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty(), (Function1 & Serializable)fn -> (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filename"), fn)})));
            return Multipart.FormData$.BodyPart$.MODULE$.apply(mp.name(), AkkaHttpBackend.entity$1(ct, mp), dispositionParams, headers);
        }));
    }

    public AkkaHttpBackend(ActorSystem actorSystem, ExecutionContext ec, boolean terminateActorSystemOnClose, SttpBackendOptions opts, Option<ConnectionPoolSettings> customConnectionPoolSettings, AkkaHttpClient http) {
        this.actorSystem = actorSystem;
        this.ec = ec;
        this.terminateActorSystemOnClose = terminateActorSystemOnClose;
        this.opts = opts;
        this.http = http;
        this.as = actorSystem;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)this.as());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.connectionPoolSettings = ((ConnectionPoolSettings)customConnectionPoolSettings.getOrElse((Function0 & Serializable)() -> (ConnectionPoolSettings)ConnectionPoolSettings$.MODULE$.apply($this.actorSystem))).withUpdatedConnectionSettings((Function1 & Serializable)x$1 -> x$1.withConnectingTimeout($this.opts.connectionTimeout()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

