/*
 * Decompiled with CFR 0.152.
 */
package sttp.apispec.openapi.validation;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.apispec.Schema;
import sttp.apispec.SchemaLike;
import sttp.apispec.openapi.Components;
import sttp.apispec.openapi.Encoding;
import sttp.apispec.openapi.Header;
import sttp.apispec.openapi.MediaType;
import sttp.apispec.openapi.OpenAPI;
import sttp.apispec.openapi.Operation;
import sttp.apispec.openapi.Parameter;
import sttp.apispec.openapi.ParameterStyle;
import sttp.apispec.openapi.PathItem;
import sttp.apispec.openapi.Reference;
import sttp.apispec.openapi.RequestBody;
import sttp.apispec.openapi.Response;
import sttp.apispec.openapi.ResponsesKey;
import sttp.apispec.openapi.validation.IncompatibleAllowEmptyValue$;
import sttp.apispec.openapi.validation.IncompatibleAllowReserved$;
import sttp.apispec.openapi.validation.IncompatibleContent;
import sttp.apispec.openapi.validation.IncompatibleContent$;
import sttp.apispec.openapi.validation.IncompatibleContentType$;
import sttp.apispec.openapi.validation.IncompatibleEncoding;
import sttp.apispec.openapi.validation.IncompatibleEncoding$;
import sttp.apispec.openapi.validation.IncompatibleExplode$;
import sttp.apispec.openapi.validation.IncompatibleHeader;
import sttp.apispec.openapi.validation.IncompatibleHeader$;
import sttp.apispec.openapi.validation.IncompatibleMediaType;
import sttp.apispec.openapi.validation.IncompatibleMediaType$;
import sttp.apispec.openapi.validation.IncompatibleOperation;
import sttp.apispec.openapi.validation.IncompatibleOperation$;
import sttp.apispec.openapi.validation.IncompatibleParameter;
import sttp.apispec.openapi.validation.IncompatibleParameter$;
import sttp.apispec.openapi.validation.IncompatiblePath;
import sttp.apispec.openapi.validation.IncompatiblePath$;
import sttp.apispec.openapi.validation.IncompatibleRequestBody;
import sttp.apispec.openapi.validation.IncompatibleRequestBody$;
import sttp.apispec.openapi.validation.IncompatibleRequiredValue$;
import sttp.apispec.openapi.validation.IncompatibleResponse;
import sttp.apispec.openapi.validation.IncompatibleResponse$;
import sttp.apispec.openapi.validation.IncompatibleSchema$;
import sttp.apispec.openapi.validation.IncompatibleSecurityRequirement;
import sttp.apispec.openapi.validation.IncompatibleSecurityRequirement$;
import sttp.apispec.openapi.validation.IncompatibleStyle$;
import sttp.apispec.openapi.validation.MissingEncoding$;
import sttp.apispec.openapi.validation.MissingHeader$;
import sttp.apispec.openapi.validation.MissingMediaType$;
import sttp.apispec.openapi.validation.MissingOperation$;
import sttp.apispec.openapi.validation.MissingParameter$;
import sttp.apispec.openapi.validation.MissingPath$;
import sttp.apispec.openapi.validation.MissingRequestBody$;
import sttp.apispec.openapi.validation.MissingResponse$;
import sttp.apispec.openapi.validation.MissingSchema$;
import sttp.apispec.openapi.validation.OpenAPIComparator$;
import sttp.apispec.openapi.validation.OpenAPICompatibilityIssue;
import sttp.apispec.validation.SchemaComparator;
import sttp.apispec.validation.SchemaCompatibilityIssue;

public class OpenAPIComparator {
    private final OpenAPI clientOpenAPI;
    private final OpenAPI serverOpenAPI;
    private final List<Tuple2<String, Function1<PathItem, Option<Operation>>>> httpMethods;
    private final Map<String, Schema> clientSchemas;
    private final Map<String, Schema> serverSchemas;

    public static OpenAPIComparator apply(OpenAPI openAPI, OpenAPI openAPI2) {
        return OpenAPIComparator$.MODULE$.apply(openAPI, openAPI2);
    }

    public OpenAPIComparator(OpenAPI clientOpenAPI, OpenAPI serverOpenAPI) {
        Map map;
        Map map2;
        this.clientOpenAPI = clientOpenAPI;
        this.serverOpenAPI = serverOpenAPI;
        this.httpMethods = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"get", (Function1 & Serializable)_$1 -> _$1.get()), Tuple2$.MODULE$.apply((Object)"post", (Function1 & Serializable)_$2 -> _$2.post()), Tuple2$.MODULE$.apply((Object)"patch", (Function1 & Serializable)_$3 -> _$3.patch()), Tuple2$.MODULE$.apply((Object)"delete", (Function1 & Serializable)_$4 -> _$4.delete()), Tuple2$.MODULE$.apply((Object)"options", (Function1 & Serializable)_$5 -> _$5.options()), Tuple2$.MODULE$.apply((Object)"trace", (Function1 & Serializable)_$6 -> _$6.trace()), Tuple2$.MODULE$.apply((Object)"head", (Function1 & Serializable)_$7 -> _$7.head()), Tuple2$.MODULE$.apply((Object)"put", (Function1 & Serializable)_$8 -> _$8.put())}));
        Option<Components> option = clientOpenAPI.components();
        if (option instanceof Some) {
            Components components = (Components)((Some)option).value();
            map2 = (Map)components.schemas().flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    SchemaLike schemaLike = (SchemaLike)tuple2._2();
                    String key = (String)tuple2._1();
                    if (schemaLike instanceof Schema) {
                        Schema schema = (Schema)schemaLike;
                        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)key, (Object)schema));
                    }
                }
                return None$.MODULE$;
            });
        } else {
            map2 = Predef$.MODULE$.Map().empty();
        }
        this.clientSchemas = map2;
        Option<Components> option2 = serverOpenAPI.components();
        if (option2 instanceof Some) {
            Components components = (Components)((Some)option2).value();
            map = (Map)components.schemas().flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    SchemaLike schemaLike = (SchemaLike)tuple2._2();
                    String key = (String)tuple2._1();
                    if (schemaLike instanceof Schema) {
                        Schema schema = (Schema)schemaLike;
                        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)key, (Object)schema));
                    }
                }
                return None$.MODULE$;
            });
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        this.serverSchemas = map;
    }

    public List<OpenAPICompatibilityIssue> compare() {
        return this.clientOpenAPI.paths().pathItems().toList().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String pathName = (String)tuple2._1();
                PathItem clientPathItem = (PathItem)tuple2._2();
                Option serverPathItem = this.serverOpenAPI.paths().pathItems().get((Object)pathName);
                Option option = serverPathItem;
                if (None$.MODULE$.equals(option)) {
                    return Some$.MODULE$.apply((Object)MissingPath$.MODULE$.apply(pathName));
                }
                if (option instanceof Some) {
                    PathItem serverPathItem2 = (PathItem)((Some)option).value();
                    Option<IncompatiblePath> pathIssues = this.checkPath(pathName, clientPathItem, serverPathItem2);
                    if (pathIssues.isEmpty()) {
                        return None$.MODULE$;
                    }
                    return pathIssues;
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        });
    }

    private Option<IncompatiblePath> checkPath(String pathName, PathItem clientPathItem, PathItem serverPathItem) {
        List issues = this.httpMethods.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Option serverOperation;
                String httpMethod = (String)tuple2._1();
                Function1 getOperation = (Function1)tuple2._2();
                Option clientOperation = (Option)getOperation.apply((Object)clientPathItem);
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)clientOperation, (Object)(serverOperation = (Option)getOperation.apply((Object)serverPathItem)));
                if (tuple22 != null) {
                    Option option = (Option)tuple22._1();
                    Option option2 = (Option)tuple22._2();
                    if (option instanceof Some) {
                        if (None$.MODULE$.equals(option2)) {
                            return Some$.MODULE$.apply((Object)MissingOperation$.MODULE$.apply(httpMethod));
                        }
                        Operation clientOp = (Operation)((Some)option).value();
                        if (option2 instanceof Some) {
                            Operation serverOp = (Operation)((Some)option2).value();
                            return this.checkOperation(httpMethod, clientOp, serverOp);
                        }
                    }
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        });
        if (issues.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)IncompatiblePath$.MODULE$.apply(pathName, (List<OpenAPICompatibilityIssue>)issues));
    }

    /*
     * Unable to fully structure code
     */
    private Option<IncompatibleOperation> checkOperation(String httpMethod, Operation clientOperation, Operation serverOperation) {
        serverParameters = this.getOperationParameters(serverOperation);
        clientParameters = this.getOperationParameters(clientOperation);
        parametersIssue = clientParameters.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$2(scala.collection.immutable.List sttp.apispec.openapi.Parameter ), (Lsttp/apispec/openapi/Parameter;)Lscala/collection/IterableOnce;)((OpenAPIComparator)this, serverParameters));
        var8_7 = Tuple2$.MODULE$.apply(clientOperation.requestBody(), serverOperation.requestBody());
        if (var8_7 == null) ** GOTO lbl-1000
        var9_8 = (Option)var8_7._1();
        var10_9 = (Option)var8_7._2();
        if (!(var9_8 instanceof Some) || !((var11_10 = (Either)((Some)var9_8).value()) instanceof Right)) ** GOTO lbl-1000
        clientRequestBody = (RequestBody)((Right)var11_10).value();
        if (var10_9 instanceof Some && (var13_12 = (Either)((Some)var10_9).value()) instanceof Right) {
            serverRequestBody = (RequestBody)((Right)var13_12).value();
            v0 = this.checkRequestBody(clientRequestBody, serverRequestBody);
        } else if (None$.MODULE$.equals(var10_9)) {
            v0 = Some$.MODULE$.apply((Object)MissingRequestBody$.MODULE$.apply());
        } else lbl-1000:
        // 3 sources

        {
            v0 = None$.MODULE$;
        }
        requestBodyIssue = v0;
        responsesIssues = (scala.collection.immutable.Iterable)clientOperation.responses().responses().flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$4(sttp.apispec.openapi.Operation scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Option;)((OpenAPIComparator)this, (Operation)serverOperation));
        incompatibleSecurityRequirements = clientOperation.security().filterNot((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$5(sttp.apispec.openapi.Operation scala.collection.immutable.ListMap ), (Lscala/collection/immutable/ListMap;)Z)((Operation)serverOperation));
        securityIssues = incompatibleSecurityRequirements.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$6(scala.collection.immutable.ListMap ), (Lscala/collection/immutable/ListMap;)Lsttp/apispec/openapi/validation/IncompatibleSecurityRequirement;)());
        issues = (List)((IterableOps)((IterableOps)parametersIssue.$plus$plus((IterableOnce)requestBodyIssue)).$plus$plus((IterableOnce)responsesIssues)).$plus$plus((IterableOnce)securityIssues);
        if (issues.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)IncompatibleOperation$.MODULE$.apply(httpMethod, (List<OpenAPICompatibilityIssue>)issues));
    }

    private Option<IncompatibleParameter> checkParameter(Parameter clientParameter, Parameter serverParameter) {
        Option<ParameterStyle> option = serverParameter.style();
        Option<ParameterStyle> option2 = clientParameter.style();
        boolean isCompatibleStyle = !(option != null ? !option.equals(option2) : option2 != null);
        Option<Object> option3 = serverParameter.explode();
        Option<Object> option4 = clientParameter.explode();
        boolean isCompatibleExplode = !(option3 != null ? !option3.equals(option4) : option4 != null);
        Option<Object> option5 = serverParameter.allowEmptyValue();
        Option<Object> option6 = clientParameter.allowEmptyValue();
        boolean isCompatibleAllowEmptyValue = !(option5 != null ? !option5.equals(option6) : option6 != null);
        Option<Object> option7 = serverParameter.allowReserved();
        Option<Object> option8 = clientParameter.allowReserved();
        boolean isCompatibleAllowReserved = !(option7 != null ? !option7.equals(option8) : option8 != null);
        Option<Object> option9 = serverParameter.required();
        Option<Object> option10 = clientParameter.required();
        boolean isCompatibleRequiredValue = !(option9 != null ? !option9.equals(option10) : option10 != null);
        List issues = (List)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)this.checkSchema(clientParameter.schema(), serverParameter.schema()).toList().$plus$plus((IterableOnce)this.checkContent(clientParameter.content(), serverParameter.content()).toList())).$plus$plus((IterableOnce)(!isCompatibleStyle ? Some$.MODULE$.apply((Object)IncompatibleStyle$.MODULE$.apply(clientParameter.style(), serverParameter.style())) : None$.MODULE$).toList())).$plus$plus((IterableOnce)(!isCompatibleExplode ? Some$.MODULE$.apply((Object)IncompatibleExplode$.MODULE$.apply(clientParameter.explode(), serverParameter.explode())) : None$.MODULE$).toList())).$plus$plus((IterableOnce)(!isCompatibleAllowEmptyValue ? Some$.MODULE$.apply((Object)IncompatibleAllowEmptyValue$.MODULE$.apply(clientParameter.allowEmptyValue(), serverParameter.allowEmptyValue())) : None$.MODULE$).toList())).$plus$plus((IterableOnce)(!isCompatibleAllowReserved ? Some$.MODULE$.apply((Object)IncompatibleAllowReserved$.MODULE$.apply(clientParameter.allowReserved(), serverParameter.allowReserved())) : None$.MODULE$).toList())).$plus$plus((IterableOnce)(!isCompatibleRequiredValue ? Some$.MODULE$.apply((Object)IncompatibleRequiredValue$.MODULE$.apply(clientParameter.required(), serverParameter.required())) : None$.MODULE$).toList());
        if (issues.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)IncompatibleParameter$.MODULE$.apply(clientParameter.name(), (List<OpenAPICompatibilityIssue>)issues));
    }

    private Option<IncompatibleContent> checkContent(ListMap<String, MediaType> clientContent, ListMap<String, MediaType> serverContent) {
        scala.collection.immutable.Iterable issues = (scala.collection.immutable.Iterable)clientContent.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String clientMediaType = (String)tuple2._1();
                MediaType clientMediaTypeDescription = (MediaType)tuple2._2();
                Option serverMediaTypeDescription = serverContent.get((Object)clientMediaType);
                Option option = serverMediaTypeDescription;
                if (None$.MODULE$.equals(option)) {
                    return Some$.MODULE$.apply((Object)MissingMediaType$.MODULE$.apply(clientMediaType));
                }
                if (option instanceof Some) {
                    MediaType serverMediaTypeDescription2 = (MediaType)((Some)option).value();
                    return this.checkMediaType(clientMediaType, clientMediaTypeDescription, serverMediaTypeDescription2);
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        if (issues.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)IncompatibleContent$.MODULE$.apply((List<OpenAPICompatibilityIssue>)issues.toList()));
    }

    private Option<IncompatibleEncoding> checkEncoding(String encodingName, Encoding clientEncoding, Encoding serverEncoding) {
        Option<ParameterStyle> option = serverEncoding.style();
        Option<ParameterStyle> option2 = clientEncoding.style();
        boolean isCompatibleStyle = !(option != null ? !option.equals(option2) : option2 != null);
        Option<Object> option3 = serverEncoding.explode();
        Option<Object> option4 = clientEncoding.explode();
        boolean isCompatibleExplode = !(option3 != null ? !option3.equals(option4) : option4 != null);
        Option<Object> option5 = serverEncoding.allowReserved();
        Option<Object> option6 = clientEncoding.allowReserved();
        boolean isCompatibleAllowReserved = !(option5 != null ? !option5.equals(option6) : option6 != null);
        Option<String> option7 = serverEncoding.contentType();
        Option<String> option8 = clientEncoding.contentType();
        boolean isCompatibleContentType = !(option7 != null ? !option7.equals(option8) : option8 != null);
        scala.collection.immutable.Iterable headerIssues = (scala.collection.immutable.Iterable)clientEncoding.headers().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Either either = (Either)tuple2._2();
                String clientHeaderName = (String)tuple2._1();
                if (either instanceof Right) {
                    Either either2;
                    Header clientHeader = (Header)((Right)either).value();
                    Option serverHeader = serverEncoding.headers().get((Object)clientHeaderName);
                    Option option = serverHeader;
                    if (option instanceof Some && (either2 = (Either)((Some)option).value()) instanceof Right) {
                        Header serverHeader2 = (Header)((Right)either2).value();
                        return this.checkResponseHeader(clientHeaderName, clientHeader, serverHeader2);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Some$.MODULE$.apply((Object)MissingHeader$.MODULE$.apply(clientHeaderName));
                    }
                    return None$.MODULE$;
                }
            }
            return None$.MODULE$;
        });
        scala.collection.immutable.Iterable issues = (scala.collection.immutable.Iterable)((IterableOps)((IterableOps)((IterableOps)headerIssues.$plus$plus((IterableOnce)(!isCompatibleStyle ? Some$.MODULE$.apply((Object)IncompatibleStyle$.MODULE$.apply(clientEncoding.style(), serverEncoding.style())) : None$.MODULE$).toList())).$plus$plus((IterableOnce)(!isCompatibleContentType ? Some$.MODULE$.apply((Object)IncompatibleContentType$.MODULE$.apply(clientEncoding.contentType(), serverEncoding.contentType())) : None$.MODULE$).toList())).$plus$plus((IterableOnce)(!isCompatibleExplode ? Some$.MODULE$.apply((Object)IncompatibleExplode$.MODULE$.apply(clientEncoding.explode(), serverEncoding.explode())) : None$.MODULE$).toList())).$plus$plus((IterableOnce)(!isCompatibleAllowReserved ? Some$.MODULE$.apply((Object)IncompatibleAllowReserved$.MODULE$.apply(clientEncoding.allowReserved(), serverEncoding.allowReserved())) : None$.MODULE$).toList());
        if (issues.nonEmpty()) {
            return Some$.MODULE$.apply((Object)IncompatibleEncoding$.MODULE$.apply(encodingName, (List<OpenAPICompatibilityIssue>)issues.toList()));
        }
        return None$.MODULE$;
    }

    private Option<IncompatibleMediaType> checkMediaType(String mediaType, MediaType clientMediaTypeDescription, MediaType serverMediaTypeDescription) {
        scala.collection.immutable.Iterable encodingIssues = (scala.collection.immutable.Iterable)clientMediaTypeDescription.encoding().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String clientEncodingName = (String)tuple2._1();
                Encoding clientEncoding = (Encoding)tuple2._2();
                Option serverEncoding = serverMediaTypeDescription.encoding().get((Object)clientEncodingName);
                Option option = serverEncoding;
                if (None$.MODULE$.equals(option)) {
                    return Some$.MODULE$.apply((Object)MissingEncoding$.MODULE$.apply(clientEncodingName));
                }
                if (option instanceof Some) {
                    Encoding serverEncoding2 = (Encoding)((Some)option).value();
                    return this.checkEncoding(clientEncodingName, clientEncoding, serverEncoding2);
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        Iterable issues = (Iterable)Option$.MODULE$.option2Iterable(this.checkSchema(clientMediaTypeDescription.schema(), serverMediaTypeDescription.schema())).$plus$plus((IterableOnce)encodingIssues);
        if (issues.nonEmpty()) {
            return Some$.MODULE$.apply((Object)IncompatibleMediaType$.MODULE$.apply(mediaType, (List<OpenAPICompatibilityIssue>)issues.toList()));
        }
        return None$.MODULE$;
    }

    private Option<OpenAPICompatibilityIssue> checkSchema(Option<SchemaLike> clientSchema, Option<SchemaLike> serverSchema) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(clientSchema, serverSchema);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                SchemaLike clientSchema2 = (SchemaLike)((Some)option).value();
                if (option2 instanceof Some) {
                    SchemaComparator schemaComparator = new SchemaComparator(this.clientSchemas, this.serverSchemas);
                    SchemaLike serverSchema2 = (SchemaLike)((Some)option2).value();
                    List schemaIssues = schemaComparator.compare(clientSchema2, serverSchema2);
                    if (schemaIssues.nonEmpty()) {
                        return Some$.MODULE$.apply((Object)IncompatibleSchema$.MODULE$.apply((List<SchemaCompatibilityIssue>)schemaIssues));
                    }
                    return None$.MODULE$;
                }
                if (None$.MODULE$.equals(option2)) {
                    return Some$.MODULE$.apply((Object)MissingSchema$.MODULE$.apply());
                }
            }
        }
        return None$.MODULE$;
    }

    private List<Parameter> getOperationParameters(Operation operation) {
        return operation.parameters().flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Parameter parameter = (Parameter)((Right)either).value();
                return Some$.MODULE$.apply((Object)parameter);
            }
            if (either instanceof Left) {
                Reference reference = (Reference)((Left)either).value();
                return this.resolveParameterReference(this.serverOpenAPI, reference.$ref());
            }
            throw new MatchError((Object)either);
        });
    }

    private Option<Parameter> resolveParameterReference(OpenAPI openAPI, String ref) {
        Option<Components> option = openAPI.components();
        if (option instanceof Some) {
            Components component = (Components)((Some)option).value();
            return component.getLocalParameter(ref);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    private Option<IncompatibleRequestBody> checkRequestBody(RequestBody clientRequestBody, RequestBody serverRequestBody) {
        Option<Object> option = serverRequestBody.required();
        Option<Object> option2 = clientRequestBody.required();
        boolean isCompatibleRequiredValue = !(option != null ? !option.equals(option2) : option2 != null);
        List contentIssues = this.checkContent(clientRequestBody.content(), serverRequestBody.content()).toList();
        List issues = (List)contentIssues.$plus$plus((IterableOnce)(!isCompatibleRequiredValue ? Some$.MODULE$.apply((Object)IncompatibleRequiredValue$.MODULE$.apply(clientRequestBody.required(), serverRequestBody.required())) : None$.MODULE$).toList());
        if (issues.nonEmpty()) {
            return Some$.MODULE$.apply((Object)IncompatibleRequestBody$.MODULE$.apply((List<OpenAPICompatibilityIssue>)issues));
        }
        return None$.MODULE$;
    }

    private Option<IncompatibleResponse> checkResponse(Response clientResponse, Response serverResponse) {
        Option<IncompatibleContent> contentIssue = this.checkContent(clientResponse.content(), serverResponse.content());
        scala.collection.immutable.Iterable headerIssues = (scala.collection.immutable.Iterable)clientResponse.headers().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Either either = (Either)tuple2._2();
                String clientHeaderName = (String)tuple2._1();
                if (either instanceof Right) {
                    Either either2;
                    Header clientHeader = (Header)((Right)either).value();
                    Option serverHeader = serverResponse.headers().get((Object)clientHeaderName);
                    Option option = serverHeader;
                    if (option instanceof Some && (either2 = (Either)((Some)option).value()) instanceof Right) {
                        Header serverHeader2 = (Header)((Right)either2).value();
                        return this.checkResponseHeader(clientHeaderName, clientHeader, serverHeader2);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Some$.MODULE$.apply((Object)MissingHeader$.MODULE$.apply(clientHeaderName));
                    }
                    return None$.MODULE$;
                }
            }
            return None$.MODULE$;
        });
        List issues = (List)contentIssue.toList().$plus$plus((IterableOnce)headerIssues);
        if (issues.nonEmpty()) {
            return Some$.MODULE$.apply((Object)IncompatibleResponse$.MODULE$.apply((List<OpenAPICompatibilityIssue>)issues));
        }
        return None$.MODULE$;
    }

    private Option<IncompatibleHeader> checkResponseHeader(String headerName, Header clientHeader, Header serverHeader) {
        Option<OpenAPICompatibilityIssue> schemaIssues = this.checkSchema(clientHeader.schema(), serverHeader.schema());
        Option<IncompatibleContent> contentIssue = this.checkContent(clientHeader.content(), serverHeader.content());
        Option<ParameterStyle> option = serverHeader.style();
        Option<ParameterStyle> option2 = clientHeader.style();
        boolean isCompatibleStyle = !(option != null ? !option.equals(option2) : option2 != null);
        Option<Object> option3 = serverHeader.explode();
        Option<Object> option4 = clientHeader.explode();
        boolean isCompatibleExplode = !(option3 != null ? !option3.equals(option4) : option4 != null);
        Option<Object> option5 = serverHeader.allowEmptyValue();
        Option<Object> option6 = clientHeader.allowEmptyValue();
        boolean isCompatibleAllowEmptyValue = !(option5 != null ? !option5.equals(option6) : option6 != null);
        Option<Object> option7 = serverHeader.allowReserved();
        Option<Object> option8 = clientHeader.allowReserved();
        boolean isCompatibleAllowReserved = !(option7 != null ? !option7.equals(option8) : option8 != null);
        Option<Object> option9 = serverHeader.required();
        Option<Object> option10 = clientHeader.required();
        boolean isCompatibleRequiredValue = !(option9 != null ? !option9.equals(option10) : option10 != null);
        List issues = (List)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)schemaIssues.toList().$plus$plus((IterableOnce)contentIssue.toList())).$plus$plus((IterableOnce)(!isCompatibleStyle ? Some$.MODULE$.apply((Object)IncompatibleStyle$.MODULE$.apply(clientHeader.style(), serverHeader.style())) : None$.MODULE$).toList())).$plus$plus((IterableOnce)(!isCompatibleExplode ? Some$.MODULE$.apply((Object)IncompatibleExplode$.MODULE$.apply(clientHeader.explode(), serverHeader.explode())) : None$.MODULE$).toList())).$plus$plus((IterableOnce)(!isCompatibleAllowEmptyValue ? Some$.MODULE$.apply((Object)IncompatibleAllowEmptyValue$.MODULE$.apply(clientHeader.allowEmptyValue(), serverHeader.allowEmptyValue())) : None$.MODULE$).toList())).$plus$plus((IterableOnce)(!isCompatibleAllowReserved ? Some$.MODULE$.apply((Object)IncompatibleAllowReserved$.MODULE$.apply(clientHeader.allowReserved(), serverHeader.allowReserved())) : None$.MODULE$).toList())).$plus$plus((IterableOnce)(!isCompatibleRequiredValue ? Some$.MODULE$.apply((Object)IncompatibleRequiredValue$.MODULE$.apply(clientHeader.required(), serverHeader.required())) : None$.MODULE$).toList());
        if (issues.nonEmpty()) {
            return Some$.MODULE$.apply((Object)IncompatibleHeader$.MODULE$.apply(headerName, (List<OpenAPICompatibilityIssue>)issues));
        }
        return None$.MODULE$;
    }

    private final /* synthetic */ IterableOnce $anonfun$2(List serverParameters$1, Parameter clientParameter) {
        Option serverParameter = serverParameters$1.find((Function1 & Serializable)_$9 -> {
            String string = _$9.name();
            String string2 = clientParameter.name();
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        Option option = serverParameter;
        if (None$.MODULE$.equals(option)) {
            return Some$.MODULE$.apply((Object)MissingParameter$.MODULE$.apply(clientParameter.name()));
        }
        if (option instanceof Some) {
            Parameter serverParameter2 = (Parameter)((Some)option).value();
            return this.checkParameter(clientParameter, serverParameter2);
        }
        throw new MatchError((Object)option);
    }

    private final /* synthetic */ Option $anonfun$4(Operation serverOperation$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Either either = (Either)tuple2._2();
            ResponsesKey clientResponseKey = (ResponsesKey)tuple2._1();
            if (either instanceof Right) {
                Either either2;
                Response clientResponse = (Response)((Right)either).value();
                Option serverResponse = serverOperation$1.responses().responses().get((Object)clientResponseKey);
                Option option = serverResponse;
                if (option instanceof Some && (either2 = (Either)((Some)option).value()) instanceof Right) {
                    Response serverResponse2 = (Response)((Right)either2).value();
                    return this.checkResponse(clientResponse, serverResponse2);
                }
                if (None$.MODULE$.equals(option)) {
                    return Some$.MODULE$.apply((Object)MissingResponse$.MODULE$.apply(clientResponseKey));
                }
                return None$.MODULE$;
            }
        }
        return None$.MODULE$;
    }

    private static final /* synthetic */ boolean $anonfun$5(Operation serverOperation$2, ListMap elem) {
        return serverOperation$2.security().contains((Object)elem);
    }

    private static final /* synthetic */ IncompatibleSecurityRequirement $anonfun$6(ListMap _$10) {
        return IncompatibleSecurityRequirement$.MODULE$.apply((ListMap<String, Vector<String>>)_$10);
    }
}

