/*
 * Decompiled with CFR 0.152.
 */
package sttp.client.okhttp;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Route;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import sttp.client.BasicRequestBody;
import sttp.client.BasicResponseAs;
import sttp.client.ByteArrayBody;
import sttp.client.ByteBufferBody;
import sttp.client.FileBody;
import sttp.client.IgnoreResponse$;
import sttp.client.InputStreamBody;
import sttp.client.MultipartBody;
import sttp.client.NoBody$;
import sttp.client.RequestBody;
import sttp.client.RequestT;
import sttp.client.Response;
import sttp.client.ResponseAs;
import sttp.client.ResponseAsByteArray$;
import sttp.client.ResponseAsFile;
import sttp.client.ResponseAsStream;
import sttp.client.ResponseMetadata;
import sttp.client.ResponseMetadata$;
import sttp.client.StreamBody;
import sttp.client.StringBody;
import sttp.client.SttpBackend;
import sttp.client.SttpBackendOptions;
import sttp.client.internal.FileHelpers$;
import sttp.client.internal.SttpFile;
import sttp.client.internal.package$;
import sttp.client.monad.MonadError;
import sttp.client.okhttp.OkHttpBackend$EncodingHandler$;
import sttp.client.okhttp.WebSocketHandler;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.Part;
import sttp.model.StatusCode$;
import sttp.model.Uri;

@ScalaSignature(bytes="\u0006\u0001\tmd!B\u000f\u001f\u0003\u0003)\u0003\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0007?\u0002!\t!!-\t\u0011\u0005m\u0006\u0001\"\u0001\u001f\u0003{Cq!a3\u0001\t\u0013\ti\rC\u0004\u0002j\u0002!I!a;\t\u0011\tm\u0001\u0001\"\u0001\u001f\u0005;AqA!\u000f\u0001\t\u0013\u0011Y\u0004C\u0004\u0003>\u0001!IAa\u0010\t\u000f\te\u0003\u0001\"\u0001\u0003\\!9!\u0011\r\u0001\u0005\u0002\t\r\u0004b\u0002B;\u0001\u0011\u0005#qO\u0004\u00069zA\t!\u0018\u0004\u0006;yA\tA\u0018\u0005\u0006?>!\t\u0001Y\u0003\u0005C>\u0001!mB\u0003y\u001f!\u0005\u0011PB\u0003b\u001f!\u00051\u0010C\u0003`'\u0011\u0005A\u0010C\u0003~'\u0011\u0005aP\u0002\u0004\u0002\f=!\u0011Q\u0002\u0005\u000b\u0003C1\"\u0011!Q\u0001\n\u0005\r\u0002BB0\u0017\t\u0003\t\t\u0004C\u0004\u00028Y!\t%!\u000f\t\u0011\u0005Us\u0002\"\u0001\u001f\u0003/B\u0001\"!\u001c\u0010\t\u0003q\u0012q\u000e\u0005\t\u0003\u001f{A\u0011\u0001\u0010\u0002\u0012\niqj\u001b%uiB\u0014\u0015mY6f]\u0012T!a\b\u0011\u0002\r=\\\u0007\u000e\u001e;q\u0015\t\t#%\u0001\u0004dY&,g\u000e\u001e\u0006\u0002G\u0005!1\u000f\u001e;q\u0007\u0001)2AJ\u001aA'\r\u0001q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u000b9z\u0013g\u0010\"\u000e\u0003\u0001J!\u0001\r\u0011\u0003\u0017M#H\u000f\u001d\"bG.,g\u000e\u001a\t\u0003eMb\u0001\u0001B\u00035\u0001\t\u0007QGA\u0001G+\t1T(\u0005\u00028uA\u0011\u0001\u0006O\u0005\u0003s%\u0012qAT8uQ&tw\r\u0005\u0002)w%\u0011A(\u000b\u0002\u0004\u0003:LH!\u0002 4\u0005\u00041$!A0\u0011\u0005I\u0002E!B!\u0001\u0005\u00041$!A*\u0011\u0005\r#U\"\u0001\u0010\n\u0005\u0015s\"\u0001E,fEN{7m[3u\u0011\u0006tG\r\\3s!\t9%*D\u0001I\u0015\u0005I\u0015aB8lQR$\boM\u0005\u0003\u0017\"\u0013AbT6IiR\u00048\t\\5f]R\f1b\u00197pg\u0016\u001cE.[3oiB\u0011\u0001FT\u0005\u0003\u001f&\u0012qAQ8pY\u0016\fg.A\u000bdkN$x.\\#oG>$\u0017N\\4IC:$G.\u001a:\u0011\u0005I\u000bbBA*\u000f\u001d\t!6L\u0004\u0002V5:\u0011a+W\u0007\u0002/*\u0011\u0001\fJ\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!!\t\u0012\n\u0005}\u0001\u0013!D(l\u0011R$\bOQ1dW\u0016tG\r\u0005\u0002D\u001fM\u0011qbJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0013q\"\u00128d_\u0012Lgn\u001a%b]\u0012dWM\u001d\t\u0005Q\r,\u0007.\u0003\u0002eS\ty\u0001+\u0019:uS\u0006dg)\u001e8di&|g\u000e\u0005\u0003)M\"\u0004\u0018BA4*\u0005\u0019!V\u000f\u001d7feA\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0003S>T\u0011!\\\u0001\u0005U\u00064\u0018-\u0003\u0002pU\nY\u0011J\u001c9viN#(/Z1n!\t\tXO\u0004\u0002sgB\u0011a+K\u0005\u0003i&\na\u0001\u0015:fI\u00164\u0017B\u0001<x\u0005\u0019\u0019FO]5oO*\u0011A/K\u0001\u0010\u000b:\u001cw\u000eZ5oO\"\u000bg\u000e\u001a7feB\u0011!pE\u0007\u0002\u001fM\u00111c\n\u000b\u0002s\u0006)\u0011\r\u001d9msR\u0019q0!\u0001\u0011\u0005i\f\u0002bBA\u0002+\u0001\u0007\u0011QA\u0001\u0002MB1\u0001&a\u0002ia\"L1!!\u0003*\u0005%1UO\\2uS>t'G\u0001\nQe>D\u00180Q;uQ\u0016tG/[2bi>\u00148#\u0002\f\u0002\u0010\u0005m\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005UA.\u0001\u0003mC:<\u0017\u0002BA\r\u0003'\u0011aa\u00142kK\u000e$\bcA$\u0002\u001e%\u0019\u0011q\u0004%\u0003\u001b\u0005+H\u000f[3oi&\u001c\u0017\r^8s\u0003\u0011\tW\u000f\u001e5\u0011\t\u0005\u0015\u00121\u0006\b\u0004]\u0005\u001d\u0012bAA\u0015A\u0005\u00112\u000b\u001e;q\u0005\u0006\u001c7.\u001a8e\u001fB$\u0018n\u001c8t\u0013\u0011\ti#a\f\u0003\u0013A\u0013x\u000e_=BkRD'bAA\u0015AQ!\u00111GA\u001b!\tQh\u0003C\u0004\u0002\"a\u0001\r!a\t\u0002\u0019\u0005,H\u000f[3oi&\u001c\u0017\r^3\u0015\r\u0005m\u0012\u0011IA&!\r9\u0015QH\u0005\u0004\u0003\u007fA%a\u0002*fcV,7\u000f\u001e\u0005\b\u0003\u0007J\u0002\u0019AA#\u0003\u0015\u0011x.\u001e;f!\r9\u0015qI\u0005\u0004\u0003\u0013B%!\u0002*pkR,\u0007bBA'3\u0001\u0007\u0011qJ\u0001\te\u0016\u001c\bo\u001c8tKB\u0019q)!\u0015\n\u0007\u0005M\u0003J\u0001\u0005SKN\u0004xN\\:f\u00035!WMZ1vYR\u001cE.[3oiR)a)!\u0017\u0002d!9\u00111\f\u000eA\u0002\u0005u\u0013a\u0003:fC\u0012$\u0016.\\3pkR\u00042\u0001KA0\u0013\r\t\t'\u000b\u0002\u0005\u0019>tw\rC\u0004\u0002fi\u0001\r!a\u001a\u0002\u000f=\u0004H/[8ogB\u0019a&!\u001b\n\u0007\u0005-\u0004E\u0001\nTiR\u0004()Y2lK:$w\n\u001d;j_:\u001c\u0018aH;qI\u0006$Xm\u00117jK:$\u0018JZ\"vgR|WNU3bIRKW.Z8viV1\u0011\u0011OAC\u0003\u0017#RARA:\u0003\u001bCq!!\u001e\u001c\u0001\u0004\t9(A\u0001s!!\tI(a \u0002\u0004\u0006%eb\u0001+\u0002|%\u0019\u0011Q\u0010\u0011\u0002\u000fA\f7m[1hK&!\u0011qHAA\u0015\r\ti\b\t\t\u0004e\u0005\u0015EABAD7\t\u0007aGA\u0001U!\r\u0011\u00141\u0012\u0003\u0006\u0003n\u0011\rA\u000e\u0005\u0006Cm\u0001\rAR\u0001\u001fKb\u001cW\r\u001d;j_:$vn\u0015;ua\u000ec\u0017.\u001a8u\u000bb\u001cW\r\u001d;j_:$b!a%\u0002*\u00065\u0006#\u0002\u0015\u0002\u0016\u0006e\u0015bAALS\t1q\n\u001d;j_:\u0004B!a'\u0002$:!\u0011QTAQ\u001d\r1\u0016qT\u0005\u0002U%\u0019\u0011QP\u0015\n\t\u0005\u0015\u0016q\u0015\u0002\n\u000bb\u001cW\r\u001d;j_:T1!! *\u0011\u0019\tY\u000b\ba\u0001\u001b\u0006Y\u0011n],fEN|7m[3u\u0011\u001d\ty\u000b\ba\u0001\u00033\u000b\u0011!\u001a\u000b\t\u0003g\u000b),a.\u0002:B!1\tA\u0019@\u0011\u0015\tC\u00011\u0001G\u0011\u0015aE\u00011\u0001N\u0011\u0015\u0001F\u00011\u0001R\u00039\u0019wN\u001c<feR\u0014V-];fgR,B!a0\u0002JR!\u00111HAa\u0011\u001d\t\u0019-\u0002a\u0001\u0003\u000b\fqA]3rk\u0016\u001cH\u000fE\u0004\u0002z\u0005}\u0014qY \u0011\u0007I\nI\r\u0002\u0004\u0002\b\u0016\u0011\rAN\u0001\rE>$\u0017\u0010V8PW\"#H\u000f]\u000b\u0005\u0003\u001f\f9\u000f\u0006\u0004\u0002R\u0006e\u0017\u0011\u001d\t\u0006Q\u0005U\u00151\u001b\t\u0004\u000f\u0006U\u0017bAAl\u0011\nY!+Z9vKN$(i\u001c3z\u0011\u001d\tYN\u0002a\u0001\u0003;\fAAY8esB!a&a8@\u0013\r\t9\u000e\t\u0005\b\u0003G4\u0001\u0019AAs\u0003\t\u0019G\u000f\u0005\u0003)\u0003+\u0003HABAD\r\t\u0007a'\u0001\u0007bI\u0012lU\u000f\u001c;ja\u0006\u0014H\u000f\u0006\u0004\u0002n\u0006M(Q\u0001\t\u0004Q\u0005=\u0018bAAyS\t!QK\\5u\u0011\u001d\t)p\u0002a\u0001\u0003o\fqAY;jY\u0012,'\u000f\u0005\u0003\u0002z\u0006}hbA$\u0002|&\u0019\u0011Q %\u0002\u001b5+H\u000e^5qCJ$(i\u001c3z\u0013\u0011\u0011\tAa\u0001\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0019\u0011Q %\t\u000f\t\u001dq\u00011\u0001\u0003\n\u0005\u0011Q\u000e\u001d\t\u0007\u0005\u0017\u0011\tB!\u0006\u000e\u0005\t5!b\u0001B\bE\u0005)Qn\u001c3fY&!!1\u0003B\u0007\u0005\u0011\u0001\u0016M\u001d;\u0011\u00079\u00129\"C\u0002\u0003\u001a\u0001\u0012\u0001CQ1tS\u000e\u0014V-];fgR\u0014u\u000eZ=\u0002\u0019I,\u0017\r\u001a*fgB|gn]3\u0016\t\t}!\u0011\u0006\u000b\u0007\u0005C\u0011YCa\f\u0011\tI\u001a$1\u0005\t\u0006]\t\u0015\"qE\u0005\u0004\u0003'\u0002\u0003c\u0001\u001a\u0003*\u00111\u0011q\u0011\u0005C\u0002YBqA!\f\t\u0001\u0004\ty%A\u0002sKNDqA!\r\t\u0001\u0004\u0011\u0019$\u0001\u0006sKN\u0004xN\\:f\u0003N\u0004bA\fB\u001b\u0005Oy\u0014b\u0001B\u001cA\tQ!+Z:q_:\u001cX-Q:\u0002!M$\u0018M\u001c3be\u0012,enY8eS:<WCAA\u0003\u0003=\u0011Xm\u001d9p]N,\u0007*\u00198eY\u0016\u0014H\u0003\u0002B!\u0005+\u0012RAa\u0011(\u0005\u000f2aA!\u0012\u000b\u0001\t\u0005#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004#\u0002B%\u0005\u001fzdb\u0001+\u0003L%\u0019!Q\n\u0011\u0002\u0015I+7\u000f]8og\u0016\f5/\u0003\u0003\u0003R\tM#\u0001F#bO\u0016\u0014(+Z:q_:\u001cX\rS1oI2,'OC\u0002\u0003N\u0001BaAa\u0016\u000b\u0001\u0004A\u0017\u0001\u0004:fgB|gn]3C_\u0012L\u0018aE:ue\u0016\fW\u000eV8SKF,Xm\u001d;C_\u0012LH\u0003BAi\u0005;BaAa\u0018\f\u0001\u0004y\u0014AB:ue\u0016\fW.\u0001\u000bsKN\u0004xN\\:f\u0005>$\u0017\u0010V8TiJ,\u0017-\u001c\u000b\u0005\u0005K\u0012\t\bE\u0003\u0003h\t5t(\u0004\u0002\u0003j)\u0019!1N\u0015\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005_\u0012IGA\u0002UefDaAa\u001d\r\u0001\u0004A\u0017aC5oaV$8\u000b\u001e:fC6\fQa\u00197pg\u0016$\"A!\u001f\u0011\tI\u001a\u0014Q\u001e")
public abstract class OkHttpBackend<F, S>
implements SttpBackend<F, S, WebSocketHandler> {
    private final OkHttpClient client;
    private final boolean closeClient;
    private final PartialFunction<Tuple2<InputStream, String>, InputStream> customEncodingHandler;

    public <T> Request convertRequest(RequestT<Object, T, S> request) {
        Request.Builder builder = new Request.Builder().url(((Uri)request.uri()).toString());
        Option<okhttp3.RequestBody> body = this.bodyToOkHttp(request.body(), (Option<String>)request.headers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.is(HeaderNames$.MODULE$.ContentType()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value()));
        builder.method(((Method)request.method()).method(), (okhttp3.RequestBody)body.getOrElse((Function0 & Serializable & scala.Serializable)() -> HttpMethod.requiresRequestBody((String)((Method)request.method()).method()) ? okhttp3.RequestBody.create((String)"", null) : null));
        request.headers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Header header = x0$1;
            Option option = Header$.MODULE$.unapply(header);
            if (option.isEmpty()) {
                throw new MatchError((Object)header);
            }
            String name = (String)((Tuple2)option.get())._1();
            String value = (String)((Tuple2)option.get())._2();
            Request.Builder builder = builder.addHeader(name, value);
            return builder;
        });
        return builder.build();
    }

    private <T> Option<okhttp3.RequestBody> bodyToOkHttp(RequestBody<S> body, Option<String> ct) {
        Some some;
        MediaType mediaType = (MediaType)ct.flatMap((Function1 & Serializable & scala.Serializable)c -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MediaType.parse((String)c)).toOption()).orNull(Predef$.MODULE$.$conforms());
        RequestBody<S> requestBody = body;
        if (NoBody$.MODULE$.equals(requestBody)) {
            some = None$.MODULE$;
        } else if (requestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)requestBody;
            String b = stringBody.s();
            some = new Some((Object)okhttp3.RequestBody.create((String)b, (MediaType)mediaType));
        } else if (requestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)requestBody;
            byte[] b = byteArrayBody.b();
            some = new Some((Object)okhttp3.RequestBody.create((byte[])b, (MediaType)mediaType));
        } else if (requestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = (ByteBufferBody)requestBody;
            ByteBuffer b = byteBufferBody.b();
            some = b.isReadOnly() ? new Some((Object)okhttp3.RequestBody.create((ByteString)ByteString.of((ByteBuffer)b), (MediaType)mediaType)) : new Some((Object)okhttp3.RequestBody.create((byte[])b.array(), (MediaType)mediaType));
        } else if (requestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)requestBody;
            InputStream b = inputStreamBody.b();
            some = new Some((Object)new okhttp3.RequestBody(null, b, mediaType){
                private final InputStream b$1;
                private final MediaType mediaType$1;

                public void writeTo(BufferedSink sink) {
                    sink.writeAll(Okio.source((InputStream)this.b$1));
                }

                public MediaType contentType() {
                    return this.mediaType$1;
                }
                {
                    this.b$1 = b$1;
                    this.mediaType$1 = mediaType$1;
                }
            });
        } else if (requestBody instanceof FileBody) {
            FileBody fileBody = (FileBody)requestBody;
            SttpFile b = fileBody.f();
            some = new Some((Object)okhttp3.RequestBody.create((File)b.toFile(), (MediaType)mediaType));
        } else if (requestBody instanceof StreamBody) {
            StreamBody streamBody = (StreamBody)requestBody;
            Object s = streamBody.s();
            some = this.streamToRequestBody(s);
        } else if (requestBody instanceof MultipartBody) {
            MultipartBody multipartBody = (MultipartBody)requestBody;
            Seq ps = multipartBody.parts();
            MultipartBody.Builder b = new MultipartBody.Builder().setType((MediaType)Option$.MODULE$.apply((Object)mediaType).getOrElse((Function0 & Serializable & scala.Serializable)() -> okhttp3.MultipartBody.FORM));
            ps.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.addMultipart(b, (Part<BasicRequestBody>)x$3);
                return BoxedUnit.UNIT;
            });
            some = new Some((Object)b.build());
        } else {
            throw new MatchError(requestBody);
        }
        return some;
    }

    private void addMultipart(MultipartBody.Builder builder, Part<BasicRequestBody> mp) {
        Seq allHeaders = (Seq)mp.headers().$colon$plus((Object)Header$.MODULE$.apply(HeaderNames$.MODULE$.ContentDisposition(), mp.contentDispositionHeaderValue()), Seq$.MODULE$.canBuildFrom());
        Headers headers = Headers.of((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)allHeaders.filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.is(HeaderNames$.MODULE$.ContentType())))).map((Function1 & Serializable & scala.Serializable)h -> new Tuple2((Object)h.name(), (Object)h.value()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()));
        this.bodyToOkHttp((RequestBody)mp.body(), (Option<String>)mp.contentType()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> builder.addPart(headers, x$5));
    }

    public <T> F readResponse(okhttp3.Response res, ResponseAs<T, S> responseAs) {
        String method;
        List headers = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(res.headers().names()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)name -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.headers().values(name)).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> Header$.MODULE$.apply(name, x$6), Buffer$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom())).toList();
        ResponseMetadata responseMetadata = ResponseMetadata$.MODULE$.apply((Seq)headers, StatusCode$.MODULE$.apply(res.code()), res.message());
        Option encoding = headers.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Header, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.is(HeaderNames$.MODULE$.ContentEncoding()) ? A1.value() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Header x1) {
                Header header = x1;
                boolean bl = header.is(HeaderNames$.MODULE$.ContentEncoding());
                return bl;
            }
        });
        String string = method = res.request().method();
        String string2 = Method$.MODULE$.HEAD();
        InputStream byteBody = (string == null ? string2 != null : !string.equals(string2)) ? (InputStream)encoding.map((Function1 & Serializable & scala.Serializable)e -> (InputStream)$this.customEncodingHandler.orElse(OkHttpBackend$EncodingHandler$.MODULE$.apply(this.standardEncoding())).apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)res.body().byteStream()), e))).getOrElse((Function0 & Serializable & scala.Serializable)() -> res.body().byteStream()) : res.body().byteStream();
        Object body = this.responseHandler(byteBody).handle(responseAs, this.responseMonad(), responseMetadata);
        return (F)this.responseMonad().map(body, (Function1 & Serializable & scala.Serializable)x$7 -> new Response(x$7, StatusCode$.MODULE$.apply(res.code()), res.message(), (Seq)headers, (List)Nil$.MODULE$));
    }

    private Function2<InputStream, String, InputStream> standardEncoding() {
        return (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            void var2_7;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                InputStream body = (InputStream)tuple2._1();
                String string = (String)tuple2._2();
                if ("gzip".equals(string)) {
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(body);
                    return var2_7;
                }
            }
            if (tuple2 != null) {
                InputStream body = (InputStream)tuple2._1();
                String string = (String)tuple2._2();
                if ("deflate".equals(string)) {
                    InflaterInputStream inflaterInputStream = new InflaterInputStream(body);
                    return var2_7;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String ce = (String)tuple2._2();
            throw new UnsupportedEncodingException(new StringBuilder(22).append("Unsupported encoding: ").append(ce).toString());
        };
    }

    private ResponseAs.EagerResponseHandler<S> responseHandler(InputStream responseBody) {
        return new ResponseAs.EagerResponseHandler<S>(this, responseBody){
            private final /* synthetic */ OkHttpBackend $outer;
            private final InputStream responseBody$1;

            public <T, F> F handle(ResponseAs<T, S> responseAs, MonadError<F> responseMonad, ResponseMetadata meta) {
                return (F)ResponseAs.EagerResponseHandler.handle$((ResponseAs.EagerResponseHandler)this, responseAs, responseMonad, (ResponseMetadata)meta);
            }

            public <T> Try<T> handleBasic(BasicResponseAs<T, S> bra) {
                Try try_;
                BasicResponseAs<T, S> basicResponseAs = bra;
                if (IgnoreResponse$.MODULE$.equals(basicResponseAs)) {
                    try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.responseBody$1.close());
                } else if (ResponseAsByteArray$.MODULE$.equals(basicResponseAs)) {
                    Try body = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.toByteArray($this.responseBody$1));
                    this.responseBody$1.close();
                    try_ = body;
                } else if (basicResponseAs instanceof ResponseAsStream) {
                    ResponseAsStream responseAsStream = (ResponseAsStream)basicResponseAs;
                    try_ = this.$outer.responseBodyToStream(this.responseBody$1).map((Function1)responseAsStream.responseIsStream());
                } else if (basicResponseAs instanceof ResponseAsFile) {
                    ResponseAsFile responseAsFile = (ResponseAsFile)basicResponseAs;
                    SttpFile file = responseAsFile.output();
                    Try body = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> FileHelpers$.MODULE$.saveFile(file.toFile(), $this.responseBody$1));
                    this.responseBody$1.close();
                    try_ = body.map((Function1 & Serializable & scala.Serializable)x$8 -> file);
                } else {
                    throw new MatchError(basicResponseAs);
                }
                return try_;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.responseBody$1 = responseBody$1;
                ResponseAs.EagerResponseHandler.$init$((ResponseAs.EagerResponseHandler)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleBasic$1(sttp.client.okhttp.OkHttpBackend$$anon$2 ), $anonfun$handleBasic$2(sttp.client.okhttp.OkHttpBackend$$anon$2 ), $anonfun$handleBasic$3(sttp.client.okhttp.OkHttpBackend$$anon$2 sttp.client.internal.SttpFile ), $anonfun$handleBasic$4(sttp.client.internal.SttpFile scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
    }

    public Option<okhttp3.RequestBody> streamToRequestBody(S stream) {
        return None$.MODULE$;
    }

    public Try<S> responseBodyToStream(InputStream inputStream) {
        return new Failure((Throwable)new IllegalStateException("Streaming isn't supported"));
    }

    public F close() {
        return (F)(this.closeClient ? this.responseMonad().eval((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client.dispatcher().executorService().shutdown()) : this.responseMonad().unit((Object)BoxedUnit.UNIT));
    }

    public OkHttpBackend(OkHttpClient client, boolean closeClient, PartialFunction<Tuple2<InputStream, String>, InputStream> customEncodingHandler) {
        this.client = client;
        this.closeClient = closeClient;
        this.customEncodingHandler = customEncodingHandler;
    }

    public static class ProxyAuthenticator
    implements Authenticator {
        private final SttpBackendOptions.ProxyAuth auth;

        public Request authenticate(Route route, okhttp3.Response response) {
            String credential = Credentials.basic((String)this.auth.username(), (String)this.auth.password());
            return response.request().newBuilder().header("Proxy-Authorization", credential).build();
        }

        public ProxyAuthenticator(SttpBackendOptions.ProxyAuth auth) {
            this.auth = auth;
        }
    }
}

