/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.akkahttp;

import akka.http.javadsl.model.ContentType;
import akka.http.scaladsl.model.BodyPartEntity;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.HttpCharsets$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.Multipart;
import akka.http.scaladsl.model.RequestEntity;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.stream.scaladsl.StreamConverters$;
import akka.util.ByteString$;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sttp.client3.ByteArrayBody;
import sttp.client3.ByteBufferBody;
import sttp.client3.FileBody;
import sttp.client3.InputStreamBody;
import sttp.client3.MultipartBody;
import sttp.client3.NoBody$;
import sttp.client3.RequestBody;
import sttp.client3.RequestT;
import sttp.client3.StreamBody;
import sttp.client3.StringBody;
import sttp.client3.akkahttp.ToAkka$;
import sttp.client3.akkahttp.Util$;
import sttp.client3.internal.SttpFile;
import sttp.client3.internal.package$;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.Part;

public final class BodyToAkka$ {
    public static final BodyToAkka$ MODULE$ = new BodyToAkka$();

    public <R> Try<HttpRequest> apply(RequestT<?, ?, R> r, RequestBody<R> body, HttpRequest ar) {
        return Util$.MODULE$.parseContentTypeOrOctetStream(r).flatMap((Function1 & Serializable)ct -> {
            RequestBody requestBody = body;
            if (NoBody$.MODULE$.equals(requestBody)) {
                return new Success((Object)ar);
            }
            if (requestBody instanceof StringBody) {
                StringBody stringBody = (StringBody)requestBody;
                String b = stringBody.s();
                String encoding = stringBody.encoding();
                return new Success((Object)ar.withEntity((ContentType)BodyToAkka$.ctWithCharset$1(ct, encoding), b.getBytes(encoding)));
            }
            if (requestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)requestBody;
                byte[] b = byteArrayBody.b();
                return new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, b)));
            }
            if (requestBody instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = (ByteBufferBody)requestBody;
                ByteBuffer b = byteBufferBody.b();
                return new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b))));
            }
            if (requestBody instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)requestBody;
                InputStream b = inputStreamBody.b();
                return new Success((Object)ar.withEntity(BodyToAkka$.streamEntity$1(ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> b, StreamConverters$.MODULE$.fromInputStream$default$2()), r)));
            }
            if (requestBody instanceof FileBody) {
                FileBody fileBody = (FileBody)requestBody;
                SttpFile b = fileBody.f();
                return new Success((Object)ar.withEntity((ContentType)ct, b.toPath()));
            }
            if (requestBody instanceof StreamBody) {
                StreamBody streamBody = (StreamBody)requestBody;
                Object s = streamBody.b();
                return new Success((Object)ar.withEntity(BodyToAkka$.streamEntity$1(ct, (Source)s, r)));
            }
            if (requestBody instanceof MultipartBody) {
                MultipartBody multipartBody = (MultipartBody)requestBody;
                Seq ps = multipartBody.parts();
                return Util$.MODULE$.traverseTry((Seq)ps.map((Function1 & Serializable)mp -> BodyToAkka$.toBodyPart$1(mp))).flatMap((Function1 & Serializable)bodyParts -> MODULE$.multipartEntity(r, (Seq<Multipart.FormData.BodyPart>)bodyParts).map((Function1 & Serializable)entity -> ar.withEntity(entity)));
            }
            throw new MatchError((Object)requestBody);
        });
    }

    private Try<RequestEntity> multipartEntity(RequestT<?, ?, ?> r, Seq<Multipart.FormData.BodyPart> bodyParts) {
        Option option = r.headers().find((Function1 & Serializable)header -> BoxesRunTime.boxToBoolean((boolean)Util$.MODULE$.isContentType(header)));
        if (None$.MODULE$.equals(option)) {
            return new Success((Object)Multipart.FormData$.MODULE$.apply(bodyParts).toEntity());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Header ct = (Header)some.value();
            return Util$.MODULE$.parseContentType(ct.value()).map((Function1 & Serializable)x$2 -> x$2.mediaType()).flatMap((Function1 & Serializable)x0$1 -> {
                MediaType mediaType = x0$1;
                if (mediaType instanceof MediaType.Multipart) {
                    MediaType.Multipart multipart = (MediaType.Multipart)mediaType;
                    return new Success((Object)Multipart.General$.MODULE$.apply(multipart, Source$.MODULE$.apply((Iterable)bodyParts.map((Function1 & Serializable)bp -> Multipart.General$.BodyPart$.MODULE$.apply(bp.entity(), bp.headers())))).toEntity());
                }
                return new Failure((Throwable)new RuntimeException(new StringBuilder(28).append("Non-multipart content type: ").append(ct).toString()));
            });
        }
        throw new MatchError((Object)option);
    }

    private static final akka.http.scaladsl.model.ContentType ctWithCharset$1(akka.http.scaladsl.model.ContentType ct, String charset) {
        return (akka.http.scaladsl.model.ContentType)HttpCharsets$.MODULE$.getForKey((Object)charset).map((Function1 & Serializable)hc -> ContentType$.MODULE$.apply(ct.mediaType(), (Function0 & Serializable)() -> hc)).getOrElse((Function0 & Serializable)() -> ct);
    }

    private static final Option contentLength$1(RequestT r$1) {
        return r$1.headers().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.is(HeaderNames$.MODULE$.ContentLength()))).flatMap((Function1 & Serializable)h -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(h.value()))).toOption());
    }

    private static final BodyPartEntity streamPartEntity$1(akka.http.scaladsl.model.ContentType contentType, Source s, Part mp$1) {
        Option option = mp$1.contentLength();
        if (None$.MODULE$.equals(option)) {
            return new HttpEntity.IndefiniteLength(contentType, s);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long l = BoxesRunTime.unboxToLong((Object)some.value());
            return HttpEntity$.MODULE$.apply(contentType, l, s);
        }
        throw new MatchError((Object)option);
    }

    private static final BodyPartEntity entity$1(akka.http.scaladsl.model.ContentType ct, Part mp$1) {
        RequestBody requestBody = (RequestBody)mp$1.body();
        if (requestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)requestBody;
            String b = stringBody.s();
            String encoding = stringBody.encoding();
            return HttpEntity$.MODULE$.apply(BodyToAkka$.ctWithCharset$1(ct, encoding), b.getBytes(encoding));
        }
        if (requestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)requestBody;
            byte[] b = byteArrayBody.b();
            return HttpEntity$.MODULE$.apply(ct, b);
        }
        if (requestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = (ByteBufferBody)requestBody;
            ByteBuffer b = byteBufferBody.b();
            return HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b));
        }
        if (requestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)requestBody;
            return BodyToAkka$.streamPartEntity$1(ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> inputStreamBody.b(), StreamConverters$.MODULE$.fromInputStream$default$2()), mp$1);
        }
        if (requestBody instanceof FileBody) {
            FileBody fileBody = (FileBody)requestBody;
            SttpFile b = fileBody.f();
            return HttpEntity$.MODULE$.fromPath(ct, b.toPath(), HttpEntity$.MODULE$.fromPath$default$3());
        }
        if (requestBody instanceof StreamBody) {
            StreamBody streamBody = (StreamBody)requestBody;
            Object b = streamBody.b();
            return BodyToAkka$.streamPartEntity$1(ct, (Source)b, mp$1);
        }
        if (requestBody instanceof MultipartBody) {
            throw package$.MODULE$.throwNestedMultipartNotAllowed();
        }
        if (NoBody$.MODULE$.equals(requestBody)) {
            return HttpEntity$.MODULE$.Empty();
        }
        throw new MatchError((Object)requestBody);
    }

    private static final Try toBodyPart$1(Part mp) {
        return Util$.MODULE$.parseContentTypeOrOctetStream((Option<String>)mp.contentType()).flatMap((Function1 & Serializable)ct -> ToAkka$.MODULE$.headers((Seq<Header>)mp.headers().toList()).map((Function1 & Serializable)headers -> Multipart.FormData$.BodyPart$.MODULE$.apply(mp.name(), BodyToAkka$.entity$1(ct, mp), mp.dispositionParams(), headers)));
    }

    private static final RequestEntity streamEntity$1(akka.http.scaladsl.model.ContentType contentType, Source s, RequestT r$1) {
        Option option = BodyToAkka$.contentLength$1(r$1);
        if (None$.MODULE$.equals(option)) {
            return HttpEntity$.MODULE$.apply(contentType, s);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long l = BoxesRunTime.unboxToLong((Object)some.value());
            return HttpEntity$.MODULE$.apply(contentType, l, s);
        }
        throw new MatchError((Object)option);
    }

    private BodyToAkka$() {
    }
}

