/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.asynchttpclient;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sttp.client3.asynchttpclient.WebSocketImpl$;
import sttp.client3.internal.ws.SimpleQueue;
import sttp.client3.internal.ws.WebSocketEvent;
import sttp.model.Header$;
import sttp.model.Headers;
import sttp.model.Headers$;
import sttp.monad.Canceler$;
import sttp.monad.MonadAsyncError;
import sttp.monad.syntax;
import sttp.monad.syntax$;
import sttp.ws.WebSocket;
import sttp.ws.WebSocketClosed$;
import sttp.ws.WebSocketFrame;

public class WebSocketImpl<F>
implements WebSocket<F> {
    private final org.asynchttpclient.ws.WebSocket ws;
    private final SimpleQueue<F, WebSocketEvent> queue;
    private final AtomicBoolean _isOpen;
    private final MonadAsyncError monad;

    public static <F> WebSocket<F> newCoupledToAHCWebSocket(org.asynchttpclient.ws.WebSocket webSocket, SimpleQueue<F, WebSocketEvent> simpleQueue, MonadAsyncError<F> monadAsyncError) {
        return WebSocketImpl$.MODULE$.newCoupledToAHCWebSocket(webSocket, simpleQueue, monadAsyncError);
    }

    public WebSocketImpl(org.asynchttpclient.ws.WebSocket ws, SimpleQueue<F, WebSocketEvent> queue, AtomicBoolean _isOpen, MonadAsyncError<F> monad) {
        this.ws = ws;
        this.queue = queue;
        this._isOpen = _isOpen;
        this.monad = monad;
    }

    public MonadAsyncError<F> monad() {
        return this.monad;
    }

    public F receive() {
        return (F)syntax$.MODULE$.MonadErrorOps(this::receive$$anonfun$1).flatMap((Function1 & Serializable)x$1 -> {
            WebSocketEvent.Frame frame;
            WebSocketFrame webSocketFrame;
            Object object;
            WebSocketEvent webSocketEvent = x$1;
            if (webSocketEvent instanceof WebSocketEvent.Open && WebSocketEvent.Open$.MODULE$.unapply((WebSocketEvent.Open)webSocketEvent)) {
                object = this.receive();
                return object;
            }
            if (webSocketEvent instanceof WebSocketEvent.Frame && (webSocketFrame = (frame = WebSocketEvent.Frame$.MODULE$.unapply((WebSocketEvent.Frame)webSocketEvent))._1()) instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close c = (WebSocketFrame.Close)webSocketFrame;
                this.queue.offer((Object)WebSocketEvent.Error$.MODULE$.apply((Throwable)WebSocketClosed$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)c))));
                object = this.monad().unit((Object)c);
                return object;
            }
            if (!(webSocketEvent instanceof WebSocketEvent.Error)) {
                if (!(webSocketEvent instanceof WebSocketEvent.Frame)) throw new MatchError((Object)webSocketEvent);
                WebSocketEvent.Frame frame2 = WebSocketEvent.Frame$.MODULE$.unapply((WebSocketEvent.Frame)webSocketEvent);
                WebSocketFrame webSocketFrame2 = frame2._1();
                if (webSocketFrame2 == null) throw new MatchError((Object)webSocketEvent);
                WebSocketFrame f = webSocketFrame2;
                object = this.monad().unit((Object)f);
                return object;
            }
            WebSocketEvent.Error error = (WebSocketEvent.Error)webSocketEvent;
            WebSocketEvent.Error error2 = WebSocketEvent.Error$.MODULE$.unapply(error);
            Throwable throwable = error2._1();
            if (throwable instanceof Exception) {
                Exception t = (Exception)throwable;
                WebSocketEvent.Error e = error;
                this.queue.offer((Object)e);
                object = this.monad().error((Throwable)t);
                return object;
            }
            Throwable t = throwable;
            throw t;
        }, this.monad());
    }

    public F send(WebSocketFrame f, boolean isContinuation) {
        return (F)this.monad().flatten(this.monad().eval(() -> this.send$$anonfun$1(f, isContinuation)));
    }

    public boolean send$default$2() {
        return false;
    }

    public Headers upgradeHeaders() {
        return Headers$.MODULE$.apply((Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.ws.getUpgradeHeaders().iteratorAsString()).asScala()).map((Function1 & Serializable)e -> Header$.MODULE$.apply((String)e.getKey(), (String)e.getValue())).toList());
    }

    public F isOpen() {
        return (F)this.monad().eval(this::isOpen$$anonfun$1);
    }

    private F fromNettyFuture(Future<Void> f) {
        return (F)this.monad().async((Function1 & Serializable)cb -> {
            Future f2 = f.addListener((GenericFutureListener)new FutureListener<Void>(cb){
                private final Function1 cb$1;
                {
                    this.cb$1 = cb$2;
                }

                public void operationComplete(Future future) {
                    if (future.isSuccess()) {
                        this.cb$1.apply((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
                    } else {
                        this.cb$1.apply((Object)package$.MODULE$.Left().apply((Object)future.cause()));
                    }
                }
            });
            return Canceler$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> f2.cancel(true));
        });
    }

    private final Object receive$$anonfun$1() {
        return this.queue.poll();
    }

    private static final int send$$anonfun$2$$anonfun$1() {
        return 0;
    }

    private static final int send$$anonfun$3$$anonfun$2() {
        return 0;
    }

    private static final int send$$anonfun$4$$anonfun$3() {
        return 0;
    }

    private static final int send$$anonfun$5$$anonfun$4() {
        return 0;
    }

    private final Object send$$anonfun$1(WebSocketFrame f$1, boolean isContinuation$1) {
        Object object;
        WebSocketFrame webSocketFrame = f$1;
        if (webSocketFrame instanceof WebSocketFrame.Text) {
            WebSocketFrame.Text text = WebSocketFrame.Text$.MODULE$.unapply((WebSocketFrame.Text)webSocketFrame);
            String string = text._1();
            boolean bl = text._2();
            Option option = text._3();
            String payload = string;
            boolean finalFragment = bl;
            Option rsv = option;
            if (!isContinuation$1) {
                object = this.fromNettyFuture((Future<Void>)this.ws.sendTextFrame(payload, finalFragment, BoxesRunTime.unboxToInt((Object)rsv.getOrElse(WebSocketImpl::send$$anonfun$2$$anonfun$1))));
            } else {
                String payload2 = string;
                boolean finalFragment2 = bl;
                Option rsv2 = option;
                object = this.fromNettyFuture((Future<Void>)this.ws.sendContinuationFrame(payload2, finalFragment2, BoxesRunTime.unboxToInt((Object)rsv2.getOrElse(WebSocketImpl::send$$anonfun$3$$anonfun$2))));
            }
        } else if (webSocketFrame instanceof WebSocketFrame.Binary) {
            WebSocketFrame.Binary binary = WebSocketFrame.Binary$.MODULE$.unapply((WebSocketFrame.Binary)webSocketFrame);
            byte[] byArray = binary._1();
            boolean bl = binary._2();
            Option option = binary._3();
            byte[] payload = byArray;
            boolean finalFragment = bl;
            Option rsv = option;
            if (!isContinuation$1) {
                object = this.fromNettyFuture((Future<Void>)this.ws.sendBinaryFrame(payload, finalFragment, BoxesRunTime.unboxToInt((Object)rsv.getOrElse(WebSocketImpl::send$$anonfun$4$$anonfun$3))));
            } else {
                byte[] payload3 = byArray;
                boolean finalFragment3 = bl;
                Option rsv3 = option;
                object = this.fromNettyFuture((Future<Void>)this.ws.sendContinuationFrame(payload3, finalFragment3, BoxesRunTime.unboxToInt((Object)rsv3.getOrElse(WebSocketImpl::send$$anonfun$5$$anonfun$4))));
            }
        } else if (webSocketFrame instanceof WebSocketFrame.Ping) {
            byte[] byArray;
            WebSocketFrame.Ping ping = WebSocketFrame.Ping$.MODULE$.unapply((WebSocketFrame.Ping)webSocketFrame);
            byte[] payload = byArray = ping._1();
            object = this.fromNettyFuture((Future<Void>)this.ws.sendPingFrame(payload));
        } else if (webSocketFrame instanceof WebSocketFrame.Pong) {
            byte[] byArray;
            WebSocketFrame.Pong pong = WebSocketFrame.Pong$.MODULE$.unapply((WebSocketFrame.Pong)webSocketFrame);
            byte[] payload = byArray = pong._1();
            object = this.fromNettyFuture((Future<Void>)this.ws.sendPongFrame(payload));
        } else if (webSocketFrame instanceof WebSocketFrame.Close) {
            WebSocketFrame.Close close = WebSocketFrame.Close$.MODULE$.unapply((WebSocketFrame.Close)webSocketFrame);
            int n = close._1();
            String string = close._2();
            int statusCode = n;
            String reasonText = string;
            boolean wasOpen = this._isOpen.getAndSet(false);
            if (wasOpen) {
                this.queue.offer((Object)WebSocketEvent.Error$.MODULE$.apply((Throwable)WebSocketClosed$.MODULE$.apply((Option)None$.MODULE$)));
                object = this.fromNettyFuture((Future<Void>)this.ws.sendCloseFrame(statusCode, reasonText));
            } else {
                BoxedUnit boxedUnit = (BoxedUnit)syntax$.MODULE$.MonadErrorValueOps((Object)BoxedUnit.UNIT);
                object = syntax.MonadErrorValueOps$.MODULE$.unit$extension((Object)boxedUnit, this.monad());
            }
        } else {
            throw new MatchError((Object)webSocketFrame);
        }
        return object;
    }

    private final boolean isOpen$$anonfun$1() {
        return this._isOpen.get();
    }
}

