/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.opentracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.io.Serializable;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import sttp.client3.RequestT;
import sttp.client3.SttpBackend;
import sttp.client3.opentracing.OpenTracingBackend$;
import sttp.client3.opentracing.RequestBuilderAdapter;
import sttp.client3.opentracing.RequestBuilderCarrier;
import sttp.model.Method;
import sttp.model.Uri;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

public class OpenTracingBackend<F, P>
implements SttpBackend<F, P> {
    private final SttpBackend<F, P> delegate;
    private final Tracer tracer;
    private final MonadError<F> _monad;

    public static <U, T, R> RichRequest<U, T, R> RichRequest(RequestT<U, T, R> requestT) {
        return OpenTracingBackend$.MODULE$.RichRequest(requestT);
    }

    public static <F, P> SttpBackend<F, P> apply(SttpBackend<F, P> sttpBackend, Tracer tracer) {
        return OpenTracingBackend$.MODULE$.apply(sttpBackend, tracer);
    }

    public OpenTracingBackend(SttpBackend<F, P> delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
        this._monad = this.responseMonad();
    }

    public <T, R> F send(RequestT<Object, T, R> request) {
        return (F)syntax$.MODULE$.MonadErrorOps(() -> this.send$$anonfun$1(request)).flatMap((Function1 & Serializable)span -> {
            RequestBuilderAdapter requestBuilderAdapter = new RequestBuilderAdapter(request);
            this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new RequestBuilderCarrier(requestBuilderAdapter));
            return this.responseMonad().handleError(() -> this.send$$anonfun$7$$anonfun$3(span, requestBuilderAdapter), (PartialFunction)new Serializable((Span)span, this){
                private final Span span$1;
                private final OpenTracingBackend $outer;
                {
                    this.span$1 = span$7;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    Object[] objectArray = new Tuple2[2];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"event");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Tags.ERROR.getKey());
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"error.object");
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)e);
                    this.span$1.setTag((Tag)Tags.ERROR, (Object)Boolean.TRUE).log((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).finish();
                    return this.$outer.responseMonad().error(e);
                }
            });
        }, this._monad);
    }

    public F close() {
        return (F)this.delegate.close();
    }

    public MonadError<F> responseMonad() {
        return this.delegate.responseMonad();
    }

    private static final Function1 $anonfun$2() {
        return (Function1 & Serializable)x -> (Tracer.SpanBuilder)Predef$.MODULE$.identity(x);
    }

    private static final String $anonfun$3() {
        return "default-operation-id";
    }

    private static final Span send$$anonfun$3$$anonfun$1$$anonfun$1(Span span$2) {
        return span$2;
    }

    private final Span send$$anonfun$4$$anonfun$2(RequestT request$2) {
        Function1 spanBuilderTransformer = (Function1)Option$.MODULE$.option2Iterable(request$2.tag(OpenTracingBackend$.sttp$client3$opentracing$OpenTracingBackend$$$SpanBuilderTransformerRequestTag)).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof Function1) {
                    Function1 f = (Function1)object;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof Function1) {
                    Function1 f = (Function1)object2;
                    object = f;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        }).getOrElse(OpenTracingBackend::$anonfun$2);
        Span span = ((Tracer.SpanBuilder)spanBuilderTransformer.apply((Object)this.tracer.buildSpan(request$2.tag(OpenTracingBackend$.sttp$client3$opentracing$OpenTracingBackend$$$OperationIdRequestTag).getOrElse(OpenTracingBackend::$anonfun$3).toString()))).withTag((Tag)Tags.SPAN_KIND, (Object)"client").withTag((Tag)Tags.HTTP_METHOD, (Object)((Method)request$2.method()).method()).withTag((Tag)Tags.HTTP_URL, (Object)((Uri)request$2.uri()).toString()).withTag((Tag)Tags.COMPONENT, (Object)"sttp3-client").start();
        return (Span)Option$.MODULE$.option2Iterable(request$2.tag(OpenTracingBackend$.sttp$client3$opentracing$OpenTracingBackend$$$SpanTransformerRequestTag)).collectFirst((PartialFunction)new Serializable(span){
            private final Span span$1;
            {
                this.span$1 = span$6;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof Function1) {
                    Function1 spanTranformer = (Function1)object;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof Function1) {
                    Function1 spanTranformer = (Function1)object2;
                    object = spanTranformer.apply((Object)this.span$1);
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        }).getOrElse(() -> OpenTracingBackend.send$$anonfun$3$$anonfun$1$$anonfun$1(span));
    }

    private final Object send$$anonfun$1(RequestT request$1) {
        return this.responseMonad().eval(() -> this.send$$anonfun$4$$anonfun$2(request$1));
    }

    private final Object send$$anonfun$5$$anonfun$1$$anonfun$1(RequestBuilderAdapter requestBuilderAdapter$2) {
        return this.delegate.send(requestBuilderAdapter$2.request());
    }

    private final Object send$$anonfun$7$$anonfun$3(Span span$3, RequestBuilderAdapter requestBuilderAdapter$1) {
        return syntax$.MODULE$.MonadErrorOps(() -> this.send$$anonfun$5$$anonfun$1$$anonfun$1(requestBuilderAdapter$1)).map((Function1 & Serializable)response -> {
            span$3.setTag((Tag)Tags.HTTP_STATUS, (Object)response.code()).finish();
            return response;
        }, this._monad);
    }

    public static class RichRequest<U, T, R> {
        private final RequestT<U, T, R> request;

        public RichRequest(RequestT<U, T, R> request) {
            this.request = request;
        }

        public RequestT<U, T, R> tagWithOperationId(String operationId) {
            return this.request.tag(OpenTracingBackend$.sttp$client3$opentracing$OpenTracingBackend$$$OperationIdRequestTag, (Object)operationId);
        }

        public RequestT<U, T, R> tagWithTransformSpan(Function1<Span, Span> transformSpan) {
            return this.request.tag(OpenTracingBackend$.sttp$client3$opentracing$OpenTracingBackend$$$SpanTransformerRequestTag, transformSpan);
        }

        public RequestT<U, T, R> tagWithTransformSpanBuilder(Function1<Tracer.SpanBuilder, Tracer.SpanBuilder> transformSpan) {
            return this.request.tag(OpenTracingBackend$.sttp$client3$opentracing$OpenTracingBackend$$$SpanBuilderTransformerRequestTag, transformSpan);
        }

        public RequestT<U, T, R> setOpenTracingParentSpan(Span parent) {
            return this.tagWithTransformSpanBuilder((Function1<Tracer.SpanBuilder, Tracer.SpanBuilder>)(Function1 & Serializable)_$3 -> _$3.asChildOf(parent));
        }

        public RequestT<U, T, R> setOpenTracingParentSpanContext(SpanContext parentSpanContext) {
            return this.tagWithTransformSpanBuilder((Function1<Tracer.SpanBuilder, Tracer.SpanBuilder>)(Function1 & Serializable)_$4 -> _$4.asChildOf(parentSpanContext));
        }
    }
}

