/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.Summary;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.WeakHashMap;
import sttp.client3.FollowRedirectsBackend;
import sttp.client3.FollowRedirectsBackend$;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.SttpBackend;
import sttp.client3.listener.ListenerBackend;
import sttp.client3.listener.RequestListener;
import sttp.client3.listener.RequestListener$;
import sttp.client3.prometheus.BaseCollectorConfig;
import sttp.client3.prometheus.CollectorConfig;
import sttp.client3.prometheus.CollectorConfig$;
import sttp.client3.prometheus.HistogramCollectorConfig;
import sttp.client3.prometheus.HistogramCollectorConfig$;
import sttp.client3.prometheus.PrometheusListener;
import sttp.model.Method;
import sttp.model.StatusCode$;

public final class PrometheusBackend$ {
    public static PrometheusBackend$ MODULE$;
    private final String DefaultHistogramName;
    private final String DefaultRequestsInProgressGaugeName;
    private final String DefaultSuccessCounterName;
    private final String DefaultErrorCounterName;
    private final String DefaultFailureCounterName;
    private final String DefaultRequestSizeName;
    private final String DefaultResponseSizeName;
    private final String DefaultMethodLabel;
    private final String DefaultStatusLabel;
    private final WeakHashMap<CollectorRegistry, ConcurrentHashMap<String, Histogram>> histograms;
    private final WeakHashMap<CollectorRegistry, ConcurrentHashMap<String, Gauge>> gauges;
    private final WeakHashMap<CollectorRegistry, ConcurrentHashMap<String, Counter>> counters;
    private final WeakHashMap<CollectorRegistry, ConcurrentHashMap<String, Summary>> summaries;

    static {
        new PrometheusBackend$();
    }

    public String DefaultHistogramName() {
        return this.DefaultHistogramName;
    }

    public String DefaultRequestsInProgressGaugeName() {
        return this.DefaultRequestsInProgressGaugeName;
    }

    public String DefaultSuccessCounterName() {
        return this.DefaultSuccessCounterName;
    }

    public String DefaultErrorCounterName() {
        return this.DefaultErrorCounterName;
    }

    public String DefaultFailureCounterName() {
        return this.DefaultFailureCounterName;
    }

    public String DefaultRequestSizeName() {
        return this.DefaultRequestSizeName;
    }

    public String DefaultResponseSizeName() {
        return this.DefaultResponseSizeName;
    }

    public String DefaultMethodLabel() {
        return this.DefaultMethodLabel;
    }

    public String DefaultStatusLabel() {
        return this.DefaultStatusLabel;
    }

    public <F, P> SttpBackend<F, P> apply(SttpBackend<F, P> delegate, Function1<RequestT<Object, ?, ?>, Option<HistogramCollectorConfig>> requestToHistogramNameMapper, Function1<RequestT<Object, ?, ?>, Option<CollectorConfig>> requestToInProgressGaugeNameMapper, Function2<RequestT<Object, ?, ?>, Response<?>, Option<CollectorConfig>> responseToSuccessCounterMapper, Function2<RequestT<Object, ?, ?>, Response<?>, Option<CollectorConfig>> responseToErrorCounterMapper, Function2<RequestT<Object, ?, ?>, Throwable, Option<CollectorConfig>> requestToFailureCounterMapper, Function1<RequestT<Object, ?, ?>, Option<CollectorConfig>> requestToSizeSummaryMapper, Function2<RequestT<Object, ?, ?>, Response<?>, Option<CollectorConfig>> responseToSizeSummaryMapper, CollectorRegistry collectorRegistry) {
        return new FollowRedirectsBackend((SttpBackend)new ListenerBackend(delegate, RequestListener$.MODULE$.lift((RequestListener)new PrometheusListener((Function1 & Serializable & scala.Serializable)req -> (Option)requestToHistogramNameMapper.apply(req), (Function1 & Serializable & scala.Serializable)req -> (Option)requestToInProgressGaugeNameMapper.apply(req), (Function1 & Serializable & scala.Serializable)rr -> (Option)responseToSuccessCounterMapper.apply(rr._1(), rr._2()), (Function1 & Serializable & scala.Serializable)rr -> (Option)responseToErrorCounterMapper.apply(rr._1(), rr._2()), (Function1 & Serializable & scala.Serializable)r -> (Option)requestToFailureCounterMapper.apply(r._1(), r._2()), (Function1 & Serializable & scala.Serializable)req -> (Option)requestToSizeSummaryMapper.apply(req), (Function1 & Serializable & scala.Serializable)rr -> (Option)responseToSizeSummaryMapper.apply(rr._1(), rr._2()), collectorRegistry, this.cacheFor(this.histograms(), collectorRegistry), this.cacheFor(this.gauges(), collectorRegistry), this.cacheFor(this.counters(), collectorRegistry), this.cacheFor(this.summaries(), collectorRegistry)), delegate.responseMonad())), FollowRedirectsBackend$.MODULE$.$lessinit$greater$default$2(), FollowRedirectsBackend$.MODULE$.$lessinit$greater$default$3(), FollowRedirectsBackend$.MODULE$.$lessinit$greater$default$4());
    }

    public <F, P> Function1<RequestT<Object, ?, ?>, Option<HistogramCollectorConfig>> apply$default$2() {
        return (Function1 & Serializable & scala.Serializable)req -> new Some((Object)MODULE$.addMethodLabel((BaseCollectorConfig)new HistogramCollectorConfig(MODULE$.DefaultHistogramName(), HistogramCollectorConfig$.MODULE$.apply$default$2(), HistogramCollectorConfig$.MODULE$.apply$default$3()), (RequestT<Object, ?, ?>)req));
    }

    public <F, P> Function1<RequestT<Object, ?, ?>, Option<CollectorConfig>> apply$default$3() {
        return (Function1 & Serializable & scala.Serializable)req -> new Some((Object)MODULE$.addMethodLabel((BaseCollectorConfig)new CollectorConfig(MODULE$.DefaultRequestsInProgressGaugeName(), CollectorConfig$.MODULE$.apply$default$2()), (RequestT<Object, ?, ?>)req));
    }

    public <F, P> Function2<RequestT<Object, ?, ?>, Response<?>, Option<CollectorConfig>> apply$default$4() {
        return (Function2 & Serializable & scala.Serializable)(req, resp) -> new Some((Object)MODULE$.addStatusLabel((BaseCollectorConfig)MODULE$.addMethodLabel((BaseCollectorConfig)new CollectorConfig(MODULE$.DefaultSuccessCounterName(), CollectorConfig$.MODULE$.apply$default$2()), (RequestT<Object, ?, ?>)req), (Response<?>)resp));
    }

    public <F, P> Function2<RequestT<Object, ?, ?>, Response<?>, Option<CollectorConfig>> apply$default$5() {
        return (Function2 & Serializable & scala.Serializable)(req, resp) -> new Some((Object)MODULE$.addStatusLabel((BaseCollectorConfig)MODULE$.addMethodLabel((BaseCollectorConfig)new CollectorConfig(MODULE$.DefaultErrorCounterName(), CollectorConfig$.MODULE$.apply$default$2()), (RequestT<Object, ?, ?>)req), (Response<?>)resp));
    }

    public <F, P> Function2<RequestT<Object, ?, ?>, Throwable, Option<CollectorConfig>> apply$default$6() {
        return (Function2 & Serializable & scala.Serializable)(req, x$1) -> new Some((Object)MODULE$.addMethodLabel((BaseCollectorConfig)new CollectorConfig(MODULE$.DefaultFailureCounterName(), CollectorConfig$.MODULE$.apply$default$2()), (RequestT<Object, ?, ?>)req));
    }

    public <F, P> Function1<RequestT<Object, ?, ?>, Option<CollectorConfig>> apply$default$7() {
        return (Function1 & Serializable & scala.Serializable)req -> new Some((Object)MODULE$.addMethodLabel((BaseCollectorConfig)new CollectorConfig(MODULE$.DefaultRequestSizeName(), CollectorConfig$.MODULE$.apply$default$2()), (RequestT<Object, ?, ?>)req));
    }

    public <F, P> Function2<RequestT<Object, ?, ?>, Response<?>, Option<CollectorConfig>> apply$default$8() {
        return (Function2 & Serializable & scala.Serializable)(req, resp) -> new Some((Object)MODULE$.addStatusLabel((BaseCollectorConfig)MODULE$.addMethodLabel((BaseCollectorConfig)new CollectorConfig(MODULE$.DefaultResponseSizeName(), CollectorConfig$.MODULE$.apply$default$2()), (RequestT<Object, ?, ?>)req), (Response<?>)resp));
    }

    public <F, P> CollectorRegistry apply$default$9() {
        return CollectorRegistry.defaultRegistry;
    }

    public <T extends BaseCollectorConfig> BaseCollectorConfig addMethodLabel(T config, RequestT<Object, ?, ?> req) {
        None$ methodLabel = ((LinearSeqOptimized)config.labels().map((Function1 & Serializable & scala.Serializable)x$2 -> ((String)x$2._1()).toLowerCase(), List$.MODULE$.canBuildFrom())).contains((Object)this.DefaultMethodLabel()) ? None$.MODULE$ : new Some((Object)new Tuple2((Object)this.DefaultMethodLabel(), (Object)((Method)req.method()).method().toUpperCase()));
        return config.addLabels((List<Tuple2<String, String>>)methodLabel.toList());
    }

    public <T extends BaseCollectorConfig> BaseCollectorConfig addStatusLabel(T config, Response<?> resp) {
        None$ statusLabel = ((LinearSeqOptimized)config.labels().map((Function1 & Serializable & scala.Serializable)x$3 -> ((String)x$3._1()).toLowerCase(), List$.MODULE$.canBuildFrom())).contains((Object)this.DefaultStatusLabel()) ? None$.MODULE$ : new Some((Object)new Tuple2((Object)this.DefaultStatusLabel(), (Object)this.mapStatusToLabelValue(resp.code())));
        return config.addLabels((List<Tuple2<String, String>>)statusLabel.toList());
    }

    private String mapStatusToLabelValue(int s) {
        if (StatusCode$.MODULE$.isInformational$extension(s)) {
            return "1xx";
        }
        if (StatusCode$.MODULE$.isSuccess$extension(s)) {
            return "2xx";
        }
        if (StatusCode$.MODULE$.isRedirect$extension(s)) {
            return "3xx";
        }
        if (StatusCode$.MODULE$.isClientError$extension(s)) {
            return "4xx";
        }
        if (StatusCode$.MODULE$.isServerError$extension(s)) {
            return "5xx";
        }
        return Integer.toString(s);
    }

    public void clear(CollectorRegistry collectorRegistry) {
        collectorRegistry.clear();
        this.histograms().remove((Object)collectorRegistry);
        this.gauges().remove((Object)collectorRegistry);
        this.counters().remove((Object)collectorRegistry);
        this.summaries().remove((Object)collectorRegistry);
    }

    private WeakHashMap<CollectorRegistry, ConcurrentHashMap<String, Histogram>> histograms() {
        return this.histograms;
    }

    private WeakHashMap<CollectorRegistry, ConcurrentHashMap<String, Gauge>> gauges() {
        return this.gauges;
    }

    private WeakHashMap<CollectorRegistry, ConcurrentHashMap<String, Counter>> counters() {
        return this.counters;
    }

    private WeakHashMap<CollectorRegistry, ConcurrentHashMap<String, Summary>> summaries() {
        return this.summaries;
    }

    private <T> ConcurrentHashMap<String, T> cacheFor(WeakHashMap<CollectorRegistry, ConcurrentHashMap<String, T>> cache, CollectorRegistry collectorRegistry) {
        ConcurrentHashMap concurrentHashMap;
        WeakHashMap<CollectorRegistry, ConcurrentHashMap<String, T>> weakHashMap = cache;
        synchronized (weakHashMap) {
            concurrentHashMap = (ConcurrentHashMap)cache.getOrElseUpdate((Object)collectorRegistry, (Function0 & Serializable & scala.Serializable)() -> new ConcurrentHashMap());
        }
        return concurrentHashMap;
    }

    private PrometheusBackend$() {
        MODULE$ = this;
        this.DefaultHistogramName = "sttp_request_latency";
        this.DefaultRequestsInProgressGaugeName = "sttp_requests_in_progress";
        this.DefaultSuccessCounterName = "sttp_requests_success_count";
        this.DefaultErrorCounterName = "sttp_requests_error_count";
        this.DefaultFailureCounterName = "sttp_requests_failure_count";
        this.DefaultRequestSizeName = "sttp_request_size_bytes";
        this.DefaultResponseSizeName = "sttp_response_size_bytes";
        this.DefaultMethodLabel = "method";
        this.DefaultStatusLabel = "status";
        this.histograms = new WeakHashMap();
        this.gauges = new WeakHashMap();
        this.counters = new WeakHashMap();
        this.summaries = new WeakHashMap();
    }
}

