/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.logging.slf4j;

import java.io.Serializable;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.runtime.BoxedUnit;
import sttp.client3.logging.LogLevel;
import sttp.client3.logging.Logger;
import sttp.monad.MonadError;

public class Slf4jLogger<F>
implements Logger<F> {
    private final MonadError<F> monad;
    private final org.slf4j.Logger underlying;

    public Slf4jLogger(String name, MonadError<F> monad) {
        this.monad = monad;
        this.underlying = LoggerFactory.getLogger((String)name);
    }

    public F apply(LogLevel level, Function0<String> message) {
        return (F)this.monad.eval((Function0 & Serializable)() -> {
            this.apply$$anonfun$1(level, message);
            return BoxedUnit.UNIT;
        });
    }

    public F apply(LogLevel level, Function0<String> message, Throwable t) {
        return (F)this.monad.eval((Function0 & Serializable)() -> {
            this.apply$$anonfun$2(level, message, t);
            return BoxedUnit.UNIT;
        });
    }

    private final void apply$$anonfun$1(LogLevel level$1, Function0 message$1) {
        LogLevel logLevel = level$1;
        if (LogLevel.Trace$.MODULE$.equals(logLevel)) {
            if (this.underlying.isTraceEnabled()) {
                this.underlying.trace((String)message$1.apply());
                return;
            }
            return;
        }
        if (LogLevel.Debug$.MODULE$.equals(logLevel)) {
            if (this.underlying.isDebugEnabled()) {
                this.underlying.debug((String)message$1.apply());
                return;
            }
            return;
        }
        if (LogLevel.Info$.MODULE$.equals(logLevel)) {
            if (this.underlying.isInfoEnabled()) {
                this.underlying.info((String)message$1.apply());
                return;
            }
            return;
        }
        if (LogLevel.Warn$.MODULE$.equals(logLevel)) {
            if (this.underlying.isWarnEnabled()) {
                this.underlying.warn((String)message$1.apply());
                return;
            }
            return;
        }
        if (LogLevel.Error$.MODULE$.equals(logLevel)) {
            if (this.underlying.isErrorEnabled()) {
                this.underlying.error((String)message$1.apply());
                return;
            }
            return;
        }
        throw new MatchError((Object)logLevel);
    }

    private final void apply$$anonfun$2(LogLevel level$2, Function0 message$2, Throwable t$1) {
        LogLevel logLevel = level$2;
        if (LogLevel.Trace$.MODULE$.equals(logLevel)) {
            if (this.underlying.isTraceEnabled()) {
                this.underlying.trace((String)message$2.apply(), t$1);
                return;
            }
            return;
        }
        if (LogLevel.Debug$.MODULE$.equals(logLevel)) {
            if (this.underlying.isDebugEnabled()) {
                this.underlying.debug((String)message$2.apply(), t$1);
                return;
            }
            return;
        }
        if (LogLevel.Info$.MODULE$.equals(logLevel)) {
            if (this.underlying.isInfoEnabled()) {
                this.underlying.info((String)message$2.apply(), t$1);
                return;
            }
            return;
        }
        if (LogLevel.Warn$.MODULE$.equals(logLevel)) {
            if (this.underlying.isWarnEnabled()) {
                this.underlying.warn((String)message$2.apply(), t$1);
                return;
            }
            return;
        }
        if (LogLevel.Error$.MODULE$.equals(logLevel)) {
            if (this.underlying.isErrorEnabled()) {
                this.underlying.error((String)message$2.apply(), t$1);
                return;
            }
            return;
        }
        throw new MatchError((Object)logLevel);
    }
}

