/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.mockserver;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import io.circe.Decoder$;
import io.circe.JsonObject;
import io.circe.Printer;
import io.circe.Printer$;
import io.circe.parser.package$;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Either$;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.SttpBackend;
import sttp.model.ContentTypeRange$;
import sttp.model.HasHeaders;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.Headers;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.model.Method;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;
import sttp.model.Uri;
import sttp.tapir.CodecFormat;
import sttp.tapir.DecodeResult;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointOutput;
import sttp.tapir.RawBodyType;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.capabilities.NoStreams;
import sttp.tapir.capabilities.NoStreams$;
import sttp.tapir.client.sttp.SttpClientInterpreter$;
import sttp.tapir.client.sttp.WebSocketToPipe$;
import sttp.tapir.internal.package;
import sttp.tapir.server.interpreter.EncodeOutputs;
import sttp.tapir.server.interpreter.OutputValues;
import sttp.tapir.server.interpreter.OutputValues$;
import sttp.tapir.server.interpreter.ToResponseBody;
import sttp.tapir.server.mockserver.ExpectationBodyDefinition;
import sttp.tapir.server.mockserver.ExpectationBodyDefinition$JsonMatchType$Strict$;
import sttp.tapir.server.mockserver.ExpectationRequestDefinition;
import sttp.tapir.server.mockserver.ExpectationResponseDefinition;
import sttp.tapir.server.mockserver.MockServerException;
import sttp.tapir.server.mockserver.SttpMockServerClient;

public final class SttpMockServerClient$ {
    public static final SttpMockServerClient$ MODULE$ = new SttpMockServerClient$();
    private static final Printer sttp$tapir$server$mockserver$SttpMockServerClient$$printer = Printer$.MODULE$.noSpaces();

    public <F> SttpMockServerClient<F> apply(Uri baseUri, SttpBackend<F, Object> backend) {
        return new SttpMockServerClient<F>(baseUri, backend);
    }

    public <A, E, I, O> ExpectationRequestDefinition sttp$tapir$server$mockserver$SttpMockServerClient$$toExpectationRequest(Endpoint<A, I, E, O, Object> endpoint, A securityInput, I input) {
        RequestT request = (RequestT)((Function1)SttpClientInterpreter$.MODULE$.apply(SttpClientInterpreter$.MODULE$.apply$default$1()).toSecureRequest(endpoint, (Option)None$.MODULE$, WebSocketToPipe$.MODULE$.webSocketsNotSupported()).apply(securityInput)).apply(input);
        return new ExpectationRequestDefinition(((Method)request.method()).method(), (Uri)request.uri(), this.toExpectationBody(request), this.headersToMultiMapOpt((Seq<Header>)request.headers()));
    }

    public <E, I, O> ExpectationResponseDefinition sttp$tapir$server$mockserver$SttpMockServerClient$$toExpectationResponse(OutputValues<Object> outputValues, int statusCode) {
        return new ExpectationResponseDefinition(((StatusCode)outputValues.statusCode().getOrElse((Function0 & Serializable)() -> new StatusCode(statusCode))).code(), this.toExpectationBody(outputValues), this.headersToMultiMapOpt((Seq<Header>)outputValues.headers()));
    }

    private <E, O> Option<ExpectationBodyDefinition> toExpectationBody(RequestT<Object, DecodeResult<Either<E, O>>, Object> request) {
        return Option$.MODULE$.apply((Object)new String(sttp.client3.testing.package$.MODULE$.RichTestingRequest(request).forceBodyAsByteArray())).withFilter((Function1 & Serializable)body -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(body)))).flatMap((Function1 & Serializable)body -> request.contentType().flatMap((Function1 & Serializable)contentTypeRaw -> MediaType$.MODULE$.parse(contentTypeRaw).toOption().map((Function1 & Serializable)contentType -> MODULE$.stringToBodyDefinition((MediaType)contentType, (String)body))));
    }

    private Option<ExpectationBodyDefinition> toExpectationBody(OutputValues<Object> outputValues) {
        return outputValues.body().map((Function1 & Serializable)x$4 -> x$4.apply((Object)new Headers(outputValues.headers())).toString()).withFilter((Function1 & Serializable)body -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(body)))).flatMap((Function1 & Serializable)body -> outputValues.headers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SttpMockServerClient$.$anonfun$toExpectationBody$8(x$5))).flatMap((Function1 & Serializable)contentTypeRaw -> MediaType$.MODULE$.parse(contentTypeRaw.value()).toOption().map((Function1 & Serializable)contentType -> MODULE$.stringToBodyDefinition((MediaType)contentType, (String)body))));
    }

    private ExpectationBodyDefinition stringToBodyDefinition(MediaType contentType, String body) {
        MediaType mediaType = contentType;
        MediaType mediaType2 = MediaType$.MODULE$.ApplicationJson();
        MediaType mediaType3 = mediaType;
        if (!(mediaType2 != null ? !mediaType2.equals(mediaType3) : mediaType3 != null)) {
            return new ExpectationBodyDefinition.JsonBodyDefinition((JsonObject)EitherOps$.MODULE$.valueOr$extension(package.either$.MODULE$.catsSyntaxEither(package$.MODULE$.decode(body, Decoder$.MODULE$.decodeJsonObject())), (Function1 & Serializable)x$6 -> {
                throw x$6;
            }), ExpectationBodyDefinition$JsonMatchType$Strict$.MODULE$);
        }
        return new ExpectationBodyDefinition.PlainBodyDefinition(body, mediaType);
    }

    public <A, E, I, O> OutputValues<Object> sttp$tapir$server$mockserver$SttpMockServerClient$$toOutputValues(Endpoint<A, I, E, O, Object> endpoint, Either<E, O> expectedOutput) {
        Object responseValue = Either.MergeableEither$.MODULE$.merge$extension(Either$.MODULE$.MergeableEither(expectedOutput));
        ToResponseBody<Object, NoStreams> toResponseBody = new ToResponseBody<Object, NoStreams>(){
            private final NoStreams streams;

            public NoStreams streams() {
                return this.streams;
            }

            public <RAW> Object fromRawValue(RAW v, HasHeaders headers, CodecFormat format, RawBodyType<RAW> bodyType) {
                return v;
            }

            public Object fromStreamValue(Nothing$ v, HasHeaders headers, CodecFormat format, Option<Charset> charset) {
                throw v;
            }

            public <REQ, RESP> Object fromWebSocketPipe(Nothing$ pipe, WebSocketBodyOutput<Nothing$, REQ, RESP, ?, NoStreams> o) {
                throw pipe;
            }
            {
                this.streams = NoStreams$.MODULE$;
            }
        };
        return new EncodeOutputs((ToResponseBody)toResponseBody, (Seq)new .colon.colon((Object)ContentTypeRange$.MODULE$.AnyRange(), (List)Nil$.MODULE$)).apply((EndpointOutput)expectedOutput.fold((Function1 & Serializable)x$7 -> endpoint.errorOutput(), (Function1 & Serializable)x$8 -> endpoint.output()), (package.Params)new package.ParamsAsAny(responseValue), OutputValues$.MODULE$.empty());
    }

    private Option<Map<String, List<String>>> headersToMultiMapOpt(Seq<Header> headers) {
        if (headers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)headers.groupBy((Function1 & Serializable)x$9 -> x$9.name()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)((IterableOnceOps)values.map((Function1 & Serializable)x$10 -> x$10.value())).toList());
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public Printer sttp$tapir$server$mockserver$SttpMockServerClient$$printer() {
        return sttp$tapir$server$mockserver$SttpMockServerClient$$printer;
    }

    public Either<Throwable, BoxedUnit> sttp$tapir$server$mockserver$SttpMockServerClient$$handleSimpleResponse(Response<Either<String, String>> response) {
        return ((Either)response.body()).left().map((Function1 & Serializable)error -> new MockServerException.UnexpectedError(response.code(), (String)error)).map((Function1 & Serializable)x$11 -> {
            SttpMockServerClient$.$anonfun$handleSimpleResponse$2(x$11);
            return BoxedUnit.UNIT;
        });
    }

    public <A> Either<Throwable, A> sttp$tapir$server$mockserver$SttpMockServerClient$$handleResponse(Response<Either<String, String>> response, Function1<String, Throwable> onBadRequest, Function1<String, Throwable> onNotAcceptable, Function1<String, Either<Throwable, A>> onSuccess) {
        return ((Either)response.body()).left().map((Function1 & Serializable)errorBody -> {
            if (response.code() == StatusCode$.MODULE$.BadRequest()) {
                return (Throwable)onBadRequest.apply(errorBody);
            }
            if (response.code() == StatusCode$.MODULE$.NotAcceptable()) {
                return (Throwable)onNotAcceptable.apply(errorBody);
            }
            return new MockServerException.UnexpectedError(response.code(), (String)errorBody);
        }).flatMap(onSuccess);
    }

    public static final /* synthetic */ boolean $anonfun$toExpectationBody$8(Header x$5) {
        String string = x$5.name();
        String string2 = HeaderNames$.MODULE$.ContentType();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$handleSimpleResponse$2(String x$11) {
    }

    private SttpMockServerClient$() {
    }
}

