/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.akkahttp;

import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.Multipart;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.unmarshalling.Unmarshaller;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import sttp.capabilities.akka.AkkaStreams;
import sttp.capabilities.akka.AkkaStreams$;
import sttp.model.Header$;
import sttp.model.Part;
import sttp.tapir.FileRange;
import sttp.tapir.FileRange$;
import sttp.tapir.RawBodyType;
import sttp.tapir.model.ServerRequest;
import sttp.tapir.server.akkahttp.AkkaHttpServerOptions;
import sttp.tapir.server.interpreter.RawValue;
import sttp.tapir.server.interpreter.RawValue$;
import sttp.tapir.server.interpreter.RequestBody;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc!\u0002\u0007\u000e\u00015)\u0002\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011Y\u0002!\u0011!Q\u0001\f]B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ya\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0011K\u0011\u0019Y\u0005\u0001)A\u0005Q!)A\n\u0001C!\u001b\")A\u000e\u0001C![\")A\u000f\u0001C\u0005k\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0001bBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0002\u0010\u0003.\\\u0017MU3rk\u0016\u001cHOQ8es*\u0011abD\u0001\tC.\\\u0017\r\u001b;ua*\u0011\u0001#E\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005I\u0019\u0012!\u0002;ba&\u0014(\"\u0001\u000b\u0002\tM$H\u000f]\n\u0004\u0001Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0003\u001eA\tBS\"\u0001\u0010\u000b\u0005}y\u0011aC5oi\u0016\u0014\bO]3uKJL!!\t\u0010\u0003\u0017I+\u0017/^3ti\n{G-\u001f\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003Ka\t!bY8oGV\u0014(/\u001a8u\u0013\t9CE\u0001\u0004GkR,(/\u001a\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nA!Y6lC*\u0011QfE\u0001\rG\u0006\u0004\u0018MY5mSRLWm]\u0005\u0003_)\u00121\"Q6lCN#(/Z1ng\u0006i1/\u001a:wKJ|\u0005\u000f^5p]N\u001c\u0001\u0001\u0005\u00024i5\tQ\"\u0003\u00026\u001b\t)\u0012i[6b\u0011R$\boU3sm\u0016\u0014x\n\u001d;j_:\u001c\u0018aA7biB\u0011\u0001\bP\u0007\u0002s)\u0011!hO\u0001\u0007gR\u0014X-Y7\u000b\u0003-J!!P\u001d\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0002\u0005\u0015\u001c\u0007CA\u0012A\u0013\t\tEE\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\"\u0001\u0012%\u0015\u0007\u00153u\t\u0005\u00024\u0001!)a\u0007\u0002a\u0002o!)a\b\u0002a\u0002\u007f!)\u0001\u0007\u0002a\u0001e\u000591\u000f\u001e:fC6\u001cX#\u0001\u0015\u0002\u0011M$(/Z1ng\u0002\nQ\u0001^8SC^,\"AT+\u0015\u0007=sf\rE\u0002$MA\u00032!H)T\u0013\t\u0011fD\u0001\u0005SC^4\u0016\r\\;f!\t!V\u000b\u0004\u0001\u0005\u000bY;!\u0019A,\u0003\u0003I\u000b\"\u0001W.\u0011\u0005]I\u0016B\u0001.\u0019\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u0006/\n\u0005uC\"aA!os\")ql\u0002a\u0001A\u00069!/Z9vKN$\bCA1e\u001b\u0005\u0011'BA2\u0012\u0003\u0015iw\u000eZ3m\u0013\t)'MA\u0007TKJ4XM\u001d*fcV,7\u000f\u001e\u0005\u0006O\u001e\u0001\r\u0001[\u0001\tE>$\u0017\u0010V=qKB\u0019\u0011N[*\u000e\u0003EI!a[\t\u0003\u0017I\u000bwOQ8esRK\b/Z\u0001\ti>\u001cFO]3b[R\u0011an\u001d\t\u0003_Ft!\u0001]\u0003\u000e\u0003\u0001I!A\u001d\u0018\u0003\u0019\tKg.\u0019:z'R\u0014X-Y7\t\u000b}C\u0001\u0019\u00011\u0002#\u0005\\7.\u001a*fcV,7\u000f^#oi&$\u0018\u0010\u0006\u0002w\u007fB\u0011q/`\u0007\u0002q*\u00111-\u001f\u0006\u0003un\f\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0003yn\nA\u0001\u001b;ua&\u0011a\u0010\u001f\u0002\u000e%\u0016\fX/Z:u\u000b:$\u0018\u000e^=\t\u000b}K\u0001\u0019\u00011\u0002\u001fQ|'+Y<Ge>lWI\u001c;jif,B!!\u0002\u0002\u000eQA\u0011qAA\b\u0003#\tY\u0002\u0005\u0003$M\u0005%\u0001\u0003B\u000fR\u0003\u0017\u00012\u0001VA\u0007\t\u00151&B1\u0001X\u0011\u0015y&\u00021\u0001a\u0011\u001d\t\u0019B\u0003a\u0001\u0003+\tAAY8esB\u0019q/a\u0006\n\u0007\u0005e\u0001P\u0001\u0006IiR\u0004XI\u001c;jifDaa\u001a\u0006A\u0002\u0005u\u0001\u0003B5k\u0003\u0017\t\u0011\u0002^8SC^\u0004\u0016M\u001d;\u0016\t\u0005\r\u00121\u0007\u000b\t\u0003K\t)$a\u000e\u0002RA!1EJA\u0014!\u0019\tI#!\f\u000225\u0011\u00111\u0006\u0006\u0003GNIA!a\f\u0002,\t!\u0001+\u0019:u!\r!\u00161\u0007\u0003\u0006-.\u0011\ra\u0016\u0005\u0006?.\u0001\r\u0001\u0019\u0005\b\u0003sY\u0001\u0019AA\u001e\u0003\u0011\u0001\u0018M\u001d;\u0011\t\u0005u\u00121\n\b\u0005\u0003\u007f\t)ED\u0002x\u0003\u0003J1!a\u0011y\u0003%iU\u000f\u001c;ja\u0006\u0014H/\u0003\u0003\u0002H\u0005%\u0013\u0001\u0003$pe6$\u0015\r^1\u000b\u0007\u0005\r\u00030\u0003\u0003\u0002N\u0005=#\u0001\u0003\"pIf\u0004\u0016M\u001d;\u000b\t\u0005\u001d\u0013\u0011\n\u0005\u0007O.\u0001\r!a\u0015\u0011\t%T\u0017\u0011\u0007")
public class AkkaRequestBody
implements RequestBody<Future, AkkaStreams> {
    private final AkkaHttpServerOptions serverOptions;
    private final Materializer mat;
    private final ExecutionContext ec;
    private final AkkaStreams streams;
    private volatile boolean bitmap$init$0;

    public AkkaStreams streams() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/tapir/tapir/server/akka-http-server/src/main/scala/sttp/tapir/server/akkahttp/AkkaRequestBody.scala: 22");
        }
        return this.streams;
    }

    public <R> Future<RawValue<R>> toRaw(ServerRequest request, RawBodyType<R> bodyType) {
        return this.toRawFromEntity(request, (HttpEntity)this.akkeRequestEntity(request), bodyType);
    }

    public Source<ByteString, Object> toStream(ServerRequest request) {
        return this.akkeRequestEntity(request).dataBytes();
    }

    private RequestEntity akkeRequestEntity(ServerRequest request) {
        return ((RequestContext)request.underlying()).request().entity();
    }

    private <R> Future<RawValue<R>> toRawFromEntity(ServerRequest request, HttpEntity body, RawBodyType<R> bodyType) {
        Future future;
        RawBodyType<R> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            future = ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.stringUnmarshaller())).apply((Object)body, this.ec, this.mat).map((Function1 & Serializable)x$1 -> new RawValue(x$1, RawValue$.MODULE$.apply$default$2()), this.ec);
        } else if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            future = ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.byteArrayUnmarshaller())).apply((Object)body, this.ec, this.mat).map((Function1 & Serializable)x$2 -> new RawValue(x$2, RawValue$.MODULE$.apply$default$2()), this.ec);
        } else if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            future = ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.byteStringUnmarshaller())).apply((Object)body, this.ec, this.mat).map((Function1 & Serializable)b -> new RawValue((Object)b.asByteBuffer(), RawValue$.MODULE$.apply$default$2()), this.ec);
        } else if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            future = ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.byteArrayUnmarshaller())).apply((Object)body, this.ec, this.mat).map((Function1 & Serializable)b -> new RawValue((Object)new ByteArrayInputStream((byte[])b), RawValue$.MODULE$.apply$default$2()), this.ec);
        } else if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            future = ((Future)this.serverOptions.createFile().apply((Object)request)).flatMap((Function1 & Serializable)file -> ((Future)body.dataBytes().runWith((Graph)FileIO$.MODULE$.toPath(file.toPath(), FileIO$.MODULE$.toPath$default$2()), $this.mat)).map((Function1 & Serializable)x$3 -> new FileRange(file, FileRange$.MODULE$.apply$default$2()), $this.ec).map((Function1 & Serializable)f -> new RawValue(f, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FileRange[]{f}))), $this.ec), this.ec);
        } else if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody multipartBody = (RawBodyType.MultipartBody)rawBodyType;
            future = ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.multipartFormDataUnmarshaller(Unmarshaller$.MODULE$.multipartFormDataUnmarshaller$default$1(), Unmarshaller$.MODULE$.multipartFormDataUnmarshaller$default$2()))).apply((Object)body, this.ec, this.mat).flatMap((Function1 & Serializable)fd -> ((Future)((Source)fd.parts().mapConcat((Function1 & Serializable)part -> multipartBody.partType(part.name()).map((Function1 & Serializable)x$4 -> new Tuple2(part, x$4)).toList()).mapAsync(1, (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Multipart.FormData.BodyPart part = (Multipart.FormData.BodyPart)tuple2._1();
                RawBodyType codecMeta = (RawBodyType)tuple2._2();
                Future future = this.toRawPart(request, part, codecMeta);
                return future;
            })).runWith((Graph)Sink$.MODULE$.seq(), $this.mat)).map((Function1 & Serializable)parts -> RawValue$.MODULE$.fromParts(parts), $this.ec), this.ec);
        } else {
            throw new MatchError(rawBodyType);
        }
        return future;
    }

    private <R> Future<Part<R>> toRawPart(ServerRequest request, Multipart.FormData.BodyPart part, RawBodyType<R> bodyType) {
        return this.toRawFromEntity(request, (HttpEntity)part.entity(), bodyType).map((Function1 & Serializable)r -> new Part(part.name(), r.value(), part.additionalDispositionParams(), (Seq)part.additionalHeaders().map((Function1 & Serializable)h -> Header$.MODULE$.apply(h.name(), h.value()))).contentType(part.entity().contentType().toString()), this.ec);
    }

    public AkkaRequestBody(AkkaHttpServerOptions serverOptions, Materializer mat, ExecutionContext ec) {
        this.serverOptions = serverOptions;
        this.mat = mat;
        this.ec = ec;
        this.streams = AkkaStreams$.MODULE$;
        this.bitmap$init$0 = true;
    }
}

