/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.files;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.model.ContentRangeUnits$;
import sttp.model.MediaType;
import sttp.model.headers.ETag;
import sttp.model.headers.Range;
import sttp.monad.MonadError;
import sttp.monad.MonadError$;
import sttp.monad.syntax;
import sttp.monad.syntax$;
import sttp.tapir.FileRange;
import sttp.tapir.RangeValue;
import sttp.tapir.files.FilesOptions;
import sttp.tapir.files.FilesOptions$;
import sttp.tapir.files.ResolvedUrl;
import sttp.tapir.files.StaticErrorOutput;
import sttp.tapir.files.StaticErrorOutput$RangeNotSatisfiable$;
import sttp.tapir.files.StaticInput;
import sttp.tapir.files.StaticOutput;
import sttp.tapir.files.StaticOutput$NotModified$;
import sttp.tapir.files.package$;

public final class Files$ {
    public static Files$ MODULE$;

    static {
        new Files$();
    }

    public <F> Function1<MonadError<F>, Function1<StaticInput, F>> head(String systemPath, FilesOptions<F> options) {
        return (Function1 & Serializable & scala.Serializable)monad -> (Function1 & Serializable & scala.Serializable)filesInput -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> ((Function1)MODULE$.get(systemPath, options).apply(monad)).apply(filesInput)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.withoutBody()), monad);
    }

    public <F> FilesOptions<F> head$default$2() {
        return FilesOptions$.MODULE$.default();
    }

    public <F> Function1<MonadError<F>, Function1<StaticInput, F>> get(String systemPath, FilesOptions<F> options) {
        return (Function1 & Serializable & scala.Serializable)monad -> (Function1 & Serializable & scala.Serializable)filesInput -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> MonadError$.MODULE$.apply(monad).blocking((Function0 & Serializable & scala.Serializable)() -> Paths.get(systemPath, new String[0]).toRealPath(new LinkOption[0]))).flatMap((Function1 & Serializable & scala.Serializable)path -> {
            Function2<List<String>, Option<List<String>>, Either<StaticErrorOutput, ResolvedUrl>> resolveUrlFn = MODULE$.resolveSystemPathUrl((StaticInput)filesInput, options, (Path)path);
            return MODULE$.files((StaticInput)filesInput, options, resolveUrlFn, (Function2 & Serializable & scala.Serializable)(url, range) -> MODULE$.fileRangeFromUrl((URL)url, (Option<RangeValue>)range), (MonadError)monad);
        }, monad);
    }

    public <F> FilesOptions<F> get$default$2() {
        return FilesOptions$.MODULE$.default();
    }

    public <F> Function1<MonadError<F>, Function1<Option<RangeValue>, Function1<URL, F>>> defaultEtag() {
        return (Function1 & Serializable & scala.Serializable)monad -> (Function1 & Serializable & scala.Serializable)range -> (Function1 & Serializable & scala.Serializable)url -> monad.blocking((Function0 & Serializable & scala.Serializable)() -> {
            URLConnection connection = url.openConnection();
            long lastModified = connection.getLastModified();
            long length = connection.getContentLengthLong();
            return new Some((Object)package$.MODULE$.defaultETag(lastModified, (Option<RangeValue>)range, length));
        });
    }

    private FileRange fileRangeFromUrl(URL url, Option<RangeValue> range) {
        return new FileRange(new File(url.toURI()), range);
    }

    private <F> Function2<List<String>, Option<List<String>>, Either<StaticErrorOutput, ResolvedUrl>> resolveSystemPathUrl(StaticInput input, FilesOptions<F> options, Path systemPath) {
        if (!BoxesRunTime.unboxToBoolean((Object)options.fileFilter().apply(input.path()))) {
            return (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> package$.MODULE$.LeftUrlNotFound();
        }
        return (Function2 & Serializable & scala.Serializable)(path, option) -> this.resolveRec$1((List)path, (Option)option, systemPath, input, options);
    }

    public <F, R> F files(StaticInput input, FilesOptions<F> options, Function2<List<String>, Option<List<String>>, Either<StaticErrorOutput, ResolvedUrl>> resolveUrlFn, Function2<URL, Option<RangeValue>, R> urlToResultFn, MonadError<F> m) {
        return (F)m.flatten(m.blocking((Function0 & Serializable & scala.Serializable)() -> {
            Right right;
            ResolvedUrl resolvedUrl;
            Either either = (Either)resolveUrlFn.apply(input.path(), options.defaultFile());
            if (either instanceof Left) {
                Left left = (Left)either;
                StaticErrorOutput error = (StaticErrorOutput)left.value();
                return syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)scala.package$.MODULE$.Left().apply((Object)error)), m);
            }
            if (either instanceof Right && (resolvedUrl = (ResolvedUrl)(right = (Right)either).value()) != null) {
                URL url = resolvedUrl.url();
                MediaType contentType = resolvedUrl.mediaType();
                Option<String> contentEncoding = resolvedUrl.contentEncoding();
                Option<Range> option = input.range();
                if (option instanceof Some) {
                    long fileSize;
                    Some some = (Some)option;
                    Range range = (Range)some.value();
                    if (range.isValid(fileSize = url.openConnection().getContentLengthLong())) {
                        RangeValue rangeValue = new RangeValue(range.start(), range.end(), fileSize);
                        return syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> MODULE$.rangeFileOutput(input, url, (Function1)((Function1)options.calculateETag().apply((Object)m)).apply((Object)new Some((Object)rangeValue)), rangeValue, contentType, urlToResultFn, m)).map((Function1 & Serializable & scala.Serializable)x$7 -> scala.package$.MODULE$.Right().apply(x$7), m);
                    }
                    return syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)scala.package$.MODULE$.Left().apply((Object)StaticErrorOutput$RangeNotSatisfiable$.MODULE$)), m);
                }
                if (None$.MODULE$.equals(option)) {
                    return syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> MODULE$.wholeFileOutput(input, url, (Function1)((Function1)options.calculateETag().apply((Object)m)).apply((Object)None$.MODULE$), contentType, contentEncoding, urlToResultFn, m)).map((Function1 & Serializable & scala.Serializable)x$8 -> scala.package$.MODULE$.Right().apply(x$8), m);
                }
                throw new MatchError(option);
            }
            throw new MatchError((Object)either);
        }));
    }

    private Path resolveGzipSibling(Path path) {
        return path.resolveSibling(new StringBuilder(3).append(((Object)path.getFileName()).toString()).append(".gz").toString());
    }

    private <F, R> F rangeFileOutput(StaticInput filesInput, URL url, Function1<URL, F> calculateETag, RangeValue range, MediaType contentType, Function2<URL, Option<RangeValue>, R> urlToResult, MonadError<F> m) {
        return this.fileOutput(filesInput, url, calculateETag, (Function3 & Serializable & scala.Serializable)(lastModified, x$9, etag) -> Files$.$anonfun$rangeFileOutput$1(urlToResult, url, range, contentType, BoxesRunTime.unboxToLong((Object)lastModified), BoxesRunTime.unboxToLong((Object)x$9), etag), m);
    }

    private <F, R> F wholeFileOutput(StaticInput filesInput, URL url, Function1<URL, F> calculateETag, MediaType contentType, Option<String> contentEncoding, Function2<URL, Option<RangeValue>, R> urlToResult, MonadError<F> m) {
        return this.fileOutput(filesInput, url, calculateETag, (Function3 & Serializable & scala.Serializable)(lastModified, fileLength, etag) -> Files$.$anonfun$wholeFileOutput$1(urlToResult, url, contentType, contentEncoding, BoxesRunTime.unboxToLong((Object)lastModified), BoxesRunTime.unboxToLong((Object)fileLength), etag), m);
    }

    private <F, R> F fileOutput(StaticInput filesInput, URL url, Function1<URL, F> calculateETag, Function3<Object, Object, Option<ETag>, StaticOutput<R>> result, MonadError<F> m) {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> calculateETag.apply((Object)url)).flatMap((Function1 & Serializable & scala.Serializable)etagOpt -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> m.blocking((Function0 & Serializable & scala.Serializable)() -> url.openConnection())).flatMap((Function1 & Serializable & scala.Serializable)urlConnection -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> m.blocking((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> urlConnection.getLastModified())).flatMap((Function1 & Serializable & scala.Serializable)lastModified -> Files$.$anonfun$fileOutput$8(filesInput, etagOpt, m, urlConnection, result, BoxesRunTime.unboxToLong((Object)lastModified)), m), m), m);
    }

    private final Either resolveRec$1(List path, Option option, Path systemPath$3, StaticInput input$1, FilesOptions options$3) {
        Path realRequestedPath;
        while (true) {
            Path resolved = (Path)path.foldLeft((Object)systemPath$3, (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.resolve((String)x$4));
            Path resolvedGzipped = this.resolveGzipSibling(resolved);
            if (package$.MODULE$.useGzippedIfAvailable(input$1, options$3) && Files.exists(resolvedGzipped, LinkOption.NOFOLLOW_LINKS)) {
                Path realRequestedPath2 = resolvedGzipped.toRealPath(LinkOption.NOFOLLOW_LINKS);
                if (!realRequestedPath2.startsWith(resolvedGzipped)) {
                    return package$.MODULE$.LeftUrlNotFound();
                }
                return scala.package$.MODULE$.Right().apply((Object)new ResolvedUrl(realRequestedPath2.toUri().toURL(), package$.MODULE$.contentTypeFromName(((Object)resolved.getFileName()).toString()), (Option<String>)new Some((Object)"gzip")));
            }
            if (!Files.exists(resolved, LinkOption.NOFOLLOW_LINKS)) {
                Option option2 = option;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    List defaultPath = (List)some.value();
                    option = None$.MODULE$;
                    path = defaultPath;
                    continue;
                }
                if (None$.MODULE$.equals(option2)) {
                    return package$.MODULE$.LeftUrlNotFound();
                }
                throw new MatchError((Object)option2);
            }
            realRequestedPath = resolved.toRealPath(LinkOption.NOFOLLOW_LINKS);
            if (!realRequestedPath.startsWith(systemPath$3)) {
                return package$.MODULE$.LeftUrlNotFound();
            }
            if (!realRequestedPath.toFile().isDirectory()) break;
            path = (List)path.$colon$plus((Object)"index.html", List$.MODULE$.canBuildFrom());
        }
        return scala.package$.MODULE$.Right().apply((Object)new ResolvedUrl(realRequestedPath.toUri().toURL(), package$.MODULE$.contentTypeFromName(((Object)realRequestedPath.getFileName()).toString()), (Option<String>)None$.MODULE$));
    }

    public static final /* synthetic */ StaticOutput.FoundPartial $anonfun$rangeFileOutput$1(Function2 urlToResult$1, URL url$3, RangeValue range$2, MediaType contentType$2, long lastModified, long x$9, Option etag) {
        return new StaticOutput.FoundPartial<Object>(urlToResult$1.apply((Object)url$3, (Object)new Some((Object)range$2)), (Option<Instant>)new Some((Object)Instant.ofEpochMilli(lastModified)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)range$2.contentLength())), (Option<MediaType>)new Some((Object)contentType$2), (Option<ETag>)etag, (Option<String>)new Some((Object)ContentRangeUnits$.MODULE$.Bytes()), (Option<String>)new Some((Object)range$2.toContentRange().toString()));
    }

    public static final /* synthetic */ StaticOutput.Found $anonfun$wholeFileOutput$1(Function2 urlToResult$2, URL url$4, MediaType contentType$3, Option contentEncoding$2, long lastModified, long fileLength, Option etag) {
        return new StaticOutput.Found<Object>(urlToResult$2.apply((Object)url$4, (Object)None$.MODULE$), (Option<Instant>)new Some((Object)Instant.ofEpochMilli(lastModified)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)fileLength)), (Option<MediaType>)new Some((Object)contentType$3), (Option<ETag>)etag, (Option<String>)new Some((Object)ContentRangeUnits$.MODULE$.Bytes()), (Option<String>)contentEncoding$2);
    }

    public static final /* synthetic */ StaticOutput $anonfun$fileOutput$12(Function3 result$1, long lastModified$1, Option etagOpt$1, long fileLength) {
        return (StaticOutput)result$1.apply((Object)BoxesRunTime.boxToLong((long)lastModified$1), (Object)BoxesRunTime.boxToLong((long)fileLength), (Object)etagOpt$1);
    }

    public static final /* synthetic */ Object $anonfun$fileOutput$8(StaticInput filesInput$3, Option etagOpt$1, MonadError m$2, URLConnection urlConnection$1, Function3 result$1, long lastModified) {
        return syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> {
            if (package$.MODULE$.isModified(filesInput$3, (Option<ETag>)etagOpt$1, lastModified)) {
                return syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> m$2.blocking((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> urlConnection$1.getContentLengthLong())).map((Function1 & Serializable & scala.Serializable)fileLength -> Files$.$anonfun$fileOutput$12(result$1, lastModified, etagOpt$1, BoxesRunTime.unboxToLong((Object)fileLength)), m$2);
            }
            return syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)StaticOutput$NotModified$.MODULE$), m$2);
        }).map((Function1 & Serializable & scala.Serializable)resourceResult -> resourceResult, m$2);
    }

    private Files$() {
        MODULE$ = this;
    }
}

