/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.http4s;

import cats.effect.kernel.Async;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.file.Files$;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.http4s.EntityEncoder;
import org.http4s.EntityEncoder$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusDisposition$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType$;
import org.http4s.multipart.Multipart$;
import org.http4s.multipart.Part;
import org.typelevel.ci.CIString;
import org.typelevel.ci.CIString$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sttp.capabilities.fs2.Fs2Streams;
import sttp.capabilities.fs2.Fs2Streams$;
import sttp.model.HasHeaders;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.Part$;
import sttp.tapir.CodecFormat;
import sttp.tapir.FileRange;
import sttp.tapir.InputStreamRange;
import sttp.tapir.RawBodyType;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.server.http4s.Http4sServerOptions;
import sttp.tapir.server.http4s.Http4sWebSockets$;
import sttp.tapir.server.interpreter.ToResponseBody;

public class Http4sToResponseBody<F>
implements ToResponseBody<Either<F, Tuple2<Stream<F, Object>, Option<Object>>>, Fs2Streams<F>> {
    private final Http4sServerOptions<F> serverOptions;
    private final Async<F> evidence$1;
    private final Fs2Streams streams;

    public Http4sToResponseBody(Http4sServerOptions<F> serverOptions, Async<F> evidence$1) {
        this.serverOptions = serverOptions;
        this.evidence$1 = evidence$1;
        this.streams = Fs2Streams$.MODULE$.apply();
    }

    public Fs2Streams<F> streams() {
        return this.streams;
    }

    public <R> Either<F, Tuple2<Stream<F, Object>, Option<Object>>> fromRawValue(R v, HasHeaders headers, CodecFormat format, RawBodyType<R> bodyType) {
        return package$.MODULE$.Right().apply(this.rawValueToEntity(bodyType, v));
    }

    public Either<F, Tuple2<Stream<F, Object>, Option<Object>>> fromStreamValue(Stream<F, Object> v, HasHeaders headers, CodecFormat format, Option<Charset> charset) {
        return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply(v, (Object)None$.MODULE$));
    }

    public <REQ, RESP> Either<F, Tuple2<Stream<F, Object>, Option<Object>>> fromWebSocketPipe(Function1<Stream<F, REQ>, Stream<F, RESP>> pipe, WebSocketBodyOutput<Function1<Stream<F, REQ>, Stream<F, RESP>>, REQ, RESP, ?, Fs2Streams<F>> o) {
        return package$.MODULE$.Left().apply(Http4sWebSockets$.MODULE$.pipeToBody(pipe, o, this.evidence$1));
    }

    private <CF extends CodecFormat, R> Tuple2<Stream<F, Object>, Option<Object>> rawValueToEntity(RawBodyType<R> bodyType, R r2) {
        RawBodyType<R> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            Charset charset;
            RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset charset2 = charset = stringBody._1();
            byte[] bytes = r2.toString().getBytes(charset2);
            return Tuple2$.MODULE$.apply((Object)Stream$.MODULE$.chunk(Chunk$.MODULE$.array((Object)bytes, ClassTag$.MODULE$.apply(Byte.TYPE))), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(bytes.length))));
        }
        if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            return Tuple2$.MODULE$.apply((Object)Stream$.MODULE$.chunk(Chunk$.MODULE$.array((Object)((byte[])r2), ClassTag$.MODULE$.apply(Byte.TYPE))), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(((byte[])r2).length))));
        }
        if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            return Tuple2$.MODULE$.apply((Object)Stream$.MODULE$.chunk(Chunk$.MODULE$.byteBuffer((ByteBuffer)r2)), (Object)None$.MODULE$);
        }
        if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            return Tuple2$.MODULE$.apply(this.inputStreamToFs2((Function0<InputStream>)(Function0 & Serializable)() -> (InputStream)r2), (Object)None$.MODULE$);
        }
        if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            Stream fs2Stream = (Stream)((InputStreamRange)r2).range().map((Function1 & Serializable)range -> this.inputStreamToFs2((Function0<InputStream>)((InputStreamRange)r2).inputStreamFromRangeStart()).take(range.contentLength())).getOrElse(() -> this.$anonfun$2(r2));
            return Tuple2$.MODULE$.apply((Object)fs2Stream, (Object)None$.MODULE$);
        }
        if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            Object tapirFile = r2;
            Stream stream = (Stream)((FileRange)tapirFile).range().flatMap((Function1 & Serializable)r -> r.startAndEnd().map((Function1 & Serializable)s -> Files$.MODULE$.apply(Files$.MODULE$.implicitForAsync(this.evidence$1)).readRange(((FileRange)tapirFile).file().toPath(), (int)r.contentLength(), s._1$mcJ$sp(), s._2$mcJ$sp()))).getOrElse(() -> this.$anonfun$4(tapirFile));
            return Tuple2$.MODULE$.apply((Object)stream, (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)((FileRange)tapirFile).file().length())));
        }
        if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody m = (RawBodyType.MultipartBody)rawBodyType;
            scala.collection.immutable.Seq parts = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)r2).flatMap((Function1 & Serializable)_$2 -> this.rawPartToBodyPart(m, (sttp.model.Part)_$2));
            Stream body = ((EntityEncoder)Predef$.MODULE$.implicitly((Object)EntityEncoder$.MODULE$.multipartEncoder())).toEntity((Object)Multipart$.MODULE$.apply(parts.toVector())).body();
            return Tuple2$.MODULE$.apply((Object)body, (Object)None$.MODULE$);
        }
        throw new MatchError(rawBodyType);
    }

    private Stream<F, Object> inputStreamToFs2(Function0<InputStream> inputStream) {
        return fs2.io.package$.MODULE$.readInputStream(cats.effect.package$.MODULE$.Sync().apply(this.evidence$1).blocking(inputStream), this.serverOptions.ioChunkSize(), fs2.io.package$.MODULE$.readInputStream$default$3(), this.evidence$1);
    }

    private <T> Option<Part<F>> rawPartToBodyPart(RawBodyType.MultipartBody m, sttp.model.Part<T> part) {
        return m.partType(part.name()).map(arg_0 -> this.rawPartToBodyPart$$anonfun$1(part, arg_0));
    }

    private Content.minusType parseContentType(String ct) {
        return Content$minusType$.MODULE$.apply((MediaType)MediaType$.MODULE$.parse(ct).getOrElse(() -> Http4sToResponseBody.parseContentType$$anonfun$1(ct)));
    }

    private final Stream $anonfun$2(Object r$3) {
        return this.inputStreamToFs2((Function0<InputStream>)((InputStreamRange)r$3).inputStream());
    }

    private final Stream $anonfun$4(Object tapirFile$3) {
        return Files$.MODULE$.apply(Files$.MODULE$.implicitForAsync(this.evidence$1)).readAll(((FileRange)tapirFile$3).file().toPath(), this.serverOptions.ioChunkSize());
    }

    private static final /* synthetic */ Header.ToRaw $anonfun$6(Header header) {
        return Header.ToRaw$.MODULE$.rawToRaw(Header.Raw$.MODULE$.apply(CIString$.MODULE$.apply(header.name()), header.value()));
    }

    private final /* synthetic */ Content.minusType $anonfun$7(String ct) {
        return this.parseContentType(ct);
    }

    private static final Content.minusType $anonfun$8() {
        return Content$minusType$.MODULE$.apply(MediaType$.MODULE$.application().octet$minusstream());
    }

    private static final /* synthetic */ Tuple2 $anonfun$9(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            CIString cIString = (CIString)Predef$.MODULE$.ArrowAssoc((Object)CIString$.MODULE$.apply(k));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)cIString, (Object)v);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ boolean $anonfun$10(Header _$3) {
        return _$3.is(HeaderNames$.MODULE$.ContentType());
    }

    private static final /* synthetic */ Header.ToRaw $anonfun$11(Header.ToRaw h) {
        return Header.ToRaw$.MODULE$.identityToRaw(h);
    }

    private static final /* synthetic */ Header.ToRaw $anonfun$12(Header.ToRaw h) {
        return Header.ToRaw$.MODULE$.identityToRaw(h);
    }

    private static final /* synthetic */ boolean $anonfun$13(Header _$4) {
        return _$4.is(HeaderNames$.MODULE$.ContentLength());
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ Part rawPartToBodyPart$$anonfun$1(sttp.model.Part part$1, RawBodyType partType) {
        headers = ((IterableOnceOps)part$1.headers().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$6(sttp.model.Header ), (Lsttp/model/Header;)Lorg/http4s/Header$ToRaw;)())).toList();
        partContentType = (Content.minusType)part$1.contentType().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$7(java.lang.String ), (Ljava/lang/String;)Lorg/http4s/headers/Content$minusType;)((Http4sToResponseBody)this)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$8(), ()Lorg/http4s/headers/Content$minusType;)());
        var6_5 = this.rawValueToEntity(partType, part$1.body());
        if (var6_5 == null) {
            throw new MatchError(var6_5);
        }
        entity = (Stream)var6_5._1();
        contentLength = (Option)var6_5._2();
        var5_8 = Tuple2$.MODULE$.apply((Object)entity, (Object)contentLength);
        entity = (Stream)var5_8._1();
        contentLength = (Option)var5_8._2();
        var12_11 = (String)Predef$.MODULE$.ArrowAssoc((Object)Part$.MODULE$.NameDispositionParam());
        dispositionParams = (Map)part$1.otherDispositionParams().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var12_11, (Object)part$1.name())).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$9(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)());
        contentDispositionHeader = Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusDisposition$.MODULE$.apply("form-data", dispositionParams), Content$minusDisposition$.MODULE$.headerInstance());
        shouldAddCtHeader = part$1.headers().exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$10(sttp.model.Header ), (Lsttp/model/Header;)Z)());
        if (shouldAddCtHeader) {
            v0 = new Header.ToRaw[1];
            var16_15 = Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)partContentType, Content$minusType$.MODULE$.headerInstance());
            v0[0] = Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)headers.$colon$colon((Object)contentDispositionHeader).$colon$colon((Object)var16_15), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$11(org.http4s.Header$ToRaw ), (Lorg/http4s/Header$ToRaw;)Lorg/http4s/Header$ToRaw;)());
            v1 = Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(v0));
        } else {
            v1 = Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)headers.$colon$colon((Object)contentDispositionHeader), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$12(org.http4s.Header$ToRaw ), (Lorg/http4s/Header$ToRaw;)Lorg/http4s/Header$ToRaw;)())}));
        }
        allHeaders0 = v1;
        shouldAddClHeader = part$1.headers().exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$13(sttp.model.Header ), (Lsttp/model/Header;)Z)());
        var19_18 = contentLength;
        if (!(var19_18 instanceof Some)) ** GOTO lbl-1000
        cl = BoxesRunTime.unboxToLong((Object)((Some)var19_18).value());
        if (shouldAddClHeader) {
            v2 = Headers$.MODULE$.put$extension(allHeaders0, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusLength$.MODULE$.apply(cl), Content$minusLength$.MODULE$.headerInstance())}));
        } else lbl-1000:
        // 2 sources

        {
            v2 = allHeaders0;
        }
        allHeaders = v2;
        return org.http4s.multipart.Part$.MODULE$.apply(allHeaders, entity);
    }

    private static final MediaType parseContentType$$anonfun$1(String ct$1) {
        throw new IllegalArgumentException(new StringBuilder(27).append("Cannot parse content type: ").append(ct$1).toString());
    }
}

