/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.docs.openapi;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import sttp.model.Header;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.tapir.Codec;
import sttp.tapir.CodecFormat;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.SchemaType;
import sttp.tapir.internal.package$;

public final class EndpointInputToDecodeFailureOutput$ {
    public static final EndpointInputToDecodeFailureOutput$ MODULE$ = new EndpointInputToDecodeFailureOutput$();

    public Option<String> defaultBadRequestDescription(EndpointInput<?> input2) {
        Vector fallibleBasicInputs = (Vector)package$.MODULE$.RichEndpointInput(input2).asVectorOfBasicInputs(false).filter((Function1 & Serializable)input -> BoxesRunTime.boxToBoolean((boolean)EndpointInputToDecodeFailureOutput$.MODULE$.inputMayFailWithBadRequest(input)));
        return fallibleBasicInputs.nonEmpty() ? new Some((Object)this.badRequestDescription(fallibleBasicInputs)) : None$.MODULE$;
    }

    private boolean inputMayFailWithBadRequest(EndpointInput.Basic<?> input) {
        boolean bl;
        EndpointInput.Basic<?> basic = input;
        if (basic instanceof EndpointInput.FixedMethod) {
            bl = false;
        } else if (basic instanceof EndpointInput.FixedPath) {
            bl = false;
        } else if (basic instanceof EndpointIO.Empty) {
            bl = false;
        } else if (basic instanceof EndpointInput.PathCapture) {
            EndpointInput.PathCapture pathCapture = (EndpointInput.PathCapture)basic;
            Codec codec = pathCapture.codec();
            bl = this.decodingMayFail(codec);
        } else if (basic instanceof EndpointIO.OneOfBody) {
            EndpointIO.OneOfBody oneOfBody = (EndpointIO.OneOfBody)basic;
            List variants = oneOfBody.variants();
            bl = variants.exists((Function1 & Serializable)variant -> BoxesRunTime.boxToBoolean((boolean)EndpointInputToDecodeFailureOutput$.MODULE$.decodingMayFail(variant.codec())));
        } else if (basic instanceof EndpointInput.Atom) {
            EndpointInput.Atom atom = (EndpointInput.Atom)basic;
            bl = this.decodingMayFail(atom.codec()) || !atom.codec().schema().isOptional();
        } else {
            throw new MatchError(basic);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <CF extends CodecFormat> boolean decodingMayFail(Codec<?, ?, CF> codec) {
        MediaType mediaType = codec.format().mediaType();
        MediaType mediaType2 = MediaType$.MODULE$.TextPlain();
        if (mediaType == null) {
            if (mediaType2 != null) {
                return true;
            }
        } else if (!mediaType.equals(mediaType2)) return true;
        if (codec.schema().hasValidation()) return true;
        if (codec.schema().format().nonEmpty()) return true;
        SchemaType schemaType = codec.schema().schemaType();
        SchemaType.SString sString = new SchemaType.SString();
        if (schemaType == null) {
            if (sString == null) return false;
            return true;
        } else if (schemaType.equals(sString)) return false;
        return true;
    }

    private String badRequestDescription(Vector<EndpointInput.Basic<?>> fallibleBasicInputs) {
        return ((IterableOnceOps)((SeqOps)fallibleBasicInputs.map((Function1 & Serializable)input -> MODULE$.failureSourceMessage((EndpointInput<?>)input))).distinct()).mkString(", ");
    }

    public String failureSourceMessage(EndpointInput<?> input) {
        String string;
        block19: {
            EndpointInput.Single single;
            while (true) {
                if ((single = input) instanceof EndpointInput.FixedMethod) {
                    string = "Invalid value for: method";
                    break block19;
                }
                if (single instanceof EndpointInput.FixedPath) {
                    string = "Invalid value for: path segment";
                    break block19;
                }
                if (single instanceof EndpointInput.PathCapture) {
                    EndpointInput.PathCapture pathCapture = (EndpointInput.PathCapture)single;
                    Option name = pathCapture.name();
                    string = new StringBuilder(34).append("Invalid value for: path parameter ").append(name.getOrElse((Function0 & Serializable)() -> "?")).toString();
                    break block19;
                }
                if (single instanceof EndpointInput.PathsCapture) {
                    string = "Invalid value for: path";
                    break block19;
                }
                if (single instanceof EndpointInput.Query) {
                    EndpointInput.Query query = (EndpointInput.Query)single;
                    String name = query.name();
                    string = new StringBuilder(35).append("Invalid value for: query parameter ").append(name).toString();
                    break block19;
                }
                if (single instanceof EndpointInput.QueryParams) {
                    string = "Invalid value for: query parameters";
                    break block19;
                }
                if (single instanceof EndpointInput.Cookie) {
                    EndpointInput.Cookie cookie = (EndpointInput.Cookie)single;
                    String name = cookie.name();
                    string = new StringBuilder(26).append("Invalid value for: cookie ").append(name).toString();
                    break block19;
                }
                if (single instanceof EndpointInput.ExtractFromRequest) {
                    string = "Invalid value";
                    break block19;
                }
                if (!(single instanceof EndpointInput.Auth)) break;
                EndpointInput.Auth auth = (EndpointInput.Auth)single;
                input = auth.input();
            }
            if (single instanceof EndpointInput.MappedPair) {
                string = "Invalid value";
            } else if (single instanceof EndpointIO.Body) {
                string = "Invalid value for: body";
            } else if (single instanceof EndpointIO.StreamBodyWrapper) {
                string = "Invalid value for: body";
            } else if (single instanceof EndpointIO.Header) {
                EndpointIO.Header header = (EndpointIO.Header)single;
                String name = header.name();
                string = new StringBuilder(26).append("Invalid value for: header ").append(name).toString();
            } else if (single instanceof EndpointIO.FixedHeader) {
                EndpointIO.FixedHeader fixedHeader = (EndpointIO.FixedHeader)single;
                Header name = fixedHeader.h();
                string = new StringBuilder(26).append("Invalid value for: header ").append(name).toString();
            } else {
                string = single instanceof EndpointIO.Headers ? "Invalid value for: headers" : "Invalid value";
            }
        }
        return string;
    }

    private EndpointInputToDecodeFailureOutput$() {
    }
}

