/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.docs.openapi;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import sttp.model.Header;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.tapir.Codec;
import sttp.tapir.CodecFormat;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.SchemaType;
import sttp.tapir.internal.package$;

public final class EndpointInputToDecodeFailureOutput$ {
    public static final EndpointInputToDecodeFailureOutput$ MODULE$ = new EndpointInputToDecodeFailureOutput$();

    public Option<String> defaultBadRequestDescription(EndpointInput<?> input2) {
        Vector fallibleBasicInputs = (Vector)package$.MODULE$.RichEndpointInput(input2).asVectorOfBasicInputs(false).filter((Function1 & Serializable)input -> BoxesRunTime.boxToBoolean((boolean)EndpointInputToDecodeFailureOutput$.MODULE$.inputMayFailWithBadRequest(input)));
        if (fallibleBasicInputs.nonEmpty()) {
            return new Some((Object)this.badRequestDescription(fallibleBasicInputs));
        }
        return None$.MODULE$;
    }

    private boolean inputMayFailWithBadRequest(EndpointInput.Basic<?> input) {
        EndpointInput.Basic<?> basic = input;
        if (basic instanceof EndpointInput.FixedMethod) {
            return false;
        }
        if (basic instanceof EndpointInput.FixedPath) {
            return false;
        }
        if (basic instanceof EndpointIO.Empty) {
            return false;
        }
        if (basic instanceof EndpointInput.PathCapture) {
            EndpointInput.PathCapture pathCapture = (EndpointInput.PathCapture)basic;
            Codec codec = pathCapture.codec();
            return this.decodingMayFail(codec);
        }
        if (basic instanceof EndpointIO.OneOfBody) {
            EndpointIO.OneOfBody oneOfBody = (EndpointIO.OneOfBody)basic;
            List variants = oneOfBody.variants();
            return variants.exists((Function1 & Serializable)variant -> BoxesRunTime.boxToBoolean((boolean)EndpointInputToDecodeFailureOutput$.MODULE$.decodingMayFail(variant.codec())));
        }
        if (basic instanceof EndpointInput.Atom) {
            EndpointInput.Atom atom = (EndpointInput.Atom)basic;
            return this.decodingMayFail(atom.codec()) || !atom.codec().schema().isOptional();
        }
        throw new MatchError(basic);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <CF extends CodecFormat> boolean decodingMayFail(Codec<?, ?, CF> codec) {
        MediaType mediaType = codec.format().mediaType();
        MediaType mediaType2 = MediaType$.MODULE$.TextPlain();
        if (mediaType == null) {
            if (mediaType2 != null) {
                return true;
            }
        } else if (!mediaType.equals(mediaType2)) return true;
        if (codec.schema().hasValidation()) return true;
        if (codec.schema().format().nonEmpty()) return true;
        SchemaType schemaType = codec.schema().schemaType();
        SchemaType.SString sString = new SchemaType.SString();
        if (schemaType == null) {
            if (sString == null) return false;
            return true;
        } else if (schemaType.equals(sString)) return false;
        return true;
    }

    private String badRequestDescription(Vector<EndpointInput.Basic<?>> fallibleBasicInputs) {
        return ((IterableOnceOps)((SeqOps)fallibleBasicInputs.map((Function1 & Serializable)input -> MODULE$.failureSourceMessage((EndpointInput<?>)input))).distinct()).mkString(", ");
    }

    public String failureSourceMessage(EndpointInput<?> input) {
        EndpointInput.Single single;
        while (true) {
            if ((single = input) instanceof EndpointInput.FixedMethod) {
                return "Invalid value for: method";
            }
            if (single instanceof EndpointInput.FixedPath) {
                return "Invalid value for: path segment";
            }
            if (single instanceof EndpointInput.PathCapture) {
                EndpointInput.PathCapture pathCapture = (EndpointInput.PathCapture)single;
                Option name = pathCapture.name();
                return new StringBuilder(34).append("Invalid value for: path parameter ").append(name.getOrElse((Function0 & Serializable)() -> "?")).toString();
            }
            if (single instanceof EndpointInput.PathsCapture) {
                return "Invalid value for: path";
            }
            if (single instanceof EndpointInput.Query) {
                EndpointInput.Query query = (EndpointInput.Query)single;
                String name = query.name();
                return new StringBuilder(35).append("Invalid value for: query parameter ").append(name).toString();
            }
            if (single instanceof EndpointInput.QueryParams) {
                return "Invalid value for: query parameters";
            }
            if (single instanceof EndpointInput.Cookie) {
                EndpointInput.Cookie cookie = (EndpointInput.Cookie)single;
                String name = cookie.name();
                return new StringBuilder(26).append("Invalid value for: cookie ").append(name).toString();
            }
            if (single instanceof EndpointInput.ExtractFromRequest) {
                return "Invalid value";
            }
            if (!(single instanceof EndpointInput.Auth)) break;
            EndpointInput.Auth auth = (EndpointInput.Auth)single;
            input = auth.input();
        }
        if (single instanceof EndpointInput.MappedPair) {
            return "Invalid value";
        }
        if (single instanceof EndpointIO.Body) {
            return "Invalid value for: body";
        }
        if (single instanceof EndpointIO.StreamBodyWrapper) {
            return "Invalid value for: body";
        }
        if (single instanceof EndpointIO.Header) {
            EndpointIO.Header header = (EndpointIO.Header)single;
            String name = header.name();
            return new StringBuilder(26).append("Invalid value for: header ").append(name).toString();
        }
        if (single instanceof EndpointIO.FixedHeader) {
            EndpointIO.FixedHeader fixedHeader = (EndpointIO.FixedHeader)single;
            Header name = fixedHeader.h();
            return new StringBuilder(26).append("Invalid value for: header ").append(name).toString();
        }
        if (single instanceof EndpointIO.Headers) {
            return "Invalid value for: headers";
        }
        return "Invalid value";
    }

    private EndpointInputToDecodeFailureOutput$() {
    }
}

