/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.pekkohttp;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.pekko.http.scaladsl.model.BodyPartEntity;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpCharset;
import org.apache.pekko.http.scaladsl.model.HttpCharset$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.Multipart;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.ws.Message;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.StreamConverters$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import sttp.capabilities.pekko.PekkoStreams;
import sttp.capabilities.pekko.PekkoStreams$;
import sttp.model.HasHeaders;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Part;
import sttp.tapir.CodecFormat;
import sttp.tapir.FileRange;
import sttp.tapir.InputStreamRange;
import sttp.tapir.RawBodyType;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.internal.package$;
import sttp.tapir.server.interpreter.ToResponseBody;
import sttp.tapir.server.pekkohttp.ContentTypeCache$;
import sttp.tapir.server.pekkohttp.PekkoModel$;
import sttp.tapir.server.pekkohttp.PekkoWebSockets$;

@ScalaSignature(bytes="\u0006\u0005\tUc!\u0002\u000b\u0016\u0001Ui\u0002\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b1\u0002\u001f\t\u0011\u001d\u0003!\u0011!Q\u0001\f!CQA\u0014\u0001\u0005\u0002=Cq\u0001\u0016\u0001C\u0002\u0013\u0005S\u000b\u0003\u0004W\u0001\u0001\u0006IA\r\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0011\u0019a\u0006\u0001)A\u00053\")Q\f\u0001C!=\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003?\u0002A\u0011BA1\u0011\u001d\ty\n\u0001C\u0005\u0003CCq!!0\u0001\t\u0013\ty\fC\u0004\u0002H\u0002!I!!3\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9!\u0011\u0003\u0001\u0005\n\tM\u0001b\u0002B\r\u0001\u0011%!1\u0004\u0005\b\u0005k\u0001A\u0011\u0002B\u001c\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007\u00121\u0003U3lW>$vNU3ta>t7/\u001a\"pIfT!AF\f\u0002\u0013A,7n[8iiR\u0004(B\u0001\r\u001a\u0003\u0019\u0019XM\u001d<fe*\u0011!dG\u0001\u0006i\u0006\u0004\u0018N\u001d\u0006\u00029\u0005!1\u000f\u001e;q'\r\u0001a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0015B#FM\u0007\u0002M)\u0011qeF\u0001\fS:$XM\u001d9sKR,'/\u0003\u0002*M\tqAk\u001c*fgB|gn]3C_\u0012L\bCA\u00160\u001d\taS&D\u0001\u0016\u0013\tqS#A\u0004qC\u000e\\\u0017mZ3\n\u0005A\n$!\u0005)fW.|'+Z:q_:\u001cXMQ8es*\u0011a&\u0006\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nQ\u0001]3lW>T!aN\u000e\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\n\u0005e\"$\u0001\u0004)fW.|7\u000b\u001e:fC6\u001c\u0018!A7\u0004\u0001A\u0011Q(R\u0007\u0002})\u0011q\bQ\u0001\u0007gR\u0014X-Y7\u000b\u0005U\n%B\u0001\"D\u0003\u0019\t\u0007/Y2iK*\tA)A\u0002pe\u001eL!A\u0012 \u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0002\u0005\u0015\u001c\u0007CA%M\u001b\u0005Q%BA&!\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u001b*\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005\u0001FcA)S'B\u0011A\u0006\u0001\u0005\u0006u\r\u0001\u001d\u0001\u0010\u0005\u0006\u000f\u000e\u0001\u001d\u0001S\u0001\bgR\u0014X-Y7t+\u0005\u0011\u0014\u0001C:ue\u0016\fWn\u001d\u0011\u0002\u0013\rCWO\\6TSj,W#A-\u0011\u0005}Q\u0016BA.!\u0005\rIe\u000e^\u0001\u000b\u0007\",hn[*ju\u0016\u0004\u0013\u0001\u00044s_6\u0014\u0016m\u001e,bYV,WCA0e)\u0015Q\u0003-\\;|\u0011\u0015\t\u0007\u00021\u0001c\u0003\u00051\bCA2e\u0019\u0001!Q!\u001a\u0005C\u0002\u0019\u0014\u0011AU\t\u0003O*\u0004\"a\b5\n\u0005%\u0004#a\u0002(pi\"Lgn\u001a\t\u0003?-L!\u0001\u001c\u0011\u0003\u0007\u0005s\u0017\u0010C\u0003o\u0011\u0001\u0007q.A\u0004iK\u0006$WM]:\u0011\u0005A\u001cX\"A9\u000b\u0005I\\\u0012!B7pI\u0016d\u0017B\u0001;r\u0005)A\u0015m\u001d%fC\u0012,'o\u001d\u0005\u0006m\"\u0001\ra^\u0001\u0007M>\u0014X.\u0019;\u0011\u0005aLX\"A\r\n\u0005iL\"aC\"pI\u0016\u001cgi\u001c:nCRDQ\u0001 \u0005A\u0002u\f\u0001BY8esRK\b/\u001a\t\u0004qz\u0014\u0017BA@\u001a\u0005-\u0011\u0016m\u001e\"pIf$\u0016\u0010]3\u0002\u001f\u0019\u0014x.\\*ue\u0016\fWNV1mk\u0016$\u0012BKA\u0003\u0003#\t\u0019\"!\u0006\t\r\u0005L\u0001\u0019AA\u0004!\u0011\tI!!\u0004\u000f\u0007\u0005-A!D\u0001\u0001\u0013\r\ty\u0001\u000f\u0002\r\u0005&t\u0017M]=TiJ,\u0017-\u001c\u0005\u0006]&\u0001\ra\u001c\u0005\u0006m&\u0001\ra\u001e\u0005\b\u0003/I\u0001\u0019AA\r\u0003\u001d\u0019\u0007.\u0019:tKR\u0004RaHA\u000e\u0003?I1!!\b!\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011EA\u0017\u001b\t\t\u0019C\u0003\u0003\u0002\u0018\u0005\u0015\"\u0002BA\u0014\u0003S\t1A\\5p\u0015\t\tY#\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003G\u0011qa\u00115beN,G/A\tge>lw+\u001a2T_\u000e\\W\r\u001e)ja\u0016,b!!\u000e\u0002D\u0005%C#\u0002\u0016\u00028\u00055\u0003bBA\u001d\u0015\u0001\u0007\u00111H\u0001\u0005a&\u0004X\r\u0005\u0005\u0002\n\u0005u\u0012\u0011IA$\u0013\r\ty\u0004\u000f\u0002\u0005!&\u0004X\rE\u0002d\u0003\u0007\"a!!\u0012\u000b\u0005\u00041'a\u0001*F#B\u00191-!\u0013\u0005\r\u0005-#B1\u0001g\u0005\u0011\u0011Vi\u0015)\t\u000f\u0005=#\u00021\u0001\u0002R\u0005\tq\u000e\r\u0003\u0002T\u0005m\u0003\u0003\u0004=\u0002V\u0005m\u0012\u0011IA$\u00033\u0012\u0014bAA,3\t\u0019r+\u001a2T_\u000e\\W\r\u001e\"pIf|U\u000f\u001e9viB\u00191-a\u0017\u0005\u0017\u0005u\u0013QJA\u0001\u0002\u0003\u0015\tA\u001a\u0002\u0004?\u0012\n\u0014\u0001\u0007:boZ\u000bG.^3U_J+7\u000f]8og\u0016,e\u000e^5usV1\u00111MAM\u0003{\"\"\"!\u001a\u0002x\u0005}\u0014\u0011RAK!\u0011\t9'a\u001d\u000e\u0005\u0005%$b\u0001:\u0002l)!\u0011QNA8\u0003!\u00198-\u00197bINd'bAA9\u0001\u0006!\u0001\u000e\u001e;q\u0013\u0011\t)(!\u001b\u0003\u001dI+7\u000f]8og\u0016,e\u000e^5us\"1Ap\u0003a\u0001\u0003s\u0002B\u0001\u001f@\u0002|A\u00191-! \u0005\u000b\u0015\\!\u0019\u00014\t\u000f\u0005\u00055\u00021\u0001\u0002\u0004\u0006\u00111\r\u001e\t\u0005\u0003O\n))\u0003\u0003\u0002\b\u0006%$aC\"p]R,g\u000e\u001e+za\u0016Dq!a#\f\u0001\u0004\ti)A\u0007d_:$XM\u001c;MK:<G\u000f\u001b\t\u0006?\u0005m\u0011q\u0012\t\u0004?\u0005E\u0015bAAJA\t!Aj\u001c8h\u0011\u001d\t9j\u0003a\u0001\u0003w\n\u0011A\u001d\u0003\b\u00037[!\u0019AAO\u0005\t\u0019e)\u0005\u0002ho\u0006\u00012M]3bi\u00164\u0015\u000e\\3T_V\u00148-\u001a\u000b\t\u0003G\u000bY+!.\u0002:B!\u0011QUA\u0007\u001d\r\u0019\u0014qU\u0005\u0004\u0003S#\u0014\u0001\u0004)fW.|7\u000b\u001e:fC6\u001c\bbBAW\u0019\u0001\u0007\u0011qV\u0001\ni\u0006\u0004\u0018N\u001d$jY\u0016\u00042\u0001_AY\u0013\r\t\u0019,\u0007\u0002\n\r&dWMU1oO\u0016Dq!a.\r\u0001\u0004\ty)A\u0003ti\u0006\u0014H\u000fC\u0004\u0002<2\u0001\r!a$\u0002\u0015\tLH/Z:U_R\fG.\u0001\bu_J\u000bgnZ3e'R\u0014X-Y7\u0015\r\u0005\r\u0016\u0011YAc\u0011\u001d\t\u0019-\u0004a\u0001\u0003G\u000bQ\"\u001b8ji&\fGn\u0015;sK\u0006l\u0007bBA^\u001b\u0001\u0007\u0011qR\u0001\u000fgR\u0014X-Y7U_\u0016sG/\u001b;z)!\t)'a3\u0002P\u0006E\u0007bBAg\u001d\u0001\u0007\u00111Q\u0001\fG>tG/\u001a8u)f\u0004X\rC\u0004\u0002\f:\u0001\r!!$\t\r}r\u0001\u0019AAR\u0003E\u0011\u0018m\u001e)beR$vNQ8esB\u000b'\u000f^\u000b\u0005\u0003/\u0014i\u0001\u0006\u0004\u0002Z\u0006E(\u0011\u0001\t\u0006?\u0005m\u00111\u001c\t\u0005\u0003;\fYO\u0004\u0003\u0002`\u0006\u0015h\u0002BA4\u0003CLA!a9\u0002j\u0005IQ*\u001e7uSB\f'\u000f^\u0005\u0005\u0003O\fI/\u0001\u0005G_JlG)\u0019;b\u0015\u0011\t\u0019/!\u001b\n\t\u00055\u0018q\u001e\u0002\t\u0005>$\u0017\u0010U1si*!\u0011q]Au\u0011\u0019Qt\u00021\u0001\u0002tB!\u0011Q_A~\u001d\rA\u0018q_\u0005\u0004\u0003sL\u0012a\u0003*bo\n{G-\u001f+za\u0016LA!!@\u0002\u0000\niQ*\u001e7uSB\f'\u000f\u001e\"pIfT1!!?\u001a\u0011\u001d\u0011\u0019a\u0004a\u0001\u0005\u000b\tA\u0001]1siB)\u0001Oa\u0002\u0003\f%\u0019!\u0011B9\u0003\tA\u000b'\u000f\u001e\t\u0004G\n5AA\u0002B\b\u001f\t\u0007aMA\u0001U\u0003M1wN]7biR{7i\u001c8uK:$H+\u001f9f)\u0019\t\u0019I!\u0006\u0003\u0018!)a\u000f\u0005a\u0001o\"9\u0011q\u0003\tA\u0002\u0005e\u0011\u0001\u00059beN,7i\u001c8uK:$H+\u001f9f)\u0011\t\u0019I!\b\t\u000f\u0005\u0005\u0015\u00031\u0001\u0003 A!!\u0011\u0005B\u0018\u001d\u0011\u0011\u0019Ca\u000b\u0011\u0007\t\u0015\u0002%\u0004\u0002\u0003()\u0019!\u0011F\u001e\u0002\rq\u0012xn\u001c;?\u0013\r\u0011i\u0003I\u0001\u0007!J,G-\u001a4\n\t\tE\"1\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t5\u0002%\u0001\u000bdQ\u0006\u00148/\u001a;U_\"#H\u000f]\"iCJ\u001cX\r\u001e\u000b\u0005\u0005s\u0011y\u0004\u0005\u0003\u0002h\tm\u0012\u0002\u0002B\u001f\u0003S\u00121\u0002\u0013;ua\u000eC\u0017M]:fi\"9\u0011q\u0003\nA\u0002\u0005}\u0011\u0001H8wKJ\u0014\u0018\u000eZ3D_:$XM\u001c;UsB,\u0017J\u001a#fM&tW\rZ\u000b\u0005\u0005\u000b\u0012I\u0005\u0006\u0004\u0003H\t=#1\u000b\t\u0004G\n%Ca\u0002B&'\t\u0007!Q\n\u0002\u0003%\u0016\u000b2aZA3\u0011\u001d\u0011\tf\u0005a\u0001\u0005\u000f\n!A]3\t\u000b9\u001c\u0002\u0019A8")
public class PekkoToResponseBody
implements ToResponseBody<Either<Flow<Message, Message, Object>, ResponseEntity>, PekkoStreams> {
    private final Materializer m;
    private final ExecutionContext ec;
    private final PekkoStreams streams;
    private final int ChunkSize;

    public PekkoStreams streams() {
        return this.streams;
    }

    private int ChunkSize() {
        return this.ChunkSize;
    }

    public <R> Either<Flow<Message, Message, Object>, ResponseEntity> fromRawValue(R v, HasHeaders headers, CodecFormat format, RawBodyType<R> bodyType) {
        return new Right((Object)this.overrideContentTypeIfDefined(this.rawValueToResponseEntity(bodyType, this.formatToContentType(format, (Option<Charset>)package$.MODULE$.charset(bodyType)), (Option<Object>)headers.contentLength(), v), headers));
    }

    public Either<Flow<Message, Message, Object>, ResponseEntity> fromStreamValue(Source<ByteString, Object> v, HasHeaders headers, CodecFormat format, Option<Charset> charset) {
        return new Right((Object)this.overrideContentTypeIfDefined(this.streamToEntity(this.formatToContentType(format, charset), (Option<Object>)headers.contentLength(), v), headers));
    }

    public <REQ, RESP> Either<Flow<Message, Message, Object>, ResponseEntity> fromWebSocketPipe(Flow<REQ, RESP, Object> pipe, WebSocketBodyOutput<Flow<REQ, RESP, Object>, REQ, RESP, ?, PekkoStreams> o) {
        return new Left(PekkoWebSockets$.MODULE$.pipeToBody(pipe, o, this.ec, this.m));
    }

    private <CF extends CodecFormat, R> ResponseEntity rawValueToResponseEntity(RawBodyType<R> bodyType, ContentType ct, Option<Object> contentLength, R r2) {
        RawBodyType<R> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            RawBodyType.StringBody stringBody = (RawBodyType.StringBody)rawBodyType;
            Charset charset = stringBody.charset();
            ContentType contentType = ct;
            if (contentType instanceof ContentType.NonBinary) {
                ContentType.NonBinary nonBinary = (ContentType.NonBinary)contentType;
                return HttpEntity$.MODULE$.apply(nonBinary, (String)r2);
            }
            return HttpEntity$.MODULE$.apply(ct, ((String)r2).getBytes(charset));
        }
        if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            return HttpEntity$.MODULE$.apply(ct, (byte[])r2);
        }
        if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            return HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply((ByteBuffer)r2));
        }
        if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            return this.streamToEntity(ct, contentLength, (Source<ByteString, Object>)StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> r2, this.ChunkSize()));
        }
        if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            Object resource = r2;
            Source initialStream = StreamConverters$.MODULE$.fromInputStream(((InputStreamRange)resource).inputStreamFromRangeStart(), this.ChunkSize());
            return (ResponseEntity)((InputStreamRange)resource).range().map((Function1 & Serializable)r -> this.streamToEntity(ct, contentLength, this.toRangedStream((Source<ByteString, Object>)initialStream, r.contentLength()))).getOrElse((Function0 & Serializable)() -> this.streamToEntity(ct, contentLength, (Source<ByteString, Object>)initialStream));
        }
        if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            Object tapirFile = r2;
            return (ResponseEntity)((FileRange)tapirFile).range().flatMap((Function1 & Serializable)r -> r.startAndEnd().map((Function1 & Serializable)s -> HttpEntity$.MODULE$.apply(ct, this.createFileSource((FileRange)tapirFile, s._1$mcJ$sp(), r.contentLength())))).getOrElse((Function0 & Serializable)() -> HttpEntity$.MODULE$.fromPath(ct, ((FileRange)tapirFile).file().toPath(), HttpEntity$.MODULE$.fromPath$default$3()));
        }
        if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody multipartBody = (RawBodyType.MultipartBody)rawBodyType;
            Seq parts = (Seq)((Seq)r2).flatMap((Function1 & Serializable)x$1 -> this.rawPartToBodyPart(multipartBody, (Part)x$1));
            Multipart.FormData body = Multipart.FormData$.MODULE$.apply(parts);
            return body.toEntity();
        }
        throw new MatchError(rawBodyType);
    }

    private Source<ByteString, Object> createFileSource(FileRange tapirFile, long start, long bytesTotal) {
        return this.toRangedStream((Source<ByteString, Object>)FileIO$.MODULE$.fromPath(tapirFile.file().toPath(), this.ChunkSize(), start), bytesTotal);
    }

    private Source<ByteString, Object> toRangedStream(Source<ByteString, Object> initialStream, long bytesTotal) {
        return (Source)initialStream.scan((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)ByteString$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                ByteString next = (ByteString)tuple2._2();
                if (tuple22 != null) {
                    long bytesConsumed = tuple22._1$mcJ$sp();
                    int bytesInNext = next.length();
                    long bytesFromNext = Math.max(0L, Math.min(bytesTotal - bytesConsumed, (long)bytesInNext));
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)(bytesConsumed + (long)bytesInNext)), (Object)next.take((int)bytesFromNext));
                }
            }
            throw new MatchError((Object)tuple2);
        }).takeWhile((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PekkoToResponseBody.$anonfun$toRangedStream$2(bytesTotal, x$2)), true).map((Function1 & Serializable)x$3 -> (ByteString)x$3._2());
    }

    private ResponseEntity streamToEntity(ContentType contentType, Option<Object> contentLength, Source<ByteString, Object> stream) {
        Option<Object> option = contentLength;
        if (None$.MODULE$.equals(option)) {
            return HttpEntity$.MODULE$.apply(contentType, stream);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long l = BoxesRunTime.unboxToLong((Object)some.value());
            return HttpEntity$.MODULE$.apply(contentType, l, stream);
        }
        throw new MatchError(option);
    }

    private <T> Option<Multipart.FormData.BodyPart> rawPartToBodyPart(RawBodyType.MultipartBody m, Part<T> part) {
        return m.partType(part.name()).map((Function1 & Serializable)partType -> {
            Option partContentLength;
            ContentType partContentType = (ContentType)part.contentType().map((Function1 & Serializable)ct -> this.parseContentType((String)ct)).getOrElse((Function0 & Serializable)() -> ContentTypes$.MODULE$.application$divoctet$minusstream());
            ResponseEntity responseEntity = this.rawValueToResponseEntity((RawBodyType)partType, partContentType, (Option<Object>)(partContentLength = part.header(HeaderNames$.MODULE$.ContentLength()).flatMap((Function1 & Serializable)v -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(v))).toOption())), (Object)part.body());
            if (!(responseEntity instanceof BodyPartEntity)) {
                throw new IllegalArgumentException(new StringBuilder(37).append(partType).append(" is not supported in multipart bodies").toString());
            }
            ResponseEntity responseEntity2 = responseEntity;
            ResponseEntity body = this.overrideContentTypeIfDefined(responseEntity2, (HasHeaders)part);
            return Multipart.FormData$.BodyPart$.MODULE$.apply(part.name(), (BodyPartEntity)body, part.otherDispositionParams(), (Seq)PekkoModel$.MODULE$.parseHeadersOrThrowWithoutContentHeaders((HasHeaders)part).toList());
        });
    }

    private ContentType formatToContentType(CodecFormat format, Option<Charset> charset) {
        CodecFormat codecFormat = format;
        if (codecFormat instanceof CodecFormat.Json) {
            return ContentTypes$.MODULE$.application$divjson();
        }
        if (codecFormat instanceof CodecFormat.TextPlain) {
            return MediaTypes$.MODULE$.text$divplain().withCharset(this.charsetToHttpCharset((Charset)charset.getOrElse((Function0 & Serializable)() -> StandardCharsets.UTF_8)));
        }
        if (codecFormat instanceof CodecFormat.TextHtml) {
            return MediaTypes$.MODULE$.text$divhtml().withCharset(this.charsetToHttpCharset((Charset)charset.getOrElse((Function0 & Serializable)() -> StandardCharsets.UTF_8)));
        }
        if (codecFormat instanceof CodecFormat.OctetStream) {
            return ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divoctet$minusstream());
        }
        if (codecFormat instanceof CodecFormat.Zip) {
            return ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divzip());
        }
        if (codecFormat instanceof CodecFormat.XWwwFormUrlencoded) {
            return ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divx$minuswww$minusform$minusurlencoded());
        }
        if (codecFormat instanceof CodecFormat.MultipartFormData) {
            return ContentType$.MODULE$.apply((MediaType.Binary)MediaTypes$.MODULE$.multipart$divform$minusdata());
        }
        MediaType mt = codecFormat.mediaType().isText() ? (MediaType)charset.fold((Function0 & Serializable)() -> codecFormat.mediaType(), (Function1 & Serializable)x$4 -> codecFormat.mediaType().charset(x$4)) : codecFormat.mediaType();
        return this.parseContentType(mt.toString());
    }

    private ContentType parseContentType(String ct) {
        return ContentTypeCache$.MODULE$.getOrParse(ct);
    }

    private HttpCharset charsetToHttpCharset(Charset charset) {
        return HttpCharset$.MODULE$.custom(charset.name(), (Seq)Nil$.MODULE$);
    }

    private <RE extends ResponseEntity> RE overrideContentTypeIfDefined(RE re, HasHeaders headers) {
        Option option = headers.contentType();
        if (option instanceof Some) {
            Some some = (Some)option;
            String ct = (String)some.value();
            return (RE)re.withContentType(this.parseContentType(ct));
        }
        if (None$.MODULE$.equals(option)) {
            return re;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$toRangedStream$2(long bytesTotal$1, Tuple2 x$2) {
        return x$2._1$mcJ$sp() < bytesTotal$1;
    }

    public PekkoToResponseBody(Materializer m, ExecutionContext ec) {
        this.m = m;
        this.ec = ec;
        this.streams = PekkoStreams$.MODULE$;
        this.ChunkSize = 8192;
    }
}

