/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.pekkohttp;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.ws.Message;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directives$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.directives.OnSuccessMagnet$;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.apache.pekko.http.scaladsl.server.util.Tupler$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.capabilities.package;
import sttp.capabilities.pekko.PekkoStreams;
import sttp.model.HasHeaders;
import sttp.model.Method$;
import sttp.monad.FutureMonad;
import sttp.monad.MonadError;
import sttp.tapir.model.ServerRequest;
import sttp.tapir.server.ServerEndpoint;
import sttp.tapir.server.interceptor.Interceptor;
import sttp.tapir.server.interceptor.RequestResult;
import sttp.tapir.server.interceptor.reject.RejectInterceptor$;
import sttp.tapir.server.interpreter.BodyListener;
import sttp.tapir.server.interpreter.FilterServerEndpoints;
import sttp.tapir.server.interpreter.FilterServerEndpoints$;
import sttp.tapir.server.interpreter.RequestBody;
import sttp.tapir.server.interpreter.ServerInterpreter;
import sttp.tapir.server.interpreter.ToResponseBody;
import sttp.tapir.server.model.ServerResponse;
import sttp.tapir.server.pekkohttp.PekkoBodyListener;
import sttp.tapir.server.pekkohttp.PekkoHttpServerInterpreter$;
import sttp.tapir.server.pekkohttp.PekkoHttpServerOptions;
import sttp.tapir.server.pekkohttp.PekkoHttpServerOptions$;
import sttp.tapir.server.pekkohttp.PekkoModel$;
import sttp.tapir.server.pekkohttp.PekkoRequestBody;
import sttp.tapir.server.pekkohttp.PekkoServerRequest;
import sttp.tapir.server.pekkohttp.PekkoServerRequest$;
import sttp.tapir.server.pekkohttp.PekkoStreamSizeExceptionInterceptor$;
import sttp.tapir.server.pekkohttp.PekkoToResponseBody;

public interface PekkoHttpServerInterpreter {
    public static PekkoHttpServerInterpreter apply(ExecutionContext executionContext) {
        return PekkoHttpServerInterpreter$.MODULE$.apply(executionContext);
    }

    public static PekkoHttpServerInterpreter apply(PekkoHttpServerOptions pekkoHttpServerOptions, ExecutionContext executionContext) {
        return PekkoHttpServerInterpreter$.MODULE$.apply(pekkoHttpServerOptions, executionContext);
    }

    public ExecutionContext executionContext();

    public static PekkoHttpServerOptions pekkoHttpServerOptions$(PekkoHttpServerInterpreter $this) {
        return $this.pekkoHttpServerOptions();
    }

    default public PekkoHttpServerOptions pekkoHttpServerOptions() {
        return PekkoHttpServerOptions$.MODULE$.default(this.executionContext());
    }

    public static Function1 toRoute$(PekkoHttpServerInterpreter $this, ServerEndpoint se) {
        return $this.toRoute((ServerEndpoint<package.WebSockets, Future>)se);
    }

    default public Function1<RequestContext, Future<RouteResult>> toRoute(ServerEndpoint<package.WebSockets, Future> se) {
        return this.toRoute((List<ServerEndpoint<package.WebSockets, Future>>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ServerEndpoint[]{se}))));
    }

    public static Function1 toRoute$(PekkoHttpServerInterpreter $this, List ses) {
        return $this.toRoute((List<ServerEndpoint<package.WebSockets, Future>>)ses);
    }

    default public Function1<RequestContext, Future<RouteResult>> toRoute(List<ServerEndpoint<package.WebSockets, Future>> ses) {
        return this.toRoute((Function2<Materializer, ExecutionContext, RequestBody<Future, PekkoStreams>>)(Function2 & Serializable)(_$1, _$2) -> new PekkoRequestBody(this.pekkoHttpServerOptions(), (Materializer)_$1, (ExecutionContext)_$2), (Function2<Materializer, ExecutionContext, ToResponseBody<Either<Flow<Message, Message, Object>, ResponseEntity>, PekkoStreams>>)(Function2 & Serializable)(_$3, _$4) -> new PekkoToResponseBody((Materializer)_$3, (ExecutionContext)_$4), ses);
    }

    public static Function1 toRoute$(PekkoHttpServerInterpreter $this, Function2 requestBody, Function2 toResponseBody, List ses) {
        return $this.toRoute((Function2<Materializer, ExecutionContext, RequestBody<Future, PekkoStreams>>)requestBody, (Function2<Materializer, ExecutionContext, ToResponseBody<Either<Flow<Message, Message, Object>, ResponseEntity>, PekkoStreams>>)toResponseBody, (List<ServerEndpoint<package.WebSockets, Future>>)ses);
    }

    default public Function1<RequestContext, Future<RouteResult>> toRoute(Function2<Materializer, ExecutionContext, RequestBody<Future, PekkoStreams>> requestBody, Function2<Materializer, ExecutionContext, ToResponseBody<Either<Flow<Message, Message, Object>, ResponseEntity>, PekkoStreams>> toResponseBody, List<ServerEndpoint<package.WebSockets, Future>> ses) {
        FilterServerEndpoints filterServerEndpoints = FilterServerEndpoints$.MODULE$.apply(ses);
        List interceptors = RejectInterceptor$.MODULE$.disableWhenSingleEndpoint(this.pekkoHttpServerOptions().appendInterceptor((Interceptor<Future>)PekkoStreamSizeExceptionInterceptor$.MODULE$).interceptors(), ses);
        return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractExecutionContext(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)ec -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractMaterializer(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)mat -> {
            FutureMonad monad = new FutureMonad((ExecutionContext)ec);
            PekkoBodyListener bodyListener = new PekkoBodyListener((ExecutionContext)ec);
            ServerInterpreter interpreter = new ServerInterpreter((Function1)filterServerEndpoints, (RequestBody)requestBody.apply(mat, ec), (ToResponseBody)toResponseBody.apply(mat, ec), interceptors, this.pekkoHttpServerOptions().deleteFile(), (MonadError)monad, (BodyListener)bodyListener);
            return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractRequestContext(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)ctx -> {
                PekkoServerRequest serverRequest = PekkoServerRequest$.MODULE$.apply((RequestContext)ctx, PekkoServerRequest$.MODULE$.$lessinit$greater$default$2());
                return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.onSuccess(OnSuccessMagnet$.MODULE$.apply(() -> PekkoHttpServerInterpreter.toRoute$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(interpreter, serverRequest), Tupler$.MODULE$.forAnyRef())), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x$1 -> {
                    RequestResult requestResult = x$1;
                    if (requestResult instanceof RequestResult.Failure) {
                        RequestResult.Failure failure = RequestResult.Failure$.MODULE$.unapply((RequestResult.Failure)requestResult);
                        List list = failure._1();
                        return Directives$.MODULE$.reject();
                    }
                    if (requestResult instanceof RequestResult.Response) {
                        ServerResponse serverResponse;
                        RequestResult.Response response = RequestResult.Response$.MODULE$.unapply((RequestResult.Response)requestResult);
                        ServerResponse response2 = serverResponse = response._1();
                        return this.serverResponseToPekko((ServerResponse<Either<Flow<Message, Message, Object>, ResponseEntity>>)response2, serverRequest.method());
                    }
                    throw new MatchError((Object)requestResult);
                });
            });
        }));
    }

    private Function1<RequestContext, Future<RouteResult>> serverResponseToPekko(ServerResponse<Either<Flow<Message, Message, Object>, ResponseEntity>> response, String requestMethod) {
        StatusCode statusCode = (StatusCode)StatusCodes$.MODULE$.getForKey((Object)BoxesRunTime.boxToInteger((int)response.code())).getOrElse(() -> PekkoHttpServerInterpreter.$anonfun$1(response));
        Seq<HttpHeader> pekkoHeaders = PekkoModel$.MODULE$.parseHeadersOrThrowWithoutContentHeaders((HasHeaders)response);
        Option option = response.body();
        if (option instanceof Some) {
            Either either = (Either)((Some)option).value();
            if (either instanceof Left) {
                Flow flow = (Flow)((Left)either).value();
                return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.respondWithHeaders(pekkoHeaders)).apply(() -> PekkoHttpServerInterpreter.serverResponseToPekko$$anonfun$1(flow));
            }
            if (either instanceof Right) {
                ResponseEntity entity = (ResponseEntity)((Right)either).value();
                return Directives$.MODULE$.complete(() -> PekkoHttpServerInterpreter.serverResponseToPekko$$anonfun$2(statusCode, pekkoHeaders, entity));
            }
        }
        if (None$.MODULE$.equals(option)) {
            if (Method$.MODULE$.is$extension(requestMethod, Method$.MODULE$.HEAD()) && response.contentLength().isDefined()) {
                ContentType.Binary binary;
                long contentLength = BoxesRunTime.unboxToLong((Object)response.contentLength().getOrElse(PekkoHttpServerInterpreter::$anonfun$2));
                Option option2 = response.contentType();
                if (option2 instanceof Some) {
                    String t = (String)((Some)option2).value();
                    binary = (ContentType)ContentType$.MODULE$.parse(t).getOrElse(PekkoHttpServerInterpreter::$anonfun$3);
                } else if (None$.MODULE$.equals(option2)) {
                    binary = ContentTypes$.MODULE$.NoContentType();
                } else {
                    throw new MatchError((Object)option2);
                }
                ContentType.Binary contentType = binary;
                return Directives$.MODULE$.complete(() -> PekkoHttpServerInterpreter.serverResponseToPekko$$anonfun$3(statusCode, pekkoHeaders, contentLength, (ContentType)contentType));
            }
            Option option3 = response.contentType();
            if (option3 instanceof Some) {
                String t = (String)((Some)option3).value();
                ContentType contentType = (ContentType)ContentType$.MODULE$.parse(t).getOrElse(PekkoHttpServerInterpreter::$anonfun$4);
                return Directives$.MODULE$.complete(() -> PekkoHttpServerInterpreter.serverResponseToPekko$$anonfun$4(statusCode, pekkoHeaders, contentType));
            }
            if (None$.MODULE$.equals(option3)) {
                return Directives$.MODULE$.complete(() -> PekkoHttpServerInterpreter.serverResponseToPekko$$anonfun$5(statusCode, pekkoHeaders));
            }
            throw new MatchError((Object)option3);
        }
        throw new MatchError((Object)option);
    }

    private static Future toRoute$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(ServerInterpreter interpreter$2, PekkoServerRequest serverRequest$1) {
        return (Future)interpreter$2.apply((ServerRequest)serverRequest$1);
    }

    private static StatusCode $anonfun$1(ServerResponse response$1) {
        return StatusCodes$.MODULE$.custom(response$1.code(), "", StatusCodes$.MODULE$.custom$default$3());
    }

    private static Function1 serverResponseToPekko$$anonfun$1(Flow flow$1) {
        return Directives$.MODULE$.handleWebSocketMessages(flow$1);
    }

    private static ToResponseMarshallable serverResponseToPekko$$anonfun$2(StatusCode statusCode$1, Seq pekkoHeaders$1, ResponseEntity entity$1) {
        return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply(statusCode$1, pekkoHeaders$1, entity$1, HttpResponse$.MODULE$.apply$default$4()), Marshaller$.MODULE$.fromResponse());
    }

    private static long $anonfun$2() {
        return 0L;
    }

    private static ContentType $anonfun$3() {
        return ContentTypes$.MODULE$.NoContentType();
    }

    private static ToResponseMarshallable serverResponseToPekko$$anonfun$3(StatusCode statusCode$2, Seq pekkoHeaders$2, long contentLength$1, ContentType contentType$1) {
        return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply(statusCode$2, pekkoHeaders$2, (ResponseEntity)HttpEntity.Default$.MODULE$.apply(contentType$1, contentLength$1, Source$.MODULE$.empty()), HttpResponse$.MODULE$.apply$default$4()), Marshaller$.MODULE$.fromResponse());
    }

    private static ContentType $anonfun$4() {
        return ContentTypes$.MODULE$.NoContentType();
    }

    private static ToResponseMarshallable serverResponseToPekko$$anonfun$4(StatusCode statusCode$3, Seq pekkoHeaders$3, ContentType contentType$2) {
        return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply(statusCode$3, pekkoHeaders$3, (ResponseEntity)HttpEntity.Strict$.MODULE$.apply(contentType$2, ByteString$.MODULE$.empty()), HttpResponse$.MODULE$.apply$default$4()), Marshaller$.MODULE$.fromResponse());
    }

    private static ToResponseMarshallable serverResponseToPekko$$anonfun$5(StatusCode statusCode$4, Seq pekkoHeaders$4) {
        return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply(statusCode$4, pekkoHeaders$4, HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4()), Marshaller$.MODULE$.fromResponse());
    }
}

