/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.pekkohttp;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.pekko.http.scaladsl.model.EntityStreamSizeException;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.Multipart;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.StreamConverters$;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sttp.capabilities.pekko.PekkoStreams;
import sttp.capabilities.pekko.PekkoStreams$;
import sttp.model.Header$;
import sttp.model.Part;
import sttp.model.Part$;
import sttp.tapir.FileRange;
import sttp.tapir.FileRange$;
import sttp.tapir.InputStreamRange$;
import sttp.tapir.RawBodyType;
import sttp.tapir.model.ServerRequest;
import sttp.tapir.server.interpreter.RawValue;
import sttp.tapir.server.interpreter.RawValue$;
import sttp.tapir.server.interpreter.RequestBody;
import sttp.tapir.server.pekkohttp.PekkoHttpServerOptions;

public class PekkoRequestBody
implements RequestBody<Future, PekkoStreams> {
    private final PekkoHttpServerOptions serverOptions;
    private final Materializer mat;
    private final ExecutionContext ec;
    private final PekkoStreams streams;

    public PekkoRequestBody(PekkoHttpServerOptions serverOptions, Materializer mat, ExecutionContext ec) {
        this.serverOptions = serverOptions;
        this.mat = mat;
        this.ec = ec;
        this.streams = PekkoStreams$.MODULE$;
    }

    public PekkoStreams streams() {
        return this.streams;
    }

    public <R> Future<RawValue<R>> toRaw(ServerRequest request, RawBodyType<R> bodyType, Option<Object> maxBytes) {
        return this.toRawFromEntity(request, (HttpEntity)this.requestEntity(request, maxBytes), bodyType);
    }

    public Source<ByteString, Object> toStream(ServerRequest request, Option<Object> maxBytes) {
        return this.requestEntity(request, maxBytes).dataBytes();
    }

    private RequestEntity requestEntity(ServerRequest request, Option<Object> maxBytes2) {
        RequestEntity entity = ((RequestContext)request.underlying()).request().entity();
        return (RequestEntity)maxBytes2.map((Function1 & Serializable)maxBytes -> entity.withSizeLimit(BoxesRunTime.unboxToLong((Object)maxBytes))).getOrElse(() -> PekkoRequestBody.requestEntity$$anonfun$2(entity));
    }

    private <R> Future<RawValue<R>> toRawFromEntity(ServerRequest request, HttpEntity body, RawBodyType<R> bodyType) {
        RawBodyType<R> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset charset = stringBody._1();
            return ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.stringUnmarshaller())).apply((Object)body, this.ec, this.mat).map((Function1 & Serializable)_$1 -> RawValue$.MODULE$.apply(_$1, RawValue$.MODULE$.$lessinit$greater$default$2()), this.ec);
        }
        if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            return ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.byteArrayUnmarshaller())).apply((Object)body, this.ec, this.mat).map((Function1 & Serializable)_$2 -> RawValue$.MODULE$.apply(_$2, RawValue$.MODULE$.$lessinit$greater$default$2()), this.ec);
        }
        if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            return ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.byteStringUnmarshaller())).apply((Object)body, this.ec, this.mat).map((Function1 & Serializable)b -> RawValue$.MODULE$.apply((Object)b.asByteBuffer(), RawValue$.MODULE$.$lessinit$greater$default$2()), this.ec);
        }
        if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            return Future$.MODULE$.successful((Object)RawValue$.MODULE$.apply(body.dataBytes().runWith((Graph)StreamConverters$.MODULE$.asInputStream(StreamConverters$.MODULE$.asInputStream$default$1()), this.mat), RawValue$.MODULE$.$lessinit$greater$default$2()));
        }
        if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            return ((Future)this.serverOptions.createFile().apply((Object)request)).flatMap((Function1 & Serializable)file -> ((Future)body.dataBytes().runWith((Graph)FileIO$.MODULE$.toPath(file.toPath(), FileIO$.MODULE$.toPath$default$2()), this.mat)).recoverWith((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Exception e;
                    Throwable throwable = x;
                    return throwable instanceof Exception && (e = (Exception)throwable).getCause() instanceof EntityStreamSizeException;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Exception e;
                    Throwable throwable = x;
                    if (throwable instanceof Exception && (e = (Exception)throwable).getCause() instanceof EntityStreamSizeException) {
                        return Future$.MODULE$.failed(e.getCause());
                    }
                    return function1.apply((Object)x);
                }
            }, this.ec).map((Function1 & Serializable)_$3 -> FileRange$.MODULE$.apply(file, FileRange$.MODULE$.$lessinit$greater$default$2()), this.ec).map((Function1 & Serializable)f -> RawValue$.MODULE$.apply(f, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FileRange[]{f}))), this.ec), this.ec);
        }
        if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            return Future$.MODULE$.successful((Object)RawValue$.MODULE$.apply((Object)InputStreamRange$.MODULE$.apply((Function0 & Serializable)() -> (InputStream)body.dataBytes().runWith((Graph)StreamConverters$.MODULE$.asInputStream(StreamConverters$.MODULE$.asInputStream$default$1()), this.mat), InputStreamRange$.MODULE$.$lessinit$greater$default$2()), RawValue$.MODULE$.$lessinit$greater$default$2()));
        }
        if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody m = (RawBodyType.MultipartBody)rawBodyType;
            return ((Unmarshaller)Predef$.MODULE$.implicitly((Object)Unmarshaller$.MODULE$.multipartFormDataUnmarshaller(Unmarshaller$.MODULE$.multipartFormDataUnmarshaller$default$1(), Unmarshaller$.MODULE$.multipartFormDataUnmarshaller$default$2()))).apply((Object)body, this.ec, this.mat).flatMap((Function1 & Serializable)fd -> ((Future)((Source)fd.parts().mapConcat((Function1 & Serializable)part -> m.partType(part.name()).map((Function1 & Serializable)_$4 -> Tuple2$.MODULE$.apply(part, _$4)).toList()).mapAsync(1, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Multipart.FormData.BodyPart part = (Multipart.FormData.BodyPart)tuple2._1();
                    RawBodyType codecMeta = (RawBodyType)tuple2._2();
                    return this.toRawPart(request, part, codecMeta);
                }
                throw new MatchError((Object)tuple2);
            })).runWith((Graph)Sink$.MODULE$.seq(), this.mat)).map((Function1 & Serializable)parts -> RawValue$.MODULE$.fromParts(parts), this.ec), this.ec);
        }
        throw new MatchError(rawBodyType);
    }

    private <R> Future<Part<R>> toRawPart(ServerRequest request, Multipart.FormData.BodyPart part, RawBodyType<R> bodyType) {
        return this.toRawFromEntity(request, (HttpEntity)part.entity(), bodyType).map((Function1 & Serializable)r -> Part$.MODULE$.apply(part.name(), r.value(), part.additionalDispositionParams(), (Seq)part.additionalHeaders().map((Function1 & Serializable)h -> Header$.MODULE$.apply(h.name(), h.value()))).contentType(part.entity().contentType().toString()), this.ec);
    }

    private static final RequestEntity requestEntity$$anonfun$2(RequestEntity entity$2) {
        return entity$2;
    }
}

