/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.pekkohttp;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.pekko.http.scaladsl.model.BodyPartEntity;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpCharset;
import org.apache.pekko.http.scaladsl.model.HttpCharset$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.MediaTypes$;
import org.apache.pekko.http.scaladsl.model.Multipart;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.ws.Message;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.StreamConverters$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try$;
import sttp.capabilities.pekko.PekkoStreams;
import sttp.capabilities.pekko.PekkoStreams$;
import sttp.model.HasHeaders;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Part;
import sttp.tapir.CodecFormat;
import sttp.tapir.FileRange;
import sttp.tapir.InputStreamRange;
import sttp.tapir.RawBodyType;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.server.interpreter.ToResponseBody;
import sttp.tapir.server.pekkohttp.PekkoModel$;
import sttp.tapir.server.pekkohttp.PekkoWebSockets$;

public class PekkoToResponseBody
implements ToResponseBody<Either<Flow<Message, Message, Object>, ResponseEntity>, PekkoStreams> {
    private final Materializer m;
    private final ExecutionContext ec;
    private final PekkoStreams streams;
    private final int ChunkSize;

    public PekkoToResponseBody(Materializer m, ExecutionContext ec) {
        this.m = m;
        this.ec = ec;
        this.streams = PekkoStreams$.MODULE$;
        this.ChunkSize = 8192;
    }

    public PekkoStreams streams() {
        return this.streams;
    }

    public <R> Either<Flow<Message, Message, Object>, ResponseEntity> fromRawValue(R v, HasHeaders headers, CodecFormat format, RawBodyType<R> bodyType) {
        return package$.MODULE$.Right().apply((Object)this.overrideContentTypeIfDefined(this.rawValueToResponseEntity(bodyType, this.formatToContentType(format, (Option<Charset>)sttp.tapir.internal.package$.MODULE$.charset(bodyType)), (Option<Object>)headers.contentLength(), v), headers));
    }

    public Either<Flow<Message, Message, Object>, ResponseEntity> fromStreamValue(Source<ByteString, Object> v, HasHeaders headers, CodecFormat format, Option<Charset> charset) {
        return package$.MODULE$.Right().apply((Object)this.overrideContentTypeIfDefined(this.streamToEntity(this.formatToContentType(format, charset), (Option<Object>)headers.contentLength(), v), headers));
    }

    public <REQ, RESP> Either<Flow<Message, Message, Object>, ResponseEntity> fromWebSocketPipe(Flow<REQ, RESP, Object> pipe, WebSocketBodyOutput<Flow<REQ, RESP, Object>, REQ, RESP, ?, PekkoStreams> o) {
        return package$.MODULE$.Left().apply(PekkoWebSockets$.MODULE$.pipeToBody(pipe, o, this.ec, this.m));
    }

    private <CF extends CodecFormat, R> ResponseEntity rawValueToResponseEntity(RawBodyType<R> bodyType, ContentType ct, Option<Object> contentLength, R r2) {
        RawBodyType<R> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            Charset charset;
            RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset charset2 = charset = stringBody._1();
            ContentType contentType = ct;
            if (contentType instanceof ContentType.NonBinary) {
                ContentType.NonBinary nb = (ContentType.NonBinary)contentType;
                return HttpEntity$.MODULE$.apply(nb, (String)r2);
            }
            return HttpEntity$.MODULE$.apply(ct, ((String)r2).getBytes(charset2));
        }
        if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            return HttpEntity$.MODULE$.apply(ct, (byte[])r2);
        }
        if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            return HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply((ByteBuffer)r2));
        }
        if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            return this.streamToEntity(ct, contentLength, (Source<ByteString, Object>)StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> (InputStream)r2, this.ChunkSize));
        }
        if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            Object resource = r2;
            Source initialStream = StreamConverters$.MODULE$.fromInputStream(((InputStreamRange)resource).inputStreamFromRangeStart(), this.ChunkSize);
            return (ResponseEntity)((InputStreamRange)resource).range().map((Function1 & Serializable)r -> this.streamToEntity(ct, contentLength, this.toRangedStream((Source<ByteString, Object>)initialStream, r.contentLength()))).getOrElse(() -> this.rawValueToResponseEntity$$anonfun$3(ct, contentLength, initialStream));
        }
        if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            Object tapirFile = r2;
            return (ResponseEntity)((FileRange)tapirFile).range().flatMap((Function1 & Serializable)r -> r.startAndEnd().map((Function1 & Serializable)s -> HttpEntity$.MODULE$.apply(ct, this.createFileSource((FileRange)tapirFile, s._1$mcJ$sp(), r.contentLength())))).getOrElse(() -> PekkoToResponseBody.rawValueToResponseEntity$$anonfun$5(ct, tapirFile));
        }
        if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody m = (RawBodyType.MultipartBody)rawBodyType;
            Seq parts = (Seq)((Seq)r2).flatMap((Function1 & Serializable)_$1 -> this.rawPartToBodyPart(m, (Part)_$1));
            Multipart.FormData body = Multipart.FormData$.MODULE$.apply(parts);
            return body.toEntity();
        }
        throw new MatchError(rawBodyType);
    }

    private Source<ByteString, Object> createFileSource(FileRange tapirFile, long start, long bytesTotal) {
        return this.toRangedStream((Source<ByteString, Object>)FileIO$.MODULE$.fromPath(tapirFile.file().toPath(), this.ChunkSize, start), bytesTotal);
    }

    private Source<ByteString, Object> toRangedStream(Source<ByteString, Object> initialStream, long bytesTotal) {
        return (Source)initialStream.scan((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L), (Object)ByteString$.MODULE$.empty()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                long bytesConsumed = BoxesRunTime.unboxToLong((Object)tuple2._1());
                ByteString next = (ByteString)tuple22._2();
                int bytesInNext = next.length();
                long bytesFromNext = Math.max(0L, Math.min(bytesTotal - bytesConsumed, (long)bytesInNext));
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(bytesConsumed + (long)bytesInNext)), (Object)next.take((int)bytesFromNext));
            }
            throw new MatchError((Object)tuple22);
        }).takeWhile((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToLong((Object)_$2._1()) < bytesTotal, true).map((Function1 & Serializable)_$3 -> (ByteString)_$3._2());
    }

    private ResponseEntity streamToEntity(ContentType contentType, Option<Object> contentLength, Source<ByteString, Object> stream) {
        Option<Object> option = contentLength;
        if (None$.MODULE$.equals(option)) {
            return HttpEntity$.MODULE$.apply(contentType, stream);
        }
        if (option instanceof Some) {
            long l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return HttpEntity$.MODULE$.apply(contentType, l, stream);
        }
        throw new MatchError(option);
    }

    private <T> Option<Multipart.FormData.BodyPart> rawPartToBodyPart(RawBodyType.MultipartBody m, Part<T> part) {
        return m.partType(part.name()).map((Function1 & Serializable)partType -> {
            Option partContentLength;
            ContentType partContentType = (ContentType)part.contentType().map((Function1 & Serializable)ct -> this.parseContentType((String)ct)).getOrElse(PekkoToResponseBody::$anonfun$3);
            ResponseEntity responseEntity = this.rawValueToResponseEntity((RawBodyType)partType, partContentType, (Option<Object>)(partContentLength = part.header(HeaderNames$.MODULE$.ContentLength()).flatMap((Function1 & Serializable)v -> Try$.MODULE$.apply(() -> PekkoToResponseBody.$anonfun$4$$anonfun$1(v)).toOption())), (Object)part.body());
            if (!(responseEntity instanceof BodyPartEntity)) {
                throw new IllegalArgumentException(new StringBuilder(37).append(partType).append(" is not supported in multipart bodies").toString());
            }
            BodyPartEntity b = (BodyPartEntity)responseEntity;
            BodyPartEntity body = (BodyPartEntity)this.overrideContentTypeIfDefined((ResponseEntity)b, (HasHeaders)part);
            return Multipart.FormData$.BodyPart$.MODULE$.apply(part.name(), body, part.otherDispositionParams(), (Seq)PekkoModel$.MODULE$.parseHeadersOrThrowWithoutContentHeaders((HasHeaders)part).toList());
        });
    }

    private ContentType formatToContentType(CodecFormat format, Option<Charset> charset) {
        CodecFormat codecFormat = format;
        if (codecFormat instanceof CodecFormat.Json && CodecFormat.Json$.MODULE$.unapply((CodecFormat.Json)codecFormat)) {
            return ContentTypes$.MODULE$.application$divjson();
        }
        if (codecFormat instanceof CodecFormat.TextPlain && CodecFormat.TextPlain$.MODULE$.unapply((CodecFormat.TextPlain)codecFormat)) {
            return MediaTypes$.MODULE$.text$divplain().withCharset(this.charsetToHttpCharset((Charset)charset.getOrElse(PekkoToResponseBody::formatToContentType$$anonfun$1)));
        }
        if (codecFormat instanceof CodecFormat.TextHtml && CodecFormat.TextHtml$.MODULE$.unapply((CodecFormat.TextHtml)codecFormat)) {
            return MediaTypes$.MODULE$.text$divhtml().withCharset(this.charsetToHttpCharset((Charset)charset.getOrElse(PekkoToResponseBody::formatToContentType$$anonfun$2)));
        }
        if (codecFormat instanceof CodecFormat.OctetStream && CodecFormat.OctetStream$.MODULE$.unapply((CodecFormat.OctetStream)codecFormat)) {
            return ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divoctet$minusstream());
        }
        if (codecFormat instanceof CodecFormat.Zip && CodecFormat.Zip$.MODULE$.unapply((CodecFormat.Zip)codecFormat)) {
            return ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divzip());
        }
        if (codecFormat instanceof CodecFormat.XWwwFormUrlencoded && CodecFormat.XWwwFormUrlencoded$.MODULE$.unapply((CodecFormat.XWwwFormUrlencoded)codecFormat)) {
            return ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divx$minuswww$minusform$minusurlencoded());
        }
        if (codecFormat instanceof CodecFormat.MultipartFormData && CodecFormat.MultipartFormData$.MODULE$.unapply((CodecFormat.MultipartFormData)codecFormat)) {
            return ContentType$.MODULE$.apply((MediaType.Binary)MediaTypes$.MODULE$.multipart$divform$minusdata());
        }
        CodecFormat f = codecFormat;
        MediaType mt = f.mediaType().isText() ? (MediaType)charset.fold(() -> PekkoToResponseBody.$anonfun$5(f), (Function1 & Serializable)_$4 -> f.mediaType().charset(_$4)) : f.mediaType();
        return this.parseContentType(mt.toString());
    }

    private ContentType parseContentType(String ct) {
        return (ContentType)ContentType$.MODULE$.parse(ct).getOrElse(() -> PekkoToResponseBody.parseContentType$$anonfun$1(ct));
    }

    private HttpCharset charsetToHttpCharset(Charset charset) {
        return HttpCharset$.MODULE$.custom(charset.name(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    private <RE extends ResponseEntity> RE overrideContentTypeIfDefined(RE re, HasHeaders headers) {
        Option option = headers.contentType();
        if (option instanceof Some) {
            String ct = (String)((Some)option).value();
            return (RE)re.withContentType(this.parseContentType(ct));
        }
        if (None$.MODULE$.equals(option)) {
            return re;
        }
        throw new MatchError((Object)option);
    }

    private final ResponseEntity rawValueToResponseEntity$$anonfun$3(ContentType ct$2, Option contentLength$2, Source initialStream$2) {
        return this.streamToEntity(ct$2, (Option<Object>)contentLength$2, (Source<ByteString, Object>)initialStream$2);
    }

    private static final RequestEntity rawValueToResponseEntity$$anonfun$5(ContentType ct$5, Object tapirFile$3) {
        return HttpEntity$.MODULE$.fromPath(ct$5, ((FileRange)tapirFile$3).file().toPath(), HttpEntity$.MODULE$.fromPath$default$3());
    }

    private static final ContentType $anonfun$3() {
        return ContentTypes$.MODULE$.application$divoctet$minusstream();
    }

    private static final long $anonfun$4$$anonfun$1(String v$1) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(v$1));
    }

    private static final Charset formatToContentType$$anonfun$1() {
        return StandardCharsets.UTF_8;
    }

    private static final Charset formatToContentType$$anonfun$2() {
        return StandardCharsets.UTF_8;
    }

    private static final MediaType $anonfun$5(CodecFormat f$1) {
        return f$1.mediaType();
    }

    private static final ContentType parseContentType$$anonfun$1(String ct$6) {
        throw new IllegalArgumentException(new StringBuilder(27).append("Cannot parse content type: ").append(ct$6).toString());
    }
}

