/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.pekkohttp;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.model.ws.BinaryMessage;
import org.apache.pekko.http.scaladsl.model.ws.BinaryMessage$;
import org.apache.pekko.http.scaladsl.model.ws.Message;
import org.apache.pekko.http.scaladsl.model.ws.TextMessage;
import org.apache.pekko.http.scaladsl.model.ws.TextMessage$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import sttp.capabilities.pekko.PekkoStreams;
import sttp.tapir.DecodeResult;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.model.WebSocketFrameDecodeFailure;
import sttp.ws.WebSocketClosed$;
import sttp.ws.WebSocketFrame;
import sttp.ws.WebSocketFrame$;

public final class PekkoWebSockets$
implements Serializable {
    public static final PekkoWebSockets$ MODULE$ = new PekkoWebSockets$();

    private PekkoWebSockets$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PekkoWebSockets$.class);
    }

    public <REQ, RESP> Flow<Message, Message, Object> pipeToBody(Flow<REQ, RESP, Object> pipe, WebSocketBodyOutput<Flow<REQ, RESP, Object>, REQ, RESP, ?, PekkoStreams> o, ExecutionContext ec, Materializer mat) {
        return (Flow)((Flow)Flow$.MODULE$.apply().mapAsync(1, (Function1 & Serializable)_$1 -> this.messageToFrame((Message)_$1, ec, mat)).map((Function1 & Serializable)f -> {
            DecodeResult decodeResult = o.requests().decode(f);
            if (decodeResult instanceof DecodeResult.Failure) {
                DecodeResult.Failure failure = (DecodeResult.Failure)decodeResult;
                throw new WebSocketFrameDecodeFailure((WebSocketFrame)f, failure);
            }
            if (decodeResult instanceof DecodeResult.Value) {
                Object object;
                DecodeResult.Value value = DecodeResult.Value$.MODULE$.unapply((DecodeResult.Value)decodeResult);
                Object v = object = value._1();
                return v;
            }
            throw new MatchError((Object)decodeResult);
        })).via(pipe).map((Function1 & Serializable)h -> (WebSocketFrame)o.responses().encode(h)).takeWhile((Function1 & Serializable)x$1 -> {
            WebSocketFrame webSocketFrame = x$1;
            if (webSocketFrame instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close close = WebSocketFrame.Close$.MODULE$.unapply((WebSocketFrame.Close)webSocketFrame);
                int n = close._1();
                String string = close._2();
                return false;
            }
            return true;
        }).mapConcat((Function1 & Serializable)_$2 -> this.frameToMessage((WebSocketFrame)_$2).toList());
    }

    private Future<WebSocketFrame.Data<?>> messageToFrame(Message m, ExecutionContext ec, Materializer mat) {
        Message message = m;
        if (message instanceof TextMessage) {
            TextMessage msg = (TextMessage)message;
            return msg.textStream().runFold((Object)"", (Function2 & Serializable)(_$3, _$4) -> new StringBuilder(0).append((String)_$3).append((String)_$4).toString(), mat).map((Function1 & Serializable)t -> WebSocketFrame$.MODULE$.text(t), ec);
        }
        if (message instanceof BinaryMessage) {
            BinaryMessage msg = (BinaryMessage)message;
            return msg.dataStream().runFold((Object)ByteString$.MODULE$.empty(), (Function2 & Serializable)(_$5, _$6) -> _$5.$plus$plus(_$6), mat).map((Function1 & Serializable)b -> WebSocketFrame$.MODULE$.binary((byte[])b.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))), ec);
        }
        throw new MatchError((Object)message);
    }

    private Option<Message> frameToMessage(WebSocketFrame w) {
        WebSocketFrame webSocketFrame = w;
        if (webSocketFrame instanceof WebSocketFrame.Text) {
            WebSocketFrame.Text text = WebSocketFrame.Text$.MODULE$.unapply((WebSocketFrame.Text)webSocketFrame);
            String string = text._1();
            boolean bl = text._2();
            Option option = text._3();
            String p = string;
            return Some$.MODULE$.apply((Object)TextMessage$.MODULE$.apply(p));
        }
        if (webSocketFrame instanceof WebSocketFrame.Binary) {
            WebSocketFrame.Binary binary = WebSocketFrame.Binary$.MODULE$.unapply((WebSocketFrame.Binary)webSocketFrame);
            byte[] byArray = binary._1();
            boolean bl = binary._2();
            Option option = binary._3();
            byte[] p = byArray;
            return Some$.MODULE$.apply((Object)BinaryMessage$.MODULE$.apply(ByteString$.MODULE$.apply(p)));
        }
        if (webSocketFrame instanceof WebSocketFrame.Ping) {
            WebSocketFrame.Ping ping = WebSocketFrame.Ping$.MODULE$.unapply((WebSocketFrame.Ping)webSocketFrame);
            byte[] byArray = ping._1();
            return None$.MODULE$;
        }
        if (webSocketFrame instanceof WebSocketFrame.Pong) {
            WebSocketFrame.Pong pong = WebSocketFrame.Pong$.MODULE$.unapply((WebSocketFrame.Pong)webSocketFrame);
            byte[] byArray = pong._1();
            return None$.MODULE$;
        }
        if (webSocketFrame instanceof WebSocketFrame.Close) {
            WebSocketFrame.Close close = WebSocketFrame.Close$.MODULE$.unapply((WebSocketFrame.Close)webSocketFrame);
            int n = close._1();
            String string = close._2();
            throw WebSocketClosed$.MODULE$.apply((Option)None$.MODULE$);
        }
        throw new MatchError((Object)webSocketFrame);
    }
}

