/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.client.play;

import akka.stream.scaladsl.Source;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Supplier;
import play.api.libs.ws.BodyWritable;
import play.api.libs.ws.BodyWritable$;
import play.api.libs.ws.DefaultBodyReadables$;
import play.api.libs.ws.DefaultBodyWritables$;
import play.api.libs.ws.DefaultWSCookie;
import play.api.libs.ws.DefaultWSCookie$;
import play.api.libs.ws.StandaloneWSClient;
import play.api.libs.ws.StandaloneWSRequest;
import play.api.libs.ws.StandaloneWSResponse;
import play.api.libs.ws.WSCookie;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.capabilities.akka.AkkaStreams$;
import sttp.capabilities.package;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.QueryParams;
import sttp.model.ResponseMetadata;
import sttp.model.ResponseMetadata$;
import sttp.model.StatusCode$;
import sttp.tapir.Codec;
import sttp.tapir.CodecFormat;
import sttp.tapir.DecodeResult;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.EndpointOutput;
import sttp.tapir.FileRange;
import sttp.tapir.FileRange$;
import sttp.tapir.InputStreamRange;
import sttp.tapir.InputStreamRange$;
import sttp.tapir.Mapping;
import sttp.tapir.RawBodyType;
import sttp.tapir.StreamBodyIO;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.client.ClientOutputParams;
import sttp.tapir.client.play.PlayClientOptions;
import sttp.tapir.internal.package;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg!\u0002\n\u0014\u0001MY\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u0011!\u0002!\u0011!Q\u0001\n%BQa\r\u0001\u0005\u0002QBQ\u0001\u000f\u0001\u0005\u0002eBaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0015\u0001\u0011%\u00111\u0006\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\t\u0019\b\u0001C\u0005\u0003kBq!!/\u0001\t\u0003\tY\fC\u0004\u0002h\u0002!I!!;\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!\u0011\t\u0001\u0005\n\t\r\u0003b\u0002B:\u0001\u0011%!Q\u000f\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u0011Y\n\u0001C\u0005\u0005;C\u0011B!/\u0001\u0005\u0004%IAa/\t\u0011\t\u0015\u0007\u0001)A\u0005\u0005{\u0013A#\u00128ea>Lg\u000e\u001e+p!2\f\u0017p\u00117jK:$(B\u0001\u000b\u0016\u0003\u0011\u0001H.Y=\u000b\u0005Y9\u0012AB2mS\u0016tGO\u0003\u0002\u00193\u0005)A/\u00199je*\t!$\u0001\u0003tiR\u00048C\u0001\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fM\u0006i1\r\\5f]R|\u0005\u000f^5p]N\u001c\u0001\u0001\u0005\u0002&M5\t1#\u0003\u0002('\t\t\u0002\u000b\\1z\u00072LWM\u001c;PaRLwN\\:\u0002\u0005]\u001c\bC\u0001\u00162\u001b\u0005Y#B\u0001\u0015-\u0015\tic&\u0001\u0003mS\n\u001c(BA\u00181\u0003\r\t\u0007/\u001b\u0006\u0002)%\u0011!g\u000b\u0002\u0013'R\fg\u000eZ1m_:,wkU\"mS\u0016tG/\u0001\u0004=S:LGO\u0010\u000b\u0004kY:\u0004CA\u0013\u0001\u0011\u0015\u00113\u00011\u0001%\u0011\u0015A3\u00011\u0001*\u00035!x\u000e\u00157bsJ+\u0017/^3tiV1!\bQ&iWN$2aO7v!\u0011iBHP%\n\u0005ur\"!\u0003$v]\u000e$\u0018n\u001c82!\ty\u0004\t\u0004\u0001\u0005\u000b\u0005#!\u0019\u0001\"\u0003\u0003\u0005\u000b\"a\u0011$\u0011\u0005u!\u0015BA#\u001f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!H$\n\u0005!s\"aA!osB!Q\u0004\u0010&N!\ty4\nB\u0003M\t\t\u0007!IA\u0001J!\u0011ib\nU*\n\u0005=s\"A\u0002+va2,'\u0007\u0005\u0002+#&\u0011!k\u000b\u0002\u0014'R\fg\u000eZ1m_:,wk\u0015*fcV,7\u000f\u001e\t\u0005;q\"v\u000b\u0005\u0002++&\u0011ak\u000b\u0002\u0015'R\fg\u000eZ1m_:,wk\u0015*fgB|gn]3\u0011\u0007aK6,D\u0001\u0018\u0013\tQvC\u0001\u0007EK\u000e|G-\u001a*fgVdG\u000f\u0005\u0003]I\u001eTgBA/c\u001d\tq\u0016-D\u0001`\u0015\t\u00017%\u0001\u0004=e>|GOP\u0005\u0002?%\u00111MH\u0001\ba\u0006\u001c7.Y4f\u0013\t)gM\u0001\u0004FSRDWM\u001d\u0006\u0003Gz\u0001\"a\u00105\u0005\u000b%$!\u0019\u0001\"\u0003\u0003\u0015\u0003\"aP6\u0005\u000b1$!\u0019\u0001\"\u0003\u0003=CQA\u001c\u0003A\u0002=\f\u0011!\u001a\t\b1Bt$j\u001a6s\u0013\t\txC\u0001\u0005F]\u0012\u0004x.\u001b8u!\ty4\u000fB\u0003u\t\t\u0007!IA\u0001S\u0011\u00151H\u00011\u0001x\u0003\u001d\u0011\u0017m]3Ve&\u0004\"\u0001\u001f?\u000f\u0005eT\bC\u00010\u001f\u0013\tYh$\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>\u001f\u0003\u0001\"x\u000e\u00157bsJ+\u0017/^3tiRC'o\\<EK\u000e|G-\u001a$bS2,(/Z:\u0016\u0019\u0005\r\u0011\u0011BA\b\u00033\ti\"!\n\u0015\r\u0005\u0015\u0011qDA\u0014!\u0019iB(a\u0002\u0002\fA\u0019q(!\u0003\u0005\u000b\u0005+!\u0019\u0001\"\u0011\rua\u0014QBA\t!\ry\u0014q\u0002\u0003\u0006\u0019\u0016\u0011\rA\u0011\t\u0006;9\u0003\u00161\u0003\t\u0006;q\"\u0016Q\u0003\t\u00079\u0012\f9\"a\u0007\u0011\u0007}\nI\u0002B\u0003j\u000b\t\u0007!\tE\u0002@\u0003;!Q\u0001\\\u0003C\u0002\tCaA\\\u0003A\u0002\u0005\u0005\u0002\u0003\u0004-q\u0003\u000f\ti!a\u0006\u0002\u001c\u0005\r\u0002cA \u0002&\u0011)A/\u0002b\u0001\u0005\")a/\u0002a\u0001o\u0006\t\u0002/\u0019:tKBc\u0017-\u001f*fgB|gn]3\u0016\u0019\u00055\u00121IA$\u0003o\tY$a\u0013\u0015\t\u0005=\u0012Q\b\t\u0006;q\"\u0016\u0011\u0007\t\u00051f\u000b\u0019\u0004\u0005\u0004]I\u0006U\u0012\u0011\b\t\u0004\u007f\u0005]B!B5\u0007\u0005\u0004\u0011\u0005cA \u0002<\u0011)AN\u0002b\u0001\u0005\"1aN\u0002a\u0001\u0003\u007f\u0001B\u0002\u00179\u0002B\u0005\u0015\u0013QGA\u001d\u0003\u0013\u00022aPA\"\t\u0015\teA1\u0001C!\ry\u0014q\t\u0003\u0006\u0019\u001a\u0011\rA\u0011\t\u0004\u007f\u0005-C!\u0002;\u0007\u0005\u0004\u0011\u0015\u0001E2p_.LWm]!t\u0011\u0016\fG-\u001a:t)\u0011\t\t&a\u001a\u0011\ra\f\u0019f^A,\u0013\r\t)F \u0002\u0004\u001b\u0006\u0004\b#BA-\u0003G:XBAA.\u0015\u0011\ti&a\u0018\u0002\u0013%lW.\u001e;bE2,'bAA1=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u00141\f\u0002\u0004'\u0016\f\bbBA5\u000f\u0001\u0007\u00111N\u0001\bG>|7.[3t!\u0019\tI&a\u0019\u0002nA\u0019!&a\u001c\n\u0007\u0005E4F\u0001\u0005X'\u000e{wn[5f\u00039\u0019X\r^%oaV$\b+\u0019:b[N,B!a\u001e\u0002\u0006R9\u0001+!\u001f\u0002\b\u0006\u001d\u0006bBA>\u0011\u0001\u0007\u0011QP\u0001\u0006S:\u0004X\u000f\u001e\t\u00061\u0006}\u00141Q\u0005\u0004\u0003\u0003;\"!D#oIB|\u0017N\u001c;J]B,H\u000fE\u0002@\u0003\u000b#Q\u0001\u0014\u0005C\u0002\tCq!!#\t\u0001\u0004\tY)\u0001\u0004qCJ\fWn\u001d\t\u0005\u0003\u001b\u000b\tK\u0004\u0003\u0002\u0010\u0006ue\u0002BAI\u00033sA!a%\u0002\u0018:\u0019a,!&\n\u0003iI!\u0001G\r\n\u0007\u0005mu#\u0001\u0005j]R,'O\\1m\u0013\r\u0019\u0017q\u0014\u0006\u0004\u00037;\u0012\u0002BAR\u0003K\u0013a\u0001U1sC6\u001c(bA2\u0002 \"1\u0011\u0011\u0016\u0005A\u0002A\u000b1A]3rQ\rA\u0011Q\u0016\t\u0005\u0003_\u000b),\u0004\u0002\u00022*\u0019\u00111\u0017\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u0006E&a\u0002;bS2\u0014XmY\u0001\u0010Q\u0006tG\r\\3J]B,H\u000fU1jeRY\u0001+!0\u0002L\u0006e\u00171\\As\u0011\u001d\ty,\u0003a\u0001\u0003\u0003\fA\u0001\\3giB\"\u00111YAd!\u0015A\u0016qPAc!\ry\u0014q\u0019\u0003\f\u0003\u0013\fi,!A\u0001\u0002\u000b\u0005!IA\u0002`IEBq!!4\n\u0001\u0004\ty-A\u0003sS\u001eDG\u000f\r\u0003\u0002R\u0006U\u0007#\u0002-\u0002\u0000\u0005M\u0007cA \u0002V\u0012Y\u0011q[Af\u0003\u0003\u0005\tQ!\u0001C\u0005\ryFE\r\u0005\b\u0003\u0013K\u0001\u0019AAF\u0011\u001d\ti.\u0003a\u0001\u0003?\fQa\u001d9mSR\u0004B!!$\u0002b&!\u00111]AS\u0005-\u0019\u0006\u000f\\5u!\u0006\u0014\u0018-\\:\t\r\u0005%\u0016\u00021\u0001Q\u00031A\u0017M\u001c3mK6\u000b\u0007\u000f]3e+\u0019\tY/!>\u0003\u0006QI\u0001+!<\u0002z\n%!1\u0002\u0005\b\u0003_T\u0001\u0019AAy\u0003\u0015!X\u000f\u001d7f!\u0015A\u0016qPAz!\ry\u0014Q\u001f\u0003\u0007\u0003oT!\u0019\u0001\"\u0003\u0005%K\u0005bBA~\u0015\u0001\u0007\u0011Q`\u0001\u0006G>$Wm\u0019\t\b1\u0006}(1AAz\u0013\r\u0011\ta\u0006\u0002\b\u001b\u0006\u0004\b/\u001b8h!\ry$Q\u0001\u0003\u0007\u0005\u000fQ!\u0019\u0001\"\u0003\u0003QCq!!#\u000b\u0001\u0004\tY\t\u0003\u0004\u0002**\u0001\r\u0001U\u0001\bg\u0016$(i\u001c3z+!\u0011\tBa\n\u0003\u001a\tMB#\u0003)\u0003\u0014\tm!\u0011\u0006B \u0011\u001d\u0011)b\u0003a\u0001\u0005/\t\u0011A\u001e\t\u0004\u007f\teAA\u0002B\u0004\u0017\t\u0007!\tC\u0004\u0003\u001e-\u0001\rAa\b\u0002\u0011\t|G-\u001f+za\u0016\u0004R\u0001\u0017B\u0011\u0005KI1Aa\t\u0018\u0005-\u0011\u0016m\u001e\"pIf$\u0016\u0010]3\u0011\u0007}\u00129\u0003B\u0003u\u0017\t\u0007!\tC\u0004\u0002|.\u0001\rAa\u000b\u0011\u0013a\u0013iC!\n\u0003\u0018\tE\u0012b\u0001B\u0018/\t)1i\u001c3fGB\u0019qHa\r\u0005\u000f\tU2B1\u0001\u00038\t\u00111IR\t\u0004\u0007\ne\u0002c\u0001-\u0003<%\u0019!QH\f\u0003\u0017\r{G-Z2G_Jl\u0017\r\u001e\u0005\u0007\u0003S[\u0001\u0019\u0001)\u0002!M,Go\u0015;sK\u0006l\u0017N\\4C_\u0012LX\u0003\u0002B#\u0005S\"BAa\u0012\u0003PQ)\u0001K!\u0013\u0003r!9!Q\u0003\u0007A\u0002\t-\u0003\u0003\u0002B'\u0005[r1a\u0010B(\u0011\u001d\u0011\t\u0006\u0004a\u0001\u0005'\nqa\u001d;sK\u0006l7\u000f\u0005\u0004\u0003V\t\u0005$q\r\b\u0005\u0005/\u0012iF\u0004\u0003\u0002\u0014\ne\u0013b\u0001B.3\u0005a1-\u00199bE&d\u0017\u000e^5fg&\u00191Ma\u0018\u000b\u0007\tm\u0013$\u0003\u0003\u0003d\t\u0015$aB*ue\u0016\fWn\u001d\u0006\u0004G\n}\u0003cA \u0003j\u00111!1\u000e\u0007C\u0002\t\u0013\u0011aU\u0005\u0005\u0005_\u0012\tG\u0001\u0007CS:\f'/_*ue\u0016\fW\u000e\u0003\u0004\u0002*2\u0001\r\u0001U\u0001\u000bO\u0016$xJ\u001d+ie><X\u0003\u0002B<\u0005w\"BA!\u001f\u0003~A\u0019qHa\u001f\u0005\r\t\u001dQB1\u0001C\u0011\u001d\u0011y(\u0004a\u0001\u0005\u0003\u000b!\u0001\u001a:\u0011\taK&\u0011P\u0001\u0013e\u0016\u001c\bo\u001c8tK\u001a\u0013x.\\(viB,H\u000f\u0006\u0003\u0003\b\n%\u0005\u0003B\u000f=)\u001aCqAa#\u000f\u0001\u0004\u0011i)A\u0002pkR\u0004DAa$\u0003\u0018B)\u0001L!%\u0003\u0016&\u0019!1S\f\u0003\u001d\u0015sG\r]8j]R|U\u000f\u001e9viB\u0019qHa&\u0005\u0017\te%\u0011RA\u0001\u0002\u0003\u0015\tA\u0011\u0002\u0004?\u0012\u001a\u0014\u0001\u00042pIfL5o\u0015;sK\u0006lW\u0003\u0002BP\u0005o#BA!)\u00032B)QDa)\u0003(&\u0019!Q\u0015\u0010\u0003\r=\u0003H/[8oa\u0011\u0011IK!,\u0011\r\tU#\u0011\rBV!\ry$Q\u0016\u0003\u000b\u0005_{\u0011\u0011!A\u0001\u0006\u0003\u0011%aA0%i!9!1R\bA\u0002\tM\u0006#\u0002-\u0003\u0012\nU\u0006cA \u00038\u0012)Aj\u0004b\u0001\u0005\u0006\u00112\r\\5f]R|U\u000f\u001e9viB\u000b'/Y7t+\t\u0011i\f\u0005\u0003\u0003@\n\u0005W\"A\u000b\n\u0007\t\rWC\u0001\nDY&,g\u000e^(viB,H\u000fU1sC6\u001c\u0018aE2mS\u0016tGoT;uaV$\b+\u0019:b[N\u0004\u0003")
public class EndpointToPlayClient {
    private final PlayClientOptions clientOptions;
    private final StandaloneWSClient ws;
    private final ClientOutputParams clientOutputParams;

    public <A, I, E, O, R> Function1<A, Function1<I, Tuple2<StandaloneWSRequest, Function1<StandaloneWSResponse, DecodeResult<Either<E, O>>>>>> toPlayRequest(Endpoint<A, I, E, O, R> e, String baseUri) {
        return (Function1 & Serializable & scala.Serializable)aParams -> (Function1 & Serializable & scala.Serializable)iParams -> {
            StandaloneWSRequest req0 = this.setInputParams(e.securityInput(), (package.Params)new package.ParamsAsAny(aParams), $this.ws.url(baseUri));
            StandaloneWSRequest req = this.setInputParams(e.input(), (package.Params)new package.ParamsAsAny(iParams), req0).withMethod(((Method)e.method().getOrElse((Function0 & Serializable & scala.Serializable)() -> new Method(Method$.MODULE$.GET()))).method());
            return new Tuple2((Object)req, (Function1 & Serializable & scala.Serializable)response -> this.responseParser$1((StandaloneWSResponse)response, e, req));
        };
    }

    public <A, I, E, O, R> Function1<A, Function1<I, Tuple2<StandaloneWSRequest, Function1<StandaloneWSResponse, Either<E, O>>>>> toPlayRequestThrowDecodeFailures(Endpoint<A, I, E, O, R> e, String baseUri) {
        return (Function1 & Serializable & scala.Serializable)aParams -> (Function1 & Serializable & scala.Serializable)iParams -> {
            Tuple2 tuple2 = (Tuple2)((Function1)this.toPlayRequest(e, baseUri).apply(aParams)).apply(iParams);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StandaloneWSRequest req = (StandaloneWSRequest)tuple2._1();
            Function1 responseParser = (Function1)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)req, (Object)responseParser);
            StandaloneWSRequest req2 = (StandaloneWSRequest)tuple22._1();
            Function1 responseParser2 = (Function1)tuple22._2();
            return new Tuple2((Object)req2, (Function1 & Serializable & scala.Serializable)response -> this.throwingResponseParser$1((StandaloneWSResponse)response, responseParser2));
        };
    }

    private <A, I, E, O, R> Function1<StandaloneWSResponse, DecodeResult<Either<E, O>>> parsePlayResponse(Endpoint<A, I, E, O, R> e) {
        return (Function1 & Serializable & scala.Serializable)response -> {
            int code = StatusCode$.MODULE$.apply(response.status());
            Function1<StandaloneWSResponse, Object> parser = StatusCode$.MODULE$.isSuccess$extension(code) ? this.responseFromOutput(e.output()) : this.responseFromOutput(e.errorOutput());
            EndpointOutput output = StatusCode$.MODULE$.isSuccess$extension(code) ? e.output() : e.errorOutput();
            Vector headers = ((TraversableOnce)this.cookiesAsHeaders((scala.collection.immutable.Seq<WSCookie>)response.cookies().toVector()).$plus$plus((GenTraversableOnce)response.headers()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Seq values = (Seq)tuple2._2();
                    return (Seq)values.map((Function1 & Serializable & scala.Serializable)v -> Header$.MODULE$.apply(name, v), scala.collection.Seq$.MODULE$.canBuildFrom());
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom())).toVector();
            ResponseMetadata meta = ResponseMetadata$.MODULE$.apply(code, response.statusText(), (scala.collection.immutable.Seq)headers);
            DecodeResult params = this.clientOutputParams().apply(output, parser.apply(response), meta);
            return params.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asAny()).map((Function1 & Serializable & scala.Serializable)p -> {
                if (StatusCode$.MODULE$.isSuccess$extension(code)) {
                    return package$.MODULE$.Right().apply(p);
                }
                return package$.MODULE$.Left().apply(p);
            });
        };
    }

    private Map<String, scala.collection.immutable.Seq<String>> cookiesAsHeaders(scala.collection.immutable.Seq<WSCookie> cookies) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Set-Cookie"), cookies.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(1).append(c.name()).append("=").append(c.value()).toString(), Seq$.MODULE$.canBuildFrom()))}));
    }

    private <I> StandaloneWSRequest setInputParams(EndpointInput<I> input, package.Params params, StandaloneWSRequest req) {
        EndpointIO.Body body;
        while (true) {
            EndpointIO.StreamBodyWrapper streamBodyWrapper;
            StreamBodyIO streamBodyIO;
            List list;
            EndpointIO.StreamBodyWrapper streamBodyWrapper2;
            StreamBodyIO streamBodyIO2;
            Right right;
            EndpointIO.StreamBodyWrapper streamBodyWrapper3;
            Either either;
            .colon.colon colon2;
            EndpointIO.OneOfBodyVariant oneOfBodyVariant;
            List list2;
            boolean bl = false;
            EndpointInput.Query query = null;
            boolean bl2 = false;
            EndpointIO.OneOfBody oneOfBody = null;
            body = input;
            if (body instanceof EndpointInput.FixedMethod) {
                EndpointInput.FixedMethod fixedMethod = (EndpointInput.FixedMethod)body;
                String m = fixedMethod.m();
                return req.withMethod(m);
            }
            if (body instanceof EndpointInput.FixedPath) {
                EndpointInput.FixedPath fixedPath = (EndpointInput.FixedPath)body;
                String p2 = fixedPath.s();
                return req.withUrl(new StringBuilder(1).append(req.url()).append("/").append(EndpointToPlayClient.encodePathSegment$1(p2)).toString());
            }
            if (body instanceof EndpointInput.PathCapture) {
                EndpointInput.PathCapture pathCapture = (EndpointInput.PathCapture)body;
                Codec codec = pathCapture.codec();
                String v = (String)codec.encode(EndpointToPlayClient.value$1(params));
                return req.withUrl(new StringBuilder(1).append(req.url()).append("/").append(EndpointToPlayClient.encodePathSegment$1(v)).toString());
            }
            if (body instanceof EndpointInput.PathsCapture) {
                EndpointInput.PathsCapture pathsCapture = (EndpointInput.PathsCapture)body;
                Codec codec = pathsCapture.codec();
                List ps = (List)codec.encode(EndpointToPlayClient.value$1(params));
                return req.withUrl(new StringBuilder(0).append(req.url()).append(((TraversableOnce)ps.map((Function1 & Serializable & scala.Serializable)p -> EndpointToPlayClient.encodePathSegment$1(p), List$.MODULE$.canBuildFrom())).mkString("/", "/", "")).toString());
            }
            if (body instanceof EndpointInput.Query) {
                bl = true;
                query = (EndpointInput.Query)body;
                String name = query.name();
                Option option = query.flagValue();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Object flagValue = some.value();
                    if (BoxesRunTime.equals((Object)EndpointToPlayClient.value$1(params), (Object)flagValue)) {
                        return req.addQueryStringParameters((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)"")}));
                    }
                }
            }
            if (bl) {
                String name = query.name();
                Codec codec = query.codec();
                StandaloneWSRequest req2 = (StandaloneWSRequest)((LinearSeqOptimized)codec.encode(EndpointToPlayClient.value$1(params))).foldLeft((Object)req, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 != null) {
                        StandaloneWSRequest r = (StandaloneWSRequest)tuple2._1();
                        String v = (String)tuple2._2();
                        return r.addQueryStringParameters((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)v)}));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return req2;
            }
            if (body instanceof EndpointInput.Cookie) {
                EndpointInput.Cookie cookie = (EndpointInput.Cookie)body;
                String name = cookie.name();
                Codec codec = cookie.codec();
                StandaloneWSRequest req2 = (StandaloneWSRequest)Option$.MODULE$.option2Iterable((Option)codec.encode(EndpointToPlayClient.value$1(params))).foldLeft((Object)req, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                    Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                    if (tuple2 != null) {
                        StandaloneWSRequest r = (StandaloneWSRequest)tuple2._1();
                        String v = (String)tuple2._2();
                        return r.addCookies((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WSCookie[]{new DefaultWSCookie(name, v, DefaultWSCookie$.MODULE$.apply$default$3(), DefaultWSCookie$.MODULE$.apply$default$4(), DefaultWSCookie$.MODULE$.apply$default$5(), DefaultWSCookie$.MODULE$.apply$default$6(), DefaultWSCookie$.MODULE$.apply$default$7())}));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return req2;
            }
            if (body instanceof EndpointInput.QueryParams) {
                EndpointInput.QueryParams queryParams = (EndpointInput.QueryParams)body;
                Codec codec = queryParams.codec();
                QueryParams mqp = (QueryParams)codec.encode(EndpointToPlayClient.value$1(params));
                return req.addQueryStringParameters(mqp.toSeq());
            }
            if (body instanceof EndpointIO.Empty) {
                return req;
            }
            if (body instanceof EndpointIO.Body) {
                EndpointIO.Body body2 = body;
                RawBodyType bodyType = body2.bodyType();
                Codec codec = body2.codec();
                StandaloneWSRequest req2 = this.setBody(EndpointToPlayClient.value$1(params), bodyType, codec, req);
                return req2;
            }
            if (body instanceof EndpointIO.OneOfBody) {
                Either either2;
                .colon.colon colon3;
                EndpointIO.OneOfBodyVariant oneOfBodyVariant2;
                bl2 = true;
                oneOfBody = (EndpointIO.OneOfBody)body;
                List list3 = oneOfBody.variants();
                if (list3 instanceof .colon.colon && (oneOfBodyVariant2 = (EndpointIO.OneOfBodyVariant)(colon3 = (.colon.colon)list3).head()) != null && (either2 = oneOfBodyVariant2.body()) instanceof Left) {
                    EndpointIO.Body body3;
                    Left left = (Left)either2;
                    input = body3 = (EndpointIO.Body)left.value();
                    continue;
                }
            }
            if (bl2 && (list2 = oneOfBody.variants()) instanceof .colon.colon && (oneOfBodyVariant = (EndpointIO.OneOfBodyVariant)(colon2 = (.colon.colon)list2).head()) != null && (either = oneOfBodyVariant.body()) instanceof Right && (streamBodyWrapper3 = (EndpointIO.StreamBodyWrapper)(right = (Right)either).value()) instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO2 = (streamBodyWrapper2 = streamBodyWrapper3).wrapped()) instanceof StreamBodyIO) {
                StreamBodyIO streamBodyIO3 = streamBodyIO2;
                package.Streams streams = streamBodyIO3.streams();
                return this.setStreamingBody(streams, EndpointToPlayClient.value$1(params), req);
            }
            if (bl2 && Nil$.MODULE$.equals(list = oneOfBody.variants())) {
                throw new RuntimeException("One of body without variants");
            }
            if (body instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = (EndpointIO.StreamBodyWrapper)body).wrapped()) instanceof StreamBodyIO) {
                StreamBodyIO streamBodyIO4 = streamBodyIO;
                package.Streams streams = streamBodyIO4.streams();
                return this.setStreamingBody(streams, EndpointToPlayClient.value$1(params), req);
            }
            if (body instanceof EndpointIO.Header) {
                EndpointIO.Header header = (EndpointIO.Header)body;
                String name = header.name();
                Codec codec = header.codec();
                StandaloneWSRequest req2 = (StandaloneWSRequest)((LinearSeqOptimized)codec.encode(EndpointToPlayClient.value$1(params))).foldLeft((Object)req, (Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                    Tuple2 tuple2 = new Tuple2(x0$3, x1$3);
                    if (tuple2 != null) {
                        StandaloneWSRequest r = (StandaloneWSRequest)tuple2._1();
                        String v = (String)tuple2._2();
                        return r.addHttpHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)v)}));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return req2;
            }
            if (body instanceof EndpointIO.Headers) {
                EndpointIO.Headers headers = (EndpointIO.Headers)body;
                Codec codec = headers.codec();
                List headers2 = (List)codec.encode(EndpointToPlayClient.value$1(params));
                StandaloneWSRequest req2 = (StandaloneWSRequest)headers2.foldLeft((Object)req, (Function2 & Serializable & scala.Serializable)(x0$4, x1$4) -> {
                    Tuple2 tuple2 = new Tuple2(x0$4, x1$4);
                    if (tuple2 != null) {
                        StandaloneWSRequest r = (StandaloneWSRequest)tuple2._1();
                        Header h = (Header)tuple2._2();
                        return r.addHttpHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)h.name()), (Object)h.value())}));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return req2;
            }
            if (body instanceof EndpointIO.FixedHeader) {
                EndpointIO.FixedHeader fixedHeader = (EndpointIO.FixedHeader)body;
                Header h = fixedHeader.h();
                StandaloneWSRequest req2 = req.addHttpHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)h.name()), (Object)h.value())}));
                return req2;
            }
            if (body instanceof EndpointInput.ExtractFromRequest) {
                return req;
            }
            if (!(body instanceof EndpointInput.Auth)) break;
            EndpointInput.Auth auth = (EndpointInput.Auth)body;
            input = auth.input();
        }
        if (body instanceof EndpointInput.Pair) {
            EndpointInput.Pair pair = (EndpointInput.Pair)body;
            EndpointInput left = pair.left();
            EndpointInput right = pair.right();
            Function1 split = pair.split$access$3();
            return this.handleInputPair(left, right, params, (Function1<package.Params, Tuple2<package.Params, package.Params>>)split, req);
        }
        if (body instanceof EndpointIO.Pair) {
            EndpointIO.Pair pair = (EndpointIO.Pair)body;
            EndpointIO left = pair.left();
            EndpointIO right = pair.right();
            Function1 split = pair.split$access$3();
            return this.handleInputPair((EndpointInput<?>)left, (EndpointInput<?>)right, params, (Function1<package.Params, Tuple2<package.Params, package.Params>>)split, req);
        }
        if (body instanceof EndpointInput.MappedPair) {
            EndpointInput.MappedPair mappedPair = (EndpointInput.MappedPair)body;
            EndpointInput.Pair wrapped = mappedPair.input();
            Mapping codec = mappedPair.mapping();
            return this.handleMapped((EndpointInput)wrapped, (Mapping)codec, params, req);
        }
        if (body instanceof EndpointIO.MappedPair) {
            EndpointIO.MappedPair mappedPair = (EndpointIO.MappedPair)body;
            EndpointIO.Pair wrapped = mappedPair.io();
            Mapping codec = mappedPair.mapping();
            return this.handleMapped((EndpointInput)wrapped, (Mapping)codec, params, req);
        }
        throw new MatchError((Object)body);
    }

    public StandaloneWSRequest handleInputPair(EndpointInput<?> left, EndpointInput<?> right, package.Params params, Function1<package.Params, Tuple2<package.Params, package.Params>> split, StandaloneWSRequest req) {
        Tuple2 tuple2 = (Tuple2)split.apply((Object)params);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        package.Params leftParams = (package.Params)tuple2._1();
        package.Params rightParams = (package.Params)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftParams, (Object)rightParams);
        package.Params leftParams2 = (package.Params)tuple22._1();
        package.Params rightParams2 = (package.Params)tuple22._2();
        StandaloneWSRequest req2 = this.setInputParams(left, leftParams2, req);
        return this.setInputParams(right, rightParams2, req2);
    }

    private <II, T> StandaloneWSRequest handleMapped(EndpointInput<II> tuple, Mapping<T, II> codec, package.Params params, StandaloneWSRequest req) {
        return this.setInputParams(tuple, (package.Params)new package.ParamsAsAny(codec.encode(params.asAny())), req);
    }

    private <R, T, CF extends CodecFormat> StandaloneWSRequest setBody(T v, RawBodyType<R> bodyType, Codec<R, T, CF> codec, StandaloneWSRequest req) {
        StandaloneWSRequest standaloneWSRequest;
        Object encoded = codec.encode(v);
        RawBodyType<R> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            BodyWritable defaultStringBodyWritable = (BodyWritable)Predef$.MODULE$.implicitly((Object)DefaultBodyWritables$.MODULE$.writeableOf_String());
            BodyWritable bodyWritable = BodyWritable$.MODULE$.apply(defaultStringBodyWritable.transform(), codec.format().mediaType().toString());
            standaloneWSRequest = req.withBody((Object)((String)encoded), bodyWritable);
        } else if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            standaloneWSRequest = req.withBody((Object)((byte[])encoded), DefaultBodyWritables$.MODULE$.writeableOf_ByteArray());
        } else if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            standaloneWSRequest = req.withBody((Object)((ByteBuffer)encoded), DefaultBodyWritables$.MODULE$.writeableOf_ByteBuffer());
        } else if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            Supplier<InputStream> inputStreamSupplier = () -> (InputStream)encoded;
            standaloneWSRequest = req.withBody(inputStreamSupplier, DefaultBodyWritables$.MODULE$.writableOf_InputStream());
        } else if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            Supplier<InputStream> inputStreamSupplier = new Supplier<InputStream>(null, encoded){
                private final Object encoded$1;

                public InputStream get() {
                    return (InputStream)((InputStreamRange)this.encoded$1).inputStream().apply();
                }
                {
                    this.encoded$1 = encoded$1;
                }
            };
            standaloneWSRequest = req.withBody((Object)inputStreamSupplier, DefaultBodyWritables$.MODULE$.writableOf_InputStream());
        } else if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            standaloneWSRequest = req.withBody((Object)((FileRange)encoded).file(), DefaultBodyWritables$.MODULE$.writableOf_File());
        } else {
            if (rawBodyType instanceof RawBodyType.MultipartBody) {
                throw new IllegalArgumentException("Multipart body aren't supported");
            }
            throw new MatchError(rawBodyType);
        }
        StandaloneWSRequest req2 = standaloneWSRequest;
        return req2;
    }

    private <S> StandaloneWSRequest setStreamingBody(package.Streams<S> streams, Object v, StandaloneWSRequest req) {
        package.Streams<S> streams2 = streams;
        Object object = v;
        package.Streams<S> streams3 = streams2;
        if (AkkaStreams$.MODULE$.equals(streams3)) {
            return req.withBody((Object)((Source)object), DefaultBodyWritables$.MODULE$.writableOf_Source());
        }
        throw new IllegalArgumentException("Only AkkaStreams streaming is supported");
    }

    private <T> T getOrThrow(DecodeResult<T> dr) {
        DecodeResult<T> decodeResult = dr;
        if (decodeResult instanceof DecodeResult.Value) {
            DecodeResult.Value value = (DecodeResult.Value)decodeResult;
            Object v = value.v();
            return (T)v;
        }
        if (decodeResult instanceof DecodeResult.Error) {
            DecodeResult.Error error = (DecodeResult.Error)decodeResult;
            Throwable e = error.error();
            throw e;
        }
        throw new IllegalArgumentException(new StringBuilder(15).append("Cannot decode: ").append(decodeResult).toString());
    }

    private Function1<StandaloneWSResponse, Object> responseFromOutput(EndpointOutput<?> out) {
        return (Function1 & Serializable & scala.Serializable)response -> {
            Option<package.Streams<?>> option = this.bodyIsStream(out);
            if (option instanceof Some) {
                Some some = (Some)option;
                package.Streams streams = (package.Streams)some.value();
                package.Streams streams2 = streams;
                if (AkkaStreams$.MODULE$.equals(streams2)) {
                    return response.body(DefaultBodyReadables$.MODULE$.readableAsSource());
                }
                throw new IllegalArgumentException("Only AkkaStreams streaming is supported");
            }
            if (None$.MODULE$.equals(option)) {
                return sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(out).bodyType().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    RawBodyType rawBodyType = x0$1;
                    if (rawBodyType instanceof RawBodyType.StringBody) {
                        return response.body();
                    }
                    if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
                        return response.body(DefaultBodyReadables$.MODULE$.readableAsByteArray());
                    }
                    if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
                        return response.body(DefaultBodyReadables$.MODULE$.readableAsByteBuffer());
                    }
                    if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
                        return new ByteArrayInputStream((byte[])response.body(DefaultBodyReadables$.MODULE$.readableAsByteArray()));
                    }
                    if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
                        return new InputStreamRange((Function0 & Serializable & scala.Serializable)() -> new ByteArrayInputStream((byte[])response.body(DefaultBodyReadables$.MODULE$.readableAsByteArray())), InputStreamRange$.MODULE$.apply$default$2());
                    }
                    if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
                        File f = (File)$this.clientOptions.createFile().apply();
                        OutputStream outputStream = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                        outputStream.write((byte[])response.body(DefaultBodyReadables$.MODULE$.readableAsByteArray()));
                        outputStream.close();
                        return new FileRange(f, FileRange$.MODULE$.apply$default$2());
                    }
                    if (rawBodyType instanceof RawBodyType.MultipartBody) {
                        throw new IllegalArgumentException("Multipart bodies aren't supported in responses");
                    }
                    throw new MatchError((Object)rawBodyType);
                }).getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
            }
            throw new MatchError(option);
        };
    }

    private <I> Option<package.Streams<?>> bodyIsStream(EndpointOutput<I> out) {
        return sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(out).traverseOutputs((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends EndpointOutput<?>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                EndpointIO.StreamBodyWrapper streamBodyWrapper;
                StreamBodyIO streamBodyIO;
                A1 A1 = x1;
                if (A1 instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = (EndpointIO.StreamBodyWrapper)A1).wrapped()) instanceof StreamBodyIO) {
                    StreamBodyIO streamBodyIO2 = streamBodyIO;
                    package.Streams streams = streamBodyIO2.streams();
                    return (B1)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.Streams[]{streams}));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(EndpointOutput<?> x1) {
                EndpointIO.StreamBodyWrapper streamBodyWrapper;
                StreamBodyIO streamBodyIO;
                EndpointOutput<?> endpointOutput = x1;
                return endpointOutput instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = (EndpointIO.StreamBodyWrapper)endpointOutput).wrapped()) instanceof StreamBodyIO;
            }
        }).headOption();
    }

    private ClientOutputParams clientOutputParams() {
        return this.clientOutputParams;
    }

    private final DecodeResult responseParser$1(StandaloneWSResponse response, Endpoint e$1, StandaloneWSRequest req$1) {
        DecodeResult decodeResult = (DecodeResult)this.parsePlayResponse(e$1).apply((Object)response);
        if (decodeResult instanceof DecodeResult.Error) {
            DecodeResult.Error error = (DecodeResult.Error)decodeResult;
            String o = error.original();
            Throwable e = error.error();
            return new DecodeResult.Error(o, (Throwable)new IllegalArgumentException(new StringBuilder(31).append("Cannot decode from: ").append(o).append(", request ").append(req$1.method()).append(" ").append(req$1.uri()).toString(), e));
        }
        return decodeResult;
    }

    private final Either throwingResponseParser$1(StandaloneWSResponse response, Function1 responseParser$2) {
        return (Either)this.getOrThrow((DecodeResult)responseParser$2.apply((Object)response));
    }

    private static final Object value$1(package.Params params$1) {
        return params$1.asAny();
    }

    private static final String encodePathSegment$1(String p) {
        return URLEncoder.encode(p, "UTF-8");
    }

    public EndpointToPlayClient(PlayClientOptions clientOptions, StandaloneWSClient ws) {
        this.clientOptions = clientOptions;
        this.ws = ws;
        this.clientOutputParams = new ClientOutputParams(null){

            public DecodeResult<Object> decodeWebSocketBody(WebSocketBodyOutput<?, ?, ?, ?, ?> o, Object body) {
                return new DecodeResult.Error("", (Throwable)new IllegalArgumentException("WebSocket aren't supported yet"));
            }
        };
    }
}

