/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.client.play;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Supplier;
import org.apache.pekko.stream.scaladsl.Source;
import play.api.libs.ws.BodyWritable;
import play.api.libs.ws.BodyWritable$;
import play.api.libs.ws.DefaultBodyReadables$;
import play.api.libs.ws.DefaultBodyWritables$;
import play.api.libs.ws.DefaultWSCookie$;
import play.api.libs.ws.StandaloneWSClient;
import play.api.libs.ws.StandaloneWSRequest;
import play.api.libs.ws.StandaloneWSResponse;
import play.api.libs.ws.WSCookie;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.capabilities.package;
import sttp.capabilities.pekko.PekkoStreams$;
import sttp.model.ContentTypeRange;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.QueryParams;
import sttp.model.ResponseMetadata;
import sttp.model.ResponseMetadata$;
import sttp.model.StatusCode$;
import sttp.tapir.Codec;
import sttp.tapir.CodecFormat;
import sttp.tapir.DecodeResult;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.EndpointOutput;
import sttp.tapir.FileRange;
import sttp.tapir.FileRange$;
import sttp.tapir.InputStreamRange;
import sttp.tapir.InputStreamRange$;
import sttp.tapir.Mapping;
import sttp.tapir.RawBodyType;
import sttp.tapir.StreamBodyIO;
import sttp.tapir.StreamBodyIO$;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.client.ClientOutputParams;
import sttp.tapir.client.play.PlayClientOptions;
import sttp.tapir.internal.package;

public class EndpointToPlayClient {
    private final PlayClientOptions clientOptions;
    private final StandaloneWSClient ws;
    private final ClientOutputParams clientOutputParams;

    public EndpointToPlayClient(PlayClientOptions clientOptions, StandaloneWSClient ws) {
        this.clientOptions = clientOptions;
        this.ws = ws;
        this.clientOutputParams = new ClientOutputParams(){

            public DecodeResult decodeWebSocketBody(WebSocketBodyOutput o, Object body) {
                return DecodeResult.Error$.MODULE$.apply("", (Throwable)new IllegalArgumentException("WebSocket aren't supported yet"));
            }
        };
    }

    public <A, I, E, O, R> Function1<A, Function1<I, Tuple2<StandaloneWSRequest, Function1<StandaloneWSResponse, DecodeResult<Either<E, O>>>>>> toPlayRequest(Endpoint<A, I, E, O, R> e, String baseUri) {
        return (Function1 & Serializable)aParams -> (Function1 & Serializable)iParams -> {
            StandaloneWSRequest req0 = this.setInputParams(e.securityInput(), (package.Params)package.ParamsAsAny$.MODULE$.apply(aParams), this.ws.url(baseUri));
            StandaloneWSRequest req = this.setInputParams(e.input(), (package.Params)package.ParamsAsAny$.MODULE$.apply(iParams), req0).withMethod(((Method)e.method().getOrElse((Function0 & Serializable)() -> new Method(EndpointToPlayClient.$anonfun$1()))).method());
            return Tuple2$.MODULE$.apply((Object)req, (Function1 & Serializable)response -> this.responseParser$3(e, req, (StandaloneWSResponse)response));
        };
    }

    public <A, I, E, O, R> Function1<A, Function1<I, Tuple2<StandaloneWSRequest, Function1<StandaloneWSResponse, Either<E, O>>>>> toPlayRequestThrowDecodeFailures(Endpoint<A, I, E, O, R> e, String baseUri) {
        return (Function1 & Serializable)aParams -> (Function1 & Serializable)iParams -> {
            Tuple2 tuple2 = (Tuple2)((Function1)this.toPlayRequest(e, baseUri).apply(aParams)).apply(iParams);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StandaloneWSRequest req = (StandaloneWSRequest)tuple2._1();
            Function1 responseParser = (Function1)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)req, (Object)responseParser);
            StandaloneWSRequest req2 = (StandaloneWSRequest)tuple22._1();
            Function1 responseParser2 = (Function1)tuple22._2();
            return Tuple2$.MODULE$.apply((Object)req2, (Function1 & Serializable)response -> this.throwingResponseParser$1(responseParser2, (StandaloneWSResponse)response));
        };
    }

    private <A, I, E, O, R> Function1<StandaloneWSResponse, DecodeResult<Either<E, O>>> parsePlayResponse(Endpoint<A, I, E, O, R> e) {
        return (Function1 & Serializable)response -> {
            int code = StatusCode$.MODULE$.apply(response.status());
            Function1<StandaloneWSResponse, Object> parser = StatusCode$.MODULE$.isSuccess$extension(code) ? this.responseFromOutput(e.output()) : this.responseFromOutput(e.errorOutput());
            EndpointOutput output = StatusCode$.MODULE$.isSuccess$extension(code) ? e.output() : e.errorOutput();
            Vector headers = ((IterableOnceOps)this.cookiesAsHeaders((scala.collection.immutable.Seq<WSCookie>)response.cookies().toVector()).$plus$plus((IterableOnce)response.headers()).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Seq values = (Seq)tuple2._2();
                    return (Seq)values.map((Function1 & Serializable)v -> Header$.MODULE$.apply(name, v));
                }
                throw new MatchError((Object)tuple2);
            })).toVector();
            ResponseMetadata meta = ResponseMetadata$.MODULE$.apply(code, response.statusText(), (scala.collection.immutable.Seq)headers);
            DecodeResult params = this.clientOutputParams.apply(output, parser.apply(response), meta);
            return params.map((Function1 & Serializable)_$1 -> _$1.asAny()).map((Function1 & Serializable)p -> {
                if (StatusCode$.MODULE$.isSuccess$extension(code)) {
                    return package$.MODULE$.Right().apply(p);
                }
                return package$.MODULE$.Left().apply(p);
            });
        };
    }

    private Map<String, scala.collection.immutable.Seq<String>> cookiesAsHeaders(scala.collection.immutable.Seq<WSCookie> cookies) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Set-Cookie");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, cookies.map((Function1 & Serializable)c -> new StringBuilder(1).append(c.name()).append("=").append(c.value()).toString()));
        return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private <I> StandaloneWSRequest setInputParams(EndpointInput<I> input, package.Params params, StandaloneWSRequest req) {
        EndpointInput.Single single;
        while (true) {
            EndpointIO.StreamBodyWrapper streamBodyWrapper;
            StreamBodyIO streamBodyIO;
            if ((single = input) instanceof EndpointInput.FixedMethod) {
                EndpointInput.FixedMethod fixedMethod = EndpointInput.FixedMethod$.MODULE$.unapply((EndpointInput.FixedMethod)single);
                String string = fixedMethod._1();
                Codec codec = fixedMethod._2();
                EndpointIO.Info info = fixedMethod._3();
                String m = string;
                return req.withMethod(m);
            }
            if (single instanceof EndpointInput.FixedPath) {
                EndpointInput.FixedPath fixedPath = EndpointInput.FixedPath$.MODULE$.unapply((EndpointInput.FixedPath)single);
                String string = fixedPath._1();
                Codec codec = fixedPath._2();
                EndpointIO.Info info = fixedPath._3();
                String p2 = string;
                return req.withUrl(new StringBuilder(1).append(req.url()).append("/").append(EndpointToPlayClient.encodePathSegment$1(p2)).toString());
            }
            if (single instanceof EndpointInput.PathCapture) {
                EndpointInput.PathCapture pathCapture = EndpointInput.PathCapture$.MODULE$.unapply((EndpointInput.PathCapture)single);
                Option option = pathCapture._1();
                Codec codec = pathCapture._2();
                EndpointIO.Info info = pathCapture._3();
                Codec codec2 = codec;
                String v = (String)codec2.encode(EndpointToPlayClient.value$1(params));
                return req.withUrl(new StringBuilder(1).append(req.url()).append("/").append(EndpointToPlayClient.encodePathSegment$1(v)).toString());
            }
            if (single instanceof EndpointInput.PathsCapture) {
                EndpointInput.PathsCapture pathsCapture = EndpointInput.PathsCapture$.MODULE$.unapply((EndpointInput.PathsCapture)single);
                Codec codec = pathsCapture._1();
                EndpointIO.Info info = pathsCapture._2();
                Codec codec3 = codec;
                List ps = (List)codec3.encode(EndpointToPlayClient.value$1(params));
                return req.withUrl(new StringBuilder(0).append(req.url()).append(ps.map((Function1 & Serializable)p -> EndpointToPlayClient.encodePathSegment$1(p)).mkString("/", "/", "")).toString());
            }
            if (single instanceof EndpointInput.Query) {
                EndpointInput.Query query = EndpointInput.Query$.MODULE$.unapply((EndpointInput.Query)single);
                String string = query._1();
                Option option = query._2();
                Codec codec = query._3();
                EndpointIO.Info info = query._4();
                String name = string;
                if (option instanceof Some) {
                    Object flagValue = ((Some)option).value();
                    if (BoxesRunTime.equals((Object)EndpointToPlayClient.value$1(params), (Object)flagValue)) {
                        Object[] objectArray = new Tuple2[1];
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"");
                        return req.addQueryStringParameters((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    }
                }
                String name2 = string;
                Codec codec4 = codec;
                StandaloneWSRequest req2 = (StandaloneWSRequest)((LinearSeqOps)codec4.encode(EndpointToPlayClient.value$1(params))).foldLeft((Object)req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        StandaloneWSRequest r = (StandaloneWSRequest)tuple2._1();
                        String v = (String)tuple2._2();
                        Object[] objectArray = new Tuple2[1];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name2);
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v);
                        return r.addQueryStringParameters((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return req2;
            }
            if (single instanceof EndpointInput.Cookie) {
                EndpointInput.Cookie cookie = EndpointInput.Cookie$.MODULE$.unapply((EndpointInput.Cookie)single);
                String string = cookie._1();
                Codec codec = cookie._2();
                EndpointIO.Info info = cookie._3();
                String name = string;
                Codec codec5 = codec;
                StandaloneWSRequest req2 = (StandaloneWSRequest)Option$.MODULE$.option2Iterable((Option)codec5.encode(EndpointToPlayClient.value$1(params))).foldLeft((Object)req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        StandaloneWSRequest r = (StandaloneWSRequest)tuple2._1();
                        String v = (String)tuple2._2();
                        return r.addCookies((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new WSCookie[]{DefaultWSCookie$.MODULE$.apply(name, v, DefaultWSCookie$.MODULE$.$lessinit$greater$default$3(), DefaultWSCookie$.MODULE$.$lessinit$greater$default$4(), DefaultWSCookie$.MODULE$.$lessinit$greater$default$5(), DefaultWSCookie$.MODULE$.$lessinit$greater$default$6(), DefaultWSCookie$.MODULE$.$lessinit$greater$default$7())}));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return req2;
            }
            if (single instanceof EndpointInput.QueryParams) {
                EndpointInput.QueryParams queryParams = EndpointInput.QueryParams$.MODULE$.unapply((EndpointInput.QueryParams)single);
                Codec codec = queryParams._1();
                EndpointIO.Info info = queryParams._2();
                Codec codec6 = codec;
                QueryParams mqp = (QueryParams)codec6.encode(EndpointToPlayClient.value$1(params));
                return req.addQueryStringParameters(mqp.toSeq());
            }
            if (single instanceof EndpointIO.Empty) {
                EndpointIO.Empty empty = EndpointIO.Empty$.MODULE$.unapply((EndpointIO.Empty)single);
                Codec codec = empty._1();
                EndpointIO.Info info = empty._2();
                return req;
            }
            if (single instanceof EndpointIO.Body) {
                EndpointIO.Body body = EndpointIO.Body$.MODULE$.unapply((EndpointIO.Body)single);
                RawBodyType rawBodyType = body._1();
                Codec codec = body._2();
                EndpointIO.Info info = body._3();
                RawBodyType bodyType = rawBodyType;
                Codec codec7 = codec;
                StandaloneWSRequest req2 = this.setBody(EndpointToPlayClient.value$1(params), bodyType, codec7, req);
                return req2;
            }
            if (single instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)single);
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                if (list instanceof .colon.colon) {
                    EndpointIO.OneOfBodyVariant oneOfBodyVariant = (EndpointIO.OneOfBodyVariant)((.colon.colon)list).head();
                    List list2 = ((.colon.colon)list).next$access$1();
                    if (oneOfBodyVariant != null) {
                        EndpointIO.OneOfBodyVariant oneOfBodyVariant2 = EndpointIO.OneOfBodyVariant$.MODULE$.unapply(oneOfBodyVariant);
                        ContentTypeRange contentTypeRange = oneOfBodyVariant2._1();
                        Either either = oneOfBodyVariant2._2();
                        if (either instanceof Left) {
                            EndpointIO.Body body = (EndpointIO.Body)((Left)either).value();
                            input = body;
                            continue;
                        }
                    }
                }
            }
            if (single instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)single);
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                if (list instanceof .colon.colon) {
                    EndpointIO.OneOfBodyVariant oneOfBodyVariant = (EndpointIO.OneOfBodyVariant)((.colon.colon)list).head();
                    List list3 = ((.colon.colon)list).next$access$1();
                    if (oneOfBodyVariant != null) {
                        EndpointIO.StreamBodyWrapper streamBodyWrapper2;
                        StreamBodyIO streamBodyIO2;
                        EndpointIO.StreamBodyWrapper streamBodyWrapper3;
                        EndpointIO.OneOfBodyVariant oneOfBodyVariant3 = EndpointIO.OneOfBodyVariant$.MODULE$.unapply(oneOfBodyVariant);
                        ContentTypeRange contentTypeRange = oneOfBodyVariant3._1();
                        Either either = oneOfBodyVariant3._2();
                        if (either instanceof Right && (streamBodyWrapper3 = (EndpointIO.StreamBodyWrapper)((Right)either).value()) instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO2 = (streamBodyWrapper2 = EndpointIO.StreamBodyWrapper$.MODULE$.unapply(streamBodyWrapper3))._1()) instanceof StreamBodyIO) {
                            StreamBodyIO streamBodyIO3 = StreamBodyIO$.MODULE$.unapply(streamBodyIO2);
                            package.Streams streams = streamBodyIO3._1();
                            Codec codec = streamBodyIO3._2();
                            EndpointIO.Info info = streamBodyIO3._3();
                            Option option = streamBodyIO3._4();
                            List list4 = streamBodyIO3._5();
                            package.Streams streams2 = streams;
                            return this.setStreamingBody(streams2, EndpointToPlayClient.value$1(params), req);
                        }
                    }
                }
            }
            if (single instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)single);
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list5 = list;
                if (!(nil$ != null ? !nil$.equals(list5) : list5 != null)) {
                    throw new RuntimeException("One of body without variants");
                }
            }
            if (single instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = EndpointIO.StreamBodyWrapper$.MODULE$.unapply((EndpointIO.StreamBodyWrapper)single))._1()) instanceof StreamBodyIO) {
                StreamBodyIO streamBodyIO4 = StreamBodyIO$.MODULE$.unapply(streamBodyIO);
                package.Streams streams = streamBodyIO4._1();
                Codec codec = streamBodyIO4._2();
                EndpointIO.Info info = streamBodyIO4._3();
                Option option = streamBodyIO4._4();
                List list = streamBodyIO4._5();
                package.Streams streams3 = streams;
                return this.setStreamingBody(streams3, EndpointToPlayClient.value$1(params), req);
            }
            if (single instanceof EndpointIO.Header) {
                EndpointIO.Header header = EndpointIO.Header$.MODULE$.unapply((EndpointIO.Header)single);
                String string = header._1();
                Codec codec = header._2();
                EndpointIO.Info info = header._3();
                String name = string;
                Codec codec8 = codec;
                StandaloneWSRequest req2 = (StandaloneWSRequest)((LinearSeqOps)codec8.encode(EndpointToPlayClient.value$1(params))).foldLeft((Object)req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        StandaloneWSRequest r = (StandaloneWSRequest)tuple2._1();
                        String v = (String)tuple2._2();
                        Object[] objectArray = new Tuple2[1];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v);
                        return r.addHttpHeaders((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return req2;
            }
            if (single instanceof EndpointIO.Headers) {
                EndpointIO.Headers headers = EndpointIO.Headers$.MODULE$.unapply((EndpointIO.Headers)single);
                Codec codec = headers._1();
                EndpointIO.Info info = headers._2();
                Codec codec9 = codec;
                List headers2 = (List)codec9.encode(EndpointToPlayClient.value$1(params));
                StandaloneWSRequest req2 = (StandaloneWSRequest)headers2.foldLeft((Object)req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        StandaloneWSRequest r = (StandaloneWSRequest)tuple2._1();
                        Header h = (Header)tuple2._2();
                        Object[] objectArray = new Tuple2[1];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)h.name());
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.value());
                        return r.addHttpHeaders((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return req2;
            }
            if (single instanceof EndpointIO.FixedHeader) {
                EndpointIO.FixedHeader fixedHeader = EndpointIO.FixedHeader$.MODULE$.unapply((EndpointIO.FixedHeader)single);
                Header header = fixedHeader._1();
                Codec codec = fixedHeader._2();
                EndpointIO.Info info = fixedHeader._3();
                Header h = header;
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)h.name());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.value());
                StandaloneWSRequest req2 = req.addHttpHeaders((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                return req2;
            }
            if (single instanceof EndpointInput.ExtractFromRequest) {
                EndpointInput.ExtractFromRequest extractFromRequest = EndpointInput.ExtractFromRequest$.MODULE$.unapply((EndpointInput.ExtractFromRequest)single);
                Codec codec = extractFromRequest._1();
                EndpointIO.Info info = extractFromRequest._2();
                return req;
            }
            if (!(single instanceof EndpointInput.Auth)) break;
            EndpointInput.Auth a = (EndpointInput.Auth)single;
            input = a.input();
        }
        if (single instanceof EndpointInput.Pair) {
            EndpointInput.Pair pair = EndpointInput.Pair$.MODULE$.unapply((EndpointInput.Pair)single);
            EndpointInput endpointInput = pair._1();
            EndpointInput endpointInput2 = pair._2();
            Function2 function2 = pair._3();
            Function1 function1 = pair._4();
            EndpointInput left = endpointInput;
            EndpointInput right = endpointInput2;
            Function1 split = function1;
            return this.handleInputPair(left, right, params, (Function1<package.Params, Tuple2<package.Params, package.Params>>)split, req);
        }
        if (single instanceof EndpointIO.Pair) {
            EndpointIO.Pair pair = EndpointIO.Pair$.MODULE$.unapply((EndpointIO.Pair)single);
            EndpointIO endpointIO = pair._1();
            EndpointIO endpointIO2 = pair._2();
            Function2 function2 = pair._3();
            Function1 function1 = pair._4();
            EndpointIO left = endpointIO;
            EndpointIO right = endpointIO2;
            Function1 split = function1;
            return this.handleInputPair((EndpointInput<?>)left, (EndpointInput<?>)right, params, (Function1<package.Params, Tuple2<package.Params, package.Params>>)split, req);
        }
        if (single instanceof EndpointInput.MappedPair) {
            EndpointInput.MappedPair mappedPair = EndpointInput.MappedPair$.MODULE$.unapply((EndpointInput.MappedPair)single);
            EndpointInput.Pair pair = mappedPair._1();
            Mapping mapping = mappedPair._2();
            EndpointInput.Pair wrapped = pair;
            Mapping codec = mapping;
            return this.handleMapped((EndpointInput)wrapped, codec, params, req);
        }
        if (single instanceof EndpointIO.MappedPair) {
            EndpointIO.MappedPair mappedPair = EndpointIO.MappedPair$.MODULE$.unapply((EndpointIO.MappedPair)single);
            EndpointIO.Pair pair = mappedPair._1();
            Mapping mapping = mappedPair._2();
            EndpointIO.Pair wrapped = pair;
            Mapping codec = mapping;
            return this.handleMapped((EndpointInput)wrapped, codec, params, req);
        }
        throw new MatchError((Object)single);
    }

    public StandaloneWSRequest handleInputPair(EndpointInput<?> left, EndpointInput<?> right, package.Params params, Function1<package.Params, Tuple2<package.Params, package.Params>> split, StandaloneWSRequest req) {
        Tuple2 tuple2 = (Tuple2)split.apply((Object)params);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        package.Params leftParams = (package.Params)tuple2._1();
        package.Params rightParams = (package.Params)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)leftParams, (Object)rightParams);
        package.Params leftParams2 = (package.Params)tuple22._1();
        package.Params rightParams2 = (package.Params)tuple22._2();
        StandaloneWSRequest req2 = this.setInputParams(left, leftParams2, req);
        return this.setInputParams(right, rightParams2, req2);
    }

    private <II, T> StandaloneWSRequest handleMapped(EndpointInput<II> tuple, Mapping<T, II> codec, package.Params params, StandaloneWSRequest req) {
        return this.setInputParams(tuple, (package.Params)package.ParamsAsAny$.MODULE$.apply(codec.encode(params.asAny())), req);
    }

    private <R, T, CF extends CodecFormat> StandaloneWSRequest setBody(T v, RawBodyType<R> bodyType, Codec<R, T, CF> codec, StandaloneWSRequest req) {
        StandaloneWSRequest standaloneWSRequest;
        Object encoded = codec.encode(v);
        RawBodyType<R> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset charset = stringBody._1();
            BodyWritable defaultStringBodyWritable = (BodyWritable)Predef$.MODULE$.implicitly((Object)DefaultBodyWritables$.MODULE$.writeableOf_String());
            BodyWritable bodyWritable = BodyWritable$.MODULE$.apply(defaultStringBodyWritable.transform(), codec.format().mediaType().toString());
            standaloneWSRequest = req.withBody((Object)((String)encoded), bodyWritable);
        } else if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            standaloneWSRequest = req.withBody((Object)((byte[])encoded), DefaultBodyWritables$.MODULE$.writeableOf_ByteArray());
        } else if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            standaloneWSRequest = req.withBody((Object)((ByteBuffer)encoded), DefaultBodyWritables$.MODULE$.writeableOf_ByteBuffer());
        } else if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            Supplier<InputStream> inputStreamSupplier = () -> (InputStream)encoded;
            standaloneWSRequest = req.withBody(inputStreamSupplier, DefaultBodyWritables$.MODULE$.writableOf_InputStream());
        } else if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            Supplier<InputStream> inputStreamSupplier = new Supplier<InputStream>(encoded){
                private final Object encoded$2;
                {
                    this.encoded$2 = encoded$3;
                }

                public InputStream get() {
                    return (InputStream)((InputStreamRange)this.encoded$2).inputStream().apply();
                }
            };
            standaloneWSRequest = req.withBody((Object)inputStreamSupplier, DefaultBodyWritables$.MODULE$.writableOf_InputStream());
        } else if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            standaloneWSRequest = req.withBody((Object)((FileRange)encoded).file(), DefaultBodyWritables$.MODULE$.writableOf_File());
        } else {
            if (rawBodyType instanceof RawBodyType.MultipartBody) {
                throw new IllegalArgumentException("Multipart body aren't supported");
            }
            throw new MatchError(rawBodyType);
        }
        StandaloneWSRequest req2 = standaloneWSRequest;
        return req2;
    }

    private <S> StandaloneWSRequest setStreamingBody(package.Streams<S> streams, Object v, StandaloneWSRequest req) {
        package.Streams<S> streams2 = streams;
        if (PekkoStreams$.MODULE$.equals(streams2)) {
            return req.withBody((Object)((Source)v), DefaultBodyWritables$.MODULE$.writableOf_Source());
        }
        throw new IllegalArgumentException("Only PekkoStreams streaming is supported");
    }

    private <T> T getOrThrow(DecodeResult<T> dr) {
        DecodeResult<T> decodeResult = dr;
        if (decodeResult instanceof DecodeResult.Value) {
            Object object;
            DecodeResult.Value value = DecodeResult.Value$.MODULE$.unapply((DecodeResult.Value)decodeResult);
            Object v = object = value._1();
            return (T)v;
        }
        if (decodeResult instanceof DecodeResult.Error) {
            Throwable throwable;
            DecodeResult.Error error = DecodeResult.Error$.MODULE$.unapply((DecodeResult.Error)decodeResult);
            String string = error._1();
            Throwable e = throwable = error._2();
            throw e;
        }
        DecodeResult<T> f = decodeResult;
        throw new IllegalArgumentException(new StringBuilder(15).append("Cannot decode: ").append(f).toString());
    }

    private Function1<StandaloneWSResponse, Object> responseFromOutput(EndpointOutput<?> out) {
        return (Function1 & Serializable)response -> {
            Option<package.Streams<?>> option = this.bodyIsStream(out);
            if (option instanceof Some) {
                package.Streams streams = (package.Streams)((Some)option).value();
                package.Streams streams2 = streams;
                if (PekkoStreams$.MODULE$.equals(streams2)) {
                    return (Source)response.body(DefaultBodyReadables$.MODULE$.readableAsSource());
                }
                throw new IllegalArgumentException("Only PekkoStreams streaming is supported");
            }
            if (None$.MODULE$.equals(option)) {
                return sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(out).bodyType().map((Function1 & Serializable)x$1 -> {
                    RawBodyType rawBodyType = x$1;
                    if (rawBodyType instanceof RawBodyType.StringBody) {
                        RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
                        Charset charset = stringBody._1();
                        return response.body();
                    }
                    if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
                        return response.body(DefaultBodyReadables$.MODULE$.readableAsByteArray());
                    }
                    if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
                        return response.body(DefaultBodyReadables$.MODULE$.readableAsByteBuffer());
                    }
                    if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
                        return new ByteArrayInputStream((byte[])response.body(DefaultBodyReadables$.MODULE$.readableAsByteArray()));
                    }
                    if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
                        return InputStreamRange$.MODULE$.apply((Function0 & Serializable)() -> new ByteArrayInputStream((byte[])response.body(DefaultBodyReadables$.MODULE$.readableAsByteArray())), InputStreamRange$.MODULE$.$lessinit$greater$default$2());
                    }
                    if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
                        File f = (File)this.clientOptions.createFile().apply();
                        OutputStream outputStream = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                        outputStream.write((byte[])response.body(DefaultBodyReadables$.MODULE$.readableAsByteArray()));
                        outputStream.close();
                        return FileRange$.MODULE$.apply(f, FileRange$.MODULE$.$lessinit$greater$default$2());
                    }
                    if (rawBodyType instanceof RawBodyType.MultipartBody) {
                        RawBodyType.MultipartBody multipartBody = RawBodyType.MultipartBody$.MODULE$.unapply((RawBodyType.MultipartBody)rawBodyType);
                        Map map = multipartBody._1();
                        Option option = multipartBody._2();
                        throw new IllegalArgumentException("Multipart bodies aren't supported in responses");
                    }
                    throw new MatchError((Object)rawBodyType);
                }).getOrElse(EndpointToPlayClient::responseFromOutput$$anonfun$1$$anonfun$2);
            }
            throw new MatchError(option);
        };
    }

    private <I> Option<package.Streams<?>> bodyIsStream(EndpointOutput<I> out) {
        return sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(out).traverseOutputs((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(EndpointOutput x) {
                EndpointIO.StreamBodyWrapper streamBodyWrapper;
                StreamBodyIO streamBodyIO;
                EndpointOutput endpointOutput = x;
                if (endpointOutput instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = EndpointIO.StreamBodyWrapper$.MODULE$.unapply((EndpointIO.StreamBodyWrapper)endpointOutput))._1()) instanceof StreamBodyIO) {
                    StreamBodyIO streamBodyIO2 = StreamBodyIO$.MODULE$.unapply(streamBodyIO);
                    package.Streams streams = streamBodyIO2._1();
                    Codec codec = streamBodyIO2._2();
                    EndpointIO.Info info = streamBodyIO2._3();
                    Option option = streamBodyIO2._4();
                    List list = streamBodyIO2._5();
                    package.Streams streams2 = streams;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(EndpointOutput x, Function1 function1) {
                EndpointIO.StreamBodyWrapper streamBodyWrapper;
                StreamBodyIO streamBodyIO;
                EndpointOutput endpointOutput = x;
                if (endpointOutput instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = EndpointIO.StreamBodyWrapper$.MODULE$.unapply((EndpointIO.StreamBodyWrapper)endpointOutput))._1()) instanceof StreamBodyIO) {
                    StreamBodyIO streamBodyIO2 = StreamBodyIO$.MODULE$.unapply(streamBodyIO);
                    package.Streams streams = streamBodyIO2._1();
                    Codec codec = streamBodyIO2._2();
                    EndpointIO.Info info = streamBodyIO2._3();
                    Option option = streamBodyIO2._4();
                    List list = streamBodyIO2._5();
                    package.Streams streams2 = streams;
                    return (Vector)package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.Streams[]{streams2}));
                }
                return function1.apply((Object)x);
            }
        }).headOption();
    }

    private static final String $anonfun$1() {
        return Method$.MODULE$.GET();
    }

    private final DecodeResult responseParser$3(Endpoint e$3, StandaloneWSRequest req$1, StandaloneWSResponse response) {
        DecodeResult decodeResult = (DecodeResult)this.parsePlayResponse(e$3).apply((Object)response);
        if (decodeResult instanceof DecodeResult.Error) {
            DecodeResult.Error error = DecodeResult.Error$.MODULE$.unapply((DecodeResult.Error)decodeResult);
            String string = error._1();
            Throwable throwable = error._2();
            String o = string;
            Throwable e = throwable;
            return DecodeResult.Error$.MODULE$.apply(o, (Throwable)new IllegalArgumentException(new StringBuilder(31).append("Cannot decode from: ").append(o).append(", request ").append(req$1.method()).append(" ").append(req$1.uri()).toString(), e));
        }
        DecodeResult other = decodeResult;
        return other;
    }

    private final Either throwingResponseParser$1(Function1 responseParser$1, StandaloneWSResponse response) {
        return (Either)this.getOrThrow((DecodeResult)responseParser$1.apply((Object)response));
    }

    private static final Object value$1(package.Params params$1) {
        return params$1.asAny();
    }

    private static final String encodePathSegment$1(String p) {
        return URLEncoder.encode(p, "UTF-8");
    }

    private static final Object responseFromOutput$$anonfun$1$$anonfun$2() {
        return BoxedUnit.UNIT;
    }
}

