/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.play;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.libs.Files;
import play.api.libs.streams.Accumulator;
import play.api.mvc.BodyParser;
import play.api.mvc.MultipartFormData;
import play.api.mvc.PlayBodyParsers;
import play.api.mvc.Request;
import play.api.mvc.Result;
import play.core.parsers.Multipart;
import play.core.parsers.Multipart$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.capabilities.pekko.PekkoStreams;
import sttp.capabilities.pekko.PekkoStreams$;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.MediaType$;
import sttp.model.Part;
import sttp.model.Part$;
import sttp.tapir.FileRange;
import sttp.tapir.FileRange$;
import sttp.tapir.InputStreamRange;
import sttp.tapir.InputStreamRange$;
import sttp.tapir.RawBodyType;
import sttp.tapir.model.ServerRequest;
import sttp.tapir.server.interpreter.RawValue;
import sttp.tapir.server.interpreter.RawValue$;
import sttp.tapir.server.interpreter.RequestBody;
import sttp.tapir.server.play.PlayBodyParserException;
import sttp.tapir.server.play.PlayServerOptions;

public class PlayRequestBody
implements RequestBody<Future, PekkoStreams> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PlayRequestBody.class.getDeclaredField("filePartHandler$lzy1"));
    private final PlayServerOptions serverOptions;
    private final Materializer mat;
    private final PekkoStreams streams;
    private final PlayBodyParsers parsers;
    private volatile Object filePartHandler$lzy1;

    public PlayRequestBody(PlayServerOptions serverOptions, Materializer mat) {
        this.serverOptions = serverOptions;
        this.mat = mat;
        this.streams = PekkoStreams$.MODULE$;
        this.parsers = serverOptions.playBodyParsers();
    }

    public PekkoStreams streams() {
        return this.streams;
    }

    private Function1<Multipart.FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<Files.TemporaryFile>>> filePartHandler() {
        Object object = this.filePartHandler$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.filePartHandler$lzyINIT1();
    }

    private Object filePartHandler$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.filePartHandler$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Function1 function1 = null;
                    try {
                        function1 = Multipart$.MODULE$.handleFilePartAsTemporaryFile(this.serverOptions.temporaryFileCreator());
                        object2 = function1 == null ? LazyVals.NullValue$.MODULE$ : function1;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.filePartHandler$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return function1;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public <R> Future<RawValue<R>> toRaw(ServerRequest serverRequest, RawBodyType<R> bodyType, Option<Object> maxBytes) {
        Request<Source<ByteString, Object>> request = this.playRequest(serverRequest);
        Option charset = request.charset().map((Function1 & Serializable)x$0 -> Charset.forName(x$0));
        return this.toRaw(request, bodyType, (Option<Charset>)charset, (Function0<Source<ByteString, Object>>)(Function0 & Serializable)() -> (Source)request.body(), (Option<File>)None$.MODULE$, maxBytes, this.mat, (ExecutionContext)this.mat.executionContext());
    }

    public Source<ByteString, Object> toStream(ServerRequest serverRequest, Option<Object> maxBytes) {
        Source stream = (Source)this.playRequest(serverRequest).body();
        return (Source)maxBytes.map((Function1 & Serializable)_$1 -> PekkoStreams$.MODULE$.limitBytes(stream, BoxesRunTime.unboxToLong((Object)_$1))).getOrElse(() -> PlayRequestBody.toStream$$anonfun$2(stream));
    }

    private <R> Future<RawValue<R>> toRaw(Request<Source<ByteString, Object>> request, RawBodyType<R> bodyType, Option<Charset> charset, Function0<Source<ByteString, Object>> body, Option<File> bodyAsFile, Option<Object> maxBytes, Materializer mat, ExecutionContext ec) {
        RawBodyType<R> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            Charset charset2;
            RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset defaultCharset = charset2 = stringBody._1();
            return this.bodyAsByteString$1(maxBytes, request, body, mat, ec).map((Function1 & Serializable)b -> RawValue$.MODULE$.apply((Object)b.decodeString((Charset)charset.getOrElse(() -> PlayRequestBody.toRaw$$anonfun$2$$anonfun$1(defaultCharset))), RawValue$.MODULE$.$lessinit$greater$default$2()), ec);
        }
        if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            return this.bodyAsByteString$1(maxBytes, request, body, mat, ec).map((Function1 & Serializable)b -> RawValue$.MODULE$.apply(b.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), RawValue$.MODULE$.$lessinit$greater$default$2()), ec);
        }
        if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            return this.bodyAsByteString$1(maxBytes, request, body, mat, ec).map((Function1 & Serializable)b -> RawValue$.MODULE$.apply((Object)b.toByteBuffer(), RawValue$.MODULE$.$lessinit$greater$default$2()), ec);
        }
        if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            return this.bodyAsByteString$1(maxBytes, request, body, mat, ec).map((Function1 & Serializable)b -> RawValue$.MODULE$.apply((Object)new ByteArrayInputStream((byte[])b.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))), RawValue$.MODULE$.$lessinit$greater$default$2()), ec);
        }
        if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            return this.bodyAsByteString$1(maxBytes, request, body, mat, ec).map((Function1 & Serializable)b -> RawValue$.MODULE$.apply((Object)new InputStreamRange((Function0 & Serializable)() -> new ByteArrayInputStream((byte[])b.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))), InputStreamRange$.MODULE$.$lessinit$greater$default$2()), RawValue$.MODULE$.$lessinit$greater$default$2()), ec);
        }
        if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            Option<File> option = bodyAsFile;
            if (option instanceof Some) {
                File file = (File)((Some)option).value();
                FileRange tapirFile = FileRange$.MODULE$.apply(file, FileRange$.MODULE$.$lessinit$greater$default$2());
                return Future$.MODULE$.successful((Object)RawValue$.MODULE$.apply((Object)tapirFile, (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FileRange[]{tapirFile}))));
            }
            if (None$.MODULE$.equals(option)) {
                FileRange file = FileRange$.MODULE$.apply(Files.TemporaryFile$.MODULE$.temporaryFileToPath(this.serverOptions.temporaryFileCreator().create(this.serverOptions.temporaryFileCreator().create$default$1(), this.serverOptions.temporaryFileCreator().create$default$2())).toFile(), FileRange$.MODULE$.$lessinit$greater$default$2());
                return ((Accumulator)((Function1)maxBytes.map((Function1 & Serializable)_$3 -> this.toRaw$$anonfun$7(file, BoxesRunTime.unboxToLong((Object)_$3))).getOrElse(() -> this.toRaw$$anonfun$8(file))).apply(request)).run((Source)body.apply(), mat).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        Result result = (Result)((Left)either).value();
                        return Future$.MODULE$.failed((Throwable)new PlayBodyParserException(result));
                    }
                    if (either instanceof Right) {
                        return Future$.MODULE$.successful((Object)RawValue$.MODULE$.apply((Object)file, (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FileRange[]{file}))));
                    }
                    throw new MatchError((Object)either);
                }, ec);
            }
            throw new MatchError(option);
        }
        if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody m = (RawBodyType.MultipartBody)rawBodyType;
            return this.multiPartRequestToRawBody(request, m, body, maxBytes, mat, ec);
        }
        throw new MatchError(rawBodyType);
    }

    private Future<RawValue<scala.collection.immutable.Seq<Part<?>>>> multiPartRequestToRawBody(Request<Source<ByteString, Object>> request, RawBodyType.MultipartBody m, Function0<Source<ByteString, Object>> body, Option<Object> maxBytes, Materializer mat, ExecutionContext ec) {
        BodyParser bodyParser = (BodyParser)maxBytes.map((Function1 & Serializable)_$4 -> this.$anonfun$2(BoxesRunTime.unboxToLong((Object)_$4))).getOrElse(this::$anonfun$3);
        return ((Accumulator)bodyParser.apply(request)).run((Source)body.apply(), mat).flatMap((Function1 & Serializable)x$12 -> {
            Either either = x$12;
            if (either instanceof Left) {
                Result r = (Result)((Left)either).value();
                return Future$.MODULE$.failed((Throwable)new PlayBodyParserException(r));
            }
            if (either instanceof Right) {
                MultipartFormData value = (MultipartFormData)((Right)either).value();
                scala.collection.immutable.Seq dataParts = ((IterableOnceOps)value.dataParts().flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)tuple2._2();
                        String key = (String)tuple2._1();
                        if (seq instanceof Seq) {
                            scala.collection.immutable.Seq value = seq;
                            return m.partType(key).map((Function1 & Serializable)partType -> {
                                scala.collection.immutable.Seq data = (scala.collection.immutable.Seq)((IterableOnceOps)value.map((Function1 & Serializable)string -> ByteString$.MODULE$.apply(string))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
                                Header contentLength = Header$.MODULE$.contentLength(BoxesRunTime.unboxToLong((Object)((IterableOnceOps)data.map((Function1 & Serializable)_$5 -> _$5.length())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                                Object[] objectArray = new Tuple2[1];
                                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)contentLength.name());
                                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)contentLength.value());
                                return this.toRaw((Request<Source<ByteString, Object>>)request.withHeaders(request.headers().replace((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), (RawBodyType)partType, (Option<Charset>)sttp.tapir.internal.package$.MODULE$.charset(partType), (Function0<Source<ByteString, Object>>)(Function0 & Serializable)() -> Source$.MODULE$.apply((Iterable)data), (Option<File>)None$.MODULE$, (Option<Object>)None$.MODULE$, mat, ec).map((Function1 & Serializable)body -> Some$.MODULE$.apply((Object)Part$.MODULE$.apply(key, body.value(), Part$.MODULE$.apply$default$3(), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6())), ec);
                            });
                        }
                    }
                    throw new MatchError((Object)tuple2);
                })).toSeq();
                scala.collection.immutable.Seq fileParts = (scala.collection.immutable.Seq)value.files().map((Function1 & Serializable)f -> (Future)m.partType(f.key()).map((Function1 & Serializable)partType -> this.toRaw(request, (RawBodyType)partType, (Option<Charset>)sttp.tapir.internal.package$.MODULE$.charset(partType), (Function0<Source<ByteString, Object>>)(Function0 & Serializable)() -> FileIO$.MODULE$.fromPath(((Files.TemporaryFile)f.ref()).path(), FileIO$.MODULE$.fromPath$default$2()), (Option<File>)Some$.MODULE$.apply((Object)Files.TemporaryFile$.MODULE$.temporaryFileToPath((Files.TemporaryFile)f.ref()).toFile()), (Option<Object>)None$.MODULE$, mat, ec).map((Function1 & Serializable)body -> {
                    Object[] objectArray = new Tuple2[2];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)f.key());
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)f.dispositionType());
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)Part$.MODULE$.FileNameDispositionParam());
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)f.filename());
                    return Some$.MODULE$.apply((Object)Part$.MODULE$.apply(f.key(), body.value(), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (scala.collection.immutable.Seq)f.contentType().flatMap((Function1 & Serializable)_$6 -> MediaType$.MODULE$.parse(_$6).toOption()).map((Function1 & Serializable)mediaType -> Header$.MODULE$.contentType(mediaType)).toList()));
                }, ec)).getOrElse(() -> this.$anonfun$7$$anonfun$2(f, ec)));
                return Future$.MODULE$.sequence((IterableOnce)dataParts.$plus$plus((IterableOnce)fileParts), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)ps -> (scala.collection.immutable.Seq)ps.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Option x) {
                        Option option = x;
                        if (option instanceof Some) {
                            Part p = (Part)((Some)option).value();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Option x, Function1 function1) {
                        Option option = x;
                        if (option instanceof Some) {
                            Part p = (Part)((Some)option).value();
                            return p;
                        }
                        return function1.apply((Object)x);
                    }
                }), ec).map((Function1 & Serializable)parts -> RawValue$.MODULE$.fromParts(parts), ec);
            }
            throw new MatchError((Object)either);
        }, ec);
    }

    private Request<Source<ByteString, Object>> playRequest(ServerRequest serverRequest) {
        return (Request)serverRequest.underlying();
    }

    private static final Source toStream$$anonfun$2(Source stream$2) {
        return stream$2;
    }

    private final /* synthetic */ BodyParser bodyAsByteString$1$$anonfun$1(long _$2) {
        return this.parsers.byteString(_$2);
    }

    private final BodyParser bodyAsByteString$1$$anonfun$2() {
        return this.parsers.byteString();
    }

    private final Future bodyAsByteString$1(Option maxBytes$1, Request request$2, Function0 body$1, Materializer mat$1, ExecutionContext ec$1) {
        return ((Accumulator)((Function1)maxBytes$1.map((Function1 & Serializable)_$2 -> this.bodyAsByteString$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)_$2))).getOrElse(this::bodyAsByteString$1$$anonfun$2)).apply((Object)request$2)).run((Source)body$1.apply(), mat$1).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Result result = (Result)((Left)either).value();
                return Future$.MODULE$.failed((Throwable)new PlayBodyParserException(result));
            }
            if (either instanceof Right) {
                ByteString value = (ByteString)((Right)either).value();
                return Future$.MODULE$.successful((Object)value);
            }
            throw new MatchError((Object)either);
        }, ec$1);
    }

    private static final Charset toRaw$$anonfun$2$$anonfun$1(Charset defaultCharset$2) {
        return defaultCharset$2;
    }

    private final /* synthetic */ BodyParser toRaw$$anonfun$7(FileRange file$1, long _$3) {
        return this.parsers.file(file$1.file(), _$3);
    }

    private final BodyParser toRaw$$anonfun$8(FileRange file$2) {
        return this.parsers.file(file$2.file());
    }

    private final /* synthetic */ BodyParser $anonfun$2(long _$4) {
        return this.parsers.multipartFormData(this.filePartHandler(), _$4);
    }

    private final BodyParser $anonfun$3() {
        return this.parsers.multipartFormData(this.filePartHandler(), this.parsers.multipartFormData$default$2(), this.parsers.multipartFormData$default$3());
    }

    private final Future $anonfun$7$$anonfun$2(MultipartFormData.FilePart f$4, ExecutionContext ec$7) {
        return ((Future)this.serverOptions.deleteFile().apply((Object)Files.TemporaryFile$.MODULE$.temporaryFileToPath((Files.TemporaryFile)f$4.ref()).toFile())).map((Function1 & Serializable)_$7 -> Option$.MODULE$.empty(), ec$7);
    }
}

