/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.play;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.pekko.NotUsed;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.StreamConverters$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.http.HeaderNames$;
import play.api.http.HttpChunk;
import play.api.http.HttpEntity;
import play.api.http.websocket.Message;
import play.api.mvc.Codec$;
import play.api.mvc.MultipartFormData;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Random$;
import sttp.capabilities.pekko.PekkoStreams;
import sttp.capabilities.pekko.PekkoStreams$;
import sttp.model.HasHeaders;
import sttp.model.MediaType;
import sttp.model.Part;
import sttp.tapir.CodecFormat;
import sttp.tapir.FileRange;
import sttp.tapir.InputStreamRange;
import sttp.tapir.RawBodyType;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.server.interpreter.ToResponseBody;
import sttp.tapir.server.play.PlayWebSockets$;

public class PlayToResponseBody
implements ToResponseBody<Either<Flow<Message, Message, Object>, HttpEntity>, PekkoStreams> {
    private final PekkoStreams streams = PekkoStreams$.MODULE$;
    private final int ChunkSize;

    public PlayToResponseBody() {
        this.ChunkSize = 8192;
    }

    public PekkoStreams streams() {
        return this.streams;
    }

    public <R> Either<Flow<Message, Message, Object>, HttpEntity> fromRawValue(R v, HasHeaders headers, CodecFormat format, RawBodyType<R> bodyType) {
        return package$.MODULE$.Right().apply((Object)this.fromRawValue(v, headers, bodyType));
    }

    private <R> HttpEntity fromRawValue(R v, HasHeaders headers, RawBodyType<R> bodyType) {
        Option contentType = headers.contentType();
        RawBodyType<R> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            Charset charset;
            RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset charset2 = charset = stringBody._1();
            String str = (String)v;
            return HttpEntity.Strict$.MODULE$.apply(ByteString$.MODULE$.apply(str, charset2), contentType);
        }
        if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            byte[] bytes = (byte[])v;
            return HttpEntity.Strict$.MODULE$.apply(ByteString$.MODULE$.apply(bytes), contentType);
        }
        if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            ByteBuffer byteBuffer = (ByteBuffer)v;
            return HttpEntity.Strict$.MODULE$.apply(ByteString$.MODULE$.apply(byteBuffer), contentType);
        }
        if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            return this.streamOrChunk((Source<ByteString, Object>)StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> (InputStream)v, StreamConverters$.MODULE$.fromInputStream$default$2()), (Option<Object>)headers.contentLength(), (Option<String>)contentType);
        }
        if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            Source initialStream = StreamConverters$.MODULE$.fromInputStream(((InputStreamRange)v).inputStreamFromRangeStart(), this.ChunkSize);
            return (HttpEntity)((InputStreamRange)v).range().map((Function1 & Serializable)r -> this.streamOrChunk(this.toRangedStream((Source<ByteString, Object>)initialStream, r.contentLength()), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)r.contentLength())), (Option<String>)contentType)).getOrElse(() -> this.fromRawValue$$anonfun$3(initialStream, headers, contentType));
        }
        if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            return (HttpEntity)((FileRange)v).range().flatMap((Function1 & Serializable)r -> r.startAndEnd().map((Function1 & Serializable)s -> this.streamOrChunk(this.createFileSource((FileRange)v, s._1$mcJ$sp(), r.contentLength()), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)r.contentLength())), (Option<String>)contentType))).getOrElse(() -> this.fromRawValue$$anonfun$5(v, contentType));
        }
        if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody m = (RawBodyType.MultipartBody)rawBodyType;
            Seq rawParts = (Seq)v;
            Seq dataParts = (Seq)((IterableOps)rawParts.filter((Function1 & Serializable)part -> m.partType(part.name()).exists((Function1 & Serializable)x$1 -> {
                RawBodyType rawBodyType = x$1;
                if (rawBodyType instanceof RawBodyType.StringBody) {
                    RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
                    Charset charset = stringBody._1();
                    return true;
                }
                if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
                    return true;
                }
                return RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType);
            }))).flatMap((Function1 & Serializable)_$1 -> this.rawPartsToDataPart(m, (Part)_$1));
            Seq fileParts = (Seq)((IterableOps)rawParts.filter((Function1 & Serializable)part -> m.partType(part.name()).exists((Function1 & Serializable)x$1 -> {
                RawBodyType rawBodyType = x$1;
                if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
                    return true;
                }
                return RawBodyType.FileBody$.MODULE$.equals(rawBodyType);
            }))).flatMap((Function1 & Serializable)_$2 -> this.rawPartsToFilePart(m, (Part)_$2));
            return HttpEntity.Streamed$.MODULE$.apply(this.multipartFormToStream((Seq<MultipartFormData.DataPart>)dataParts, fileParts), (Option)None$.MODULE$, contentType);
        }
        throw new MatchError(rawBodyType);
    }

    private Source<ByteString, Object> createFileSource(FileRange tapirFile, long start, long bytesTotal) {
        return this.toRangedStream((Source<ByteString, Object>)FileIO$.MODULE$.fromPath(tapirFile.file().toPath(), this.ChunkSize, start), bytesTotal);
    }

    private Source<ByteString, Object> toRangedStream(Source<ByteString, Object> initialStream, long bytesTotal) {
        return (Source)initialStream.scan((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L), (Object)ByteString$.MODULE$.empty()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                long bytesConsumed = BoxesRunTime.unboxToLong((Object)tuple2._1());
                ByteString next = (ByteString)tuple22._2();
                int bytesInNext = next.length();
                long bytesFromNext = Math.max(0L, Math.min(bytesTotal - bytesConsumed, (long)bytesInNext));
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(bytesConsumed + (long)bytesInNext)), (Object)next.take((int)bytesFromNext));
            }
            throw new MatchError((Object)tuple22);
        }).takeWhile((Function1 & Serializable)_$3 -> BoxesRunTime.unboxToLong((Object)_$3._1()) < bytesTotal, true).map((Function1 & Serializable)_$4 -> (ByteString)_$4._2());
    }

    public Either<Flow<Message, Message, Object>, HttpEntity> fromStreamValue(Source<ByteString, Object> v, HasHeaders headers, CodecFormat format, Option<Charset> charset) {
        return package$.MODULE$.Right().apply((Object)this.streamOrChunk(v, (Option<Object>)headers.contentLength(), (Option<String>)Option$.MODULE$.apply(headers.contentType().getOrElse(() -> this.fromStreamValue$$anonfun$1(format, charset)))));
    }

    private HttpEntity streamOrChunk(Source<ByteString, Object> stream, Option<Object> contentLength, Option<String> contentType) {
        HttpEntity.Streamed streamed;
        Option<Object> option = contentLength;
        if (option instanceof Some) {
            long length = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            streamed = HttpEntity.Streamed$.MODULE$.apply(stream, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)length)), contentType);
        } else if (None$.MODULE$.equals(option)) {
            Source chunkStream = (Source)stream.map((Function1 & Serializable)data -> HttpChunk.Chunk$.MODULE$.apply(data));
            streamed = HttpEntity.Chunked$.MODULE$.apply(chunkStream, contentType);
        } else {
            throw new MatchError(option);
        }
        return (HttpEntity)streamed;
    }

    public <REQ, RESP> Either<Flow<Message, Message, Object>, HttpEntity> fromWebSocketPipe(Flow<REQ, RESP, Object> pipe, WebSocketBodyOutput<Flow<REQ, RESP, Object>, REQ, RESP, ?, PekkoStreams> o) {
        return package$.MODULE$.Left().apply(PlayWebSockets$.MODULE$.pipeToBody(pipe, o));
    }

    private <T> Option<MultipartFormData.FilePart<Source<ByteString, ?>>> rawPartsToFilePart(RawBodyType.MultipartBody m, Part<T> part) {
        return m.partType(part.name()).flatMap((Function1 & Serializable)partType -> {
            HttpEntity entity = this.fromRawValue((Object)part.body(), (HasHeaders)part, (RawBodyType)partType);
            return part.fileName().flatMap((Function1 & Serializable)fileName -> entity.contentLength().flatMap((Function1 & Serializable)contentLength -> PlayToResponseBody.rawPartsToFilePart$$anonfun$1$$anonfun$1$$anonfun$1(part, fileName, entity, BoxesRunTime.unboxToLong((Object)contentLength))));
        });
    }

    private <T> Option<MultipartFormData.DataPart> rawPartsToDataPart(RawBodyType.MultipartBody m, Part<T> part) {
        return m.partType(part.name()).flatMap((Function1 & Serializable)partType -> {
            Some some;
            Charset charset;
            RawBodyType rawBodyType = partType;
            if (rawBodyType instanceof RawBodyType.StringBody) {
                RawBodyType.StringBody valueType = (RawBodyType.StringBody)rawBodyType;
                charset = valueType.charset();
            } else {
                charset = Charset.defaultCharset();
            }
            Charset charset2 = charset;
            HttpEntity httpEntity = this.fromRawValue((Object)part.body(), (HasHeaders)part, (RawBodyType)partType);
            if (httpEntity instanceof HttpEntity.Strict) {
                HttpEntity.Strict strict = HttpEntity.Strict$.MODULE$.unapply((HttpEntity.Strict)httpEntity);
                ByteString byteString = strict._1();
                Option option = strict._2();
                ByteString data = byteString;
                some = Some$.MODULE$.apply((Object)data.decodeString(charset2));
            } else if (httpEntity instanceof HttpEntity.Streamed) {
                HttpEntity.Streamed streamed = HttpEntity.Streamed$.MODULE$.unapply((HttpEntity.Streamed)httpEntity);
                Source source = streamed._1();
                Option option = streamed._2();
                Option option2 = streamed._3();
                some = None$.MODULE$;
            } else if (httpEntity instanceof HttpEntity.Chunked) {
                HttpEntity.Chunked chunked = HttpEntity.Chunked$.MODULE$.unapply((HttpEntity.Chunked)httpEntity);
                Source source = chunked._1();
                Option option = chunked._2();
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)httpEntity);
            }
            Some maybeData = some;
            return maybeData.map((Function1 & Serializable)_$5 -> MultipartFormData.DataPart$.MODULE$.apply(part.name(), _$5));
        });
    }

    private String formatToContentType(CodecFormat format, Option<Charset> charset) {
        return ((MediaType)charset.fold(() -> PlayToResponseBody.formatToContentType$$anonfun$1(format), (Function1 & Serializable)_$6 -> format.mediaType().charset(_$6))).toString();
    }

    private <A> Source<ByteString, NotUsed> multipartFormToStream(Seq<MultipartFormData.DataPart> dataParts, Seq<MultipartFormData.FilePart<Source<ByteString, ?>>> fileParts) {
        String boundary = new StringBuilder(8).append("--------").append(Random$.MODULE$.alphanumeric().take(20).mkString("")).toString();
        return (Source)Source$.MODULE$.single((Object)PlayToResponseBody.formatDataParts$1(boundary, dataParts)).concat((Graph)Source$.MODULE$.apply((Iterable)fileParts.toList()).flatMapConcat((Function1 & Serializable)file -> (Graph)Source$.MODULE$.single((Object)PlayToResponseBody.filePartHeader$1(boundary, file)).concat((Graph)file.ref()).concat((Graph)Source$.MODULE$.single((Object)ByteString$.MODULE$.apply("\r\n", Charset.forName("UTF-8")))).concat((Graph)Source$.MODULE$.single((Object)ByteString$.MODULE$.apply(new StringBuilder(4).append("--").append(boundary).append("--").toString(), "UTF-8")))));
    }

    private final HttpEntity fromRawValue$$anonfun$3(Source initialStream$2, HasHeaders headers$1, Option contentType$2) {
        return this.streamOrChunk((Source<ByteString, Object>)initialStream$2, (Option<Object>)headers$1.contentLength(), (Option<String>)contentType$2);
    }

    private final HttpEntity fromRawValue$$anonfun$5(Object v$4, Option contentType$5) {
        return this.streamOrChunk((Source<ByteString, Object>)FileIO$.MODULE$.fromPath(((FileRange)v$4).file().toPath(), FileIO$.MODULE$.fromPath$default$2()), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)((FileRange)v$4).file().length())), (Option<String>)contentType$5);
    }

    private final String fromStreamValue$$anonfun$1(CodecFormat format$1, Option charset$1) {
        return this.formatToContentType(format$1, (Option<Charset>)charset$1);
    }

    private static final /* synthetic */ Option rawPartsToFilePart$$anonfun$1$$anonfun$1$$anonfun$1(Part part$3, String fileName$1, HttpEntity entity$2, long contentLength) {
        return part$3.otherDispositionParams().get((Object)part$3.name()).map((Function1 & Serializable)dispositionType -> MultipartFormData.FilePart$.MODULE$.apply(part$3.name(), fileName$1, entity$2.contentType(), (Object)entity$2.dataStream(), contentLength, dispositionType, MultipartFormData.FilePart$.MODULE$.$lessinit$greater$default$7()));
    }

    private static final MediaType formatToContentType$$anonfun$1(CodecFormat format$2) {
        return format$2.mediaType();
    }

    private static final ByteString formatDataParts$1(String boundary$1, Seq dataParts) {
        String result = ((IterableOnceOps)dataParts.flatMap((Function1 & Serializable)x$1 -> {
            MultipartFormData.DataPart dataPart = x$1;
            if (dataPart != null) {
                MultipartFormData.DataPart dataPart2 = MultipartFormData.DataPart$.MODULE$.unapply(dataPart);
                String string = dataPart2._1();
                String string2 = dataPart2._2();
                String name = string;
                String value = string2;
                return Predef$.MODULE$.wrapString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(58).append("\n              --").append(boundary$1).append("\r\n").append(HeaderNames$.MODULE$.CONTENT_DISPOSITION()).append(": form-data; name=\"").append(name).append("\"\r\n\r\n").append(value).append("\r\n\n            ").toString())));
            }
            throw new MatchError((Object)dataPart);
        })).mkString("");
        return (ByteString)Codec$.MODULE$.utf_8().encode().apply((Object)result);
    }

    private static final String $anonfun$8() {
        return "";
    }

    private static final ByteString filePartHeader$1(String boundary$3, MultipartFormData.FilePart file) {
        String name = new StringBuilder(2).append("\"").append(file.key()).append("\"").toString();
        String filename = new StringBuilder(2).append("\"").append(file.filename()).append("\"").toString();
        String contentType = (String)file.contentType().map((Function1 & Serializable)ct -> new StringBuilder(4).append(HeaderNames$.MODULE$.CONTENT_TYPE()).append(": ").append((String)ct).append("\r\n").toString()).getOrElse(PlayToResponseBody::$anonfun$8);
        return (ByteString)Codec$.MODULE$.utf_8().encode().apply((Object)new StringBuilder(37).append("--").append(boundary$3).append("\r\n").append(HeaderNames$.MODULE$.CONTENT_DISPOSITION()).append(": form-data; name=").append(name).append("; filename=").append(filename).append("\r\n").append(contentType).append("\r\n").toString());
    }
}

