/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.metrics.prometheus;

import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import io.prometheus.metrics.core.datapoints.DistributionDataPoint;
import io.prometheus.metrics.core.datapoints.GaugeDataPoint;
import io.prometheus.metrics.core.metrics.Counter;
import io.prometheus.metrics.core.metrics.Gauge;
import io.prometheus.metrics.core.metrics.Histogram;
import io.prometheus.metrics.expositionformats.ExpositionFormats;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import sttp.monad.MonadError;
import sttp.tapir.Codec;
import sttp.tapir.Codec$;
import sttp.tapir.CodecFormat;
import sttp.tapir.DecodeResult;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointInput;
import sttp.tapir.Schema;
import sttp.tapir.Schema$;
import sttp.tapir.model.ServerRequest;
import sttp.tapir.package$;
import sttp.tapir.server.metrics.EndpointMetric;
import sttp.tapir.server.metrics.EndpointMetric$;
import sttp.tapir.server.metrics.Metric;
import sttp.tapir.server.metrics.Metric$;
import sttp.tapir.server.metrics.MetricLabels;
import sttp.tapir.server.metrics.MetricLabels$;
import sttp.tapir.server.metrics.prometheus.PrometheusMetrics;
import sttp.tapir.server.model.ServerResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class PrometheusMetrics$
implements Mirror.Product,
Serializable {
    private static final Schema schemaForPrometheusRegistry;
    private static final ExpositionFormats prometheusExpositionFormat;
    private static final Codec prometheusRegistryCodec;
    public static final PrometheusMetrics$ MODULE$;

    private PrometheusMetrics$() {
    }

    static {
        MODULE$ = new PrometheusMetrics$();
        schemaForPrometheusRegistry = Schema$.MODULE$.string();
        prometheusExpositionFormat = ExpositionFormats.init();
        prometheusRegistryCodec = Codec$.MODULE$.anyString((CodecFormat)CodecFormat.TextPlain$.MODULE$.apply(), (Function1 & Serializable)_$3 -> DecodeResult.Value$.MODULE$.apply((Object)new PrometheusRegistry()), (Function1 & Serializable)r -> {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            prometheusExpositionFormat.getPrometheusTextFormatWriter().write((OutputStream)output, r.scrape());
            output.close();
            return output.toString();
        }, MODULE$.schemaForPrometheusRegistry());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PrometheusMetrics$.class);
    }

    public <F> PrometheusMetrics<F> apply(String namespace, PrometheusRegistry registry, List<Metric<F, ?>> metrics, EndpointInput<BoxedUnit> endpointPrefix) {
        return new PrometheusMetrics<F>(namespace, registry, metrics, endpointPrefix);
    }

    public <F> PrometheusMetrics<F> unapply(PrometheusMetrics<F> x$1) {
        return x$1;
    }

    public <F> String $lessinit$greater$default$1() {
        return "tapir";
    }

    public <F> PrometheusRegistry $lessinit$greater$default$2() {
        return PrometheusRegistry.defaultRegistry;
    }

    public <F> List<Metric<F, ?>> $lessinit$greater$default$3() {
        return scala.package$.MODULE$.List().empty();
    }

    public <F> EndpointInput<BoxedUnit> $lessinit$greater$default$4() {
        return package$.MODULE$.stringToPath("metrics");
    }

    public Schema<PrometheusRegistry> schemaForPrometheusRegistry() {
        return schemaForPrometheusRegistry;
    }

    public Codec<String, PrometheusRegistry, CodecFormat.TextPlain> prometheusRegistryCodec() {
        return prometheusRegistryCodec;
    }

    private String metricNameWithNamespace(String namespace, String metricName) {
        return new StringBuilder(1).append(namespace).append("_").append(metricName).toString();
    }

    public <F> PrometheusMetrics<F> default(String namespace, PrometheusRegistry registry, MetricLabels labels) {
        return this.apply(namespace, registry, (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Metric[]{this.requestActive(registry, namespace, labels), this.requestTotal(registry, namespace, labels), this.requestDuration(registry, namespace, labels, this.requestDuration$default$4())})), this.$lessinit$greater$default$4());
    }

    public <F> String default$default$1() {
        return "tapir";
    }

    public <F> PrometheusRegistry default$default$2() {
        return PrometheusRegistry.defaultRegistry;
    }

    public <F> MetricLabels default$default$3() {
        return MetricLabels$.MODULE$.Default();
    }

    public <F> Metric<F, Gauge> requestActive(PrometheusRegistry registry, String namespace, MetricLabels labels) {
        return Metric$.MODULE$.apply((Object)Gauge.builder().name(this.metricNameWithNamespace(namespace, "request_active")).help("Active HTTP requests").labelNames((String[])Arrays$.MODULE$.seqToArray((Seq)labels.namesForRequest(), String.class)).register(registry), (Function3 & Serializable)(req, gauge, m) -> m.unit((Object)EndpointMetric$.MODULE$.apply((Option)EndpointMetric$.MODULE$.$lessinit$greater$default$1(), (Option)EndpointMetric$.MODULE$.$lessinit$greater$default$2(), (Option)EndpointMetric$.MODULE$.$lessinit$greater$default$3(), (Option)EndpointMetric$.MODULE$.$lessinit$greater$default$4()).onEndpointRequest((Function1 & Serializable)ep -> m.eval((Function0 & Serializable)() -> {
            this.requestActive$$anonfun$1$$anonfun$1$$anonfun$1((Gauge)gauge, labels, (Endpoint)ep, (ServerRequest)req);
            return BoxedUnit.UNIT;
        })).onResponseBody((Function2 & Serializable)(ep, _$6) -> m.eval((Function0 & Serializable)() -> {
            this.requestActive$$anonfun$1$$anonfun$2$$anonfun$1((Gauge)gauge, labels, (Endpoint)ep, (ServerRequest)req);
            return BoxedUnit.UNIT;
        })).onException((Function2 & Serializable)(ep, _$7) -> m.eval((Function0 & Serializable)() -> {
            this.requestActive$$anonfun$1$$anonfun$3$$anonfun$1((Gauge)gauge, labels, (Endpoint)ep, (ServerRequest)req);
            return BoxedUnit.UNIT;
        }))));
    }

    public <F> Metric<F, Counter> requestTotal(PrometheusRegistry registry, String namespace, MetricLabels labels) {
        return Metric$.MODULE$.apply((Object)Counter.builder().name(this.metricNameWithNamespace(namespace, "request_total")).help("Total HTTP requests").labelNames((String[])Arrays$.MODULE$.seqToArray((Seq)labels.namesForRequest().$plus$plus((IterableOnce)labels.namesForResponse()), String.class)).register(registry), (Function3 & Serializable)(req, counter, m) -> m.unit((Object)EndpointMetric$.MODULE$.apply((Option)EndpointMetric$.MODULE$.$lessinit$greater$default$1(), (Option)EndpointMetric$.MODULE$.$lessinit$greater$default$2(), (Option)EndpointMetric$.MODULE$.$lessinit$greater$default$3(), (Option)EndpointMetric$.MODULE$.$lessinit$greater$default$4()).onResponseBody((Function2 & Serializable)(ep, res) -> m.eval((Function0 & Serializable)() -> {
            this.requestTotal$$anonfun$1$$anonfun$1$$anonfun$1((Counter)counter, labels, (Endpoint)ep, (ServerRequest)req, (ServerResponse)res);
            return BoxedUnit.UNIT;
        })).onException((Function2 & Serializable)(ep, ex) -> m.eval((Function0 & Serializable)() -> {
            this.requestTotal$$anonfun$1$$anonfun$2$$anonfun$1((Counter)counter, labels, (Endpoint)ep, (ServerRequest)req, (Throwable)ex);
            return BoxedUnit.UNIT;
        }))));
    }

    public <F> Metric<F, Histogram> requestDuration(PrometheusRegistry registry, String namespace, MetricLabels labels, Clock clock) {
        return Metric$.MODULE$.apply((Object)Histogram.builder().name(this.metricNameWithNamespace(namespace, "request_duration_seconds")).help("Duration of HTTP requests").labelNames((String[])Arrays$.MODULE$.seqToArray((Seq)((IterableOps)labels.namesForRequest().$plus$plus((IterableOnce)labels.namesForResponse())).$plus$plus((IterableOnce)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{labels.forResponsePhase().name()}))), String.class)).register(registry), (Function3 & Serializable)(req, histogram, m) -> m.eval(() -> this.requestDuration$$anonfun$1$$anonfun$1(clock, m, histogram, labels, req)));
    }

    public <F> Clock requestDuration$default$4() {
        return Clock.systemUTC();
    }

    public PrometheusMetrics<?> fromProduct(Product x$0) {
        return new PrometheusMetrics((String)x$0.productElement(0), (PrometheusRegistry)x$0.productElement(1), (List)x$0.productElement(2), (EndpointInput<BoxedUnit>)((EndpointInput)x$0.productElement(3)));
    }

    private final void requestActive$$anonfun$1$$anonfun$1$$anonfun$1(Gauge gauge$2, MetricLabels labels$2, Endpoint ep$1, ServerRequest req$2) {
        ((GaugeDataPoint)gauge$2.labelValues((String[])Arrays$.MODULE$.seqToArray((Seq)labels$2.valuesForRequest(ep$1, req$2), String.class))).inc();
    }

    private final void requestActive$$anonfun$1$$anonfun$2$$anonfun$1(Gauge gauge$4, MetricLabels labels$5, Endpoint ep$2, ServerRequest req$4) {
        ((GaugeDataPoint)gauge$4.labelValues((String[])Arrays$.MODULE$.seqToArray((Seq)labels$5.valuesForRequest(ep$2, req$4), String.class))).dec();
    }

    private final void requestActive$$anonfun$1$$anonfun$3$$anonfun$1(Gauge gauge$6, MetricLabels labels$7, Endpoint ep$3, ServerRequest req$6) {
        ((GaugeDataPoint)gauge$6.labelValues((String[])Arrays$.MODULE$.seqToArray((Seq)labels$7.valuesForRequest(ep$3, req$6), String.class))).dec();
    }

    private final void requestTotal$$anonfun$1$$anonfun$1$$anonfun$1(Counter counter$2, MetricLabels labels$9, Endpoint ep$4, ServerRequest req$8, ServerResponse res$1) {
        ((CounterDataPoint)counter$2.labelValues((String[])Arrays$.MODULE$.seqToArray((Seq)labels$9.valuesForRequest(ep$4, req$8).$plus$plus((IterableOnce)labels$9.valuesForResponse(res$1)), String.class))).inc();
    }

    private final void requestTotal$$anonfun$1$$anonfun$2$$anonfun$1(Counter counter$4, MetricLabels labels$12, Endpoint ep$5, ServerRequest req$10, Throwable ex$1) {
        ((CounterDataPoint)counter$4.labelValues((String[])Arrays$.MODULE$.seqToArray((Seq)labels$12.valuesForRequest(ep$5, req$10).$plus$plus((IterableOnce)labels$12.valuesForResponse(ex$1)), String.class))).inc();
    }

    private final double duration$1(Instant requestStart$1, Clock clock$3) {
        return (double)Duration.between(requestStart$1, clock$3.instant()).toMillis() / 1000.0;
    }

    private final void requestDuration$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Histogram histogram$3, MetricLabels labels$16, Endpoint ep$6, ServerRequest req$13, ServerResponse res$2, Instant requestStart$3, Clock clock$5) {
        ((DistributionDataPoint)histogram$3.labelValues((String[])Arrays$.MODULE$.seqToArray((Seq)((IterableOps)labels$16.valuesForRequest(ep$6, req$13).$plus$plus((IterableOnce)labels$16.valuesForResponse(res$2))).$plus$plus((IterableOnce)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{labels$16.forResponsePhase().headersValue()}))), String.class))).observe(this.duration$1(requestStart$3, clock$5));
    }

    private final void requestDuration$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(Histogram histogram$5, MetricLabels labels$18, Endpoint ep$7, ServerRequest req$15, ServerResponse res$3, Instant requestStart$5, Clock clock$7) {
        ((DistributionDataPoint)histogram$5.labelValues((String[])Arrays$.MODULE$.seqToArray((Seq)((IterableOps)labels$18.valuesForRequest(ep$7, req$15).$plus$plus((IterableOnce)labels$18.valuesForResponse(res$3))).$plus$plus((IterableOnce)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{labels$18.forResponsePhase().bodyValue()}))), String.class))).observe(this.duration$1(requestStart$5, clock$7));
    }

    private final void requestDuration$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(Histogram histogram$7, MetricLabels labels$20, Endpoint ep$8, ServerRequest req$17, Throwable ex$2, Instant requestStart$7, Clock clock$9) {
        ((DistributionDataPoint)histogram$7.labelValues((String[])Arrays$.MODULE$.seqToArray((Seq)((IterableOps)labels$20.valuesForRequest(ep$8, req$17).$plus$plus((IterableOnce)labels$20.valuesForResponse(ex$2))).$plus$plus((IterableOnce)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{labels$20.forResponsePhase().bodyValue()}))), String.class))).observe(this.duration$1(requestStart$7, clock$9));
    }

    private final EndpointMetric requestDuration$$anonfun$1$$anonfun$1(Clock clock$2, MonadError m$6, Histogram histogram$1, MetricLabels labels$14, ServerRequest req$11) {
        Instant requestStart = clock$2.instant();
        return EndpointMetric$.MODULE$.apply((Option)EndpointMetric$.MODULE$.$lessinit$greater$default$1(), (Option)EndpointMetric$.MODULE$.$lessinit$greater$default$2(), (Option)EndpointMetric$.MODULE$.$lessinit$greater$default$3(), (Option)EndpointMetric$.MODULE$.$lessinit$greater$default$4()).onResponseHeaders((Function2 & Serializable)(ep, res) -> m$6.eval((Function0 & Serializable)() -> {
            this.requestDuration$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(histogram$1, labels$14, (Endpoint)ep, req$11, (ServerResponse)res, requestStart, clock$2);
            return BoxedUnit.UNIT;
        })).onResponseBody((Function2 & Serializable)(ep, res) -> m$6.eval((Function0 & Serializable)() -> {
            this.requestDuration$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(histogram$1, labels$14, (Endpoint)ep, req$11, (ServerResponse)res, requestStart, clock$2);
            return BoxedUnit.UNIT;
        })).onException((Function2 & Serializable)(ep, ex) -> m$6.eval((Function0 & Serializable)() -> {
            this.requestDuration$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(histogram$1, labels$14, (Endpoint)ep, req$11, (Throwable)ex, requestStart, clock$2);
            return BoxedUnit.UNIT;
        }));
    }
}

