/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.interpreter;

import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Vector;
import sttp.tapir.DecodeResult;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.Mapping;
import sttp.tapir.internal.package;
import sttp.tapir.internal.package$;
import sttp.tapir.server.interpreter.DecodeBasicInputsResult;
import sttp.tapir.server.interpreter.InputValueResult;

public final class InputValue$ {
    public static InputValue$ MODULE$;

    static {
        new InputValue$();
    }

    public InputValueResult apply(EndpointInput<?> input, DecodeBasicInputsResult.Values values) {
        return this.apply(input, values.basicInputsValues());
    }

    private InputValueResult apply(EndpointInput<?> input, Vector<Object> remainingBasicValues) {
        EndpointInput.Single single;
        while (true) {
            if ((single = input) instanceof EndpointInput.Pair) {
                EndpointInput.Pair pair = (EndpointInput.Pair)single;
                EndpointInput left = pair.left();
                EndpointInput right = pair.right();
                Function2 combine = pair.combine$access$2();
                return this.handlePair(left, right, (Function2<package.Params, package.Params, package.Params>)combine, remainingBasicValues);
            }
            if (single instanceof EndpointIO.Pair) {
                EndpointIO.Pair pair = (EndpointIO.Pair)single;
                EndpointIO left = pair.left();
                EndpointIO right = pair.right();
                Function2 combine = pair.combine$access$2();
                return this.handlePair((EndpointInput<?>)left, (EndpointInput<?>)right, (Function2<package.Params, package.Params, package.Params>)combine, remainingBasicValues);
            }
            if (single instanceof EndpointInput.MappedPair) {
                EndpointInput.MappedPair mappedPair = (EndpointInput.MappedPair)single;
                EndpointInput.Pair wrapped = mappedPair.input();
                Mapping codec = mappedPair.mapping();
                return this.handleMappedPair((EndpointInput)wrapped, (Mapping)codec, remainingBasicValues);
            }
            if (single instanceof EndpointIO.MappedPair) {
                EndpointIO.MappedPair mappedPair = (EndpointIO.MappedPair)single;
                EndpointIO.Pair wrapped = mappedPair.io();
                Mapping codec = mappedPair.mapping();
                return this.handleMappedPair((EndpointInput)wrapped, (Mapping)codec, remainingBasicValues);
            }
            if (!(single instanceof EndpointInput.Auth)) break;
            EndpointInput.Auth auth = (EndpointInput.Auth)single;
            input = auth.input();
        }
        if (single instanceof EndpointInput.Basic) {
            Some some;
            Tuple2 tuple2;
            Option option = package$.MODULE$.RichVector(remainingBasicValues).headAndTail();
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Object v = tuple2._1();
                Vector valuesTail = (Vector)tuple2._2();
                return new InputValueResult.Value((package.Params)new package.ParamsAsAny(v), (Vector<Object>)valuesTail);
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(60).append("Mismatch between basic input values: ").append(remainingBasicValues).append(", and basic inputs in: ").append(input).toString());
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)single);
    }

    private InputValueResult handlePair(EndpointInput<?> left, EndpointInput<?> right, Function2<package.Params, package.Params, package.Params> combine, Vector<Object> remainingBasicValues) {
        InputValueResult inputValueResult = this.apply(left, remainingBasicValues);
        if (inputValueResult instanceof InputValueResult.Value) {
            InputValueResult.Value value = (InputValueResult.Value)inputValueResult;
            package.Params leftParams = value.params();
            Vector<Object> remainingBasicValues2 = value.remainingBasicValues();
            InputValueResult inputValueResult2 = this.apply(right, remainingBasicValues2);
            if (inputValueResult2 instanceof InputValueResult.Value) {
                InputValueResult.Value value2 = (InputValueResult.Value)inputValueResult2;
                package.Params rightParams = value2.params();
                Vector<Object> remainingBasicValues3 = value2.remainingBasicValues();
                return new InputValueResult.Value((package.Params)combine.apply((Object)leftParams, (Object)rightParams), remainingBasicValues3);
            }
            if (inputValueResult2 instanceof InputValueResult.Failure) {
                InputValueResult.Failure failure = (InputValueResult.Failure)inputValueResult2;
                return failure;
            }
            throw new MatchError((Object)inputValueResult2);
        }
        if (inputValueResult instanceof InputValueResult.Failure) {
            InputValueResult.Failure failure = (InputValueResult.Failure)inputValueResult;
            return failure;
        }
        throw new MatchError((Object)inputValueResult);
    }

    private <II, T> InputValueResult handleMappedPair(EndpointInput<II> wrapped, Mapping<II, T> codec, Vector<Object> remainingBasicValues) {
        InputValueResult inputValueResult = this.apply(wrapped, remainingBasicValues);
        if (inputValueResult instanceof InputValueResult.Value) {
            InputValueResult.Value value = (InputValueResult.Value)inputValueResult;
            package.Params pairValue = value.params();
            Vector<Object> remainingBasicValues2 = value.remainingBasicValues();
            DecodeResult decodeResult = codec.decode(pairValue.asAny());
            if (decodeResult instanceof DecodeResult.Value) {
                DecodeResult.Value value2 = (DecodeResult.Value)decodeResult;
                Object v = value2.v();
                return new InputValueResult.Value((package.Params)new package.ParamsAsAny(v), remainingBasicValues2);
            }
            if (decodeResult instanceof DecodeResult.Failure) {
                DecodeResult.Failure failure = (DecodeResult.Failure)decodeResult;
                return new InputValueResult.Failure(wrapped, failure);
            }
            throw new MatchError((Object)decodeResult);
        }
        if (inputValueResult instanceof InputValueResult.Failure) {
            InputValueResult.Failure failure = (InputValueResult.Failure)inputValueResult;
            return failure;
        }
        throw new MatchError((Object)inputValueResult);
    }

    private InputValue$() {
        MODULE$ = this;
    }
}

