/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.interpreter;

import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sttp.capabilities.package;
import sttp.model.ContentTypeRange;
import sttp.model.HasHeaders;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.model.StatusCode;
import sttp.tapir.Codec;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointOutput;
import sttp.tapir.Mapping;
import sttp.tapir.RawBodyType;
import sttp.tapir.StreamBodyIO;
import sttp.tapir.StreamBodyIO$;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.internal.package;
import sttp.tapir.server.interpreter.OutputValues;
import sttp.tapir.server.interpreter.ToResponseBody;

public class EncodeOutputs<B, S> {
    private final ToResponseBody<B, S> rawToResponseBody;
    private final Seq<ContentTypeRange> acceptsContentTypes;

    public EncodeOutputs(ToResponseBody<B, S> rawToResponseBody, Seq<ContentTypeRange> acceptsContentTypes) {
        this.rawToResponseBody = rawToResponseBody;
        this.acceptsContentTypes = acceptsContentTypes;
    }

    public OutputValues<B> apply(EndpointOutput<?> output, package.Params value, OutputValues<B> ov) {
        EndpointOutput<?> endpointOutput = output;
        if (endpointOutput instanceof EndpointIO.Single) {
            EndpointIO.Single s = (EndpointIO.Single)endpointOutput;
            return this.applySingle((EndpointOutput.Single<?>)s, value, ov);
        }
        if (endpointOutput instanceof EndpointOutput.Single) {
            EndpointOutput.Single s = (EndpointOutput.Single)endpointOutput;
            return this.applySingle(s, value, ov);
        }
        if (endpointOutput instanceof EndpointIO.Pair) {
            EndpointIO.Pair pair = EndpointIO.Pair$.MODULE$.unapply((EndpointIO.Pair)endpointOutput);
            EndpointIO endpointIO = pair._1();
            EndpointIO endpointIO2 = pair._2();
            Function2 function2 = pair._3();
            Function1 function1 = pair._4();
            EndpointIO left = endpointIO;
            EndpointIO right = endpointIO2;
            Function1 split = function1;
            return this.applyPair((EndpointOutput<?>)left, (EndpointOutput<?>)right, (Function1<package.Params, Tuple2<package.Params, package.Params>>)split, value, ov);
        }
        if (endpointOutput instanceof EndpointOutput.Pair) {
            EndpointOutput.Pair pair = EndpointOutput.Pair$.MODULE$.unapply((EndpointOutput.Pair)endpointOutput);
            EndpointOutput endpointOutput2 = pair._1();
            EndpointOutput endpointOutput3 = pair._2();
            Function2 function2 = pair._3();
            Function1 function1 = pair._4();
            EndpointOutput left = endpointOutput2;
            EndpointOutput right = endpointOutput3;
            Function1 split = function1;
            return this.applyPair(left, right, (Function1<package.Params, Tuple2<package.Params, package.Params>>)split, value, ov);
        }
        if (endpointOutput instanceof EndpointOutput.Void && EndpointOutput.Void$.MODULE$.unapply((EndpointOutput.Void)endpointOutput)) {
            throw new IllegalArgumentException("Cannot encode a void output!");
        }
        throw new MatchError(endpointOutput);
    }

    private OutputValues<B> applyPair(EndpointOutput<?> left, EndpointOutput<?> right, Function1<package.Params, Tuple2<package.Params, package.Params>> split, package.Params params, OutputValues<B> ov) {
        Tuple2 tuple2 = (Tuple2)split.apply((Object)params);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        package.Params leftParams = (package.Params)tuple2._1();
        package.Params rightParams = (package.Params)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)leftParams, (Object)rightParams);
        package.Params leftParams2 = (package.Params)tuple22._1();
        package.Params rightParams2 = (package.Params)tuple22._2();
        return this.apply(right, rightParams2, this.apply(left, leftParams2, ov));
    }

    private OutputValues<B> applySingle(EndpointOutput.Single<?> output, package.Params value, OutputValues<B> ov) {
        EndpointIO.StreamBodyWrapper streamBodyWrapper;
        StreamBodyIO streamBodyIO;
        EndpointOutput.Single<?> single;
        while (true) {
            if ((single = output) instanceof EndpointIO.Empty) {
                EndpointIO.Empty empty = EndpointIO.Empty$.MODULE$.unapply((EndpointIO.Empty)single);
                Codec codec = empty._1();
                EndpointIO.Info info = empty._2();
                return ov;
            }
            if (single instanceof EndpointOutput.FixedStatusCode) {
                EndpointOutput.FixedStatusCode fixedStatusCode = EndpointOutput.FixedStatusCode$.MODULE$.unapply((EndpointOutput.FixedStatusCode)single);
                int n = fixedStatusCode._1();
                Codec codec = fixedStatusCode._2();
                EndpointIO.Info info = fixedStatusCode._3();
                int sc = n;
                return ov.withStatusCode(sc);
            }
            if (single instanceof EndpointIO.FixedHeader) {
                EndpointIO.FixedHeader fixedHeader = EndpointIO.FixedHeader$.MODULE$.unapply((EndpointIO.FixedHeader)single);
                Header header = fixedHeader._1();
                Codec codec = fixedHeader._2();
                EndpointIO.Info info = fixedHeader._3();
                Header header2 = header;
                return ov.withHeader(header2.name(), header2.value());
            }
            if (single instanceof EndpointIO.Body) {
                EndpointIO.Body body = EndpointIO.Body$.MODULE$.unapply((EndpointIO.Body)single);
                RawBodyType rawBodyType = body._1();
                Codec codec = body._2();
                EndpointIO.Info info = body._3();
                RawBodyType rawBodyType2 = rawBodyType;
                Codec codec2 = codec;
                None$ maybeCharset = codec2.format().mediaType().isText() ? sttp.tapir.internal.package$.MODULE$.charset(rawBodyType2) : None$.MODULE$;
                return ov.withBody((Function1 & Serializable)headers -> this.rawToResponseBody.fromRawValue(EncodeOutputs.encodedC$1(value, codec2), (HasHeaders)headers, codec2.format(), rawBodyType2)).withDefaultContentType(codec2.format(), (Option<Charset>)maybeCharset);
            }
            if (!(single instanceof EndpointIO.OneOfBody)) break;
            EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)single);
            List list = oneOfBody._1();
            Mapping mapping = oneOfBody._2();
            List variants = list;
            Mapping mapping2 = mapping;
            EndpointIO.Atom<?> atom = this.chooseOneOfVariant(variants);
            package.ParamsAsAny paramsAsAny = package.ParamsAsAny$.MODULE$.apply(EncodeOutputs.encodedM$1(value, mapping2));
            output = atom;
            value = paramsAsAny;
        }
        if (single instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = EndpointIO.StreamBodyWrapper$.MODULE$.unapply((EndpointIO.StreamBodyWrapper)single))._1()) instanceof StreamBodyIO) {
            StreamBodyIO streamBodyIO2 = StreamBodyIO$.MODULE$.unapply(streamBodyIO);
            package.Streams streams = streamBodyIO2._1();
            Codec codec = streamBodyIO2._2();
            EndpointIO.Info info = streamBodyIO2._3();
            Option option = streamBodyIO2._4();
            List list = streamBodyIO2._5();
            Codec codec3 = codec;
            Option charset = option;
            return ov.withBody((Function1 & Serializable)headers -> this.rawToResponseBody.fromStreamValue(EncodeOutputs.encodedC$1(value, codec3), (HasHeaders)headers, codec3.format(), (Option<Charset>)charset)).withDefaultContentType(codec3.format(), (Option<Charset>)charset).withHeaderTransformation((Function1<Vector<Header>, Vector<Header>>)(Function1 & Serializable)hs -> {
                if (hs.exists((Function1 & Serializable)_$1 -> _$1.is(HeaderNames$.MODULE$.ContentLength()))) {
                    return hs;
                }
                return (Vector)hs.$colon$plus((Object)Header$.MODULE$.apply(HeaderNames$.MODULE$.TransferEncoding(), "chunked"));
            });
        }
        if (single instanceof EndpointIO.Header) {
            EndpointIO.Header header = EndpointIO.Header$.MODULE$.unapply((EndpointIO.Header)single);
            String string = header._1();
            Codec codec = header._2();
            EndpointIO.Info info = header._3();
            String name = string;
            Codec codec4 = codec;
            return (OutputValues)((LinearSeqOps)EncodeOutputs.encodedC$1(value, codec4)).foldLeft(ov, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    OutputValues ovv = (OutputValues)tuple2._1();
                    String headerValue = (String)tuple2._2();
                    return ovv.withHeader(name, headerValue);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        if (single instanceof EndpointIO.Headers) {
            EndpointIO.Headers headers2 = EndpointIO.Headers$.MODULE$.unapply((EndpointIO.Headers)single);
            Codec codec = headers2._1();
            EndpointIO.Info info = headers2._2();
            Codec codec5 = codec;
            return (OutputValues)((LinearSeqOps)EncodeOutputs.encodedC$1(value, codec5)).foldLeft(ov, (Function2 & Serializable)(ov2, h) -> ov2.withHeader(h.name(), h.value()));
        }
        if (single instanceof EndpointIO.MappedPair) {
            EndpointIO.MappedPair mappedPair = EndpointIO.MappedPair$.MODULE$.unapply((EndpointIO.MappedPair)single);
            EndpointIO.Pair pair = mappedPair._1();
            Mapping mapping = mappedPair._2();
            EndpointIO.Pair wrapped = pair;
            Mapping mapping3 = mapping;
            return this.apply((EndpointOutput<?>)wrapped, (package.Params)package.ParamsAsAny$.MODULE$.apply(EncodeOutputs.encodedM$1(value, mapping3)), ov);
        }
        if (single instanceof EndpointOutput.StatusCode) {
            EndpointOutput.StatusCode statusCode = EndpointOutput.StatusCode$.MODULE$.unapply((EndpointOutput.StatusCode)single);
            Map map = statusCode._1();
            Codec codec = statusCode._2();
            EndpointIO.Info info = statusCode._3();
            Codec codec6 = codec;
            Object object = EncodeOutputs.encodedC$1(value, codec6);
            return ov.withStatusCode(object == null ? BoxesRunTime.unboxToInt(null) : ((StatusCode)object).code());
        }
        if (single instanceof EndpointOutput.WebSocketBodyWrapper) {
            WebSocketBodyOutput webSocketBodyOutput;
            EndpointOutput.WebSocketBodyWrapper webSocketBodyWrapper = EndpointOutput.WebSocketBodyWrapper$.MODULE$.unapply((EndpointOutput.WebSocketBodyWrapper)single);
            WebSocketBodyOutput o = webSocketBodyOutput = webSocketBodyWrapper._1();
            return ov.withBody((Function1 & Serializable)_$2 -> this.rawToResponseBody.fromWebSocketPipe(EncodeOutputs.encodedC$1(value, o.codec()), o));
        }
        if (single instanceof EndpointOutput.OneOf) {
            EndpointOutput.OneOf oneOf = (EndpointOutput.OneOf)single;
            EndpointOutput.OneOf oneOf2 = EndpointOutput.OneOf$.MODULE$.unapply(oneOf);
            List list = oneOf2._1();
            Mapping mapping = oneOf2._2();
            List mappings = list;
            Mapping mapping4 = mapping;
            EndpointOutput.OneOf o = oneOf;
            Object enc = EncodeOutputs.encodedM$1(value, mapping4);
            List applicableMappings = mappings.filter((Function1 & Serializable)_$3 -> BoxesRunTime.unboxToBoolean((Object)_$3.appliesTo().apply(enc)));
            if (applicableMappings.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(225).append("None of the mappings defined in the one-of output: ").append(o.show()).append(", is applicable to the value: ").append(enc).append(". ").append("Verify that the type parameters to oneOf are correct, and that the oneOfVariants are exhaustive ").append("(that is, that they cover all possible cases).").toString());
            }
            EndpointOutput.OneOfVariant<?> chosenVariant = this.chooseOneOfVariant((Seq<EndpointOutput.OneOfVariant<?>>)applicableMappings);
            return this.apply(chosenVariant.output(), (package.Params)package.ParamsAsAny$.MODULE$.apply(enc), ov);
        }
        if (single instanceof EndpointOutput.MappedPair) {
            EndpointOutput.MappedPair mappedPair = EndpointOutput.MappedPair$.MODULE$.unapply((EndpointOutput.MappedPair)single);
            EndpointOutput.Pair pair = mappedPair._1();
            Mapping mapping = mappedPair._2();
            EndpointOutput.Pair wrapped = pair;
            Mapping mapping5 = mapping;
            return this.apply((EndpointOutput<?>)wrapped, (package.Params)package.ParamsAsAny$.MODULE$.apply(EncodeOutputs.encodedM$1(value, mapping5)), ov);
        }
        throw new MatchError(single);
    }

    private EndpointIO.Atom<?> chooseOneOfVariant(List<EndpointIO.OneOfBodyVariant<?>> variants) {
        List mediaTypeToBody = variants.map((Function1 & Serializable)v -> {
            MediaType mediaType = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)v.mediaTypeWithCharset());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType, v);
        });
        return ((EndpointIO.OneOfBodyVariant)this.chooseBestVariant((Seq)mediaTypeToBody).getOrElse(() -> EncodeOutputs.chooseOneOfVariant$$anonfun$1(variants))).bodyAsAtom();
    }

    private EndpointOutput.OneOfVariant<?> chooseOneOfVariant(Seq<EndpointOutput.OneOfVariant<?>> variants) {
        Seq bodyVariants = (Seq)variants.flatMap((Function1 & Serializable)om -> {
            Vector mediaTypeFromBody = sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(om.output()).traverseOutputs((PartialFunction)new Serializable((EndpointOutput.OneOfVariant)om){
                private final EndpointOutput.OneOfVariant om$1;
                {
                    this.om$1 = om$2;
                }

                public final boolean isDefinedAt(EndpointOutput x) {
                    EndpointOutput endpointOutput = x;
                    if (endpointOutput instanceof EndpointIO.Body) {
                        EndpointIO.Body b = (EndpointIO.Body)endpointOutput;
                        return true;
                    }
                    if (endpointOutput instanceof EndpointIO.StreamBodyWrapper) {
                        EndpointIO.StreamBodyWrapper b = (EndpointIO.StreamBodyWrapper)endpointOutput;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(EndpointOutput x, Function1 function1) {
                    EndpointOutput endpointOutput = x;
                    if (endpointOutput instanceof EndpointIO.Body) {
                        EndpointIO.Body b = (EndpointIO.Body)endpointOutput;
                        Object[] objectArray = new Tuple2[1];
                        MediaType mediaType = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)sttp.tapir.internal.package$.MODULE$.RichBody(b).mediaTypeWithCharset());
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType, (Object)this.om$1);
                        return package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    }
                    if (endpointOutput instanceof EndpointIO.StreamBodyWrapper) {
                        EndpointIO.StreamBodyWrapper b = (EndpointIO.StreamBodyWrapper)endpointOutput;
                        Object[] objectArray = new Tuple2[1];
                        MediaType mediaType = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)sttp.tapir.internal.package$.MODULE$.RichStreamBody(b).mediaTypeWithCharset());
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType, (Object)this.om$1);
                        return package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    }
                    return function1.apply((Object)x);
                }
            });
            if (mediaTypeFromBody.isEmpty()) {
                MediaType fakeMediaType = (MediaType)this.acceptsContentTypes.headOption().map((Function1 & Serializable)r -> MediaType$.MODULE$.apply(r.mainType(), r.subType(), MediaType$.MODULE$.$lessinit$greater$default$3(), MediaType$.MODULE$.$lessinit$greater$default$4())).getOrElse(EncodeOutputs::$anonfun$5);
                Object[] objectArray = new Tuple2[1];
                MediaType mediaType = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)fakeMediaType);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType, om);
                return (IterableOnce)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }
            return mediaTypeFromBody;
        });
        return (EndpointOutput.OneOfVariant)this.chooseBestVariant(bodyVariants).getOrElse(() -> EncodeOutputs.chooseOneOfVariant$$anonfun$2(variants));
    }

    private <T> Option<T> chooseBestVariant(Seq<Tuple2<MediaType, T>> variants) {
        if (variants.nonEmpty()) {
            Seq mediaTypes = (Seq)variants.map((Function1 & Serializable)_$4 -> (MediaType)_$4._1());
            return MediaType$.MODULE$.bestMatch(mediaTypes, this.acceptsContentTypes).flatMap((Function1 & Serializable)mt -> variants.find((Function1 & Serializable)_$5 -> {
                Object object = _$5._1();
                MediaType mediaType = mt;
                return !(object != null ? !object.equals(mediaType) : mediaType != null);
            }).map((Function1 & Serializable)_$6 -> _$6._2()));
        }
        return None$.MODULE$;
    }

    private static final Object encodedC$1(package.Params value$tailLocal1$1, Codec codec) {
        return codec.encode(value$tailLocal1$1.asAny());
    }

    private static final Object encodedM$1(package.Params value$tailLocal1$2, Mapping mapping) {
        return mapping.encode(value$tailLocal1$2.asAny());
    }

    private static final EndpointIO.OneOfBodyVariant chooseOneOfVariant$$anonfun$1(List variants$1) {
        return (EndpointIO.OneOfBodyVariant)variants$1.head();
    }

    private static final MediaType $anonfun$5() {
        return MediaType$.MODULE$.ApplicationOctetStream();
    }

    private static final EndpointOutput.OneOfVariant chooseOneOfVariant$$anonfun$2(Seq variants$2) {
        return (EndpointOutput.OneOfVariant)variants$2.head();
    }
}

