/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.interpreter;

import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sttp.model.HasHeaders;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.StatusCode;
import sttp.tapir.CodecFormat;
import sttp.tapir.server.interpreter.OutputValues$;

public class OutputValues<B>
implements Product,
Serializable {
    private final Option body;
    private final Vector baseHeaders;
    private final Vector headerTransformations;
    private final Option statusCode;

    public static <B> OutputValues<B> apply(Option<Function1<HasHeaders, B>> option, Vector<Header> vector, Vector<Function1<Vector<Header>, Vector<Header>>> vector2, Option<StatusCode> option2) {
        return OutputValues$.MODULE$.apply(option, vector, vector2, option2);
    }

    public static <B> OutputValues<B> empty() {
        return OutputValues$.MODULE$.empty();
    }

    public static OutputValues<?> fromProduct(Product product) {
        return OutputValues$.MODULE$.fromProduct(product);
    }

    public static <B> OutputValues<B> unapply(OutputValues<B> outputValues) {
        return OutputValues$.MODULE$.unapply(outputValues);
    }

    public OutputValues(Option<Function1<HasHeaders, B>> body, Vector<Header> baseHeaders, Vector<Function1<Vector<Header>, Vector<Header>>> headerTransformations, Option<StatusCode> statusCode) {
        this.body = body;
        this.baseHeaders = baseHeaders;
        this.headerTransformations = headerTransformations;
        this.statusCode = statusCode;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof OutputValues)) return false;
        OutputValues outputValues = (OutputValues)object;
        Option<Function1<HasHeaders, B>> option = this.body();
        Option<Function1<HasHeaders, B>> option2 = outputValues.body();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Vector<Header> vector = this.baseHeaders();
        Vector<Header> vector2 = outputValues.baseHeaders();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        Vector<Function1<Vector<Header>, Vector<Header>>> vector3 = this.headerTransformations();
        Vector<Function1<Vector<Header>, Vector<Header>>> vector4 = outputValues.headerTransformations();
        if (vector3 == null) {
            if (vector4 != null) {
                return false;
            }
        } else if (!vector3.equals(vector4)) return false;
        Option<StatusCode> option3 = this.statusCode();
        Option<StatusCode> option4 = outputValues.statusCode();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!outputValues.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof OutputValues;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "OutputValues";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "body";
            }
            case 1: {
                return "baseHeaders";
            }
            case 2: {
                return "headerTransformations";
            }
            case 3: {
                return "statusCode";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Option<Function1<HasHeaders, B>> body() {
        return this.body;
    }

    public Vector<Header> baseHeaders() {
        return this.baseHeaders;
    }

    public Vector<Function1<Vector<Header>, Vector<Header>>> headerTransformations() {
        return this.headerTransformations;
    }

    public Option<StatusCode> statusCode() {
        return this.statusCode;
    }

    public OutputValues<B> withBody(Function1<HasHeaders, B> b) {
        if (this.body().isDefined()) {
            throw new IllegalArgumentException("Body is already defined");
        }
        return this.copy((Option<Function1<HasHeaders, B>>)Some$.MODULE$.apply(b), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public OutputValues<B> withHeaderTransformation(Function1<Vector<Header>, Vector<Header>> t) {
        Vector vector = (Vector)this.headerTransformations().$colon$plus(t);
        Option<Function1<HasHeaders, B>> option = this.copy$default$1();
        Vector<Header> vector2 = this.copy$default$2();
        Option<StatusCode> option2 = this.copy$default$4();
        return this.copy(option, vector2, (Vector<Function1<Vector<Header>, Vector<Header>>>)vector, option2);
    }

    public OutputValues<B> withDefaultContentType(CodecFormat format, Option<Charset> charset) {
        return this.withHeaderTransformation((Function1<Vector<Header>, Vector<Header>>)(Function1 & Serializable)hs -> {
            if (hs.exists((Function1 & Serializable)_$7 -> _$7.is(HeaderNames$.MODULE$.ContentType()))) {
                return hs;
            }
            return (Vector)hs.$colon$plus((Object)Header$.MODULE$.apply(HeaderNames$.MODULE$.ContentType(), ((MediaType)charset.fold(() -> OutputValues.withDefaultContentType$$anonfun$1$$anonfun$2(format), (Function1 & Serializable)_$8 -> format.mediaType().charset(_$8))).toString()));
        });
    }

    public OutputValues<B> withHeader(String n, String v) {
        Vector vector = (Vector)this.baseHeaders().$colon$plus((Object)Header$.MODULE$.apply(n, v));
        Option<Function1<HasHeaders, B>> option = this.copy$default$1();
        Vector<Function1<Vector<Header>, Vector<Header>>> vector2 = this.copy$default$3();
        Option<StatusCode> option2 = this.copy$default$4();
        return this.copy(option, (Vector<Header>)vector, vector2, option2);
    }

    public OutputValues<B> withStatusCode(int sc) {
        Some some = Some$.MODULE$.apply((Object)new StatusCode(sc));
        Option<Function1<HasHeaders, B>> option = this.copy$default$1();
        Vector<Header> vector = this.copy$default$2();
        Vector<Function1<Vector<Header>, Vector<Header>>> vector2 = this.copy$default$3();
        return this.copy(option, vector, vector2, (Option<StatusCode>)some);
    }

    public Seq<Header> headers() {
        return (Seq)this.headerTransformations().foldLeft(this.baseHeaders(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Vector hs = (Vector)tuple2._1();
                Function1 t = (Function1)tuple2._2();
                return (Vector)t.apply((Object)hs);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <B> OutputValues<B> copy(Option<Function1<HasHeaders, B>> body, Vector<Header> baseHeaders, Vector<Function1<Vector<Header>, Vector<Header>>> headerTransformations, Option<StatusCode> statusCode) {
        return new OutputValues<B>(body, baseHeaders, headerTransformations, statusCode);
    }

    public <B> Option<Function1<HasHeaders, B>> copy$default$1() {
        return this.body();
    }

    public <B> Vector<Header> copy$default$2() {
        return this.baseHeaders();
    }

    public <B> Vector<Function1<Vector<Header>, Vector<Header>>> copy$default$3() {
        return this.headerTransformations();
    }

    public <B> Option<StatusCode> copy$default$4() {
        return this.statusCode();
    }

    public Option<Function1<HasHeaders, B>> _1() {
        return this.body();
    }

    public Vector<Header> _2() {
        return this.baseHeaders();
    }

    public Vector<Function1<Vector<Header>, Vector<Header>>> _3() {
        return this.headerTransformations();
    }

    public Option<StatusCode> _4() {
        return this.statusCode();
    }

    private static final MediaType withDefaultContentType$$anonfun$1$$anonfun$2(CodecFormat format$2) {
        return format$2.mediaType();
    }
}

