/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.interceptor.cors;

import java.io.Serializable;
import scala.Function1;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;
import sttp.model.Method;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;
import sttp.model.headers.Origin;
import sttp.tapir.server.interceptor.cors.CORSConfig;
import sttp.tapir.server.interceptor.cors.CORSConfig$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedCredentials$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedCredentials$Allow$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedCredentials$Deny$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedHeaders$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedHeaders$All$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedHeaders$Reflect$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedHeaders$Some$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedMethods$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedMethods$All$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedMethods$Some$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedOrigin$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedOrigin$All$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedOrigin$Matching$;
import sttp.tapir.server.interceptor.cors.CORSConfig$AllowedOrigin$Single$;
import sttp.tapir.server.interceptor.cors.CORSConfig$ExposedHeaders$;
import sttp.tapir.server.interceptor.cors.CORSConfig$ExposedHeaders$All$;
import sttp.tapir.server.interceptor.cors.CORSConfig$ExposedHeaders$None$;
import sttp.tapir.server.interceptor.cors.CORSConfig$ExposedHeaders$Some$;
import sttp.tapir.server.interceptor.cors.CORSConfig$MaxAge$;
import sttp.tapir.server.interceptor.cors.CORSConfig$MaxAge$Default$;
import sttp.tapir.server.interceptor.cors.CORSConfig$MaxAge$Some$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CORSConfig
implements Product,
Serializable {
    private final AllowedOrigin allowedOrigin;
    private final AllowedCredentials allowedCredentials;
    private final AllowedMethods allowedMethods;
    private final AllowedHeaders allowedHeaders;
    private final ExposedHeaders exposedHeaders;
    private final MaxAge maxAge;
    private final int preflightResponseStatusCode;

    public static CORSConfig apply(AllowedOrigin allowedOrigin, AllowedCredentials allowedCredentials, AllowedMethods allowedMethods, AllowedHeaders allowedHeaders, ExposedHeaders exposedHeaders, MaxAge maxAge, int n) {
        return CORSConfig$.MODULE$.apply(allowedOrigin, allowedCredentials, allowedMethods, allowedHeaders, exposedHeaders, maxAge, n);
    }

    public static CORSConfig default() {
        return CORSConfig$.MODULE$.default();
    }

    public static CORSConfig fromProduct(Product product) {
        return CORSConfig$.MODULE$.fromProduct(product);
    }

    public static CORSConfig unapply(CORSConfig cORSConfig) {
        return CORSConfig$.MODULE$.unapply(cORSConfig);
    }

    public CORSConfig(AllowedOrigin allowedOrigin, AllowedCredentials allowedCredentials, AllowedMethods allowedMethods, AllowedHeaders allowedHeaders, ExposedHeaders exposedHeaders, MaxAge maxAge, int preflightResponseStatusCode) {
        this.allowedOrigin = allowedOrigin;
        this.allowedCredentials = allowedCredentials;
        this.allowedMethods = allowedMethods;
        this.allowedHeaders = allowedHeaders;
        this.exposedHeaders = exposedHeaders;
        this.maxAge = maxAge;
        this.preflightResponseStatusCode = preflightResponseStatusCode;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -1382432363, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CORSConfig)) return false;
        CORSConfig cORSConfig = (CORSConfig)object;
        AllowedOrigin allowedOrigin = this.allowedOrigin();
        AllowedOrigin allowedOrigin2 = cORSConfig.allowedOrigin();
        if (allowedOrigin == null) {
            if (allowedOrigin2 != null) {
                return false;
            }
        } else if (!allowedOrigin.equals(allowedOrigin2)) return false;
        AllowedCredentials allowedCredentials = this.allowedCredentials();
        AllowedCredentials allowedCredentials2 = cORSConfig.allowedCredentials();
        if (allowedCredentials == null) {
            if (allowedCredentials2 != null) {
                return false;
            }
        } else if (!allowedCredentials.equals(allowedCredentials2)) return false;
        AllowedMethods allowedMethods = this.allowedMethods();
        AllowedMethods allowedMethods2 = cORSConfig.allowedMethods();
        if (allowedMethods == null) {
            if (allowedMethods2 != null) {
                return false;
            }
        } else if (!allowedMethods.equals(allowedMethods2)) return false;
        AllowedHeaders allowedHeaders = this.allowedHeaders();
        AllowedHeaders allowedHeaders2 = cORSConfig.allowedHeaders();
        if (allowedHeaders == null) {
            if (allowedHeaders2 != null) {
                return false;
            }
        } else if (!allowedHeaders.equals(allowedHeaders2)) return false;
        ExposedHeaders exposedHeaders = this.exposedHeaders();
        ExposedHeaders exposedHeaders2 = cORSConfig.exposedHeaders();
        if (exposedHeaders == null) {
            if (exposedHeaders2 != null) {
                return false;
            }
        } else if (!exposedHeaders.equals(exposedHeaders2)) return false;
        MaxAge maxAge = this.maxAge();
        MaxAge maxAge2 = cORSConfig.maxAge();
        if (maxAge == null) {
            if (maxAge2 != null) {
                return false;
            }
        } else if (!maxAge.equals(maxAge2)) return false;
        if (this.preflightResponseStatusCode() != cORSConfig.preflightResponseStatusCode()) return false;
        if (!cORSConfig.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CORSConfig;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "CORSConfig";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return new StatusCode(this._7());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "allowedOrigin";
            }
            case 1: {
                return "allowedCredentials";
            }
            case 2: {
                return "allowedMethods";
            }
            case 3: {
                return "allowedHeaders";
            }
            case 4: {
                return "exposedHeaders";
            }
            case 5: {
                return "maxAge";
            }
            case 6: {
                return "preflightResponseStatusCode";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public AllowedOrigin allowedOrigin() {
        return this.allowedOrigin;
    }

    public AllowedCredentials allowedCredentials() {
        return this.allowedCredentials;
    }

    public AllowedMethods allowedMethods() {
        return this.allowedMethods;
    }

    public AllowedHeaders allowedHeaders() {
        return this.allowedHeaders;
    }

    public ExposedHeaders exposedHeaders() {
        return this.exposedHeaders;
    }

    public MaxAge maxAge() {
        return this.maxAge;
    }

    public int preflightResponseStatusCode() {
        return this.preflightResponseStatusCode;
    }

    public CORSConfig allowAllOrigins() {
        return this.copy(CORSConfig$AllowedOrigin$All$.MODULE$, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public CORSConfig allowOrigin(Origin origin) {
        return this.copy(CORSConfig$AllowedOrigin$Single$.MODULE$.apply(origin), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public CORSConfig allowMatchingOrigins(Function1<String, Object> predicate) {
        return this.copy(CORSConfig$AllowedOrigin$Matching$.MODULE$.apply(predicate), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public CORSConfig allowCredentials() {
        CORSConfig$AllowedCredentials$Allow$ cORSConfig$AllowedCredentials$Allow$ = CORSConfig$AllowedCredentials$Allow$.MODULE$;
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedMethods allowedMethods = this.copy$default$3();
        AllowedHeaders allowedHeaders = this.copy$default$4();
        ExposedHeaders exposedHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, cORSConfig$AllowedCredentials$Allow$, allowedMethods, allowedHeaders, exposedHeaders, maxAge, n);
    }

    public CORSConfig denyCredentials() {
        CORSConfig$AllowedCredentials$Deny$ cORSConfig$AllowedCredentials$Deny$ = CORSConfig$AllowedCredentials$Deny$.MODULE$;
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedMethods allowedMethods = this.copy$default$3();
        AllowedHeaders allowedHeaders = this.copy$default$4();
        ExposedHeaders exposedHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, cORSConfig$AllowedCredentials$Deny$, allowedMethods, allowedHeaders, exposedHeaders, maxAge, n);
    }

    public CORSConfig allowAllMethods() {
        CORSConfig$AllowedMethods$All$ cORSConfig$AllowedMethods$All$ = CORSConfig$AllowedMethods$All$.MODULE$;
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedCredentials allowedCredentials = this.copy$default$2();
        AllowedHeaders allowedHeaders = this.copy$default$4();
        ExposedHeaders exposedHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, allowedCredentials, cORSConfig$AllowedMethods$All$, allowedHeaders, exposedHeaders, maxAge, n);
    }

    public CORSConfig allowMethods(Seq<Method> methods) {
        AllowedMethods.Some some = CORSConfig$AllowedMethods$Some$.MODULE$.apply((Set<Method>)methods.toSet());
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedCredentials allowedCredentials = this.copy$default$2();
        AllowedHeaders allowedHeaders = this.copy$default$4();
        ExposedHeaders exposedHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, allowedCredentials, some, allowedHeaders, exposedHeaders, maxAge, n);
    }

    public CORSConfig allowAllHeaders() {
        CORSConfig$AllowedHeaders$All$ cORSConfig$AllowedHeaders$All$ = CORSConfig$AllowedHeaders$All$.MODULE$;
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedCredentials allowedCredentials = this.copy$default$2();
        AllowedMethods allowedMethods = this.copy$default$3();
        ExposedHeaders exposedHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, allowedCredentials, allowedMethods, cORSConfig$AllowedHeaders$All$, exposedHeaders, maxAge, n);
    }

    public CORSConfig allowHeaders(Seq<String> headerNames) {
        AllowedHeaders.Some some = CORSConfig$AllowedHeaders$Some$.MODULE$.apply((Set<String>)headerNames.toSet());
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedCredentials allowedCredentials = this.copy$default$2();
        AllowedMethods allowedMethods = this.copy$default$3();
        ExposedHeaders exposedHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, allowedCredentials, allowedMethods, some, exposedHeaders, maxAge, n);
    }

    public CORSConfig reflectHeaders() {
        CORSConfig$AllowedHeaders$Reflect$ cORSConfig$AllowedHeaders$Reflect$ = CORSConfig$AllowedHeaders$Reflect$.MODULE$;
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedCredentials allowedCredentials = this.copy$default$2();
        AllowedMethods allowedMethods = this.copy$default$3();
        ExposedHeaders exposedHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, allowedCredentials, allowedMethods, cORSConfig$AllowedHeaders$Reflect$, exposedHeaders, maxAge, n);
    }

    public CORSConfig exposeAllHeaders() {
        CORSConfig$ExposedHeaders$All$ cORSConfig$ExposedHeaders$All$ = CORSConfig$ExposedHeaders$All$.MODULE$;
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedCredentials allowedCredentials = this.copy$default$2();
        AllowedMethods allowedMethods = this.copy$default$3();
        AllowedHeaders allowedHeaders = this.copy$default$4();
        MaxAge maxAge = this.copy$default$6();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, allowedCredentials, allowedMethods, allowedHeaders, cORSConfig$ExposedHeaders$All$, maxAge, n);
    }

    public CORSConfig exposeNoHeaders() {
        CORSConfig$ExposedHeaders$None$ cORSConfig$ExposedHeaders$None$ = CORSConfig$ExposedHeaders$None$.MODULE$;
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedCredentials allowedCredentials = this.copy$default$2();
        AllowedMethods allowedMethods = this.copy$default$3();
        AllowedHeaders allowedHeaders = this.copy$default$4();
        MaxAge maxAge = this.copy$default$6();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, allowedCredentials, allowedMethods, allowedHeaders, cORSConfig$ExposedHeaders$None$, maxAge, n);
    }

    public CORSConfig exposeHeaders(Seq<String> headerNames) {
        ExposedHeaders.Some some = CORSConfig$ExposedHeaders$Some$.MODULE$.apply((Set<String>)headerNames.toSet());
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedCredentials allowedCredentials = this.copy$default$2();
        AllowedMethods allowedMethods = this.copy$default$3();
        AllowedHeaders allowedHeaders = this.copy$default$4();
        MaxAge maxAge = this.copy$default$6();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, allowedCredentials, allowedMethods, allowedHeaders, some, maxAge, n);
    }

    public CORSConfig defaultMaxAge() {
        CORSConfig$MaxAge$Default$ cORSConfig$MaxAge$Default$ = CORSConfig$MaxAge$Default$.MODULE$;
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedCredentials allowedCredentials = this.copy$default$2();
        AllowedMethods allowedMethods = this.copy$default$3();
        AllowedHeaders allowedHeaders = this.copy$default$4();
        ExposedHeaders exposedHeaders = this.copy$default$5();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, allowedCredentials, allowedMethods, allowedHeaders, exposedHeaders, cORSConfig$MaxAge$Default$, n);
    }

    public CORSConfig maxAge(Duration duration) {
        MaxAge.Some some = CORSConfig$MaxAge$Some$.MODULE$.apply(duration);
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedCredentials allowedCredentials = this.copy$default$2();
        AllowedMethods allowedMethods = this.copy$default$3();
        AllowedHeaders allowedHeaders = this.copy$default$4();
        ExposedHeaders exposedHeaders = this.copy$default$5();
        int n = this.copy$default$7();
        return this.copy(allowedOrigin, allowedCredentials, allowedMethods, allowedHeaders, exposedHeaders, some, n);
    }

    public CORSConfig defaultPreflightResponseStatusCode() {
        int n = StatusCode$.MODULE$.NoContent();
        AllowedOrigin allowedOrigin = this.copy$default$1();
        AllowedCredentials allowedCredentials = this.copy$default$2();
        AllowedMethods allowedMethods = this.copy$default$3();
        AllowedHeaders allowedHeaders = this.copy$default$4();
        ExposedHeaders exposedHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        return this.copy(allowedOrigin, allowedCredentials, allowedMethods, allowedHeaders, exposedHeaders, maxAge, n);
    }

    public CORSConfig preflightResponseStatusCode(int statusCode) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), statusCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid() {
        AllowedCredentials allowedCredentials = this.allowedCredentials();
        CORSConfig$AllowedCredentials$Deny$ cORSConfig$AllowedCredentials$Deny$ = CORSConfig$AllowedCredentials$Deny$.MODULE$;
        if (allowedCredentials == null) {
            if (cORSConfig$AllowedCredentials$Deny$ == null) return true;
        } else if (allowedCredentials.equals(cORSConfig$AllowedCredentials$Deny$)) return true;
        AllowedOrigin allowedOrigin = this.allowedOrigin();
        CORSConfig$AllowedOrigin$All$ cORSConfig$AllowedOrigin$All$ = CORSConfig$AllowedOrigin$All$.MODULE$;
        if (allowedOrigin == null) {
            if (cORSConfig$AllowedOrigin$All$ == null) return false;
        } else if (allowedOrigin.equals(cORSConfig$AllowedOrigin$All$)) return false;
        AllowedHeaders allowedHeaders = this.allowedHeaders();
        CORSConfig$AllowedHeaders$All$ cORSConfig$AllowedHeaders$All$ = CORSConfig$AllowedHeaders$All$.MODULE$;
        if (allowedHeaders == null) {
            if (cORSConfig$AllowedHeaders$All$ == null) return false;
        } else if (allowedHeaders.equals(cORSConfig$AllowedHeaders$All$)) return false;
        AllowedMethods allowedMethods = this.allowedMethods();
        CORSConfig$AllowedMethods$All$ cORSConfig$AllowedMethods$All$ = CORSConfig$AllowedMethods$All$.MODULE$;
        if (allowedMethods == null) {
            if (cORSConfig$AllowedMethods$All$ == null) return false;
            return true;
        } else if (allowedMethods.equals(cORSConfig$AllowedMethods$All$)) return false;
        return true;
    }

    public CORSConfig copy(AllowedOrigin allowedOrigin, AllowedCredentials allowedCredentials, AllowedMethods allowedMethods, AllowedHeaders allowedHeaders, ExposedHeaders exposedHeaders, MaxAge maxAge, int preflightResponseStatusCode) {
        return new CORSConfig(allowedOrigin, allowedCredentials, allowedMethods, allowedHeaders, exposedHeaders, maxAge, preflightResponseStatusCode);
    }

    public AllowedOrigin copy$default$1() {
        return this.allowedOrigin();
    }

    public AllowedCredentials copy$default$2() {
        return this.allowedCredentials();
    }

    public AllowedMethods copy$default$3() {
        return this.allowedMethods();
    }

    public AllowedHeaders copy$default$4() {
        return this.allowedHeaders();
    }

    public ExposedHeaders copy$default$5() {
        return this.exposedHeaders();
    }

    public MaxAge copy$default$6() {
        return this.maxAge();
    }

    public int copy$default$7() {
        return this.preflightResponseStatusCode();
    }

    public AllowedOrigin _1() {
        return this.allowedOrigin();
    }

    public AllowedCredentials _2() {
        return this.allowedCredentials();
    }

    public AllowedMethods _3() {
        return this.allowedMethods();
    }

    public AllowedHeaders _4() {
        return this.allowedHeaders();
    }

    public ExposedHeaders _5() {
        return this.exposedHeaders();
    }

    public MaxAge _6() {
        return this.maxAge();
    }

    public int _7() {
        return this.preflightResponseStatusCode();
    }

    public static interface AllowedCredentials {
        public static int ordinal(AllowedCredentials allowedCredentials) {
            return CORSConfig$AllowedCredentials$.MODULE$.ordinal(allowedCredentials);
        }
    }

    public static interface AllowedHeaders {
        public static int ordinal(AllowedHeaders allowedHeaders) {
            return CORSConfig$AllowedHeaders$.MODULE$.ordinal(allowedHeaders);
        }
    }

    public static interface AllowedMethods {
        public static int ordinal(AllowedMethods allowedMethods) {
            return CORSConfig$AllowedMethods$.MODULE$.ordinal(allowedMethods);
        }
    }

    public static interface AllowedOrigin {
        public static int ordinal(AllowedOrigin allowedOrigin) {
            return CORSConfig$AllowedOrigin$.MODULE$.ordinal(allowedOrigin);
        }
    }

    public static interface ExposedHeaders {
        public static int ordinal(ExposedHeaders exposedHeaders) {
            return CORSConfig$ExposedHeaders$.MODULE$.ordinal(exposedHeaders);
        }
    }

    public static interface MaxAge {
        public static int ordinal(MaxAge maxAge) {
            return CORSConfig$MaxAge$.MODULE$.ordinal(maxAge);
        }
    }
}

