/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.model;

import java.io.Serializable;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.util.hashing.MurmurHash3$;
import sttp.model.Header;
import sttp.model.Headers$;
import sttp.model.ResponseMetadata;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;
import sttp.tapir.server.model.ServerResponse$;
import sttp.tapir.server.model.ValuedEndpointOutput;

public class ServerResponse<B>
implements ResponseMetadata,
Product,
Serializable {
    private final int code;
    private final Seq headers;
    private final Option body;
    private final Option source;

    public static <B> ServerResponse<B> apply(int n, Seq<Header> seq, Option<B> option, Option<ValuedEndpointOutput<?>> option2) {
        return ServerResponse$.MODULE$.apply(n, seq, option, option2);
    }

    public static ServerResponse<?> fromProduct(Product product) {
        return ServerResponse$.MODULE$.fromProduct(product);
    }

    public static <B> ServerResponse<B> notFound() {
        return ServerResponse$.MODULE$.notFound();
    }

    public static <B> ServerResponse<B> unapply(ServerResponse<B> serverResponse) {
        return ServerResponse$.MODULE$.unapply(serverResponse);
    }

    public ServerResponse(int code, Seq<Header> headers, Option<B> body, Option<ValuedEndpointOutput<?>> source) {
        this.code = code;
        this.headers = headers;
        this.body = body;
        this.source = source;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 1459290764, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ServerResponse)) return false;
        ServerResponse serverResponse = (ServerResponse)object;
        if (this.code() != serverResponse.code()) return false;
        Seq<Header> seq = this.headers();
        Seq<Header> seq2 = serverResponse.headers();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<B> option = this.body();
        Option<B> option2 = serverResponse.body();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<ValuedEndpointOutput<?>> option3 = this.source();
        Option<ValuedEndpointOutput<?>> option4 = serverResponse.source();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!serverResponse.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof ServerResponse;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "ServerResponse";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return new StatusCode(this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "code";
            }
            case 1: {
                return "headers";
            }
            case 2: {
                return "body";
            }
            case 3: {
                return "source";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int code() {
        return this.code;
    }

    public Seq<Header> headers() {
        return this.headers;
    }

    public Option<B> body() {
        return this.body;
    }

    public Option<ValuedEndpointOutput<?>> source() {
        return this.source;
    }

    public String statusText() {
        return "";
    }

    public String toString() {
        return new StringBuilder(17).append("ServerResponse(").append(new StatusCode(this.code())).append(",").append(Headers$.MODULE$.toStringSafe(this.headers(), Headers$.MODULE$.toStringSafe$default$2())).append(")").toString();
    }

    public String showShort() {
        return StatusCode$.MODULE$.toString$extension(this.code());
    }

    public String showCodeAndHeaders() {
        return new StringBuilder(3).append(new StatusCode(this.code())).append(" (").append(Headers$.MODULE$.toStringSafe(this.headers(), Headers$.MODULE$.toStringSafe$default$2())).append(")").toString();
    }

    public ServerResponse<B> addHeaders(Seq<Header> additionalHeaders) {
        Seq seq = (Seq)this.headers().$plus$plus(additionalHeaders);
        int n = this.copy$default$1();
        Option<B> option = this.copy$default$3();
        Option<ValuedEndpointOutput<?>> option2 = this.copy$default$4();
        return this.copy(n, (Seq<Header>)seq, option, option2);
    }

    public <B> ServerResponse<B> copy(int code, Seq<Header> headers, Option<B> body, Option<ValuedEndpointOutput<?>> source) {
        return new ServerResponse<B>(code, headers, body, source);
    }

    public int copy$default$1() {
        return this.code();
    }

    public <B> Seq<Header> copy$default$2() {
        return this.headers();
    }

    public <B> Option<B> copy$default$3() {
        return this.body();
    }

    public <B> Option<ValuedEndpointOutput<?>> copy$default$4() {
        return this.source();
    }

    public int _1() {
        return this.code();
    }

    public Seq<Header> _2() {
        return this.headers();
    }

    public Option<B> _3() {
        return this.body();
    }

    public Option<ValuedEndpointOutput<?>> _4() {
        return this.source();
    }
}

