/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.client.sttp4;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.capabilities.package;
import sttp.client4.BasicBodyPart;
import sttp.client4.DuplicateHeaderBehavior;
import sttp.client4.PartialRequest;
import sttp.client4.Request;
import sttp.client4.ResponseAs;
import sttp.client4.package$;
import sttp.model.ContentTypeRange;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.Part;
import sttp.model.QueryParams;
import sttp.model.ResponseMetadata;
import sttp.model.Uri;
import sttp.model.Uri$;
import sttp.tapir.Codec;
import sttp.tapir.CodecFormat;
import sttp.tapir.DecodeResult;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.EndpointOutput;
import sttp.tapir.FileRange;
import sttp.tapir.FileRange$;
import sttp.tapir.InputStreamRange;
import sttp.tapir.InputStreamRange$;
import sttp.tapir.Mapping;
import sttp.tapir.RawBodyType;
import sttp.tapir.StreamBodyIO;
import sttp.tapir.StreamBodyIO$;
import sttp.tapir.client.ClientOutputParams;
import sttp.tapir.client.sttp4.SttpClientOptions;
import sttp.tapir.internal.package;

public interface EndpointToSttpClientBase {
    public static boolean isSuccess$(EndpointToSttpClientBase $this, ResponseMetadata meta) {
        return $this.isSuccess(meta);
    }

    default public boolean isSuccess(ResponseMetadata meta) {
        return meta.isSuccess();
    }

    public static Tuple2 prepareRequestWithInput$(EndpointToSttpClientBase $this, Endpoint e, Option baseUri, Object aParams, Object iParams) {
        return $this.prepareRequestWithInput(e, (Option<Uri>)baseUri, aParams, iParams);
    }

    default public <A, E, O, I, R> Tuple2<Request<?>, Option<Tuple2<package.Streams<?>, Object>>> prepareRequestWithInput(Endpoint<A, I, E, O, R> e, Option<Uri> baseUri, A aParams, I iParams) {
        Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> tuple3 = this.setInputParams((EndpointInput<I>)e.securityInput(), (package.Params)package.ParamsAsAny$.MODULE$.apply(aParams), (Uri)baseUri.getOrElse(EndpointToSttpClientBase::$anonfun$1), (PartialRequest<?>)package$.MODULE$.basicRequest(), (Option<Tuple2<package.Streams<?>, Object>>)None$.MODULE$);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Uri uri1 = (Uri)tuple3._1();
        PartialRequest req1 = (PartialRequest)tuple3._2();
        Option streamBody1 = (Option)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)uri1, (Object)req1, (Object)streamBody1);
        Uri uri12 = (Uri)tuple32._1();
        PartialRequest req12 = (PartialRequest)tuple32._2();
        Option streamBody12 = (Option)tuple32._3();
        Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> tuple33 = this.setInputParams(e.input(), (package.Params)package.ParamsAsAny$.MODULE$.apply(iParams), uri12, req12, streamBody12);
        if (tuple33 == null) {
            throw new MatchError(tuple33);
        }
        Uri uri2 = (Uri)tuple33._1();
        PartialRequest req2 = (PartialRequest)tuple33._2();
        Option streamBody2 = (Option)tuple33._3();
        Tuple3 tuple34 = Tuple3$.MODULE$.apply((Object)uri2, (Object)req2, (Object)streamBody2);
        Uri uri22 = (Uri)tuple34._1();
        PartialRequest req22 = (PartialRequest)tuple34._2();
        Option streamBody22 = (Option)tuple34._3();
        return Tuple2$.MODULE$.apply((Object)req22.method(Method$.MODULE$.apply(((Method)e.method().getOrElse((Function0 & Serializable)() -> new Method(EndpointToSttpClientBase.prepareRequestWithInput$$anonfun$1()))).method()), uri22), (Object)streamBody22);
    }

    public static DecodeResult mapReqOutputWithMetadata$(EndpointToSttpClientBase $this, Endpoint e, Object body, ResponseMetadata meta, ClientOutputParams clientOutputParams) {
        return $this.mapReqOutputWithMetadata(e, body, meta, clientOutputParams);
    }

    default public <A, I, E, O, R, T> DecodeResult<Either<Object, Object>> mapReqOutputWithMetadata(Endpoint<A, I, E, O, R> e, T body, ResponseMetadata meta, ClientOutputParams clientOutputParams) {
        EndpointOutput output = this.isSuccess(meta) ? e.output() : e.errorOutput();
        DecodeResult params = clientOutputParams.apply(output, body, meta);
        return params.map((Function1 & Serializable)_$1 -> _$1.asAny()).map((Function1 & Serializable)p -> {
            if (this.isSuccess(meta)) {
                return scala.package$.MODULE$.Right().apply(p);
            }
            return scala.package$.MODULE$.Left().apply(p);
        });
    }

    public static DecodeResult mapDecodeError$(EndpointToSttpClientBase $this, DecodeResult decodeResult, Request req) {
        return $this.mapDecodeError((DecodeResult<Either<Object, Object>>)decodeResult, req);
    }

    default public DecodeResult<Either<Object, Object>> mapDecodeError(DecodeResult<Either<Object, Object>> decodeResult, Request<?> req) {
        DecodeResult<Either<Object, Object>> decodeResult2 = decodeResult;
        if (decodeResult2 instanceof DecodeResult.Error) {
            DecodeResult.Error error = DecodeResult.Error$.MODULE$.unapply((DecodeResult.Error)decodeResult2);
            String string = error._1();
            Throwable throwable = error._2();
            String o = string;
            Throwable e = throwable;
            return DecodeResult.Error$.MODULE$.apply(o, (Throwable)new IllegalArgumentException(new StringBuilder(32).append("Cannot decode from: ").append(o).append(", request: ").append(new Method(req.method())).append(" ").append(req.uri()).toString(), e));
        }
        DecodeResult<Either<Object, Object>> other = decodeResult2;
        return other;
    }

    public static ResponseAs outToResponseAs$(EndpointToSttpClientBase $this, EndpointOutput out, SttpClientOptions clientOptions) {
        return $this.outToResponseAs(out, clientOptions);
    }

    default public ResponseAs<Object> outToResponseAs(EndpointOutput<?> out, SttpClientOptions clientOptions) {
        return (ResponseAs)sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(out).bodyType().map((Function1 & Serializable)x$1 -> {
            RawBodyType rawBodyType = x$1;
            if (rawBodyType instanceof RawBodyType.StringBody) {
                Charset charset;
                RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
                Charset charset2 = charset = stringBody._1();
                return package$.MODULE$.asStringAlways(charset2.name());
            }
            if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
                return package$.MODULE$.asByteArrayAlways();
            }
            if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
                return package$.MODULE$.asByteArrayAlways().map((Function1 & Serializable)x$0 -> ByteBuffer.wrap(x$0));
            }
            if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
                return package$.MODULE$.asByteArrayAlways().map((Function1 & Serializable)_$2 -> new ByteArrayInputStream((byte[])_$2));
            }
            if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
                return package$.MODULE$.asFileAlways((File)clientOptions.createFile().apply()).map((Function1 & Serializable)d -> FileRange$.MODULE$.apply(d, FileRange$.MODULE$.$lessinit$greater$default$2()));
            }
            if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
                return package$.MODULE$.asByteArrayAlways().map((Function1 & Serializable)b -> InputStreamRange$.MODULE$.apply((Function0 & Serializable)() -> new ByteArrayInputStream((byte[])b), InputStreamRange$.MODULE$.$lessinit$greater$default$2()));
            }
            if (rawBodyType instanceof RawBodyType.MultipartBody) {
                RawBodyType.MultipartBody multipartBody = RawBodyType.MultipartBody$.MODULE$.unapply((RawBodyType.MultipartBody)rawBodyType);
                Map map = multipartBody._1();
                Option option = multipartBody._2();
                throw new IllegalArgumentException("Multipart bodies aren't supported in responses");
            }
            throw new MatchError((Object)rawBodyType);
        }).getOrElse(EndpointToSttpClientBase::outToResponseAs$$anonfun$2);
    }

    private <I> Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> setInputParams(EndpointInput<I> input, package.Params params, Uri uri, PartialRequest<?> req, Option<Tuple2<package.Streams<?>, Object>> streamBody) {
        EndpointInput.Single single;
        while (true) {
            EndpointIO.StreamBodyWrapper streamBodyWrapper;
            StreamBodyIO streamBodyIO;
            if ((single = input) instanceof EndpointInput.FixedMethod) {
                EndpointInput.FixedMethod fixedMethod = EndpointInput.FixedMethod$.MODULE$.unapply((EndpointInput.FixedMethod)single);
                String string = fixedMethod._1();
                Codec codec = fixedMethod._2();
                EndpointIO.Info info = fixedMethod._3();
                return Tuple3$.MODULE$.apply((Object)uri, req, streamBody);
            }
            if (single instanceof EndpointInput.FixedPath) {
                EndpointInput.FixedPath fixedPath = EndpointInput.FixedPath$.MODULE$.unapply((EndpointInput.FixedPath)single);
                String string = fixedPath._1();
                Codec codec = fixedPath._2();
                EndpointIO.Info info = fixedPath._3();
                String p = string;
                return Tuple3$.MODULE$.apply((Object)uri.addPath(p, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])), req, streamBody);
            }
            if (single instanceof EndpointInput.PathCapture) {
                EndpointInput.PathCapture pathCapture = EndpointInput.PathCapture$.MODULE$.unapply((EndpointInput.PathCapture)single);
                Option option = pathCapture._1();
                Codec codec = pathCapture._2();
                EndpointIO.Info info = pathCapture._3();
                Codec codec2 = codec;
                String v = (String)codec2.encode(EndpointToSttpClientBase.value$1(params));
                return Tuple3$.MODULE$.apply((Object)uri.addPath(v, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])), req, streamBody);
            }
            if (single instanceof EndpointInput.PathsCapture) {
                EndpointInput.PathsCapture pathsCapture = EndpointInput.PathsCapture$.MODULE$.unapply((EndpointInput.PathsCapture)single);
                Codec codec = pathsCapture._1();
                EndpointIO.Info info = pathsCapture._2();
                Codec codec3 = codec;
                List ps = (List)codec3.encode(EndpointToSttpClientBase.value$1(params));
                return Tuple3$.MODULE$.apply((Object)uri.addPath((Seq)ps), req, streamBody);
            }
            if (single instanceof EndpointInput.Query) {
                EndpointInput.Query query = EndpointInput.Query$.MODULE$.unapply((EndpointInput.Query)single);
                String string = query._1();
                Option option = query._2();
                Codec codec = query._3();
                EndpointIO.Info info = query._4();
                String name = string;
                if (option instanceof Some) {
                    Object flagValue = ((Some)option).value();
                    if (BoxesRunTime.equals((Object)EndpointToSttpClientBase.value$1(params), (Object)flagValue)) {
                        return Tuple3$.MODULE$.apply((Object)uri.withParams(uri.params().param(name, (scala.collection.immutable.Seq)scala.package$.MODULE$.Nil())), req, streamBody);
                    }
                }
                String name2 = string;
                Codec codec4 = codec;
                Uri uri2 = (Uri)((LinearSeqOps)codec4.encode(EndpointToSttpClientBase.value$1(params))).foldLeft((Object)uri, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Uri u = (Uri)tuple2._1();
                        String v = (String)tuple2._2();
                        return u.addParam(name2, v);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple3$.MODULE$.apply((Object)uri2, req, streamBody);
            }
            if (single instanceof EndpointInput.Cookie) {
                EndpointInput.Cookie cookie = EndpointInput.Cookie$.MODULE$.unapply((EndpointInput.Cookie)single);
                String string = cookie._1();
                Codec codec = cookie._2();
                EndpointIO.Info info = cookie._3();
                String name = string;
                Codec codec5 = codec;
                PartialRequest req2 = (PartialRequest)Option$.MODULE$.option2Iterable((Option)codec5.encode(EndpointToSttpClientBase.value$1(params))).foldLeft(req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        PartialRequest r = (PartialRequest)tuple2._1();
                        String v = (String)tuple2._2();
                        return (PartialRequest)r.cookie(name, v);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple3$.MODULE$.apply((Object)uri, (Object)req2, streamBody);
            }
            if (single instanceof EndpointInput.QueryParams) {
                EndpointInput.QueryParams queryParams = EndpointInput.QueryParams$.MODULE$.unapply((EndpointInput.QueryParams)single);
                Codec codec = queryParams._1();
                EndpointIO.Info info = queryParams._2();
                Codec codec6 = codec;
                QueryParams mqp = (QueryParams)codec6.encode(EndpointToSttpClientBase.value$1(params));
                Uri uri2 = uri.addParams(mqp.toSeq());
                return Tuple3$.MODULE$.apply((Object)uri2, req, streamBody);
            }
            if (single instanceof EndpointIO.Empty) {
                EndpointIO.Empty empty = EndpointIO.Empty$.MODULE$.unapply((EndpointIO.Empty)single);
                Codec codec = empty._1();
                EndpointIO.Info info = empty._2();
                return Tuple3$.MODULE$.apply((Object)uri, req, streamBody);
            }
            if (single instanceof EndpointIO.Body) {
                EndpointIO.Body body = EndpointIO.Body$.MODULE$.unapply((EndpointIO.Body)single);
                RawBodyType rawBodyType = body._1();
                Codec codec = body._2();
                EndpointIO.Info info = body._3();
                RawBodyType bodyType = rawBodyType;
                Codec codec7 = codec;
                PartialRequest<?> req2 = this.setBody(EndpointToSttpClientBase.value$1(params), bodyType, codec7, req);
                return Tuple3$.MODULE$.apply((Object)uri, req2, streamBody);
            }
            if (single instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)single);
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                if (list instanceof .colon.colon) {
                    EndpointIO.OneOfBodyVariant oneOfBodyVariant = (EndpointIO.OneOfBodyVariant)((.colon.colon)list).head();
                    List list2 = ((.colon.colon)list).next$access$1();
                    if (oneOfBodyVariant != null) {
                        EndpointIO.OneOfBodyVariant oneOfBodyVariant2 = EndpointIO.OneOfBodyVariant$.MODULE$.unapply(oneOfBodyVariant);
                        ContentTypeRange contentTypeRange = oneOfBodyVariant2._1();
                        Either either = oneOfBodyVariant2._2();
                        if (either instanceof Left) {
                            EndpointIO.Body body = (EndpointIO.Body)((Left)either).value();
                            input = body;
                            continue;
                        }
                    }
                }
            }
            if (single instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)single);
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                if (list instanceof .colon.colon) {
                    EndpointIO.OneOfBodyVariant oneOfBodyVariant = (EndpointIO.OneOfBodyVariant)((.colon.colon)list).head();
                    List list3 = ((.colon.colon)list).next$access$1();
                    if (oneOfBodyVariant != null) {
                        EndpointIO.StreamBodyWrapper streamBodyWrapper2;
                        StreamBodyIO streamBodyIO2;
                        EndpointIO.StreamBodyWrapper streamBodyWrapper3;
                        EndpointIO.OneOfBodyVariant oneOfBodyVariant3 = EndpointIO.OneOfBodyVariant$.MODULE$.unapply(oneOfBodyVariant);
                        ContentTypeRange contentTypeRange = oneOfBodyVariant3._1();
                        Either either = oneOfBodyVariant3._2();
                        if (either instanceof Right && (streamBodyWrapper3 = (EndpointIO.StreamBodyWrapper)((Right)either).value()) instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO2 = (streamBodyWrapper2 = EndpointIO.StreamBodyWrapper$.MODULE$.unapply(streamBodyWrapper3))._1()) instanceof StreamBodyIO) {
                            StreamBodyIO streamBodyIO3 = StreamBodyIO$.MODULE$.unapply(streamBodyIO2);
                            package.Streams streams = streamBodyIO3._1();
                            Codec codec = streamBodyIO3._2();
                            EndpointIO.Info info = streamBodyIO3._3();
                            Option option = streamBodyIO3._4();
                            List list4 = streamBodyIO3._5();
                            package.Streams streams2 = streams;
                            PartialRequest req2 = (PartialRequest)req.body((InputStream)EndpointToSttpClientBase.value$1(params));
                            return Tuple3$.MODULE$.apply((Object)uri, (Object)req2, streamBody);
                        }
                    }
                }
            }
            if (single instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)single);
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                List list5 = list;
                if (!(nil$ != null ? !nil$.equals(list5) : list5 != null)) {
                    throw new RuntimeException("One of body without variants");
                }
            }
            if (single instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = EndpointIO.StreamBodyWrapper$.MODULE$.unapply((EndpointIO.StreamBodyWrapper)single))._1()) instanceof StreamBodyIO) {
                StreamBodyIO streamBodyIO4 = StreamBodyIO$.MODULE$.unapply(streamBodyIO);
                package.Streams streams = streamBodyIO4._1();
                Codec codec = streamBodyIO4._2();
                EndpointIO.Info info = streamBodyIO4._3();
                Option option = streamBodyIO4._4();
                List list = streamBodyIO4._5();
                package.Streams streams3 = streams;
                Codec codec8 = codec;
                return Tuple3$.MODULE$.apply((Object)uri, req, (Object)Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)streams3, codec8.encode(EndpointToSttpClientBase.value$1(params)))));
            }
            if (single instanceof EndpointIO.Header) {
                EndpointIO.Header header = EndpointIO.Header$.MODULE$.unapply((EndpointIO.Header)single);
                String string = header._1();
                Codec codec = header._2();
                EndpointIO.Info info = header._3();
                String name = string;
                Codec codec9 = codec;
                PartialRequest req2 = (PartialRequest)((LinearSeqOps)codec9.encode(EndpointToSttpClientBase.value$1(params))).foldLeft(req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        PartialRequest r = (PartialRequest)tuple2._1();
                        String v = (String)tuple2._2();
                        return (PartialRequest)r.header(name, v);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple3$.MODULE$.apply((Object)uri, (Object)req2, streamBody);
            }
            if (single instanceof EndpointIO.Headers) {
                EndpointIO.Headers headers = EndpointIO.Headers$.MODULE$.unapply((EndpointIO.Headers)single);
                Codec codec = headers._1();
                EndpointIO.Info info = headers._2();
                Codec codec10 = codec;
                List headers2 = (List)codec10.encode(EndpointToSttpClientBase.value$1(params));
                PartialRequest req2 = (PartialRequest)headers2.foldLeft(req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        PartialRequest r = (PartialRequest)tuple2._1();
                        Header h = (Header)tuple2._2();
                        DuplicateHeaderBehavior.Replace$ onDuplicate = HeaderNames$.MODULE$.ContentType().equalsIgnoreCase(h.name()) || HeaderNames$.MODULE$.ContentLength().equalsIgnoreCase(h.name()) ? DuplicateHeaderBehavior.Replace$.MODULE$ : DuplicateHeaderBehavior.Add$.MODULE$;
                        return (PartialRequest)r.header(h, (DuplicateHeaderBehavior)onDuplicate);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple3$.MODULE$.apply((Object)uri, (Object)req2, streamBody);
            }
            if (single instanceof EndpointIO.FixedHeader) {
                EndpointIO.FixedHeader fixedHeader = EndpointIO.FixedHeader$.MODULE$.unapply((EndpointIO.FixedHeader)single);
                Header header = fixedHeader._1();
                Codec codec = fixedHeader._2();
                EndpointIO.Info info = fixedHeader._3();
                Header h = header;
                PartialRequest req2 = (PartialRequest)req.header(h, req.header$default$2());
                return Tuple3$.MODULE$.apply((Object)uri, (Object)req2, streamBody);
            }
            if (single instanceof EndpointInput.ExtractFromRequest) {
                EndpointInput.ExtractFromRequest extractFromRequest = EndpointInput.ExtractFromRequest$.MODULE$.unapply((EndpointInput.ExtractFromRequest)single);
                Codec codec = extractFromRequest._1();
                EndpointIO.Info info = extractFromRequest._2();
                return Tuple3$.MODULE$.apply((Object)uri, req, streamBody);
            }
            if (!(single instanceof EndpointInput.Auth)) break;
            EndpointInput.Auth a = (EndpointInput.Auth)single;
            input = a.input();
        }
        if (single instanceof EndpointInput.Pair) {
            EndpointInput.Pair pair = EndpointInput.Pair$.MODULE$.unapply((EndpointInput.Pair)single);
            EndpointInput endpointInput = pair._1();
            EndpointInput endpointInput2 = pair._2();
            Function2 function2 = pair._3();
            Function1 function1 = pair._4();
            EndpointInput left = endpointInput;
            EndpointInput right = endpointInput2;
            Function1 split = function1;
            return this.handleInputPair(left, right, params, (Function1<package.Params, Tuple2<package.Params, package.Params>>)split, uri, req, streamBody);
        }
        if (single instanceof EndpointIO.Pair) {
            EndpointIO.Pair pair = EndpointIO.Pair$.MODULE$.unapply((EndpointIO.Pair)single);
            EndpointIO endpointIO = pair._1();
            EndpointIO endpointIO2 = pair._2();
            Function2 function2 = pair._3();
            Function1 function1 = pair._4();
            EndpointIO left = endpointIO;
            EndpointIO right = endpointIO2;
            Function1 split = function1;
            return this.handleInputPair((EndpointInput<?>)left, (EndpointInput<?>)right, params, (Function1<package.Params, Tuple2<package.Params, package.Params>>)split, uri, req, streamBody);
        }
        if (single instanceof EndpointInput.MappedPair) {
            EndpointInput.MappedPair mappedPair = EndpointInput.MappedPair$.MODULE$.unapply((EndpointInput.MappedPair)single);
            EndpointInput.Pair pair = mappedPair._1();
            Mapping mapping = mappedPair._2();
            EndpointInput.Pair wrapped = pair;
            Mapping codec = mapping;
            return this.handleMapped((EndpointInput<?>)wrapped, (Mapping)codec, params, uri, req, streamBody);
        }
        if (single instanceof EndpointIO.MappedPair) {
            EndpointIO.MappedPair mappedPair = EndpointIO.MappedPair$.MODULE$.unapply((EndpointIO.MappedPair)single);
            EndpointIO.Pair pair = mappedPair._1();
            Mapping mapping = mappedPair._2();
            EndpointIO.Pair wrapped = pair;
            Mapping codec = mapping;
            return this.handleMapped((EndpointInput<?>)wrapped, (Mapping)codec, params, uri, req, streamBody);
        }
        throw new MatchError((Object)single);
    }

    private Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> handleInputPair(EndpointInput<?> left, EndpointInput<?> right, package.Params params, Function1<package.Params, Tuple2<package.Params, package.Params>> split, Uri uri, PartialRequest<?> req, Option<Tuple2<package.Streams<?>, Object>> streamBody) {
        Tuple2 tuple2 = (Tuple2)split.apply((Object)params);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        package.Params leftParams = (package.Params)tuple2._1();
        package.Params rightParams = (package.Params)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)leftParams, (Object)rightParams);
        package.Params leftParams2 = (package.Params)tuple22._1();
        package.Params rightParams2 = (package.Params)tuple22._2();
        Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> tuple3 = this.setInputParams(left, leftParams2, uri, req, streamBody);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Uri uri2 = (Uri)tuple3._1();
        PartialRequest req2 = (PartialRequest)tuple3._2();
        Option streamBody2 = (Option)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)uri2, (Object)req2, (Object)streamBody2);
        Uri uri22 = (Uri)tuple32._1();
        PartialRequest req22 = (PartialRequest)tuple32._2();
        Option streamBody22 = (Option)tuple32._3();
        return this.setInputParams(right, rightParams2, uri22, req22, streamBody22);
    }

    private <II, T> Tuple3<Uri, PartialRequest<?>, Option<Tuple2<package.Streams<?>, Object>>> handleMapped(EndpointInput<?> tuple, Mapping<T, II> codec, package.Params params, Uri uri, PartialRequest<?> req, Option<Tuple2<package.Streams<?>, Object>> streamBody) {
        return this.setInputParams(tuple, (package.Params)package.ParamsAsAny$.MODULE$.apply(codec.encode(params.asAny())), uri, req, streamBody);
    }

    private <L, H, CF extends CodecFormat> PartialRequest<?> setBody(H v, RawBodyType<L> bodyType, Codec<L, H, CF> codec, PartialRequest<?> req) {
        PartialRequest partialRequest;
        boolean wasContentTypeAlreadySet = req.header(HeaderNames$.MODULE$.ContentType()).nonEmpty();
        Object encoded = codec.encode(v);
        RawBodyType<L> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            Charset charset;
            RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset charset2 = charset = stringBody._1();
            partialRequest = (PartialRequest)req.body((String)encoded, charset2.name());
        } else if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            partialRequest = (PartialRequest)req.body((byte[])encoded);
        } else if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            partialRequest = (PartialRequest)req.body((ByteBuffer)encoded);
        } else if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            partialRequest = (PartialRequest)req.body((InputStream)encoded);
        } else if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            partialRequest = (PartialRequest)req.body(((FileRange)encoded).file());
        } else if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            partialRequest = (PartialRequest)req.body((InputStream)((InputStreamRange)encoded).inputStream().apply());
        } else if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody m = (RawBodyType.MultipartBody)rawBodyType;
            scala.collection.immutable.Seq parts = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)encoded).flatMap((Function1 & Serializable)p -> m.partType(p.name()).map((Function1 & Serializable)partType -> {
                Part<BasicBodyPart> sttpPart1 = this.partToSttpPart((Part)p, (RawBodyType)partType);
                Part sttpPart2 = (Part)p.headers().foldLeft(sttpPart1, (Function2 & Serializable)(part, header) -> part.header(header, header.is(HeaderNames$.MODULE$.ContentType())));
                return (Part)p.otherDispositionParams().foldLeft((Object)sttpPart2, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        Part part = (Part)tuple2._1();
                        if (tuple22 != null) {
                            String k = (String)tuple22._1();
                            String v = (String)tuple22._2();
                            return part.dispositionParam(k, v);
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
            }));
            partialRequest = (PartialRequest)req.multipartBody((scala.collection.immutable.Seq)parts.toList());
        } else {
            throw new MatchError(rawBodyType);
        }
        PartialRequest req2 = partialRequest;
        if (wasContentTypeAlreadySet) {
            return req2;
        }
        return (PartialRequest)req2.contentType(codec.format().mediaType());
    }

    private <T> Part<BasicBodyPart> partToSttpPart(Part<T> p, RawBodyType<T> bodyType) {
        RawBodyType<T> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            Charset charset;
            RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset charset2 = charset = stringBody._1();
            return package$.MODULE$.multipart(p.name(), (String)p.body(), charset2.toString());
        }
        if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            return package$.MODULE$.multipart(p.name(), (byte[])p.body());
        }
        if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            return package$.MODULE$.multipart(p.name(), (ByteBuffer)p.body());
        }
        if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            return package$.MODULE$.multipart(p.name(), (InputStream)p.body());
        }
        if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            return package$.MODULE$.multipartFile(p.name(), ((FileRange)p.body()).file());
        }
        if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            return package$.MODULE$.multipart(p.name(), (InputStream)((InputStreamRange)p.body()).inputStream().apply());
        }
        if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody multipartBody = RawBodyType.MultipartBody$.MODULE$.unapply((RawBodyType.MultipartBody)rawBodyType);
            Map map = multipartBody._1();
            Option option = multipartBody._2();
            throw new IllegalArgumentException("Nested multipart bodies aren't supported");
        }
        throw new MatchError(rawBodyType);
    }

    private static Uri $anonfun$1() {
        return Uri$.MODULE$.apply((Option)None$.MODULE$, (Option)None$.MODULE$, (Uri.PathSegments)Uri.EmptyPath$.MODULE$, (scala.collection.immutable.Seq)scala.package$.MODULE$.Nil(), (Option)None$.MODULE$);
    }

    private static String prepareRequestWithInput$$anonfun$1() {
        return Method$.MODULE$.GET();
    }

    private static ResponseAs outToResponseAs$$anonfun$2() {
        return package$.MODULE$.ignore();
    }

    private static Object value$1(package.Params params$1) {
        return params$1.asAny();
    }
}

