/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.client.sttp.ws.pekkohttp;

import java.io.Serializable;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Right;
import sttp.capabilities.pekko.PekkoStreams;
import sttp.tapir.DecodeResult;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.client.sttp.WebSocketToPipe;
import sttp.tapir.model.WebSocketFrameDecodeFailure;
import sttp.ws.WebSocket;
import sttp.ws.WebSocketFrame;

public class WebSocketToPekkoPipe<R>
implements WebSocketToPipe<R> {
    private final ExecutionContext ec;

    public WebSocketToPekkoPipe(ExecutionContext ec) {
        this.ec = ec;
    }

    @Override
    public <REQ, RESP> Object apply(Object s, WebSocket<Future> ws, WebSocketBodyOutput<Object, REQ, RESP, ?, PekkoStreams> o) {
        Sink sink = ((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)h -> (WebSocketFrame)o.requests().encode(h)).mapAsync(1, (Function1 & Serializable)_$1 -> (Future)ws.send(_$1, false))).to((Graph)Sink$.MODULE$.ignore());
        Source source = (Source)Source$.MODULE$.repeat((Function0 & Serializable)() -> (Future)ws.receive()).mapAsync(1, (Function1 & Serializable)lazyFuture -> (Future)lazyFuture.apply()).mapAsync(1, (Function1 & Serializable)x$1 -> {
            WebSocketFrame webSocketFrame = x$1;
            if (webSocketFrame instanceof WebSocketFrame.Close && !o.decodeCloseResponses()) {
                return Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$));
            }
            if (webSocketFrame instanceof WebSocketFrame.Pong && o.ignorePong()) {
                return Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)BoxedUnit.UNIT));
            }
            if (webSocketFrame instanceof WebSocketFrame.Ping) {
                byte[] byArray;
                WebSocketFrame.Ping ping = WebSocketFrame.Ping$.MODULE$.unapply((WebSocketFrame.Ping)webSocketFrame);
                byte[] p = byArray = ping._1();
                if (o.autoPongOnPing()) {
                    return ((Future)ws.send((WebSocketFrame)WebSocketFrame.Pong$.MODULE$.apply(p), ws.send$default$2())).map((Function1 & Serializable)_$2 -> package$.MODULE$.Left().apply((Object)BoxedUnit.UNIT), this.ec);
                }
            }
            WebSocketFrame f = webSocketFrame;
            DecodeResult decodeResult = o.responses().decode((Object)f);
            if (decodeResult instanceof DecodeResult.Failure) {
                DecodeResult.Failure failure = (DecodeResult.Failure)decodeResult;
                return Future$.MODULE$.failed((Throwable)new WebSocketFrameDecodeFailure(f, failure));
            }
            if (decodeResult instanceof DecodeResult.Value) {
                Object object;
                DecodeResult.Value value = DecodeResult.Value$.MODULE$.unapply((DecodeResult.Value)decodeResult);
                Object v = object = value._1();
                return Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply(v)));
            }
            throw new MatchError((Object)decodeResult);
        }).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Right) {
                    Option d = (Option)((Right)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Right) {
                    Option d = (Option)((Right)either).value();
                    return d;
                }
                return function1.apply((Object)x);
            }
        }).takeWhile((Function1 & Serializable)_$3 -> _$3.isDefined()).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Option x) {
                Option option = x;
                if (option instanceof Some) {
                    Object d = ((Some)option).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                Option option = x;
                if (option instanceof Some) {
                    Object d = ((Some)option).value();
                    return d;
                }
                return function1.apply((Object)x);
            }
        });
        return Flow$.MODULE$.fromSinkAndSource((Graph)sink, (Graph)source);
    }
}

