/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.client.sttp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.capabilities.package;
import sttp.client3.ConditionalResponseAs;
import sttp.client3.ConditionalResponseAs$;
import sttp.client3.RequestBody;
import sttp.client3.RequestT;
import sttp.client3.ResponseAs;
import sttp.model.ContentTypeRange;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.Part;
import sttp.model.QueryParams;
import sttp.model.ResponseMetadata;
import sttp.model.Uri;
import sttp.model.Uri$;
import sttp.tapir.Codec;
import sttp.tapir.CodecFormat;
import sttp.tapir.DecodeResult;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.EndpointOutput;
import sttp.tapir.FileRange;
import sttp.tapir.FileRange$;
import sttp.tapir.InputStreamRange;
import sttp.tapir.InputStreamRange$;
import sttp.tapir.Mapping;
import sttp.tapir.RawBodyType;
import sttp.tapir.StreamBodyIO;
import sttp.tapir.StreamBodyIO$;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.client.ClientOutputParams;
import sttp.tapir.client.sttp.EndpointToSttpClientExtensions;
import sttp.tapir.client.sttp.SttpClientOptions;
import sttp.tapir.client.sttp.WebSocketToPipe;
import sttp.tapir.internal.package;
import sttp.ws.WebSocket;

public class EndpointToSttpClient<R>
implements EndpointToSttpClientExtensions {
    private int webSocketSuccessStatusCode;
    private final SttpClientOptions clientOptions;
    public final WebSocketToPipe<R> sttp$tapir$client$sttp$EndpointToSttpClient$$wsToPipe;
    private final ClientOutputParams clientOutputParams;

    public EndpointToSttpClient(SttpClientOptions clientOptions, WebSocketToPipe<R> wsToPipe) {
        this.clientOptions = clientOptions;
        this.sttp$tapir$client$sttp$EndpointToSttpClient$$wsToPipe = wsToPipe;
        EndpointToSttpClientExtensions.$init$(this);
        this.clientOutputParams = new ClientOutputParams(this){
            private final /* synthetic */ EndpointToSttpClient $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public DecodeResult decodeWebSocketBody(WebSocketBodyOutput o, Object body) {
                package.Streams streams = o.streams();
                return o.codec().decode(this.$outer.sttp$tapir$client$sttp$EndpointToSttpClient$$wsToPipe.apply(streams, (WebSocket<Object>)((WebSocket)body), o));
            }
        };
        Statics.releaseFence();
    }

    @Override
    public int webSocketSuccessStatusCode() {
        return this.webSocketSuccessStatusCode;
    }

    @Override
    public void sttp$tapir$client$sttp$EndpointToSttpClientExtensions$_setter_$webSocketSuccessStatusCode_$eq(int x$0) {
        this.webSocketSuccessStatusCode = x$0;
    }

    public <A, E, O, I> Function1<A, Function1<I, RequestT<Object, DecodeResult<Either<E, O>>, R>>> toSttpRequest(Endpoint<A, I, E, O, R> e, Option<Uri> baseUri) {
        return (Function1 & Serializable)aParams -> (Function1 & Serializable)iParams -> {
            Tuple2<Uri, RequestT<None$, ?, ?>> tuple2 = this.setInputParams(e.securityInput(), (package.Params)package.ParamsAsAny$.MODULE$.apply(aParams), (Uri)baseUri.getOrElse(EndpointToSttpClient::$anonfun$1), sttp.client3.package$.MODULE$.basicRequest());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Uri uri1 = (Uri)tuple2._1();
            RequestT req1 = (RequestT)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)uri1, (Object)req1);
            Uri uri12 = (Uri)tuple22._1();
            RequestT req12 = (RequestT)tuple22._2();
            Tuple2<Uri, RequestT<None$, ?, ?>> tuple23 = this.setInputParams(e.input(), (package.Params)package.ParamsAsAny$.MODULE$.apply(iParams), uri12, req12);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            Uri uri2 = (Uri)tuple23._1();
            RequestT req2 = (RequestT)tuple23._2();
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)uri2, (Object)req2);
            Uri uri22 = (Uri)tuple24._1();
            RequestT req22 = (RequestT)tuple24._2();
            RequestT req3 = req22.copy((Object)new Method(Method$.MODULE$.apply(((Method)e.method().getOrElse((Function0 & Serializable)() -> new Method(EndpointToSttpClient.$anonfun$2()))).method())), (Object)uri22, req22.copy$default$3(), req22.copy$default$4(), req22.copy$default$5(), req22.copy$default$6(), req22.copy$default$7());
            boolean isWebSocket = this.bodyIsWebSocket(e.output());
            ResponseAs responseAs = sttp.client3.package$.MODULE$.fromMetadata(this.responseAsFromOutputs(e.errorOutput(), false), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConditionalResponseAs[]{ConditionalResponseAs$.MODULE$.apply((Function1 & Serializable)meta -> this.isSuccess$1(isWebSocket, (ResponseMetadata)meta), this.responseAsFromOutputs(e.output(), isWebSocket))})).mapWithMetadata((Function2 & Serializable)(body, meta) -> {
                EndpointOutput output = this.isSuccess$1(isWebSocket, (ResponseMetadata)meta) ? e.output() : e.errorOutput();
                DecodeResult params = this.clientOutputParams.apply(output, body, meta);
                return params.map((Function1 & Serializable)_$1 -> _$1.asAny()).map((Function1 & Serializable)p -> {
                    if (this.isSuccess$1(isWebSocket, (ResponseMetadata)meta)) {
                        return package$.MODULE$.Right().apply(p);
                    }
                    return package$.MODULE$.Left().apply(p);
                });
            }).map((Function1 & Serializable)x$1 -> {
                DecodeResult decodeResult = x$1;
                if (decodeResult instanceof DecodeResult.Error) {
                    DecodeResult.Error error = DecodeResult.Error$.MODULE$.unapply((DecodeResult.Error)decodeResult);
                    String string = error._1();
                    Throwable throwable = error._2();
                    String o = string;
                    Throwable e = throwable;
                    return DecodeResult.Error$.MODULE$.apply(o, (Throwable)new IllegalArgumentException(new StringBuilder(32).append("Cannot decode from: ").append(o).append(", request: ").append(req3.method()).append(" ").append(req3.uri()).toString(), e));
                }
                DecodeResult other = decodeResult;
                return other;
            });
            return req3.response(responseAs);
        };
    }

    private <I> Tuple2<Uri, RequestT<None$, ?, ?>> setInputParams(EndpointInput<I> input, package.Params params, Uri uri, RequestT<None$, ?, ?> req) {
        EndpointInput.Single single;
        while (true) {
            EndpointIO.StreamBodyWrapper streamBodyWrapper;
            StreamBodyIO streamBodyIO;
            if ((single = input) instanceof EndpointInput.FixedMethod) {
                EndpointInput.FixedMethod fixedMethod = EndpointInput.FixedMethod$.MODULE$.unapply((EndpointInput.FixedMethod)single);
                String string = fixedMethod._1();
                Codec codec = fixedMethod._2();
                EndpointIO.Info info = fixedMethod._3();
                return Tuple2$.MODULE$.apply((Object)uri, req);
            }
            if (single instanceof EndpointInput.FixedPath) {
                EndpointInput.FixedPath fixedPath = EndpointInput.FixedPath$.MODULE$.unapply((EndpointInput.FixedPath)single);
                String string = fixedPath._1();
                Codec codec = fixedPath._2();
                EndpointIO.Info info = fixedPath._3();
                String p = string;
                return Tuple2$.MODULE$.apply((Object)uri.addPath(p, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])), req);
            }
            if (single instanceof EndpointInput.PathCapture) {
                EndpointInput.PathCapture pathCapture = EndpointInput.PathCapture$.MODULE$.unapply((EndpointInput.PathCapture)single);
                Option option = pathCapture._1();
                Codec codec = pathCapture._2();
                EndpointIO.Info info = pathCapture._3();
                Codec codec2 = codec;
                String v = (String)codec2.encode(EndpointToSttpClient.value$1(params));
                return Tuple2$.MODULE$.apply((Object)uri.addPath(v, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])), req);
            }
            if (single instanceof EndpointInput.PathsCapture) {
                EndpointInput.PathsCapture pathsCapture = EndpointInput.PathsCapture$.MODULE$.unapply((EndpointInput.PathsCapture)single);
                Codec codec = pathsCapture._1();
                EndpointIO.Info info = pathsCapture._2();
                Codec codec3 = codec;
                List ps = (List)codec3.encode(EndpointToSttpClient.value$1(params));
                return Tuple2$.MODULE$.apply((Object)uri.addPath((Seq)ps), req);
            }
            if (single instanceof EndpointInput.Query) {
                EndpointInput.Query query = EndpointInput.Query$.MODULE$.unapply((EndpointInput.Query)single);
                String string = query._1();
                Option option = query._2();
                Codec codec = query._3();
                EndpointIO.Info info = query._4();
                String name = string;
                if (option instanceof Some) {
                    Object flagValue = ((Some)option).value();
                    if (BoxesRunTime.equals((Object)EndpointToSttpClient.value$1(params), (Object)flagValue)) {
                        return Tuple2$.MODULE$.apply((Object)uri.withParams(uri.params().param(name, (scala.collection.immutable.Seq)package$.MODULE$.Nil())), req);
                    }
                }
                String name2 = string;
                Codec codec4 = codec;
                Uri uri2 = (Uri)((LinearSeqOps)codec4.encode(EndpointToSttpClient.value$1(params))).foldLeft((Object)uri, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Uri u = (Uri)tuple2._1();
                        String v = (String)tuple2._2();
                        return u.addParam(name2, v);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple2$.MODULE$.apply((Object)uri2, req);
            }
            if (single instanceof EndpointInput.Cookie) {
                EndpointInput.Cookie cookie = EndpointInput.Cookie$.MODULE$.unapply((EndpointInput.Cookie)single);
                String string = cookie._1();
                Codec codec = cookie._2();
                EndpointIO.Info info = cookie._3();
                String name = string;
                Codec codec5 = codec;
                RequestT req2 = (RequestT)Option$.MODULE$.option2Iterable((Option)codec5.encode(EndpointToSttpClient.value$1(params))).foldLeft(req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        RequestT r = (RequestT)tuple2._1();
                        String v = (String)tuple2._2();
                        return r.cookie(name, v);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple2$.MODULE$.apply((Object)uri, (Object)req2);
            }
            if (single instanceof EndpointInput.QueryParams) {
                EndpointInput.QueryParams queryParams = EndpointInput.QueryParams$.MODULE$.unapply((EndpointInput.QueryParams)single);
                Codec codec = queryParams._1();
                EndpointIO.Info info = queryParams._2();
                Codec codec6 = codec;
                QueryParams mqp = (QueryParams)codec6.encode(EndpointToSttpClient.value$1(params));
                Uri uri2 = uri.addParams(mqp.toSeq());
                return Tuple2$.MODULE$.apply((Object)uri2, req);
            }
            if (single instanceof EndpointIO.Empty) {
                EndpointIO.Empty empty = EndpointIO.Empty$.MODULE$.unapply((EndpointIO.Empty)single);
                Codec codec = empty._1();
                EndpointIO.Info info = empty._2();
                return Tuple2$.MODULE$.apply((Object)uri, req);
            }
            if (single instanceof EndpointIO.Body) {
                EndpointIO.Body body = EndpointIO.Body$.MODULE$.unapply((EndpointIO.Body)single);
                RawBodyType rawBodyType = body._1();
                Codec codec = body._2();
                EndpointIO.Info info = body._3();
                RawBodyType bodyType = rawBodyType;
                Codec codec7 = codec;
                RequestT<None$, ?, ?> req2 = this.setBody(EndpointToSttpClient.value$1(params), bodyType, codec7, req);
                return Tuple2$.MODULE$.apply((Object)uri, req2);
            }
            if (single instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)single);
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                if (list instanceof .colon.colon) {
                    EndpointIO.OneOfBodyVariant oneOfBodyVariant = (EndpointIO.OneOfBodyVariant)((.colon.colon)list).head();
                    List list2 = ((.colon.colon)list).next$access$1();
                    if (oneOfBodyVariant != null) {
                        EndpointIO.OneOfBodyVariant oneOfBodyVariant2 = EndpointIO.OneOfBodyVariant$.MODULE$.unapply(oneOfBodyVariant);
                        ContentTypeRange contentTypeRange = oneOfBodyVariant2._1();
                        Either either = oneOfBodyVariant2._2();
                        if (either instanceof Left) {
                            EndpointIO.Body body = (EndpointIO.Body)((Left)either).value();
                            input = body;
                            continue;
                        }
                    }
                }
            }
            if (single instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)single);
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                if (list instanceof .colon.colon) {
                    EndpointIO.OneOfBodyVariant oneOfBodyVariant = (EndpointIO.OneOfBodyVariant)((.colon.colon)list).head();
                    List list3 = ((.colon.colon)list).next$access$1();
                    if (oneOfBodyVariant != null) {
                        EndpointIO.StreamBodyWrapper streamBodyWrapper2;
                        StreamBodyIO streamBodyIO2;
                        EndpointIO.StreamBodyWrapper streamBodyWrapper3;
                        EndpointIO.OneOfBodyVariant oneOfBodyVariant3 = EndpointIO.OneOfBodyVariant$.MODULE$.unapply(oneOfBodyVariant);
                        ContentTypeRange contentTypeRange = oneOfBodyVariant3._1();
                        Either either = oneOfBodyVariant3._2();
                        if (either instanceof Right && (streamBodyWrapper3 = (EndpointIO.StreamBodyWrapper)((Right)either).value()) instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO2 = (streamBodyWrapper2 = EndpointIO.StreamBodyWrapper$.MODULE$.unapply(streamBodyWrapper3))._1()) instanceof StreamBodyIO) {
                            StreamBodyIO streamBodyIO3 = StreamBodyIO$.MODULE$.unapply(streamBodyIO2);
                            package.Streams streams = streamBodyIO3._1();
                            Codec codec = streamBodyIO3._2();
                            EndpointIO.Info info = streamBodyIO3._3();
                            Option option = streamBodyIO3._4();
                            List list4 = streamBodyIO3._5();
                            package.Streams streams2 = streams;
                            RequestT req2 = req.streamBody(streams2, EndpointToSttpClient.value$1(params));
                            return Tuple2$.MODULE$.apply((Object)uri, (Object)req2);
                        }
                    }
                }
            }
            if (single instanceof EndpointIO.OneOfBody) {
                EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)single);
                List list = oneOfBody._1();
                Mapping mapping = oneOfBody._2();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list5 = list;
                if (!(nil$ != null ? !nil$.equals(list5) : list5 != null)) {
                    throw new RuntimeException("One of body without variants");
                }
            }
            if (single instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = EndpointIO.StreamBodyWrapper$.MODULE$.unapply((EndpointIO.StreamBodyWrapper)single))._1()) instanceof StreamBodyIO) {
                StreamBodyIO streamBodyIO4 = StreamBodyIO$.MODULE$.unapply(streamBodyIO);
                package.Streams streams = streamBodyIO4._1();
                Codec codec = streamBodyIO4._2();
                EndpointIO.Info info = streamBodyIO4._3();
                Option option = streamBodyIO4._4();
                List list = streamBodyIO4._5();
                package.Streams streams3 = streams;
                RequestT req2 = req.streamBody(streams3, EndpointToSttpClient.value$1(params));
                return Tuple2$.MODULE$.apply((Object)uri, (Object)req2);
            }
            if (single instanceof EndpointIO.Header) {
                EndpointIO.Header header = EndpointIO.Header$.MODULE$.unapply((EndpointIO.Header)single);
                String string = header._1();
                Codec codec = header._2();
                EndpointIO.Info info = header._3();
                String name = string;
                Codec codec8 = codec;
                RequestT req2 = (RequestT)((LinearSeqOps)codec8.encode(EndpointToSttpClient.value$1(params))).foldLeft(req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        RequestT r = (RequestT)tuple2._1();
                        String v = (String)tuple2._2();
                        return r.header(name, v);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple2$.MODULE$.apply((Object)uri, (Object)req2);
            }
            if (single instanceof EndpointIO.Headers) {
                EndpointIO.Headers headers = EndpointIO.Headers$.MODULE$.unapply((EndpointIO.Headers)single);
                Codec codec = headers._1();
                EndpointIO.Info info = headers._2();
                Codec codec9 = codec;
                List headers2 = (List)codec9.encode(EndpointToSttpClient.value$1(params));
                RequestT req2 = (RequestT)headers2.foldLeft(req, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        RequestT r = (RequestT)tuple2._1();
                        Header h = (Header)tuple2._2();
                        boolean replaceExisting = HeaderNames$.MODULE$.ContentType().equalsIgnoreCase(h.name()) || HeaderNames$.MODULE$.ContentLength().equalsIgnoreCase(h.name());
                        return r.header(h, replaceExisting);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Tuple2$.MODULE$.apply((Object)uri, (Object)req2);
            }
            if (single instanceof EndpointIO.FixedHeader) {
                EndpointIO.FixedHeader fixedHeader = EndpointIO.FixedHeader$.MODULE$.unapply((EndpointIO.FixedHeader)single);
                Header header = fixedHeader._1();
                Codec codec = fixedHeader._2();
                EndpointIO.Info info = fixedHeader._3();
                Header h = header;
                RequestT req2 = req.header(h, req.header$default$2());
                return Tuple2$.MODULE$.apply((Object)uri, (Object)req2);
            }
            if (single instanceof EndpointInput.ExtractFromRequest) {
                EndpointInput.ExtractFromRequest extractFromRequest = EndpointInput.ExtractFromRequest$.MODULE$.unapply((EndpointInput.ExtractFromRequest)single);
                Codec codec = extractFromRequest._1();
                EndpointIO.Info info = extractFromRequest._2();
                return Tuple2$.MODULE$.apply((Object)uri, req);
            }
            if (!(single instanceof EndpointInput.Auth)) break;
            EndpointInput.Auth a = (EndpointInput.Auth)single;
            input = a.input();
        }
        if (single instanceof EndpointInput.Pair) {
            EndpointInput.Pair pair = EndpointInput.Pair$.MODULE$.unapply((EndpointInput.Pair)single);
            EndpointInput endpointInput = pair._1();
            EndpointInput endpointInput2 = pair._2();
            Function2 function2 = pair._3();
            Function1 function1 = pair._4();
            EndpointInput left = endpointInput;
            EndpointInput right = endpointInput2;
            Function1 split = function1;
            return this.handleInputPair(left, right, params, (Function1<package.Params, Tuple2<package.Params, package.Params>>)split, uri, req);
        }
        if (single instanceof EndpointIO.Pair) {
            EndpointIO.Pair pair = EndpointIO.Pair$.MODULE$.unapply((EndpointIO.Pair)single);
            EndpointIO endpointIO = pair._1();
            EndpointIO endpointIO2 = pair._2();
            Function2 function2 = pair._3();
            Function1 function1 = pair._4();
            EndpointIO left = endpointIO;
            EndpointIO right = endpointIO2;
            Function1 split = function1;
            return this.handleInputPair((EndpointInput<?>)left, (EndpointInput<?>)right, params, (Function1<package.Params, Tuple2<package.Params, package.Params>>)split, uri, req);
        }
        if (single instanceof EndpointInput.MappedPair) {
            EndpointInput.MappedPair mappedPair = EndpointInput.MappedPair$.MODULE$.unapply((EndpointInput.MappedPair)single);
            EndpointInput.Pair pair = mappedPair._1();
            Mapping mapping = mappedPair._2();
            EndpointInput.Pair wrapped = pair;
            Mapping codec = mapping;
            return this.handleMapped((EndpointInput<?>)wrapped, (Mapping)codec, params, uri, req);
        }
        if (single instanceof EndpointIO.MappedPair) {
            EndpointIO.MappedPair mappedPair = EndpointIO.MappedPair$.MODULE$.unapply((EndpointIO.MappedPair)single);
            EndpointIO.Pair pair = mappedPair._1();
            Mapping mapping = mappedPair._2();
            EndpointIO.Pair wrapped = pair;
            Mapping codec = mapping;
            return this.handleMapped((EndpointInput<?>)wrapped, (Mapping)codec, params, uri, req);
        }
        throw new MatchError((Object)single);
    }

    public Tuple2<Uri, RequestT<None$, ?, ?>> handleInputPair(EndpointInput<?> left, EndpointInput<?> right, package.Params params, Function1<package.Params, Tuple2<package.Params, package.Params>> split, Uri uri, RequestT<None$, ?, ?> req) {
        Tuple2 tuple2 = (Tuple2)split.apply((Object)params);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        package.Params leftParams = (package.Params)tuple2._1();
        package.Params rightParams = (package.Params)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)leftParams, (Object)rightParams);
        package.Params leftParams2 = (package.Params)tuple22._1();
        package.Params rightParams2 = (package.Params)tuple22._2();
        Tuple2<Uri, RequestT<None$, ?, ?>> tuple23 = this.setInputParams(left, leftParams2, uri, req);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Uri uri2 = (Uri)tuple23._1();
        RequestT req2 = (RequestT)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)uri2, (Object)req2);
        Uri uri22 = (Uri)tuple24._1();
        RequestT req22 = (RequestT)tuple24._2();
        return this.setInputParams(right, rightParams2, uri22, req22);
    }

    private <II, T> Tuple2<Uri, RequestT<None$, ?, ?>> handleMapped(EndpointInput<?> tuple, Mapping<T, II> codec, package.Params params, Uri uri, RequestT<None$, ?, ?> req) {
        return this.setInputParams(tuple, (package.Params)package.ParamsAsAny$.MODULE$.apply(codec.encode(params.asAny())), uri, req);
    }

    private <L, H, CF extends CodecFormat> RequestT<None$, ?, ?> setBody(H v, RawBodyType<L> bodyType, Codec<L, H, CF> codec, RequestT<None$, ?, ?> req) {
        RequestT requestT;
        boolean wasContentTypeAlreadySet = req.header(HeaderNames$.MODULE$.ContentType()).nonEmpty();
        Object encoded = codec.encode(v);
        RawBodyType<L> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            Charset charset;
            RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset charset2 = charset = stringBody._1();
            requestT = req.body((String)encoded, charset2.name());
        } else if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            requestT = req.body((byte[])encoded);
        } else if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            requestT = req.body((ByteBuffer)encoded);
        } else if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            requestT = req.body((InputStream)encoded);
        } else if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            requestT = req.body(((FileRange)encoded).file());
        } else if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            requestT = req.body((InputStream)((InputStreamRange)encoded).inputStream().apply());
        } else if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody m = (RawBodyType.MultipartBody)rawBodyType;
            scala.collection.immutable.Seq parts = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)encoded).flatMap((Function1 & Serializable)p -> m.partType(p.name()).map((Function1 & Serializable)partType -> {
                Part<RequestBody<Object>> sttpPart1 = this.partToSttpPart((Part)p, (RawBodyType)partType);
                Part sttpPart2 = (Part)p.headers().foldLeft(sttpPart1, (Function2 & Serializable)(part, header) -> part.header(header, header.is(HeaderNames$.MODULE$.ContentType())));
                return (Part)p.otherDispositionParams().foldLeft((Object)sttpPart2, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        Part part = (Part)tuple2._1();
                        if (tuple22 != null) {
                            String k = (String)tuple22._1();
                            String v = (String)tuple22._2();
                            return part.dispositionParam(k, v);
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
            }));
            requestT = req.multipartBody((scala.collection.immutable.Seq)parts.toList());
        } else {
            throw new MatchError(rawBodyType);
        }
        RequestT req2 = requestT;
        if (wasContentTypeAlreadySet) {
            return req2;
        }
        return req2.contentType(codec.format().mediaType());
    }

    private <T> Part<RequestBody<Object>> partToSttpPart(Part<T> p, RawBodyType<T> bodyType) {
        RawBodyType<T> rawBodyType = bodyType;
        if (rawBodyType instanceof RawBodyType.StringBody) {
            Charset charset;
            RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
            Charset charset2 = charset = stringBody._1();
            return sttp.client3.package$.MODULE$.multipart(p.name(), (String)p.body(), charset2.toString());
        }
        if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
            return sttp.client3.package$.MODULE$.multipart(p.name(), (byte[])p.body());
        }
        if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
            return sttp.client3.package$.MODULE$.multipart(p.name(), (ByteBuffer)p.body());
        }
        if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
            return sttp.client3.package$.MODULE$.multipart(p.name(), (InputStream)p.body());
        }
        if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
            return sttp.client3.package$.MODULE$.multipartFile(p.name(), ((FileRange)p.body()).file());
        }
        if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
            return sttp.client3.package$.MODULE$.multipart(p.name(), (InputStream)((InputStreamRange)p.body()).inputStream().apply());
        }
        if (rawBodyType instanceof RawBodyType.MultipartBody) {
            RawBodyType.MultipartBody multipartBody = RawBodyType.MultipartBody$.MODULE$.unapply((RawBodyType.MultipartBody)rawBodyType);
            Map map = multipartBody._1();
            Option option = multipartBody._2();
            throw new IllegalArgumentException("Nested multipart bodies aren't supported");
        }
        throw new MatchError(rawBodyType);
    }

    private ResponseAs<Object, Object> responseAsFromOutputs(EndpointOutput<?> out, boolean isWebSocket) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.bodyIsStream(out), (Object)BoxesRunTime.boxToBoolean((boolean)isWebSocket));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
            if (option instanceof Some) {
                package.Streams streams = (package.Streams)((Some)option).value();
                return sttp.client3.package$.MODULE$.asStreamAlwaysUnsafe(streams);
            }
            if (bl) {
                return sttp.client3.package$.MODULE$.asWebSocketAlwaysUnsafe();
            }
            if (None$.MODULE$.equals(option) && !bl) {
                return (ResponseAs)sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(out).bodyType().map((Function1 & Serializable)x$1 -> {
                    RawBodyType rawBodyType = x$1;
                    if (rawBodyType instanceof RawBodyType.StringBody) {
                        Charset charset;
                        RawBodyType.StringBody stringBody = RawBodyType.StringBody$.MODULE$.unapply((RawBodyType.StringBody)rawBodyType);
                        Charset charset2 = charset = stringBody._1();
                        return sttp.client3.package$.MODULE$.asStringAlways(charset2.name());
                    }
                    if (RawBodyType.ByteArrayBody$.MODULE$.equals(rawBodyType)) {
                        return sttp.client3.package$.MODULE$.asByteArrayAlways();
                    }
                    if (RawBodyType.ByteBufferBody$.MODULE$.equals(rawBodyType)) {
                        return sttp.client3.package$.MODULE$.asByteArrayAlways().map((Function1 & Serializable)x$0 -> ByteBuffer.wrap(x$0));
                    }
                    if (RawBodyType.InputStreamBody$.MODULE$.equals(rawBodyType)) {
                        return sttp.client3.package$.MODULE$.asByteArrayAlways().map((Function1 & Serializable)_$2 -> new ByteArrayInputStream((byte[])_$2));
                    }
                    if (RawBodyType.FileBody$.MODULE$.equals(rawBodyType)) {
                        return sttp.client3.package$.MODULE$.asFileAlways((File)this.clientOptions.createFile().apply()).map((Function1 & Serializable)d -> FileRange$.MODULE$.apply(d, FileRange$.MODULE$.$lessinit$greater$default$2()));
                    }
                    if (RawBodyType.InputStreamRangeBody$.MODULE$.equals(rawBodyType)) {
                        return sttp.client3.package$.MODULE$.asByteArrayAlways().map((Function1 & Serializable)b -> InputStreamRange$.MODULE$.apply((Function0 & Serializable)() -> new ByteArrayInputStream((byte[])b), InputStreamRange$.MODULE$.$lessinit$greater$default$2()));
                    }
                    if (rawBodyType instanceof RawBodyType.MultipartBody) {
                        RawBodyType.MultipartBody multipartBody = RawBodyType.MultipartBody$.MODULE$.unapply((RawBodyType.MultipartBody)rawBodyType);
                        Map map = multipartBody._1();
                        Option option = multipartBody._2();
                        throw new IllegalArgumentException("Multipart bodies aren't supported in responses");
                    }
                    throw new MatchError((Object)rawBodyType);
                }).getOrElse(EndpointToSttpClient::responseAsFromOutputs$$anonfun$2);
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private <I> Option<package.Streams<?>> bodyIsStream(EndpointOutput<I> out) {
        return sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(out).traverseOutputs((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(EndpointOutput x) {
                EndpointIO.StreamBodyWrapper streamBodyWrapper;
                StreamBodyIO streamBodyIO;
                EndpointOutput endpointOutput = x;
                if (endpointOutput instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = EndpointIO.StreamBodyWrapper$.MODULE$.unapply((EndpointIO.StreamBodyWrapper)endpointOutput))._1()) instanceof StreamBodyIO) {
                    StreamBodyIO streamBodyIO2 = StreamBodyIO$.MODULE$.unapply(streamBodyIO);
                    package.Streams streams = streamBodyIO2._1();
                    Codec codec = streamBodyIO2._2();
                    EndpointIO.Info info = streamBodyIO2._3();
                    Option option = streamBodyIO2._4();
                    List list = streamBodyIO2._5();
                    package.Streams streams2 = streams;
                    return true;
                }
                if (endpointOutput instanceof EndpointIO.OneOfBody) {
                    EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)endpointOutput);
                    List list = oneOfBody._1();
                    Mapping mapping = oneOfBody._2();
                    List variants = list;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(EndpointOutput x, Function1 function1) {
                EndpointIO.StreamBodyWrapper streamBodyWrapper;
                StreamBodyIO streamBodyIO;
                EndpointOutput endpointOutput = x;
                if (endpointOutput instanceof EndpointIO.StreamBodyWrapper && (streamBodyIO = (streamBodyWrapper = EndpointIO.StreamBodyWrapper$.MODULE$.unapply((EndpointIO.StreamBodyWrapper)endpointOutput))._1()) instanceof StreamBodyIO) {
                    StreamBodyIO streamBodyIO2 = StreamBodyIO$.MODULE$.unapply(streamBodyIO);
                    package.Streams streams = streamBodyIO2._1();
                    Codec codec = streamBodyIO2._2();
                    EndpointIO.Info info = streamBodyIO2._3();
                    Option option = streamBodyIO2._4();
                    List list = streamBodyIO2._5();
                    package.Streams streams2 = streams;
                    return (Vector)package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.Streams[]{streams2}));
                }
                if (endpointOutput instanceof EndpointIO.OneOfBody) {
                    EndpointIO.OneOfBody oneOfBody = EndpointIO.OneOfBody$.MODULE$.unapply((EndpointIO.OneOfBody)endpointOutput);
                    List list = oneOfBody._1();
                    Mapping mapping = oneOfBody._2();
                    List variants = list;
                    return variants.flatMap(EndpointToSttpClient::sttp$tapir$client$sttp$EndpointToSttpClient$$anon$2$$_$applyOrElse$$anonfun$1).map(EndpointToSttpClient::sttp$tapir$client$sttp$EndpointToSttpClient$$anon$2$$_$applyOrElse$$anonfun$2).toVector();
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{sttp$tapir$client$sttp$EndpointToSttpClient$$anon$2$$_$applyOrElse$$anonfun$1(sttp.tapir.EndpointIO$OneOfBodyVariant ), sttp$tapir$client$sttp$EndpointToSttpClient$$anon$2$$_$applyOrElse$$anonfun$2(sttp.tapir.EndpointIO$StreamBodyWrapper )}, serializedLambda);
            }
        }).headOption();
    }

    private <I> boolean bodyIsWebSocket(EndpointOutput<I> out) {
        return sttp.tapir.internal.package$.MODULE$.RichEndpointOutput(out).traverseOutputs((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(EndpointOutput x) {
                EndpointOutput endpointOutput = x;
                if (endpointOutput instanceof EndpointOutput.WebSocketBodyWrapper) {
                    EndpointOutput.WebSocketBodyWrapper webSocketBodyWrapper = EndpointOutput.WebSocketBodyWrapper$.MODULE$.unapply((EndpointOutput.WebSocketBodyWrapper)endpointOutput);
                    WebSocketBodyOutput webSocketBodyOutput = webSocketBodyWrapper._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(EndpointOutput x, Function1 function1) {
                EndpointOutput endpointOutput = x;
                if (endpointOutput instanceof EndpointOutput.WebSocketBodyWrapper) {
                    EndpointOutput.WebSocketBodyWrapper webSocketBodyWrapper = EndpointOutput.WebSocketBodyWrapper$.MODULE$.unapply((EndpointOutput.WebSocketBodyWrapper)endpointOutput);
                    WebSocketBodyOutput webSocketBodyOutput = webSocketBodyWrapper._1();
                    return package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapUnitArray(new BoxedUnit[]{BoxedUnit.UNIT}));
                }
                return function1.apply((Object)x);
            }
        }).nonEmpty();
    }

    private static final Uri $anonfun$1() {
        return Uri$.MODULE$.apply((Option)None$.MODULE$, (Option)None$.MODULE$, (Uri.PathSegments)Uri.EmptyPath$.MODULE$, (scala.collection.immutable.Seq)package$.MODULE$.Nil(), (Option)None$.MODULE$);
    }

    private static final String $anonfun$2() {
        return Method$.MODULE$.GET();
    }

    private final boolean isSuccess$1(boolean isWebSocket$1, ResponseMetadata meta) {
        if (isWebSocket$1) {
            return meta.code() == this.webSocketSuccessStatusCode();
        }
        return meta.isSuccess();
    }

    private static final Object value$1(package.Params params$1) {
        return params$1.asAny();
    }

    private static final ResponseAs responseAsFromOutputs$$anonfun$2() {
        return sttp.client3.package$.MODULE$.ignore();
    }

    public static final /* synthetic */ IterableOnce sttp$tapir$client$sttp$EndpointToSttpClient$$anon$2$$_$applyOrElse$$anonfun$1(EndpointIO.OneOfBodyVariant _$3) {
        return _$3.body().toOption();
    }

    public static final /* synthetic */ package.Streams sttp$tapir$client$sttp$EndpointToSttpClient$$anon$2$$_$applyOrElse$$anonfun$2(EndpointIO.StreamBodyWrapper _$4) {
        return _$4.wrapped().streams();
    }
}

