/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.client.sttp;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.client3.RequestT;
import sttp.client3.SttpBackend;
import sttp.model.Uri;
import sttp.tapir.DecodeResult;
import sttp.tapir.Endpoint;
import sttp.tapir.client.sttp.EndpointToSttpClient;
import sttp.tapir.client.sttp.SttpClientInterpreter$;
import sttp.tapir.client.sttp.SttpClientInterpreterExtensions;
import sttp.tapir.client.sttp.SttpClientOptions;
import sttp.tapir.client.sttp.SttpClientOptions$;
import sttp.tapir.client.sttp.WebSocketToPipe;

public interface SttpClientInterpreter
extends SttpClientInterpreterExtensions {
    public static SttpClientInterpreter apply(SttpClientOptions sttpClientOptions) {
        return SttpClientInterpreter$.MODULE$.apply(sttpClientOptions);
    }

    public static SttpClientOptions apply$default$1() {
        return SttpClientInterpreter$.MODULE$.apply$default$1();
    }

    public static SttpClientOptions sttpClientOptions$(SttpClientInterpreter $this) {
        return $this.sttpClientOptions();
    }

    default public SttpClientOptions sttpClientOptions() {
        return SttpClientOptions$.MODULE$.default();
    }

    public static Function1 toClient$(SttpClientInterpreter $this, Endpoint e, Option baseUri, SttpBackend backend, WebSocketToPipe wsToPipe) {
        return $this.toClient(e, (Option<Uri>)baseUri, backend, wsToPipe);
    }

    default public <F, I, E, O, R> Function1<I, Object> toClient(Endpoint<BoxedUnit, I, E, O, R> e, Option<Uri> baseUri, SttpBackend<F, R> backend, WebSocketToPipe<R> wsToPipe) {
        Function1 req = this.toRequest(e, baseUri, wsToPipe);
        return (Function1 & Serializable)i -> backend.responseMonad().map(backend.send((RequestT)req.apply(i)), (Function1 & Serializable)_$2 -> (DecodeResult)_$2.body());
    }

    public static Function1 toClientThrowDecodeFailures$(SttpClientInterpreter $this, Endpoint e, Option baseUri, SttpBackend backend, WebSocketToPipe wsToPipe) {
        return $this.toClientThrowDecodeFailures(e, (Option<Uri>)baseUri, backend, wsToPipe);
    }

    default public <F, I, E, O, R> Function1<I, Object> toClientThrowDecodeFailures(Endpoint<BoxedUnit, I, E, O, R> e, Option<Uri> baseUri, SttpBackend<F, R> backend, WebSocketToPipe<R> wsToPipe) {
        Function1 req = this.toRequestThrowDecodeFailures(e, baseUri, wsToPipe);
        return (Function1 & Serializable)i -> backend.responseMonad().map(backend.send((RequestT)req.apply(i)), (Function1 & Serializable)_$4 -> (Either)_$4.body());
    }

    public static Function1 toClientThrowErrors$(SttpClientInterpreter $this, Endpoint e, Option baseUri, SttpBackend backend, WebSocketToPipe wsToPipe) {
        return $this.toClientThrowErrors(e, (Option<Uri>)baseUri, backend, wsToPipe);
    }

    default public <F, I, E, O, R> Function1<I, Object> toClientThrowErrors(Endpoint<BoxedUnit, I, E, O, R> e, Option<Uri> baseUri, SttpBackend<F, R> backend, WebSocketToPipe<R> wsToPipe) {
        Function1 req = this.toRequestThrowErrors(e, baseUri, wsToPipe);
        return (Function1 & Serializable)i -> backend.responseMonad().map(backend.send((RequestT)req.apply(i)), (Function1 & Serializable)_$6 -> _$6.body());
    }

    public static Function1 toRequest$(SttpClientInterpreter $this, Endpoint e, Option baseUri, WebSocketToPipe wsToPipe) {
        return $this.toRequest(e, (Option<Uri>)baseUri, wsToPipe);
    }

    default public <I, E, O, R> Function1<I, RequestT<Object, DecodeResult<Either<E, O>>, R>> toRequest(Endpoint<BoxedUnit, I, E, O, R> e, Option<Uri> baseUri, WebSocketToPipe<R> wsToPipe) {
        return (Function1)new EndpointToSttpClient<R>(this.sttpClientOptions(), wsToPipe).toSttpRequest(e, baseUri).apply((Object)BoxedUnit.UNIT);
    }

    public static Function1 toRequestThrowDecodeFailures$(SttpClientInterpreter $this, Endpoint e, Option baseUri, WebSocketToPipe wsToPipe) {
        return $this.toRequestThrowDecodeFailures(e, (Option<Uri>)baseUri, wsToPipe);
    }

    default public <I, E, O, R> Function1<I, RequestT<Object, Either<E, O>, R>> toRequestThrowDecodeFailures(Endpoint<BoxedUnit, I, E, O, R> e, Option<Uri> baseUri, WebSocketToPipe<R> wsToPipe) {
        return (Function1 & Serializable)i -> ((RequestT)((Function1)new EndpointToSttpClient(this.sttpClientOptions(), wsToPipe).toSttpRequest(e, baseUri).apply((Object)BoxedUnit.UNIT)).apply(i)).mapResponse((Function1 & Serializable)dr -> (Either)this.throwDecodeFailures((DecodeResult)dr));
    }

    public static Function1 toRequestThrowErrors$(SttpClientInterpreter $this, Endpoint e, Option baseUri, WebSocketToPipe wsToPipe) {
        return $this.toRequestThrowErrors(e, (Option<Uri>)baseUri, wsToPipe);
    }

    default public <I, E, O, R> Function1<I, RequestT<Object, O, R>> toRequestThrowErrors(Endpoint<BoxedUnit, I, E, O, R> e, Option<Uri> baseUri, WebSocketToPipe<R> wsToPipe) {
        return (Function1 & Serializable)i -> ((RequestT)((Function1)new EndpointToSttpClient(this.sttpClientOptions(), wsToPipe).toSttpRequest(e, baseUri).apply((Object)BoxedUnit.UNIT)).apply(i)).mapResponse((Function1 & Serializable)dr -> (Either)this.throwDecodeFailures((DecodeResult)dr)).mapResponse((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Object object = ((Left)either).value();
                if (object instanceof Throwable) {
                    Throwable t = (Throwable)object;
                    throw new RuntimeException(this.throwErrorExceptionMsg(e, i, t), t);
                }
                Object t = object;
                throw new RuntimeException(this.throwErrorExceptionMsg(e, i, t));
            }
            if (either instanceof Right) {
                Object o = ((Right)either).value();
                return o;
            }
            throw new MatchError((Object)either);
        });
    }

    public static Function1 toSecureClient$(SttpClientInterpreter $this, Endpoint e, Option baseUri, SttpBackend backend, WebSocketToPipe wsToPipe) {
        return $this.toSecureClient(e, (Option<Uri>)baseUri, backend, wsToPipe);
    }

    default public <F, A, I, E, O, R> Function1<A, Function1<I, Object>> toSecureClient(Endpoint<A, I, E, O, R> e, Option<Uri> baseUri, SttpBackend<F, R> backend, WebSocketToPipe<R> wsToPipe) {
        Function1 req = this.toSecureRequest(e, baseUri, wsToPipe);
        return (Function1 & Serializable)a -> (Function1 & Serializable)i -> backend.responseMonad().map(backend.send((RequestT)((Function1)req.apply(a)).apply(i)), (Function1 & Serializable)_$8 -> (DecodeResult)_$8.body());
    }

    public static Function1 toSecureClientThrowDecodeFailures$(SttpClientInterpreter $this, Endpoint e, Option baseUri, SttpBackend backend, WebSocketToPipe wsToPipe) {
        return $this.toSecureClientThrowDecodeFailures(e, (Option<Uri>)baseUri, backend, wsToPipe);
    }

    default public <F, A, I, E, O, R> Function1<A, Function1<I, Object>> toSecureClientThrowDecodeFailures(Endpoint<A, I, E, O, R> e, Option<Uri> baseUri, SttpBackend<F, R> backend, WebSocketToPipe<R> wsToPipe) {
        Function1 req = this.toSecureRequestThrowDecodeFailures(e, baseUri, wsToPipe);
        return (Function1 & Serializable)a -> (Function1 & Serializable)i -> backend.responseMonad().map(backend.send((RequestT)((Function1)req.apply(a)).apply(i)), (Function1 & Serializable)_$10 -> (Either)_$10.body());
    }

    public static Function1 toSecureClientThrowErrors$(SttpClientInterpreter $this, Endpoint e, Option baseUri, SttpBackend backend, WebSocketToPipe wsToPipe) {
        return $this.toSecureClientThrowErrors(e, (Option<Uri>)baseUri, backend, wsToPipe);
    }

    default public <F, A, I, E, O, R> Function1<A, Function1<I, Object>> toSecureClientThrowErrors(Endpoint<A, I, E, O, R> e, Option<Uri> baseUri, SttpBackend<F, R> backend, WebSocketToPipe<R> wsToPipe) {
        Function1 req = this.toSecureRequestThrowErrors(e, baseUri, wsToPipe);
        return (Function1 & Serializable)a -> (Function1 & Serializable)i -> backend.responseMonad().map(backend.send((RequestT)((Function1)req.apply(a)).apply(i)), (Function1 & Serializable)_$12 -> _$12.body());
    }

    public static Function1 toSecureRequest$(SttpClientInterpreter $this, Endpoint e, Option baseUri, WebSocketToPipe wsToPipe) {
        return $this.toSecureRequest(e, (Option<Uri>)baseUri, wsToPipe);
    }

    default public <A, I, E, O, R> Function1<A, Function1<I, RequestT<Object, DecodeResult<Either<E, O>>, R>>> toSecureRequest(Endpoint<A, I, E, O, R> e, Option<Uri> baseUri, WebSocketToPipe<R> wsToPipe) {
        return new EndpointToSttpClient<R>(this.sttpClientOptions(), wsToPipe).toSttpRequest(e, baseUri);
    }

    public static Function1 toSecureRequestThrowDecodeFailures$(SttpClientInterpreter $this, Endpoint e, Option baseUri, WebSocketToPipe wsToPipe) {
        return $this.toSecureRequestThrowDecodeFailures(e, (Option<Uri>)baseUri, wsToPipe);
    }

    default public <A, I, E, O, R> Function1<A, Function1<I, RequestT<Object, Either<E, O>, R>>> toSecureRequestThrowDecodeFailures(Endpoint<A, I, E, O, R> e, Option<Uri> baseUri, WebSocketToPipe<R> wsToPipe) {
        return (Function1 & Serializable)a -> (Function1 & Serializable)i -> ((RequestT)((Function1)new EndpointToSttpClient(this.sttpClientOptions(), wsToPipe).toSttpRequest(e, baseUri).apply(a)).apply(i)).mapResponse((Function1 & Serializable)dr -> (Either)this.throwDecodeFailures((DecodeResult)dr));
    }

    public static Function1 toSecureRequestThrowErrors$(SttpClientInterpreter $this, Endpoint e, Option baseUri, WebSocketToPipe wsToPipe) {
        return $this.toSecureRequestThrowErrors(e, (Option<Uri>)baseUri, wsToPipe);
    }

    default public <A, I, E, O, R> Function1<A, Function1<I, RequestT<Object, O, R>>> toSecureRequestThrowErrors(Endpoint<A, I, E, O, R> e, Option<Uri> baseUri, WebSocketToPipe<R> wsToPipe) {
        return (Function1 & Serializable)a -> (Function1 & Serializable)i -> ((RequestT)((Function1)new EndpointToSttpClient(this.sttpClientOptions(), wsToPipe).toSttpRequest(e, baseUri).apply(a)).apply(i)).mapResponse((Function1 & Serializable)dr -> (Either)this.throwDecodeFailures((DecodeResult)dr)).mapResponse((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Object object = ((Left)either).value();
                if (object instanceof Throwable) {
                    Throwable t = (Throwable)object;
                    throw new RuntimeException(this.throwErrorExceptionMsg(e, a, i, t), t);
                }
                Object t = object;
                throw new RuntimeException(this.throwErrorExceptionMsg(e, a, i, t));
            }
            if (either instanceof Right) {
                Object o = ((Right)either).value();
                return o;
            }
            throw new MatchError((Object)either);
        });
    }

    private <T> T throwDecodeFailures(DecodeResult<T> dr) {
        DecodeResult<T> decodeResult = dr;
        if (decodeResult instanceof DecodeResult.Value) {
            Object object;
            DecodeResult.Value value = DecodeResult.Value$.MODULE$.unapply((DecodeResult.Value)decodeResult);
            Object v = object = value._1();
            return (T)v;
        }
        if (decodeResult instanceof DecodeResult.Error) {
            Throwable throwable;
            DecodeResult.Error error = DecodeResult.Error$.MODULE$.unapply((DecodeResult.Error)decodeResult);
            String string = error._1();
            Throwable e = throwable = error._2();
            throw e;
        }
        DecodeResult<T> f = decodeResult;
        throw new IllegalArgumentException(new StringBuilder(15).append("Cannot decode: ").append(f).toString());
    }

    private <I, E, O, R> String throwErrorExceptionMsg(Endpoint<BoxedUnit, I, E, O, R> endpoint, I i, E e) {
        return new StringBuilder(37).append("Endpoint ").append(endpoint.show()).append(" returned error: ").append(e).append(", inputs: ").append(i).append(".").toString();
    }

    private <A, I, E, O, R> String throwErrorExceptionMsg(Endpoint<A, I, E, O, R> endpoint, A a, I i, E e) {
        return new StringBuilder(60).append("Endpoint ").append(endpoint.show()).append(" returned error: ").append(e).append(", for security inputs: ").append(a).append(", inputs: ").append(i).append(".").toString();
    }
}

