package com.solace.semp.v2.action.api;

import com.solace.semp.v2.action.ApiException;
import com.solace.semp.v2.action.ApiClient;
import com.solace.semp.v2.action.ApiResponse;
import com.solace.semp.v2.action.Configuration;
import com.solace.semp.v2.action.Pair;

import javax.ws.rs.core.GenericType;

import com.solace.semp.v2.action.model.AboutApiResponse;
import com.solace.semp.v2.action.model.AboutResponse;
import com.solace.semp.v2.action.model.AboutUserMsgVpnResponse;
import com.solace.semp.v2.action.model.AboutUserMsgVpnsResponse;
import com.solace.semp.v2.action.model.AboutUserResponse;
import com.solace.semp.v2.action.model.BrokerResponse;
import com.solace.semp.v2.action.model.CertAuthoritiesResponse;
import com.solace.semp.v2.action.model.CertAuthorityRefreshCrl;
import com.solace.semp.v2.action.model.CertAuthorityResponse;
import com.solace.semp.v2.action.model.MsgVpnAuthenticationOauthProviderClearStats;
import com.solace.semp.v2.action.model.MsgVpnAuthenticationOauthProviderResponse;
import com.solace.semp.v2.action.model.MsgVpnAuthenticationOauthProvidersResponse;
import com.solace.semp.v2.action.model.MsgVpnBridgeClearEvent;
import com.solace.semp.v2.action.model.MsgVpnBridgeClearStats;
import com.solace.semp.v2.action.model.MsgVpnBridgeDisconnect;
import com.solace.semp.v2.action.model.MsgVpnBridgeResponse;
import com.solace.semp.v2.action.model.MsgVpnBridgesResponse;
import com.solace.semp.v2.action.model.MsgVpnClearMsgSpoolStats;
import com.solace.semp.v2.action.model.MsgVpnClearReplicationStats;
import com.solace.semp.v2.action.model.MsgVpnClearServiceStats;
import com.solace.semp.v2.action.model.MsgVpnClearStats;
import com.solace.semp.v2.action.model.MsgVpnClientClearEvent;
import com.solace.semp.v2.action.model.MsgVpnClientClearStats;
import com.solace.semp.v2.action.model.MsgVpnClientDisconnect;
import com.solace.semp.v2.action.model.MsgVpnClientResponse;
import com.solace.semp.v2.action.model.MsgVpnClientTransactedSessionDelete;
import com.solace.semp.v2.action.model.MsgVpnClientTransactedSessionResponse;
import com.solace.semp.v2.action.model.MsgVpnClientTransactedSessionsResponse;
import com.solace.semp.v2.action.model.MsgVpnClientsResponse;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClusterInstanceBackupCachedMsgs;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClusterInstanceCancelBackupCachedMsgs;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClusterInstanceCancelRestoreCachedMsgs;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClusterInstanceClearEvent;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClusterInstanceClearStats;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClusterInstanceDeleteMsgs;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClusterInstanceResponse;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClusterInstanceRestoreCachedMsgs;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClusterInstanceStart;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClusterInstancesResponse;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClusterResponse;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheClustersResponse;
import com.solace.semp.v2.action.model.MsgVpnDistributedCacheResponse;
import com.solace.semp.v2.action.model.MsgVpnDistributedCachesResponse;
import com.solace.semp.v2.action.model.MsgVpnMqttSessionClearStats;
import com.solace.semp.v2.action.model.MsgVpnMqttSessionResponse;
import com.solace.semp.v2.action.model.MsgVpnMqttSessionsResponse;
import com.solace.semp.v2.action.model.MsgVpnQueueCancelReplay;
import com.solace.semp.v2.action.model.MsgVpnQueueClearStats;
import com.solace.semp.v2.action.model.MsgVpnQueueMsgDelete;
import com.solace.semp.v2.action.model.MsgVpnQueueMsgResponse;
import com.solace.semp.v2.action.model.MsgVpnQueueMsgsResponse;
import com.solace.semp.v2.action.model.MsgVpnQueueResponse;
import com.solace.semp.v2.action.model.MsgVpnQueueStartReplay;
import com.solace.semp.v2.action.model.MsgVpnQueuesResponse;
import com.solace.semp.v2.action.model.MsgVpnReplayLogResponse;
import com.solace.semp.v2.action.model.MsgVpnReplayLogTrimLoggedMsgs;
import com.solace.semp.v2.action.model.MsgVpnReplayLogsResponse;
import com.solace.semp.v2.action.model.MsgVpnResponse;
import com.solace.semp.v2.action.model.MsgVpnRestDeliveryPointResponse;
import com.solace.semp.v2.action.model.MsgVpnRestDeliveryPointRestConsumerClearStats;
import com.solace.semp.v2.action.model.MsgVpnRestDeliveryPointRestConsumerResponse;
import com.solace.semp.v2.action.model.MsgVpnRestDeliveryPointRestConsumersResponse;
import com.solace.semp.v2.action.model.MsgVpnRestDeliveryPointsResponse;
import com.solace.semp.v2.action.model.MsgVpnTopicEndpointCancelReplay;
import com.solace.semp.v2.action.model.MsgVpnTopicEndpointClearStats;
import com.solace.semp.v2.action.model.MsgVpnTopicEndpointMsgDelete;
import com.solace.semp.v2.action.model.MsgVpnTopicEndpointMsgResponse;
import com.solace.semp.v2.action.model.MsgVpnTopicEndpointMsgsResponse;
import com.solace.semp.v2.action.model.MsgVpnTopicEndpointResponse;
import com.solace.semp.v2.action.model.MsgVpnTopicEndpointStartReplay;
import com.solace.semp.v2.action.model.MsgVpnTopicEndpointsResponse;
import com.solace.semp.v2.action.model.MsgVpnTransactionCommit;
import com.solace.semp.v2.action.model.MsgVpnTransactionDelete;
import com.solace.semp.v2.action.model.MsgVpnTransactionResponse;
import com.solace.semp.v2.action.model.MsgVpnTransactionRollback;
import com.solace.semp.v2.action.model.MsgVpnTransactionsResponse;
import com.solace.semp.v2.action.model.MsgVpnsResponse;
import com.solace.semp.v2.action.model.SempMetaOnlyResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class AllApi {
  private ApiClient apiClient;

  public AllApi() {
    this(Configuration.getDefaultApiClient());
  }

  public AllApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Refresh the CRL file for the Certificate Authority.
   * Refresh the CRL file for the Certificate Authority.    A SEMP client authorized with a minimum access scope/level of \&quot;global/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param certAuthorityName The name of the Certificate Authority. (required)
   * @param body The Refresh CRL action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doCertAuthorityRefreshCrl(String certAuthorityName, CertAuthorityRefreshCrl body) throws ApiException {
    return doCertAuthorityRefreshCrlWithHttpInfo(certAuthorityName, body).getData();
      }

  /**
   * Refresh the CRL file for the Certificate Authority.
   * Refresh the CRL file for the Certificate Authority.    A SEMP client authorized with a minimum access scope/level of \&quot;global/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param certAuthorityName The name of the Certificate Authority. (required)
   * @param body The Refresh CRL action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doCertAuthorityRefreshCrlWithHttpInfo(String certAuthorityName, CertAuthorityRefreshCrl body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'certAuthorityName' is set
    if (certAuthorityName == null) {
      throw new ApiException(400, "Missing the required parameter 'certAuthorityName' when calling doCertAuthorityRefreshCrl");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doCertAuthorityRefreshCrl");
    }
    
    // create path and map variables
    String localVarPath = "/certAuthorities/{certAuthorityName}/refreshCrl"
      .replaceAll("\\{" + "certAuthorityName" + "\\}", apiClient.escapeString(certAuthorityName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the statistics for the OAuth Provider.
   * Clear the statistics for the OAuth Provider.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnAuthenticationOauthProviderClearStats(String msgVpnName, String oauthProviderName, MsgVpnAuthenticationOauthProviderClearStats body) throws ApiException {
    return doMsgVpnAuthenticationOauthProviderClearStatsWithHttpInfo(msgVpnName, oauthProviderName, body).getData();
      }

  /**
   * Clear the statistics for the OAuth Provider.
   * Clear the statistics for the OAuth Provider.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnAuthenticationOauthProviderClearStatsWithHttpInfo(String msgVpnName, String oauthProviderName, MsgVpnAuthenticationOauthProviderClearStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnAuthenticationOauthProviderClearStats");
    }
    
    // verify the required parameter 'oauthProviderName' is set
    if (oauthProviderName == null) {
      throw new ApiException(400, "Missing the required parameter 'oauthProviderName' when calling doMsgVpnAuthenticationOauthProviderClearStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnAuthenticationOauthProviderClearStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders/{oauthProviderName}/clearStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "oauthProviderName" + "\\}", apiClient.escapeString(oauthProviderName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear an event for the Bridge so it can be generated anew.
   * Clear an event for the Bridge so it can be generated anew.   Attribute|Required|Deprecated :---|:---:|:---: eventName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;global/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param bridgeName The name of the Bridge. (required)
   * @param bridgeVirtualRouter The virtual router of the Bridge. (required)
   * @param body The Clear Event action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnBridgeClearEvent(String msgVpnName, String bridgeName, String bridgeVirtualRouter, MsgVpnBridgeClearEvent body) throws ApiException {
    return doMsgVpnBridgeClearEventWithHttpInfo(msgVpnName, bridgeName, bridgeVirtualRouter, body).getData();
      }

  /**
   * Clear an event for the Bridge so it can be generated anew.
   * Clear an event for the Bridge so it can be generated anew.   Attribute|Required|Deprecated :---|:---:|:---: eventName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;global/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param bridgeName The name of the Bridge. (required)
   * @param bridgeVirtualRouter The virtual router of the Bridge. (required)
   * @param body The Clear Event action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnBridgeClearEventWithHttpInfo(String msgVpnName, String bridgeName, String bridgeVirtualRouter, MsgVpnBridgeClearEvent body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnBridgeClearEvent");
    }
    
    // verify the required parameter 'bridgeName' is set
    if (bridgeName == null) {
      throw new ApiException(400, "Missing the required parameter 'bridgeName' when calling doMsgVpnBridgeClearEvent");
    }
    
    // verify the required parameter 'bridgeVirtualRouter' is set
    if (bridgeVirtualRouter == null) {
      throw new ApiException(400, "Missing the required parameter 'bridgeVirtualRouter' when calling doMsgVpnBridgeClearEvent");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnBridgeClearEvent");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/bridges/{bridgeName},{bridgeVirtualRouter}/clearEvent"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "bridgeName" + "\\}", apiClient.escapeString(bridgeName.toString()))
      .replaceAll("\\{" + "bridgeVirtualRouter" + "\\}", apiClient.escapeString(bridgeVirtualRouter.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the statistics for the Bridge.
   * Clear the statistics for the Bridge.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param bridgeName The name of the Bridge. (required)
   * @param bridgeVirtualRouter The virtual router of the Bridge. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnBridgeClearStats(String msgVpnName, String bridgeName, String bridgeVirtualRouter, MsgVpnBridgeClearStats body) throws ApiException {
    return doMsgVpnBridgeClearStatsWithHttpInfo(msgVpnName, bridgeName, bridgeVirtualRouter, body).getData();
      }

  /**
   * Clear the statistics for the Bridge.
   * Clear the statistics for the Bridge.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param bridgeName The name of the Bridge. (required)
   * @param bridgeVirtualRouter The virtual router of the Bridge. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnBridgeClearStatsWithHttpInfo(String msgVpnName, String bridgeName, String bridgeVirtualRouter, MsgVpnBridgeClearStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnBridgeClearStats");
    }
    
    // verify the required parameter 'bridgeName' is set
    if (bridgeName == null) {
      throw new ApiException(400, "Missing the required parameter 'bridgeName' when calling doMsgVpnBridgeClearStats");
    }
    
    // verify the required parameter 'bridgeVirtualRouter' is set
    if (bridgeVirtualRouter == null) {
      throw new ApiException(400, "Missing the required parameter 'bridgeVirtualRouter' when calling doMsgVpnBridgeClearStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnBridgeClearStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/bridges/{bridgeName},{bridgeVirtualRouter}/clearStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "bridgeName" + "\\}", apiClient.escapeString(bridgeName.toString()))
      .replaceAll("\\{" + "bridgeVirtualRouter" + "\\}", apiClient.escapeString(bridgeVirtualRouter.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Disconnect the Bridge.
   * Disconnect the Bridge.    A SEMP client authorized with a minimum access scope/level of \&quot;global/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param bridgeName The name of the Bridge. (required)
   * @param bridgeVirtualRouter The virtual router of the Bridge. (required)
   * @param body The Disconnect action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnBridgeDisconnect(String msgVpnName, String bridgeName, String bridgeVirtualRouter, MsgVpnBridgeDisconnect body) throws ApiException {
    return doMsgVpnBridgeDisconnectWithHttpInfo(msgVpnName, bridgeName, bridgeVirtualRouter, body).getData();
      }

  /**
   * Disconnect the Bridge.
   * Disconnect the Bridge.    A SEMP client authorized with a minimum access scope/level of \&quot;global/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param bridgeName The name of the Bridge. (required)
   * @param bridgeVirtualRouter The virtual router of the Bridge. (required)
   * @param body The Disconnect action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnBridgeDisconnectWithHttpInfo(String msgVpnName, String bridgeName, String bridgeVirtualRouter, MsgVpnBridgeDisconnect body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnBridgeDisconnect");
    }
    
    // verify the required parameter 'bridgeName' is set
    if (bridgeName == null) {
      throw new ApiException(400, "Missing the required parameter 'bridgeName' when calling doMsgVpnBridgeDisconnect");
    }
    
    // verify the required parameter 'bridgeVirtualRouter' is set
    if (bridgeVirtualRouter == null) {
      throw new ApiException(400, "Missing the required parameter 'bridgeVirtualRouter' when calling doMsgVpnBridgeDisconnect");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnBridgeDisconnect");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/bridges/{bridgeName},{bridgeVirtualRouter}/disconnect"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "bridgeName" + "\\}", apiClient.escapeString(bridgeName.toString()))
      .replaceAll("\\{" + "bridgeVirtualRouter" + "\\}", apiClient.escapeString(bridgeVirtualRouter.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the message spool statistics for the Message VPN.
   * Clear the message spool statistics for the Message VPN.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnClearMsgSpoolStats(String msgVpnName, MsgVpnClearMsgSpoolStats body) throws ApiException {
    return doMsgVpnClearMsgSpoolStatsWithHttpInfo(msgVpnName, body).getData();
      }

  /**
   * Clear the message spool statistics for the Message VPN.
   * Clear the message spool statistics for the Message VPN.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnClearMsgSpoolStatsWithHttpInfo(String msgVpnName, MsgVpnClearMsgSpoolStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnClearMsgSpoolStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnClearMsgSpoolStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clearMsgSpoolStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the replication statistics for the Message VPN.
   * Clear the replication statistics for the Message VPN.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnClearReplicationStats(String msgVpnName, MsgVpnClearReplicationStats body) throws ApiException {
    return doMsgVpnClearReplicationStatsWithHttpInfo(msgVpnName, body).getData();
      }

  /**
   * Clear the replication statistics for the Message VPN.
   * Clear the replication statistics for the Message VPN.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnClearReplicationStatsWithHttpInfo(String msgVpnName, MsgVpnClearReplicationStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnClearReplicationStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnClearReplicationStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clearReplicationStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the service statistics for the Message VPN.
   * Clear the service statistics for the Message VPN.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnClearServiceStats(String msgVpnName, MsgVpnClearServiceStats body) throws ApiException {
    return doMsgVpnClearServiceStatsWithHttpInfo(msgVpnName, body).getData();
      }

  /**
   * Clear the service statistics for the Message VPN.
   * Clear the service statistics for the Message VPN.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnClearServiceStatsWithHttpInfo(String msgVpnName, MsgVpnClearServiceStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnClearServiceStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnClearServiceStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clearServiceStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the client statistics for the Message VPN.
   * Clear the client statistics for the Message VPN.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnClearStats(String msgVpnName, MsgVpnClearStats body) throws ApiException {
    return doMsgVpnClearStatsWithHttpInfo(msgVpnName, body).getData();
      }

  /**
   * Clear the client statistics for the Message VPN.
   * Clear the client statistics for the Message VPN.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnClearStatsWithHttpInfo(String msgVpnName, MsgVpnClearStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnClearStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnClearStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clearStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear an event for the Client so it can be generated anew.
   * Clear an event for the Client so it can be generated anew.   Attribute|Required|Deprecated :---|:---:|:---: eventName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param body The Clear Event action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnClientClearEvent(String msgVpnName, String clientName, MsgVpnClientClearEvent body) throws ApiException {
    return doMsgVpnClientClearEventWithHttpInfo(msgVpnName, clientName, body).getData();
      }

  /**
   * Clear an event for the Client so it can be generated anew.
   * Clear an event for the Client so it can be generated anew.   Attribute|Required|Deprecated :---|:---:|:---: eventName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param body The Clear Event action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnClientClearEventWithHttpInfo(String msgVpnName, String clientName, MsgVpnClientClearEvent body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnClientClearEvent");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling doMsgVpnClientClearEvent");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnClientClearEvent");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/clearEvent"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the statistics for the Client.
   * Clear the statistics for the Client.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnClientClearStats(String msgVpnName, String clientName, MsgVpnClientClearStats body) throws ApiException {
    return doMsgVpnClientClearStatsWithHttpInfo(msgVpnName, clientName, body).getData();
      }

  /**
   * Clear the statistics for the Client.
   * Clear the statistics for the Client.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnClientClearStatsWithHttpInfo(String msgVpnName, String clientName, MsgVpnClientClearStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnClientClearStats");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling doMsgVpnClientClearStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnClientClearStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/clearStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Disconnect the Client.
   * Disconnect the Client.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param body The Disconnect action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnClientDisconnect(String msgVpnName, String clientName, MsgVpnClientDisconnect body) throws ApiException {
    return doMsgVpnClientDisconnectWithHttpInfo(msgVpnName, clientName, body).getData();
      }

  /**
   * Disconnect the Client.
   * Disconnect the Client.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param body The Disconnect action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnClientDisconnectWithHttpInfo(String msgVpnName, String clientName, MsgVpnClientDisconnect body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnClientDisconnect");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling doMsgVpnClientDisconnect");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnClientDisconnect");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/disconnect"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Delete the Transacted Session.
   * Delete the Transacted Session.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param sessionName The name of the Transacted Session. (required)
   * @param body The Delete action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnClientTransactedSessionDelete(String msgVpnName, String clientName, String sessionName, MsgVpnClientTransactedSessionDelete body) throws ApiException {
    return doMsgVpnClientTransactedSessionDeleteWithHttpInfo(msgVpnName, clientName, sessionName, body).getData();
      }

  /**
   * Delete the Transacted Session.
   * Delete the Transacted Session.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param sessionName The name of the Transacted Session. (required)
   * @param body The Delete action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnClientTransactedSessionDeleteWithHttpInfo(String msgVpnName, String clientName, String sessionName, MsgVpnClientTransactedSessionDelete body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnClientTransactedSessionDelete");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling doMsgVpnClientTransactedSessionDelete");
    }
    
    // verify the required parameter 'sessionName' is set
    if (sessionName == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionName' when calling doMsgVpnClientTransactedSessionDelete");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnClientTransactedSessionDelete");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/transactedSessions/{sessionName}/delete"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()))
      .replaceAll("\\{" + "sessionName" + "\\}", apiClient.escapeString(sessionName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Backup cached messages of the Cache Instance to disk.
   * Backup cached messages of the Cache Instance to disk.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Backup Cached Messages action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnDistributedCacheClusterInstanceBackupCachedMsgs(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceBackupCachedMsgs body) throws ApiException {
    return doMsgVpnDistributedCacheClusterInstanceBackupCachedMsgsWithHttpInfo(msgVpnName, cacheName, clusterName, instanceName, body).getData();
      }

  /**
   * Backup cached messages of the Cache Instance to disk.
   * Backup cached messages of the Cache Instance to disk.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Backup Cached Messages action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnDistributedCacheClusterInstanceBackupCachedMsgsWithHttpInfo(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceBackupCachedMsgs body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnDistributedCacheClusterInstanceBackupCachedMsgs");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling doMsgVpnDistributedCacheClusterInstanceBackupCachedMsgs");
    }
    
    // verify the required parameter 'clusterName' is set
    if (clusterName == null) {
      throw new ApiException(400, "Missing the required parameter 'clusterName' when calling doMsgVpnDistributedCacheClusterInstanceBackupCachedMsgs");
    }
    
    // verify the required parameter 'instanceName' is set
    if (instanceName == null) {
      throw new ApiException(400, "Missing the required parameter 'instanceName' when calling doMsgVpnDistributedCacheClusterInstanceBackupCachedMsgs");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnDistributedCacheClusterInstanceBackupCachedMsgs");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters/{clusterName}/instances/{instanceName}/backupCachedMsgs"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()))
      .replaceAll("\\{" + "clusterName" + "\\}", apiClient.escapeString(clusterName.toString()))
      .replaceAll("\\{" + "instanceName" + "\\}", apiClient.escapeString(instanceName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Cancel the backup of cached messages from the Cache Instance.
   * Cancel the backup of cached messages from the Cache Instance.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Cancel Backup Cached Messages action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnDistributedCacheClusterInstanceCancelBackupCachedMsgs(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceCancelBackupCachedMsgs body) throws ApiException {
    return doMsgVpnDistributedCacheClusterInstanceCancelBackupCachedMsgsWithHttpInfo(msgVpnName, cacheName, clusterName, instanceName, body).getData();
      }

  /**
   * Cancel the backup of cached messages from the Cache Instance.
   * Cancel the backup of cached messages from the Cache Instance.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Cancel Backup Cached Messages action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnDistributedCacheClusterInstanceCancelBackupCachedMsgsWithHttpInfo(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceCancelBackupCachedMsgs body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnDistributedCacheClusterInstanceCancelBackupCachedMsgs");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling doMsgVpnDistributedCacheClusterInstanceCancelBackupCachedMsgs");
    }
    
    // verify the required parameter 'clusterName' is set
    if (clusterName == null) {
      throw new ApiException(400, "Missing the required parameter 'clusterName' when calling doMsgVpnDistributedCacheClusterInstanceCancelBackupCachedMsgs");
    }
    
    // verify the required parameter 'instanceName' is set
    if (instanceName == null) {
      throw new ApiException(400, "Missing the required parameter 'instanceName' when calling doMsgVpnDistributedCacheClusterInstanceCancelBackupCachedMsgs");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnDistributedCacheClusterInstanceCancelBackupCachedMsgs");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters/{clusterName}/instances/{instanceName}/cancelBackupCachedMsgs"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()))
      .replaceAll("\\{" + "clusterName" + "\\}", apiClient.escapeString(clusterName.toString()))
      .replaceAll("\\{" + "instanceName" + "\\}", apiClient.escapeString(instanceName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Cancel the restore of cached messages to the Cache Instance.
   * Cancel the restore of cached messages to the Cache Instance.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Cancel Restore Cached Messages action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnDistributedCacheClusterInstanceCancelRestoreCachedMsgs(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceCancelRestoreCachedMsgs body) throws ApiException {
    return doMsgVpnDistributedCacheClusterInstanceCancelRestoreCachedMsgsWithHttpInfo(msgVpnName, cacheName, clusterName, instanceName, body).getData();
      }

  /**
   * Cancel the restore of cached messages to the Cache Instance.
   * Cancel the restore of cached messages to the Cache Instance.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Cancel Restore Cached Messages action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnDistributedCacheClusterInstanceCancelRestoreCachedMsgsWithHttpInfo(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceCancelRestoreCachedMsgs body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnDistributedCacheClusterInstanceCancelRestoreCachedMsgs");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling doMsgVpnDistributedCacheClusterInstanceCancelRestoreCachedMsgs");
    }
    
    // verify the required parameter 'clusterName' is set
    if (clusterName == null) {
      throw new ApiException(400, "Missing the required parameter 'clusterName' when calling doMsgVpnDistributedCacheClusterInstanceCancelRestoreCachedMsgs");
    }
    
    // verify the required parameter 'instanceName' is set
    if (instanceName == null) {
      throw new ApiException(400, "Missing the required parameter 'instanceName' when calling doMsgVpnDistributedCacheClusterInstanceCancelRestoreCachedMsgs");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnDistributedCacheClusterInstanceCancelRestoreCachedMsgs");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters/{clusterName}/instances/{instanceName}/cancelRestoreCachedMsgs"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()))
      .replaceAll("\\{" + "clusterName" + "\\}", apiClient.escapeString(clusterName.toString()))
      .replaceAll("\\{" + "instanceName" + "\\}", apiClient.escapeString(instanceName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear an event for the Cache Instance so it can be generated anew.
   * Clear an event for the Cache Instance so it can be generated anew.   Attribute|Required|Deprecated :---|:---:|:---: eventName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Clear Event action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnDistributedCacheClusterInstanceClearEvent(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceClearEvent body) throws ApiException {
    return doMsgVpnDistributedCacheClusterInstanceClearEventWithHttpInfo(msgVpnName, cacheName, clusterName, instanceName, body).getData();
      }

  /**
   * Clear an event for the Cache Instance so it can be generated anew.
   * Clear an event for the Cache Instance so it can be generated anew.   Attribute|Required|Deprecated :---|:---:|:---: eventName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Clear Event action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnDistributedCacheClusterInstanceClearEventWithHttpInfo(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceClearEvent body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnDistributedCacheClusterInstanceClearEvent");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling doMsgVpnDistributedCacheClusterInstanceClearEvent");
    }
    
    // verify the required parameter 'clusterName' is set
    if (clusterName == null) {
      throw new ApiException(400, "Missing the required parameter 'clusterName' when calling doMsgVpnDistributedCacheClusterInstanceClearEvent");
    }
    
    // verify the required parameter 'instanceName' is set
    if (instanceName == null) {
      throw new ApiException(400, "Missing the required parameter 'instanceName' when calling doMsgVpnDistributedCacheClusterInstanceClearEvent");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnDistributedCacheClusterInstanceClearEvent");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters/{clusterName}/instances/{instanceName}/clearEvent"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()))
      .replaceAll("\\{" + "clusterName" + "\\}", apiClient.escapeString(clusterName.toString()))
      .replaceAll("\\{" + "instanceName" + "\\}", apiClient.escapeString(instanceName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the statistics for the Cache Instance.
   * Clear the statistics for the Cache Instance.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnDistributedCacheClusterInstanceClearStats(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceClearStats body) throws ApiException {
    return doMsgVpnDistributedCacheClusterInstanceClearStatsWithHttpInfo(msgVpnName, cacheName, clusterName, instanceName, body).getData();
      }

  /**
   * Clear the statistics for the Cache Instance.
   * Clear the statistics for the Cache Instance.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnDistributedCacheClusterInstanceClearStatsWithHttpInfo(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceClearStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnDistributedCacheClusterInstanceClearStats");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling doMsgVpnDistributedCacheClusterInstanceClearStats");
    }
    
    // verify the required parameter 'clusterName' is set
    if (clusterName == null) {
      throw new ApiException(400, "Missing the required parameter 'clusterName' when calling doMsgVpnDistributedCacheClusterInstanceClearStats");
    }
    
    // verify the required parameter 'instanceName' is set
    if (instanceName == null) {
      throw new ApiException(400, "Missing the required parameter 'instanceName' when calling doMsgVpnDistributedCacheClusterInstanceClearStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnDistributedCacheClusterInstanceClearStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters/{clusterName}/instances/{instanceName}/clearStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()))
      .replaceAll("\\{" + "clusterName" + "\\}", apiClient.escapeString(clusterName.toString()))
      .replaceAll("\\{" + "instanceName" + "\\}", apiClient.escapeString(instanceName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Delete messages covered by the given topic in the Cache Instance.
   * Delete messages covered by the given topic in the Cache Instance.   Attribute|Required|Deprecated :---|:---:|:---: topic|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Delete Messages action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnDistributedCacheClusterInstanceDeleteMsgs(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceDeleteMsgs body) throws ApiException {
    return doMsgVpnDistributedCacheClusterInstanceDeleteMsgsWithHttpInfo(msgVpnName, cacheName, clusterName, instanceName, body).getData();
      }

  /**
   * Delete messages covered by the given topic in the Cache Instance.
   * Delete messages covered by the given topic in the Cache Instance.   Attribute|Required|Deprecated :---|:---:|:---: topic|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Delete Messages action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnDistributedCacheClusterInstanceDeleteMsgsWithHttpInfo(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceDeleteMsgs body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnDistributedCacheClusterInstanceDeleteMsgs");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling doMsgVpnDistributedCacheClusterInstanceDeleteMsgs");
    }
    
    // verify the required parameter 'clusterName' is set
    if (clusterName == null) {
      throw new ApiException(400, "Missing the required parameter 'clusterName' when calling doMsgVpnDistributedCacheClusterInstanceDeleteMsgs");
    }
    
    // verify the required parameter 'instanceName' is set
    if (instanceName == null) {
      throw new ApiException(400, "Missing the required parameter 'instanceName' when calling doMsgVpnDistributedCacheClusterInstanceDeleteMsgs");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnDistributedCacheClusterInstanceDeleteMsgs");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters/{clusterName}/instances/{instanceName}/deleteMsgs"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()))
      .replaceAll("\\{" + "clusterName" + "\\}", apiClient.escapeString(clusterName.toString()))
      .replaceAll("\\{" + "instanceName" + "\\}", apiClient.escapeString(instanceName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Restore cached messages for the Cache Instance from disk.
   * Restore cached messages for the Cache Instance from disk.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Restore Cached Messages action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnDistributedCacheClusterInstanceRestoreCachedMsgs(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceRestoreCachedMsgs body) throws ApiException {
    return doMsgVpnDistributedCacheClusterInstanceRestoreCachedMsgsWithHttpInfo(msgVpnName, cacheName, clusterName, instanceName, body).getData();
      }

  /**
   * Restore cached messages for the Cache Instance from disk.
   * Restore cached messages for the Cache Instance from disk.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Restore Cached Messages action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnDistributedCacheClusterInstanceRestoreCachedMsgsWithHttpInfo(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceRestoreCachedMsgs body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnDistributedCacheClusterInstanceRestoreCachedMsgs");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling doMsgVpnDistributedCacheClusterInstanceRestoreCachedMsgs");
    }
    
    // verify the required parameter 'clusterName' is set
    if (clusterName == null) {
      throw new ApiException(400, "Missing the required parameter 'clusterName' when calling doMsgVpnDistributedCacheClusterInstanceRestoreCachedMsgs");
    }
    
    // verify the required parameter 'instanceName' is set
    if (instanceName == null) {
      throw new ApiException(400, "Missing the required parameter 'instanceName' when calling doMsgVpnDistributedCacheClusterInstanceRestoreCachedMsgs");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnDistributedCacheClusterInstanceRestoreCachedMsgs");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters/{clusterName}/instances/{instanceName}/restoreCachedMsgs"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()))
      .replaceAll("\\{" + "clusterName" + "\\}", apiClient.escapeString(clusterName.toString()))
      .replaceAll("\\{" + "instanceName" + "\\}", apiClient.escapeString(instanceName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Start the Cache Instance.
   * Start the Cache Instance.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Start Cache Instance action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnDistributedCacheClusterInstanceStart(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceStart body) throws ApiException {
    return doMsgVpnDistributedCacheClusterInstanceStartWithHttpInfo(msgVpnName, cacheName, clusterName, instanceName, body).getData();
      }

  /**
   * Start the Cache Instance.
   * Start the Cache Instance.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param body The Start Cache Instance action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnDistributedCacheClusterInstanceStartWithHttpInfo(String msgVpnName, String cacheName, String clusterName, String instanceName, MsgVpnDistributedCacheClusterInstanceStart body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnDistributedCacheClusterInstanceStart");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling doMsgVpnDistributedCacheClusterInstanceStart");
    }
    
    // verify the required parameter 'clusterName' is set
    if (clusterName == null) {
      throw new ApiException(400, "Missing the required parameter 'clusterName' when calling doMsgVpnDistributedCacheClusterInstanceStart");
    }
    
    // verify the required parameter 'instanceName' is set
    if (instanceName == null) {
      throw new ApiException(400, "Missing the required parameter 'instanceName' when calling doMsgVpnDistributedCacheClusterInstanceStart");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnDistributedCacheClusterInstanceStart");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters/{clusterName}/instances/{instanceName}/start"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()))
      .replaceAll("\\{" + "clusterName" + "\\}", apiClient.escapeString(clusterName.toString()))
      .replaceAll("\\{" + "instanceName" + "\\}", apiClient.escapeString(instanceName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the statistics for the MQTT Session.
   * Clear the statistics for the MQTT Session.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param mqttSessionClientId The Client ID of the MQTT Session, which corresponds to the ClientId provided in the MQTT CONNECT packet. (required)
   * @param mqttSessionVirtualRouter The virtual router of the MQTT Session. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnMqttSessionClearStats(String msgVpnName, String mqttSessionClientId, String mqttSessionVirtualRouter, MsgVpnMqttSessionClearStats body) throws ApiException {
    return doMsgVpnMqttSessionClearStatsWithHttpInfo(msgVpnName, mqttSessionClientId, mqttSessionVirtualRouter, body).getData();
      }

  /**
   * Clear the statistics for the MQTT Session.
   * Clear the statistics for the MQTT Session.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param mqttSessionClientId The Client ID of the MQTT Session, which corresponds to the ClientId provided in the MQTT CONNECT packet. (required)
   * @param mqttSessionVirtualRouter The virtual router of the MQTT Session. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnMqttSessionClearStatsWithHttpInfo(String msgVpnName, String mqttSessionClientId, String mqttSessionVirtualRouter, MsgVpnMqttSessionClearStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnMqttSessionClearStats");
    }
    
    // verify the required parameter 'mqttSessionClientId' is set
    if (mqttSessionClientId == null) {
      throw new ApiException(400, "Missing the required parameter 'mqttSessionClientId' when calling doMsgVpnMqttSessionClearStats");
    }
    
    // verify the required parameter 'mqttSessionVirtualRouter' is set
    if (mqttSessionVirtualRouter == null) {
      throw new ApiException(400, "Missing the required parameter 'mqttSessionVirtualRouter' when calling doMsgVpnMqttSessionClearStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnMqttSessionClearStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/mqttSessions/{mqttSessionClientId},{mqttSessionVirtualRouter}/clearStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "mqttSessionClientId" + "\\}", apiClient.escapeString(mqttSessionClientId.toString()))
      .replaceAll("\\{" + "mqttSessionVirtualRouter" + "\\}", apiClient.escapeString(mqttSessionVirtualRouter.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Cancel the replay of messages to the Queue.
   * Cancel the replay of messages to the Queue.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param body The Cancel Replay action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnQueueCancelReplay(String msgVpnName, String queueName, MsgVpnQueueCancelReplay body) throws ApiException {
    return doMsgVpnQueueCancelReplayWithHttpInfo(msgVpnName, queueName, body).getData();
      }

  /**
   * Cancel the replay of messages to the Queue.
   * Cancel the replay of messages to the Queue.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param body The Cancel Replay action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnQueueCancelReplayWithHttpInfo(String msgVpnName, String queueName, MsgVpnQueueCancelReplay body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnQueueCancelReplay");
    }
    
    // verify the required parameter 'queueName' is set
    if (queueName == null) {
      throw new ApiException(400, "Missing the required parameter 'queueName' when calling doMsgVpnQueueCancelReplay");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnQueueCancelReplay");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queues/{queueName}/cancelReplay"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "queueName" + "\\}", apiClient.escapeString(queueName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the statistics for the Queue.
   * Clear the statistics for the Queue.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnQueueClearStats(String msgVpnName, String queueName, MsgVpnQueueClearStats body) throws ApiException {
    return doMsgVpnQueueClearStatsWithHttpInfo(msgVpnName, queueName, body).getData();
      }

  /**
   * Clear the statistics for the Queue.
   * Clear the statistics for the Queue.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnQueueClearStatsWithHttpInfo(String msgVpnName, String queueName, MsgVpnQueueClearStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnQueueClearStats");
    }
    
    // verify the required parameter 'queueName' is set
    if (queueName == null) {
      throw new ApiException(400, "Missing the required parameter 'queueName' when calling doMsgVpnQueueClearStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnQueueClearStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queues/{queueName}/clearStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "queueName" + "\\}", apiClient.escapeString(queueName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Delete the Message from the Queue.
   * Delete the Message from the Queue.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param body The Delete action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnQueueMsgDelete(String msgVpnName, String queueName, String msgId, MsgVpnQueueMsgDelete body) throws ApiException {
    return doMsgVpnQueueMsgDeleteWithHttpInfo(msgVpnName, queueName, msgId, body).getData();
      }

  /**
   * Delete the Message from the Queue.
   * Delete the Message from the Queue.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param body The Delete action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnQueueMsgDeleteWithHttpInfo(String msgVpnName, String queueName, String msgId, MsgVpnQueueMsgDelete body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnQueueMsgDelete");
    }
    
    // verify the required parameter 'queueName' is set
    if (queueName == null) {
      throw new ApiException(400, "Missing the required parameter 'queueName' when calling doMsgVpnQueueMsgDelete");
    }
    
    // verify the required parameter 'msgId' is set
    if (msgId == null) {
      throw new ApiException(400, "Missing the required parameter 'msgId' when calling doMsgVpnQueueMsgDelete");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnQueueMsgDelete");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queues/{queueName}/msgs/{msgId}/delete"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "queueName" + "\\}", apiClient.escapeString(queueName.toString()))
      .replaceAll("\\{" + "msgId" + "\\}", apiClient.escapeString(msgId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Start the replay of messages to the Queue.
   * Start the replay of messages to the Queue.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param body The Start Replay action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnQueueStartReplay(String msgVpnName, String queueName, MsgVpnQueueStartReplay body) throws ApiException {
    return doMsgVpnQueueStartReplayWithHttpInfo(msgVpnName, queueName, body).getData();
      }

  /**
   * Start the replay of messages to the Queue.
   * Start the replay of messages to the Queue.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param body The Start Replay action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnQueueStartReplayWithHttpInfo(String msgVpnName, String queueName, MsgVpnQueueStartReplay body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnQueueStartReplay");
    }
    
    // verify the required parameter 'queueName' is set
    if (queueName == null) {
      throw new ApiException(400, "Missing the required parameter 'queueName' when calling doMsgVpnQueueStartReplay");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnQueueStartReplay");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queues/{queueName}/startReplay"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "queueName" + "\\}", apiClient.escapeString(queueName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Trim (delete) messages from the Replay Log.
   * Trim (delete) messages from the Replay Log.   Attribute|Required|Deprecated :---|:---:|:---: olderThanTime|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param replayLogName The name of the Replay Log. (required)
   * @param body The Trim Logged Messages action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnReplayLogTrimLoggedMsgs(String msgVpnName, String replayLogName, MsgVpnReplayLogTrimLoggedMsgs body) throws ApiException {
    return doMsgVpnReplayLogTrimLoggedMsgsWithHttpInfo(msgVpnName, replayLogName, body).getData();
      }

  /**
   * Trim (delete) messages from the Replay Log.
   * Trim (delete) messages from the Replay Log.   Attribute|Required|Deprecated :---|:---:|:---: olderThanTime|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param replayLogName The name of the Replay Log. (required)
   * @param body The Trim Logged Messages action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnReplayLogTrimLoggedMsgsWithHttpInfo(String msgVpnName, String replayLogName, MsgVpnReplayLogTrimLoggedMsgs body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnReplayLogTrimLoggedMsgs");
    }
    
    // verify the required parameter 'replayLogName' is set
    if (replayLogName == null) {
      throw new ApiException(400, "Missing the required parameter 'replayLogName' when calling doMsgVpnReplayLogTrimLoggedMsgs");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnReplayLogTrimLoggedMsgs");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/replayLogs/{replayLogName}/trimLoggedMsgs"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "replayLogName" + "\\}", apiClient.escapeString(replayLogName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the statistics for the REST Consumer.
   * Clear the statistics for the REST Consumer.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param restDeliveryPointName The name of the REST Delivery Point. (required)
   * @param restConsumerName The name of the REST Consumer. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnRestDeliveryPointRestConsumerClearStats(String msgVpnName, String restDeliveryPointName, String restConsumerName, MsgVpnRestDeliveryPointRestConsumerClearStats body) throws ApiException {
    return doMsgVpnRestDeliveryPointRestConsumerClearStatsWithHttpInfo(msgVpnName, restDeliveryPointName, restConsumerName, body).getData();
      }

  /**
   * Clear the statistics for the REST Consumer.
   * Clear the statistics for the REST Consumer.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param restDeliveryPointName The name of the REST Delivery Point. (required)
   * @param restConsumerName The name of the REST Consumer. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnRestDeliveryPointRestConsumerClearStatsWithHttpInfo(String msgVpnName, String restDeliveryPointName, String restConsumerName, MsgVpnRestDeliveryPointRestConsumerClearStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnRestDeliveryPointRestConsumerClearStats");
    }
    
    // verify the required parameter 'restDeliveryPointName' is set
    if (restDeliveryPointName == null) {
      throw new ApiException(400, "Missing the required parameter 'restDeliveryPointName' when calling doMsgVpnRestDeliveryPointRestConsumerClearStats");
    }
    
    // verify the required parameter 'restConsumerName' is set
    if (restConsumerName == null) {
      throw new ApiException(400, "Missing the required parameter 'restConsumerName' when calling doMsgVpnRestDeliveryPointRestConsumerClearStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnRestDeliveryPointRestConsumerClearStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/restDeliveryPoints/{restDeliveryPointName}/restConsumers/{restConsumerName}/clearStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "restDeliveryPointName" + "\\}", apiClient.escapeString(restDeliveryPointName.toString()))
      .replaceAll("\\{" + "restConsumerName" + "\\}", apiClient.escapeString(restConsumerName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Cancel the replay of messages to the Topic Endpoint.
   * Cancel the replay of messages to the Topic Endpoint.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param body The Cancel Replay action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnTopicEndpointCancelReplay(String msgVpnName, String topicEndpointName, MsgVpnTopicEndpointCancelReplay body) throws ApiException {
    return doMsgVpnTopicEndpointCancelReplayWithHttpInfo(msgVpnName, topicEndpointName, body).getData();
      }

  /**
   * Cancel the replay of messages to the Topic Endpoint.
   * Cancel the replay of messages to the Topic Endpoint.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param body The Cancel Replay action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnTopicEndpointCancelReplayWithHttpInfo(String msgVpnName, String topicEndpointName, MsgVpnTopicEndpointCancelReplay body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnTopicEndpointCancelReplay");
    }
    
    // verify the required parameter 'topicEndpointName' is set
    if (topicEndpointName == null) {
      throw new ApiException(400, "Missing the required parameter 'topicEndpointName' when calling doMsgVpnTopicEndpointCancelReplay");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnTopicEndpointCancelReplay");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/topicEndpoints/{topicEndpointName}/cancelReplay"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "topicEndpointName" + "\\}", apiClient.escapeString(topicEndpointName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Clear the statistics for the Topic Endpoint.
   * Clear the statistics for the Topic Endpoint.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnTopicEndpointClearStats(String msgVpnName, String topicEndpointName, MsgVpnTopicEndpointClearStats body) throws ApiException {
    return doMsgVpnTopicEndpointClearStatsWithHttpInfo(msgVpnName, topicEndpointName, body).getData();
      }

  /**
   * Clear the statistics for the Topic Endpoint.
   * Clear the statistics for the Topic Endpoint.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnTopicEndpointClearStatsWithHttpInfo(String msgVpnName, String topicEndpointName, MsgVpnTopicEndpointClearStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnTopicEndpointClearStats");
    }
    
    // verify the required parameter 'topicEndpointName' is set
    if (topicEndpointName == null) {
      throw new ApiException(400, "Missing the required parameter 'topicEndpointName' when calling doMsgVpnTopicEndpointClearStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnTopicEndpointClearStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/topicEndpoints/{topicEndpointName}/clearStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "topicEndpointName" + "\\}", apiClient.escapeString(topicEndpointName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Delete the Message from the Topic Endpoint.
   * Delete the Message from the Topic Endpoint.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param body The Delete action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnTopicEndpointMsgDelete(String msgVpnName, String topicEndpointName, String msgId, MsgVpnTopicEndpointMsgDelete body) throws ApiException {
    return doMsgVpnTopicEndpointMsgDeleteWithHttpInfo(msgVpnName, topicEndpointName, msgId, body).getData();
      }

  /**
   * Delete the Message from the Topic Endpoint.
   * Delete the Message from the Topic Endpoint.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param body The Delete action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnTopicEndpointMsgDeleteWithHttpInfo(String msgVpnName, String topicEndpointName, String msgId, MsgVpnTopicEndpointMsgDelete body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnTopicEndpointMsgDelete");
    }
    
    // verify the required parameter 'topicEndpointName' is set
    if (topicEndpointName == null) {
      throw new ApiException(400, "Missing the required parameter 'topicEndpointName' when calling doMsgVpnTopicEndpointMsgDelete");
    }
    
    // verify the required parameter 'msgId' is set
    if (msgId == null) {
      throw new ApiException(400, "Missing the required parameter 'msgId' when calling doMsgVpnTopicEndpointMsgDelete");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnTopicEndpointMsgDelete");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/topicEndpoints/{topicEndpointName}/msgs/{msgId}/delete"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "topicEndpointName" + "\\}", apiClient.escapeString(topicEndpointName.toString()))
      .replaceAll("\\{" + "msgId" + "\\}", apiClient.escapeString(msgId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Start the replay of messages to the Topic Endpoint.
   * Start the replay of messages to the Topic Endpoint.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param body The Start Replay action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnTopicEndpointStartReplay(String msgVpnName, String topicEndpointName, MsgVpnTopicEndpointStartReplay body) throws ApiException {
    return doMsgVpnTopicEndpointStartReplayWithHttpInfo(msgVpnName, topicEndpointName, body).getData();
      }

  /**
   * Start the replay of messages to the Topic Endpoint.
   * Start the replay of messages to the Topic Endpoint.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param body The Start Replay action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnTopicEndpointStartReplayWithHttpInfo(String msgVpnName, String topicEndpointName, MsgVpnTopicEndpointStartReplay body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnTopicEndpointStartReplay");
    }
    
    // verify the required parameter 'topicEndpointName' is set
    if (topicEndpointName == null) {
      throw new ApiException(400, "Missing the required parameter 'topicEndpointName' when calling doMsgVpnTopicEndpointStartReplay");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnTopicEndpointStartReplay");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/topicEndpoints/{topicEndpointName}/startReplay"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "topicEndpointName" + "\\}", apiClient.escapeString(topicEndpointName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Commit the Transaction.
   * Commit the Transaction.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param body The Commit action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnTransactionCommit(String msgVpnName, String xid, MsgVpnTransactionCommit body) throws ApiException {
    return doMsgVpnTransactionCommitWithHttpInfo(msgVpnName, xid, body).getData();
      }

  /**
   * Commit the Transaction.
   * Commit the Transaction.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param body The Commit action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnTransactionCommitWithHttpInfo(String msgVpnName, String xid, MsgVpnTransactionCommit body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnTransactionCommit");
    }
    
    // verify the required parameter 'xid' is set
    if (xid == null) {
      throw new ApiException(400, "Missing the required parameter 'xid' when calling doMsgVpnTransactionCommit");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnTransactionCommit");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/transactions/{xid}/commit"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "xid" + "\\}", apiClient.escapeString(xid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Delete the Transaction.
   * Delete the Transaction.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param body The Delete action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnTransactionDelete(String msgVpnName, String xid, MsgVpnTransactionDelete body) throws ApiException {
    return doMsgVpnTransactionDeleteWithHttpInfo(msgVpnName, xid, body).getData();
      }

  /**
   * Delete the Transaction.
   * Delete the Transaction.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param body The Delete action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnTransactionDeleteWithHttpInfo(String msgVpnName, String xid, MsgVpnTransactionDelete body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnTransactionDelete");
    }
    
    // verify the required parameter 'xid' is set
    if (xid == null) {
      throw new ApiException(400, "Missing the required parameter 'xid' when calling doMsgVpnTransactionDelete");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnTransactionDelete");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/transactions/{xid}/delete"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "xid" + "\\}", apiClient.escapeString(xid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Rollback the Transaction.
   * Rollback the Transaction.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param body The Rollback action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnTransactionRollback(String msgVpnName, String xid, MsgVpnTransactionRollback body) throws ApiException {
    return doMsgVpnTransactionRollbackWithHttpInfo(msgVpnName, xid, body).getData();
      }

  /**
   * Rollback the Transaction.
   * Rollback the Transaction.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param body The Rollback action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnTransactionRollbackWithHttpInfo(String msgVpnName, String xid, MsgVpnTransactionRollback body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnTransactionRollback");
    }
    
    // verify the required parameter 'xid' is set
    if (xid == null) {
      throw new ApiException(400, "Missing the required parameter 'xid' when calling doMsgVpnTransactionRollback");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnTransactionRollback");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/transactions/{xid}/rollback"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "xid" + "\\}", apiClient.escapeString(xid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get an About object.
   * Get an About object.  This provides metadata about the SEMP API, such as the version of the API supported by the broker.    A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return AboutResponse
   * @throws ApiException if fails to make API call
   */
  public AboutResponse getAbout(List<String> select) throws ApiException {
    return getAboutWithHttpInfo(select).getData();
      }

  /**
   * Get an About object.
   * Get an About object.  This provides metadata about the SEMP API, such as the version of the API supported by the broker.    A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;AboutResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<AboutResponse> getAboutWithHttpInfo(List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/about";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<AboutResponse> localVarReturnType = new GenericType<AboutResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get an API Description object.
   * Get an API Description object. The API Description object provides metadata about the SEMP API.  A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.11.
   * @return AboutApiResponse
   * @throws ApiException if fails to make API call
   */
  public AboutApiResponse getAboutApi() throws ApiException {
    return getAboutApiWithHttpInfo().getData();
      }

  /**
   * Get an API Description object.
   * Get an API Description object. The API Description object provides metadata about the SEMP API.  A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.11.
   * @return ApiResponse&lt;AboutApiResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<AboutApiResponse> getAboutApiWithHttpInfo() throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/about/api";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<AboutApiResponse> localVarReturnType = new GenericType<AboutApiResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a User object.
   * Get a User object.  This provides information about the access level for the username used to access the SEMP API.    A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return AboutUserResponse
   * @throws ApiException if fails to make API call
   */
  public AboutUserResponse getAboutUser(List<String> select) throws ApiException {
    return getAboutUserWithHttpInfo(select).getData();
      }

  /**
   * Get a User object.
   * Get a User object.  This provides information about the access level for the username used to access the SEMP API.    A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;AboutUserResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<AboutUserResponse> getAboutUserWithHttpInfo(List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/about/user";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<AboutUserResponse> localVarReturnType = new GenericType<AboutUserResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a User Message VPN object.
   * Get a User Message VPN object.  This provides information about the Message VPN access level for the username used to access the SEMP API.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return AboutUserMsgVpnResponse
   * @throws ApiException if fails to make API call
   */
  public AboutUserMsgVpnResponse getAboutUserMsgVpn(String msgVpnName, List<String> select) throws ApiException {
    return getAboutUserMsgVpnWithHttpInfo(msgVpnName, select).getData();
      }

  /**
   * Get a User Message VPN object.
   * Get a User Message VPN object.  This provides information about the Message VPN access level for the username used to access the SEMP API.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;AboutUserMsgVpnResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<AboutUserMsgVpnResponse> getAboutUserMsgVpnWithHttpInfo(String msgVpnName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getAboutUserMsgVpn");
    }
    
    // create path and map variables
    String localVarPath = "/about/user/msgVpns/{msgVpnName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<AboutUserMsgVpnResponse> localVarReturnType = new GenericType<AboutUserMsgVpnResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of User Message VPN objects.
   * Get a list of User Message VPN objects.  This provides information about the Message VPN access level for the username used to access the SEMP API.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return AboutUserMsgVpnsResponse
   * @throws ApiException if fails to make API call
   */
  public AboutUserMsgVpnsResponse getAboutUserMsgVpns(Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getAboutUserMsgVpnsWithHttpInfo(count, cursor, where, select).getData();
      }

  /**
   * Get a list of User Message VPN objects.
   * Get a list of User Message VPN objects.  This provides information about the Message VPN access level for the username used to access the SEMP API.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;AboutUserMsgVpnsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<AboutUserMsgVpnsResponse> getAboutUserMsgVpnsWithHttpInfo(Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/about/user/msgVpns";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<AboutUserMsgVpnsResponse> localVarReturnType = new GenericType<AboutUserMsgVpnsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Broker object.
   * Get a Broker object.  This object contains global configuration for the message broker.    A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return BrokerResponse
   * @throws ApiException if fails to make API call
   */
  public BrokerResponse getBroker(List<String> select) throws ApiException {
    return getBrokerWithHttpInfo(select).getData();
      }

  /**
   * Get a Broker object.
   * Get a Broker object.  This object contains global configuration for the message broker.    A SEMP client authorized with a minimum access scope/level of \&quot;global/none\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;BrokerResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<BrokerResponse> getBrokerWithHttpInfo(List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<BrokerResponse> localVarReturnType = new GenericType<BrokerResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Certificate Authority objects.
   * Get a list of Certificate Authority objects.  Clients can authenticate with the message broker over TLS by presenting a valid client certificate. The message broker authenticates the client certificate by constructing a full certificate chain (from the client certificate to intermediate CAs to a configured root CA). The intermediate CAs in this chain can be provided by the client, or configured in the message broker. The root CA must be configured on the message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: certAuthorityName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;global/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return CertAuthoritiesResponse
   * @throws ApiException if fails to make API call
   */
  public CertAuthoritiesResponse getCertAuthorities(Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getCertAuthoritiesWithHttpInfo(count, cursor, where, select).getData();
      }

  /**
   * Get a list of Certificate Authority objects.
   * Get a list of Certificate Authority objects.  Clients can authenticate with the message broker over TLS by presenting a valid client certificate. The message broker authenticates the client certificate by constructing a full certificate chain (from the client certificate to intermediate CAs to a configured root CA). The intermediate CAs in this chain can be provided by the client, or configured in the message broker. The root CA must be configured on the message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: certAuthorityName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;global/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;CertAuthoritiesResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<CertAuthoritiesResponse> getCertAuthoritiesWithHttpInfo(Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/certAuthorities";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<CertAuthoritiesResponse> localVarReturnType = new GenericType<CertAuthoritiesResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Certificate Authority object.
   * Get a Certificate Authority object.  Clients can authenticate with the message broker over TLS by presenting a valid client certificate. The message broker authenticates the client certificate by constructing a full certificate chain (from the client certificate to intermediate CAs to a configured root CA). The intermediate CAs in this chain can be provided by the client, or configured in the message broker. The root CA must be configured on the message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: certAuthorityName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;global/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param certAuthorityName The name of the Certificate Authority. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return CertAuthorityResponse
   * @throws ApiException if fails to make API call
   */
  public CertAuthorityResponse getCertAuthority(String certAuthorityName, List<String> select) throws ApiException {
    return getCertAuthorityWithHttpInfo(certAuthorityName, select).getData();
      }

  /**
   * Get a Certificate Authority object.
   * Get a Certificate Authority object.  Clients can authenticate with the message broker over TLS by presenting a valid client certificate. The message broker authenticates the client certificate by constructing a full certificate chain (from the client certificate to intermediate CAs to a configured root CA). The intermediate CAs in this chain can be provided by the client, or configured in the message broker. The root CA must be configured on the message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: certAuthorityName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;global/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param certAuthorityName The name of the Certificate Authority. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;CertAuthorityResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<CertAuthorityResponse> getCertAuthorityWithHttpInfo(String certAuthorityName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'certAuthorityName' is set
    if (certAuthorityName == null) {
      throw new ApiException(400, "Missing the required parameter 'certAuthorityName' when calling getCertAuthority");
    }
    
    // create path and map variables
    String localVarPath = "/certAuthorities/{certAuthorityName}"
      .replaceAll("\\{" + "certAuthorityName" + "\\}", apiClient.escapeString(certAuthorityName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<CertAuthorityResponse> localVarReturnType = new GenericType<CertAuthorityResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Message VPN object.
   * Get a Message VPN object.  Message VPNs (Virtual Private Networks) allow for the segregation of topic space and clients. They also group clients connecting to a network of message brokers, such that messages published within a particular group are only visible to that group&#39;s clients.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnResponse getMsgVpn(String msgVpnName, List<String> select) throws ApiException {
    return getMsgVpnWithHttpInfo(msgVpnName, select).getData();
      }

  /**
   * Get a Message VPN object.
   * Get a Message VPN object.  Message VPNs (Virtual Private Networks) allow for the segregation of topic space and clients. They also group clients connecting to a network of message brokers, such that messages published within a particular group are only visible to that group&#39;s clients.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnResponse> getMsgVpnWithHttpInfo(String msgVpnName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpn");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnResponse> localVarReturnType = new GenericType<MsgVpnResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get an OAuth Provider object.
   * Get an OAuth Provider object.  OAuth providers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| oauthProviderName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnAuthenticationOauthProviderResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnAuthenticationOauthProviderResponse getMsgVpnAuthenticationOauthProvider(String msgVpnName, String oauthProviderName, List<String> select) throws ApiException {
    return getMsgVpnAuthenticationOauthProviderWithHttpInfo(msgVpnName, oauthProviderName, select).getData();
      }

  /**
   * Get an OAuth Provider object.
   * Get an OAuth Provider object.  OAuth providers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| oauthProviderName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnAuthenticationOauthProviderResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnAuthenticationOauthProviderResponse> getMsgVpnAuthenticationOauthProviderWithHttpInfo(String msgVpnName, String oauthProviderName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnAuthenticationOauthProvider");
    }
    
    // verify the required parameter 'oauthProviderName' is set
    if (oauthProviderName == null) {
      throw new ApiException(400, "Missing the required parameter 'oauthProviderName' when calling getMsgVpnAuthenticationOauthProvider");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders/{oauthProviderName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "oauthProviderName" + "\\}", apiClient.escapeString(oauthProviderName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnAuthenticationOauthProviderResponse> localVarReturnType = new GenericType<MsgVpnAuthenticationOauthProviderResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of OAuth Provider objects.
   * Get a list of OAuth Provider objects.  OAuth providers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| oauthProviderName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnAuthenticationOauthProvidersResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnAuthenticationOauthProvidersResponse getMsgVpnAuthenticationOauthProviders(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnAuthenticationOauthProvidersWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of OAuth Provider objects.
   * Get a list of OAuth Provider objects.  OAuth providers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| oauthProviderName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnAuthenticationOauthProvidersResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnAuthenticationOauthProvidersResponse> getMsgVpnAuthenticationOauthProvidersWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnAuthenticationOauthProviders");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnAuthenticationOauthProvidersResponse> localVarReturnType = new GenericType<MsgVpnAuthenticationOauthProvidersResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Bridge object.
   * Get a Bridge object.  Bridges can be used to link two Message VPNs so that messages published to one Message VPN that match the topic subscriptions set for the bridge are also delivered to the linked Message VPN.   Attribute|Identifying|Deprecated :---|:---:|:---: bridgeName|x| bridgeVirtualRouter|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param bridgeName The name of the Bridge. (required)
   * @param bridgeVirtualRouter The virtual router of the Bridge. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnBridgeResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnBridgeResponse getMsgVpnBridge(String msgVpnName, String bridgeName, String bridgeVirtualRouter, List<String> select) throws ApiException {
    return getMsgVpnBridgeWithHttpInfo(msgVpnName, bridgeName, bridgeVirtualRouter, select).getData();
      }

  /**
   * Get a Bridge object.
   * Get a Bridge object.  Bridges can be used to link two Message VPNs so that messages published to one Message VPN that match the topic subscriptions set for the bridge are also delivered to the linked Message VPN.   Attribute|Identifying|Deprecated :---|:---:|:---: bridgeName|x| bridgeVirtualRouter|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param bridgeName The name of the Bridge. (required)
   * @param bridgeVirtualRouter The virtual router of the Bridge. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnBridgeResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnBridgeResponse> getMsgVpnBridgeWithHttpInfo(String msgVpnName, String bridgeName, String bridgeVirtualRouter, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnBridge");
    }
    
    // verify the required parameter 'bridgeName' is set
    if (bridgeName == null) {
      throw new ApiException(400, "Missing the required parameter 'bridgeName' when calling getMsgVpnBridge");
    }
    
    // verify the required parameter 'bridgeVirtualRouter' is set
    if (bridgeVirtualRouter == null) {
      throw new ApiException(400, "Missing the required parameter 'bridgeVirtualRouter' when calling getMsgVpnBridge");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/bridges/{bridgeName},{bridgeVirtualRouter}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "bridgeName" + "\\}", apiClient.escapeString(bridgeName.toString()))
      .replaceAll("\\{" + "bridgeVirtualRouter" + "\\}", apiClient.escapeString(bridgeVirtualRouter.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnBridgeResponse> localVarReturnType = new GenericType<MsgVpnBridgeResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Bridge objects.
   * Get a list of Bridge objects.  Bridges can be used to link two Message VPNs so that messages published to one Message VPN that match the topic subscriptions set for the bridge are also delivered to the linked Message VPN.   Attribute|Identifying|Deprecated :---|:---:|:---: bridgeName|x| bridgeVirtualRouter|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnBridgesResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnBridgesResponse getMsgVpnBridges(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnBridgesWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Bridge objects.
   * Get a list of Bridge objects.  Bridges can be used to link two Message VPNs so that messages published to one Message VPN that match the topic subscriptions set for the bridge are also delivered to the linked Message VPN.   Attribute|Identifying|Deprecated :---|:---:|:---: bridgeName|x| bridgeVirtualRouter|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnBridgesResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnBridgesResponse> getMsgVpnBridgesWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnBridges");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/bridges"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnBridgesResponse> localVarReturnType = new GenericType<MsgVpnBridgesResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Client object.
   * Get a Client object.  Applications or devices that connect to message brokers to send and/or receive messages are represented as Clients.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientResponse getMsgVpnClient(String msgVpnName, String clientName, List<String> select) throws ApiException {
    return getMsgVpnClientWithHttpInfo(msgVpnName, clientName, select).getData();
      }

  /**
   * Get a Client object.
   * Get a Client object.  Applications or devices that connect to message brokers to send and/or receive messages are represented as Clients.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientResponse> getMsgVpnClientWithHttpInfo(String msgVpnName, String clientName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClient");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClient");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientResponse> localVarReturnType = new GenericType<MsgVpnClientResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Client Transacted Session object.
   * Get a Client Transacted Session object.  Transacted Sessions enable clients to group multiple message send and/or receive operations together in single, atomic units known as local transactions.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| sessionName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param sessionName The name of the Transacted Session. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientTransactedSessionResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientTransactedSessionResponse getMsgVpnClientTransactedSession(String msgVpnName, String clientName, String sessionName, List<String> select) throws ApiException {
    return getMsgVpnClientTransactedSessionWithHttpInfo(msgVpnName, clientName, sessionName, select).getData();
      }

  /**
   * Get a Client Transacted Session object.
   * Get a Client Transacted Session object.  Transacted Sessions enable clients to group multiple message send and/or receive operations together in single, atomic units known as local transactions.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| sessionName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param sessionName The name of the Transacted Session. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientTransactedSessionResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientTransactedSessionResponse> getMsgVpnClientTransactedSessionWithHttpInfo(String msgVpnName, String clientName, String sessionName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientTransactedSession");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientTransactedSession");
    }
    
    // verify the required parameter 'sessionName' is set
    if (sessionName == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionName' when calling getMsgVpnClientTransactedSession");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/transactedSessions/{sessionName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()))
      .replaceAll("\\{" + "sessionName" + "\\}", apiClient.escapeString(sessionName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientTransactedSessionResponse> localVarReturnType = new GenericType<MsgVpnClientTransactedSessionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Client Transacted Session objects.
   * Get a list of Client Transacted Session objects.  Transacted Sessions enable clients to group multiple message send and/or receive operations together in single, atomic units known as local transactions.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| sessionName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientTransactedSessionsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientTransactedSessionsResponse getMsgVpnClientTransactedSessions(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnClientTransactedSessionsWithHttpInfo(msgVpnName, clientName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Client Transacted Session objects.
   * Get a list of Client Transacted Session objects.  Transacted Sessions enable clients to group multiple message send and/or receive operations together in single, atomic units known as local transactions.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| sessionName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientTransactedSessionsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientTransactedSessionsResponse> getMsgVpnClientTransactedSessionsWithHttpInfo(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientTransactedSessions");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientTransactedSessions");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/transactedSessions"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientTransactedSessionsResponse> localVarReturnType = new GenericType<MsgVpnClientTransactedSessionsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Client objects.
   * Get a list of Client objects.  Applications or devices that connect to message brokers to send and/or receive messages are represented as Clients.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientsResponse getMsgVpnClients(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnClientsWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Client objects.
   * Get a list of Client objects.  Applications or devices that connect to message brokers to send and/or receive messages are represented as Clients.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientsResponse> getMsgVpnClientsWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClients");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientsResponse> localVarReturnType = new GenericType<MsgVpnClientsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Distributed Cache object.
   * Get a Distributed Cache object.  A Distributed Cache is a collection of one or more Cache Clusters that belong to the same Message VPN. Each Cache Cluster in a Distributed Cache is configured to subscribe to a different set of topics. This effectively divides up the configured topic space, to provide scaling to very large topic spaces or very high cached message throughput.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnDistributedCacheResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnDistributedCacheResponse getMsgVpnDistributedCache(String msgVpnName, String cacheName, List<String> select) throws ApiException {
    return getMsgVpnDistributedCacheWithHttpInfo(msgVpnName, cacheName, select).getData();
      }

  /**
   * Get a Distributed Cache object.
   * Get a Distributed Cache object.  A Distributed Cache is a collection of one or more Cache Clusters that belong to the same Message VPN. Each Cache Cluster in a Distributed Cache is configured to subscribe to a different set of topics. This effectively divides up the configured topic space, to provide scaling to very large topic spaces or very high cached message throughput.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnDistributedCacheResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnDistributedCacheResponse> getMsgVpnDistributedCacheWithHttpInfo(String msgVpnName, String cacheName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnDistributedCache");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling getMsgVpnDistributedCache");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnDistributedCacheResponse> localVarReturnType = new GenericType<MsgVpnDistributedCacheResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Cache Cluster object.
   * Get a Cache Cluster object.  A Cache Cluster is a collection of one or more Cache Instances that subscribe to exactly the same topics. Cache Instances are grouped together in a Cache Cluster for the purpose of fault tolerance and load balancing. As published messages are received, the message broker message bus sends these live data messages to the Cache Instances in the Cache Cluster. This enables client cache requests to be served by any of Cache Instances in the Cache Cluster.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| clusterName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnDistributedCacheClusterResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnDistributedCacheClusterResponse getMsgVpnDistributedCacheCluster(String msgVpnName, String cacheName, String clusterName, List<String> select) throws ApiException {
    return getMsgVpnDistributedCacheClusterWithHttpInfo(msgVpnName, cacheName, clusterName, select).getData();
      }

  /**
   * Get a Cache Cluster object.
   * Get a Cache Cluster object.  A Cache Cluster is a collection of one or more Cache Instances that subscribe to exactly the same topics. Cache Instances are grouped together in a Cache Cluster for the purpose of fault tolerance and load balancing. As published messages are received, the message broker message bus sends these live data messages to the Cache Instances in the Cache Cluster. This enables client cache requests to be served by any of Cache Instances in the Cache Cluster.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| clusterName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnDistributedCacheClusterResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnDistributedCacheClusterResponse> getMsgVpnDistributedCacheClusterWithHttpInfo(String msgVpnName, String cacheName, String clusterName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnDistributedCacheCluster");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling getMsgVpnDistributedCacheCluster");
    }
    
    // verify the required parameter 'clusterName' is set
    if (clusterName == null) {
      throw new ApiException(400, "Missing the required parameter 'clusterName' when calling getMsgVpnDistributedCacheCluster");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters/{clusterName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()))
      .replaceAll("\\{" + "clusterName" + "\\}", apiClient.escapeString(clusterName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnDistributedCacheClusterResponse> localVarReturnType = new GenericType<MsgVpnDistributedCacheClusterResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Cache Instance object.
   * Get a Cache Instance object.  A Cache Instance is a single Cache process that belongs to a single Cache Cluster. A Cache Instance object provisioned on the broker is used to disseminate configuration information to the Cache process. Cache Instances listen for and cache live data messages that match the topic subscriptions configured for their parent Cache Cluster.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| clusterName|x| instanceName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnDistributedCacheClusterInstanceResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnDistributedCacheClusterInstanceResponse getMsgVpnDistributedCacheClusterInstance(String msgVpnName, String cacheName, String clusterName, String instanceName, List<String> select) throws ApiException {
    return getMsgVpnDistributedCacheClusterInstanceWithHttpInfo(msgVpnName, cacheName, clusterName, instanceName, select).getData();
      }

  /**
   * Get a Cache Instance object.
   * Get a Cache Instance object.  A Cache Instance is a single Cache process that belongs to a single Cache Cluster. A Cache Instance object provisioned on the broker is used to disseminate configuration information to the Cache process. Cache Instances listen for and cache live data messages that match the topic subscriptions configured for their parent Cache Cluster.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| clusterName|x| instanceName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param instanceName The name of the Cache Instance. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnDistributedCacheClusterInstanceResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnDistributedCacheClusterInstanceResponse> getMsgVpnDistributedCacheClusterInstanceWithHttpInfo(String msgVpnName, String cacheName, String clusterName, String instanceName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnDistributedCacheClusterInstance");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling getMsgVpnDistributedCacheClusterInstance");
    }
    
    // verify the required parameter 'clusterName' is set
    if (clusterName == null) {
      throw new ApiException(400, "Missing the required parameter 'clusterName' when calling getMsgVpnDistributedCacheClusterInstance");
    }
    
    // verify the required parameter 'instanceName' is set
    if (instanceName == null) {
      throw new ApiException(400, "Missing the required parameter 'instanceName' when calling getMsgVpnDistributedCacheClusterInstance");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters/{clusterName}/instances/{instanceName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()))
      .replaceAll("\\{" + "clusterName" + "\\}", apiClient.escapeString(clusterName.toString()))
      .replaceAll("\\{" + "instanceName" + "\\}", apiClient.escapeString(instanceName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnDistributedCacheClusterInstanceResponse> localVarReturnType = new GenericType<MsgVpnDistributedCacheClusterInstanceResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Cache Instance objects.
   * Get a list of Cache Instance objects.  A Cache Instance is a single Cache process that belongs to a single Cache Cluster. A Cache Instance object provisioned on the broker is used to disseminate configuration information to the Cache process. Cache Instances listen for and cache live data messages that match the topic subscriptions configured for their parent Cache Cluster.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| clusterName|x| instanceName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnDistributedCacheClusterInstancesResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnDistributedCacheClusterInstancesResponse getMsgVpnDistributedCacheClusterInstances(String msgVpnName, String cacheName, String clusterName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnDistributedCacheClusterInstancesWithHttpInfo(msgVpnName, cacheName, clusterName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Cache Instance objects.
   * Get a list of Cache Instance objects.  A Cache Instance is a single Cache process that belongs to a single Cache Cluster. A Cache Instance object provisioned on the broker is used to disseminate configuration information to the Cache process. Cache Instances listen for and cache live data messages that match the topic subscriptions configured for their parent Cache Cluster.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| clusterName|x| instanceName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param clusterName The name of the Cache Cluster. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnDistributedCacheClusterInstancesResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnDistributedCacheClusterInstancesResponse> getMsgVpnDistributedCacheClusterInstancesWithHttpInfo(String msgVpnName, String cacheName, String clusterName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnDistributedCacheClusterInstances");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling getMsgVpnDistributedCacheClusterInstances");
    }
    
    // verify the required parameter 'clusterName' is set
    if (clusterName == null) {
      throw new ApiException(400, "Missing the required parameter 'clusterName' when calling getMsgVpnDistributedCacheClusterInstances");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters/{clusterName}/instances"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()))
      .replaceAll("\\{" + "clusterName" + "\\}", apiClient.escapeString(clusterName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnDistributedCacheClusterInstancesResponse> localVarReturnType = new GenericType<MsgVpnDistributedCacheClusterInstancesResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Cache Cluster objects.
   * Get a list of Cache Cluster objects.  A Cache Cluster is a collection of one or more Cache Instances that subscribe to exactly the same topics. Cache Instances are grouped together in a Cache Cluster for the purpose of fault tolerance and load balancing. As published messages are received, the message broker message bus sends these live data messages to the Cache Instances in the Cache Cluster. This enables client cache requests to be served by any of Cache Instances in the Cache Cluster.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| clusterName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnDistributedCacheClustersResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnDistributedCacheClustersResponse getMsgVpnDistributedCacheClusters(String msgVpnName, String cacheName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnDistributedCacheClustersWithHttpInfo(msgVpnName, cacheName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Cache Cluster objects.
   * Get a list of Cache Cluster objects.  A Cache Cluster is a collection of one or more Cache Instances that subscribe to exactly the same topics. Cache Instances are grouped together in a Cache Cluster for the purpose of fault tolerance and load balancing. As published messages are received, the message broker message bus sends these live data messages to the Cache Instances in the Cache Cluster. This enables client cache requests to be served by any of Cache Instances in the Cache Cluster.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| clusterName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param cacheName The name of the Distributed Cache. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnDistributedCacheClustersResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnDistributedCacheClustersResponse> getMsgVpnDistributedCacheClustersWithHttpInfo(String msgVpnName, String cacheName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnDistributedCacheClusters");
    }
    
    // verify the required parameter 'cacheName' is set
    if (cacheName == null) {
      throw new ApiException(400, "Missing the required parameter 'cacheName' when calling getMsgVpnDistributedCacheClusters");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches/{cacheName}/clusters"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "cacheName" + "\\}", apiClient.escapeString(cacheName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnDistributedCacheClustersResponse> localVarReturnType = new GenericType<MsgVpnDistributedCacheClustersResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Distributed Cache objects.
   * Get a list of Distributed Cache objects.  A Distributed Cache is a collection of one or more Cache Clusters that belong to the same Message VPN. Each Cache Cluster in a Distributed Cache is configured to subscribe to a different set of topics. This effectively divides up the configured topic space, to provide scaling to very large topic spaces or very high cached message throughput.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnDistributedCachesResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnDistributedCachesResponse getMsgVpnDistributedCaches(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnDistributedCachesWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Distributed Cache objects.
   * Get a list of Distributed Cache objects.  A Distributed Cache is a collection of one or more Cache Clusters that belong to the same Message VPN. Each Cache Cluster in a Distributed Cache is configured to subscribe to a different set of topics. This effectively divides up the configured topic space, to provide scaling to very large topic spaces or very high cached message throughput.   Attribute|Identifying|Deprecated :---|:---:|:---: cacheName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnDistributedCachesResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnDistributedCachesResponse> getMsgVpnDistributedCachesWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnDistributedCaches");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/distributedCaches"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnDistributedCachesResponse> localVarReturnType = new GenericType<MsgVpnDistributedCachesResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get an MQTT Session object.
   * Get an MQTT Session object.  An MQTT Session object is a virtual representation of an MQTT client connection. An MQTT session holds the state of an MQTT client (that is, it is used to contain a client&#39;s QoS 0 and QoS 1 subscription sets and any undelivered QoS 1 messages).   Attribute|Identifying|Deprecated :---|:---:|:---: mqttSessionClientId|x| mqttSessionVirtualRouter|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param mqttSessionClientId The Client ID of the MQTT Session, which corresponds to the ClientId provided in the MQTT CONNECT packet. (required)
   * @param mqttSessionVirtualRouter The virtual router of the MQTT Session. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnMqttSessionResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnMqttSessionResponse getMsgVpnMqttSession(String msgVpnName, String mqttSessionClientId, String mqttSessionVirtualRouter, List<String> select) throws ApiException {
    return getMsgVpnMqttSessionWithHttpInfo(msgVpnName, mqttSessionClientId, mqttSessionVirtualRouter, select).getData();
      }

  /**
   * Get an MQTT Session object.
   * Get an MQTT Session object.  An MQTT Session object is a virtual representation of an MQTT client connection. An MQTT session holds the state of an MQTT client (that is, it is used to contain a client&#39;s QoS 0 and QoS 1 subscription sets and any undelivered QoS 1 messages).   Attribute|Identifying|Deprecated :---|:---:|:---: mqttSessionClientId|x| mqttSessionVirtualRouter|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param mqttSessionClientId The Client ID of the MQTT Session, which corresponds to the ClientId provided in the MQTT CONNECT packet. (required)
   * @param mqttSessionVirtualRouter The virtual router of the MQTT Session. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnMqttSessionResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnMqttSessionResponse> getMsgVpnMqttSessionWithHttpInfo(String msgVpnName, String mqttSessionClientId, String mqttSessionVirtualRouter, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnMqttSession");
    }
    
    // verify the required parameter 'mqttSessionClientId' is set
    if (mqttSessionClientId == null) {
      throw new ApiException(400, "Missing the required parameter 'mqttSessionClientId' when calling getMsgVpnMqttSession");
    }
    
    // verify the required parameter 'mqttSessionVirtualRouter' is set
    if (mqttSessionVirtualRouter == null) {
      throw new ApiException(400, "Missing the required parameter 'mqttSessionVirtualRouter' when calling getMsgVpnMqttSession");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/mqttSessions/{mqttSessionClientId},{mqttSessionVirtualRouter}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "mqttSessionClientId" + "\\}", apiClient.escapeString(mqttSessionClientId.toString()))
      .replaceAll("\\{" + "mqttSessionVirtualRouter" + "\\}", apiClient.escapeString(mqttSessionVirtualRouter.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnMqttSessionResponse> localVarReturnType = new GenericType<MsgVpnMqttSessionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of MQTT Session objects.
   * Get a list of MQTT Session objects.  An MQTT Session object is a virtual representation of an MQTT client connection. An MQTT session holds the state of an MQTT client (that is, it is used to contain a client&#39;s QoS 0 and QoS 1 subscription sets and any undelivered QoS 1 messages).   Attribute|Identifying|Deprecated :---|:---:|:---: mqttSessionClientId|x| mqttSessionVirtualRouter|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnMqttSessionsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnMqttSessionsResponse getMsgVpnMqttSessions(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnMqttSessionsWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of MQTT Session objects.
   * Get a list of MQTT Session objects.  An MQTT Session object is a virtual representation of an MQTT client connection. An MQTT session holds the state of an MQTT client (that is, it is used to contain a client&#39;s QoS 0 and QoS 1 subscription sets and any undelivered QoS 1 messages).   Attribute|Identifying|Deprecated :---|:---:|:---: mqttSessionClientId|x| mqttSessionVirtualRouter|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnMqttSessionsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnMqttSessionsResponse> getMsgVpnMqttSessionsWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnMqttSessions");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/mqttSessions"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnMqttSessionsResponse> localVarReturnType = new GenericType<MsgVpnMqttSessionsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Queue object.
   * Get a Queue object.  A Queue acts as both a destination that clients can publish messages to, and as an endpoint that clients can bind consumers to and consume messages from.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| queueName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnQueueResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnQueueResponse getMsgVpnQueue(String msgVpnName, String queueName, List<String> select) throws ApiException {
    return getMsgVpnQueueWithHttpInfo(msgVpnName, queueName, select).getData();
      }

  /**
   * Get a Queue object.
   * Get a Queue object.  A Queue acts as both a destination that clients can publish messages to, and as an endpoint that clients can bind consumers to and consume messages from.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| queueName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnQueueResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnQueueResponse> getMsgVpnQueueWithHttpInfo(String msgVpnName, String queueName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnQueue");
    }
    
    // verify the required parameter 'queueName' is set
    if (queueName == null) {
      throw new ApiException(400, "Missing the required parameter 'queueName' when calling getMsgVpnQueue");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queues/{queueName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "queueName" + "\\}", apiClient.escapeString(queueName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnQueueResponse> localVarReturnType = new GenericType<MsgVpnQueueResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Queue Message object.
   * Get a Queue Message object.  A Queue Message is a packet of information sent from producers to consumers using the Queue.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| queueName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnQueueMsgResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnQueueMsgResponse getMsgVpnQueueMsg(String msgVpnName, String queueName, String msgId, List<String> select) throws ApiException {
    return getMsgVpnQueueMsgWithHttpInfo(msgVpnName, queueName, msgId, select).getData();
      }

  /**
   * Get a Queue Message object.
   * Get a Queue Message object.  A Queue Message is a packet of information sent from producers to consumers using the Queue.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| queueName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnQueueMsgResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnQueueMsgResponse> getMsgVpnQueueMsgWithHttpInfo(String msgVpnName, String queueName, String msgId, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnQueueMsg");
    }
    
    // verify the required parameter 'queueName' is set
    if (queueName == null) {
      throw new ApiException(400, "Missing the required parameter 'queueName' when calling getMsgVpnQueueMsg");
    }
    
    // verify the required parameter 'msgId' is set
    if (msgId == null) {
      throw new ApiException(400, "Missing the required parameter 'msgId' when calling getMsgVpnQueueMsg");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queues/{queueName}/msgs/{msgId}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "queueName" + "\\}", apiClient.escapeString(queueName.toString()))
      .replaceAll("\\{" + "msgId" + "\\}", apiClient.escapeString(msgId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnQueueMsgResponse> localVarReturnType = new GenericType<MsgVpnQueueMsgResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Queue Message objects.
   * Get a list of Queue Message objects.  A Queue Message is a packet of information sent from producers to consumers using the Queue.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| queueName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnQueueMsgsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnQueueMsgsResponse getMsgVpnQueueMsgs(String msgVpnName, String queueName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnQueueMsgsWithHttpInfo(msgVpnName, queueName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Queue Message objects.
   * Get a list of Queue Message objects.  A Queue Message is a packet of information sent from producers to consumers using the Queue.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| queueName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueName The name of the Queue. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnQueueMsgsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnQueueMsgsResponse> getMsgVpnQueueMsgsWithHttpInfo(String msgVpnName, String queueName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnQueueMsgs");
    }
    
    // verify the required parameter 'queueName' is set
    if (queueName == null) {
      throw new ApiException(400, "Missing the required parameter 'queueName' when calling getMsgVpnQueueMsgs");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queues/{queueName}/msgs"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "queueName" + "\\}", apiClient.escapeString(queueName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnQueueMsgsResponse> localVarReturnType = new GenericType<MsgVpnQueueMsgsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Queue objects.
   * Get a list of Queue objects.  A Queue acts as both a destination that clients can publish messages to, and as an endpoint that clients can bind consumers to and consume messages from.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| queueName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnQueuesResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnQueuesResponse getMsgVpnQueues(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnQueuesWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Queue objects.
   * Get a list of Queue objects.  A Queue acts as both a destination that clients can publish messages to, and as an endpoint that clients can bind consumers to and consume messages from.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| queueName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnQueuesResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnQueuesResponse> getMsgVpnQueuesWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnQueues");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queues"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnQueuesResponse> localVarReturnType = new GenericType<MsgVpnQueuesResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Replay Log object.
   * Get a Replay Log object.  When the Message Replay feature is enabled enabled, message brokers store persistent messages in a Replay Log. These messages are kept until the log is full, after which the oldest messages are removed to free up space for new messages.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| replayLogName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param replayLogName The name of the Replay Log. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnReplayLogResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnReplayLogResponse getMsgVpnReplayLog(String msgVpnName, String replayLogName, List<String> select) throws ApiException {
    return getMsgVpnReplayLogWithHttpInfo(msgVpnName, replayLogName, select).getData();
      }

  /**
   * Get a Replay Log object.
   * Get a Replay Log object.  When the Message Replay feature is enabled enabled, message brokers store persistent messages in a Replay Log. These messages are kept until the log is full, after which the oldest messages are removed to free up space for new messages.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| replayLogName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param replayLogName The name of the Replay Log. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnReplayLogResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnReplayLogResponse> getMsgVpnReplayLogWithHttpInfo(String msgVpnName, String replayLogName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnReplayLog");
    }
    
    // verify the required parameter 'replayLogName' is set
    if (replayLogName == null) {
      throw new ApiException(400, "Missing the required parameter 'replayLogName' when calling getMsgVpnReplayLog");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/replayLogs/{replayLogName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "replayLogName" + "\\}", apiClient.escapeString(replayLogName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnReplayLogResponse> localVarReturnType = new GenericType<MsgVpnReplayLogResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Replay Log objects.
   * Get a list of Replay Log objects.  When the Message Replay feature is enabled enabled, message brokers store persistent messages in a Replay Log. These messages are kept until the log is full, after which the oldest messages are removed to free up space for new messages.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| replayLogName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnReplayLogsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnReplayLogsResponse getMsgVpnReplayLogs(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnReplayLogsWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Replay Log objects.
   * Get a list of Replay Log objects.  When the Message Replay feature is enabled enabled, message brokers store persistent messages in a Replay Log. These messages are kept until the log is full, after which the oldest messages are removed to free up space for new messages.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| replayLogName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnReplayLogsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnReplayLogsResponse> getMsgVpnReplayLogsWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnReplayLogs");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/replayLogs"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnReplayLogsResponse> localVarReturnType = new GenericType<MsgVpnReplayLogsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a REST Delivery Point object.
   * Get a REST Delivery Point object.  A REST Delivery Point manages delivery of messages from queues to a named list of REST Consumers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| restDeliveryPointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param restDeliveryPointName The name of the REST Delivery Point. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnRestDeliveryPointResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnRestDeliveryPointResponse getMsgVpnRestDeliveryPoint(String msgVpnName, String restDeliveryPointName, List<String> select) throws ApiException {
    return getMsgVpnRestDeliveryPointWithHttpInfo(msgVpnName, restDeliveryPointName, select).getData();
      }

  /**
   * Get a REST Delivery Point object.
   * Get a REST Delivery Point object.  A REST Delivery Point manages delivery of messages from queues to a named list of REST Consumers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| restDeliveryPointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param restDeliveryPointName The name of the REST Delivery Point. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnRestDeliveryPointResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnRestDeliveryPointResponse> getMsgVpnRestDeliveryPointWithHttpInfo(String msgVpnName, String restDeliveryPointName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnRestDeliveryPoint");
    }
    
    // verify the required parameter 'restDeliveryPointName' is set
    if (restDeliveryPointName == null) {
      throw new ApiException(400, "Missing the required parameter 'restDeliveryPointName' when calling getMsgVpnRestDeliveryPoint");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/restDeliveryPoints/{restDeliveryPointName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "restDeliveryPointName" + "\\}", apiClient.escapeString(restDeliveryPointName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnRestDeliveryPointResponse> localVarReturnType = new GenericType<MsgVpnRestDeliveryPointResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a REST Consumer object.
   * Get a REST Consumer object.  REST Consumer objects establish HTTP connectivity to REST consumer applications who wish to receive messages from a broker.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| restConsumerName|x| restDeliveryPointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param restDeliveryPointName The name of the REST Delivery Point. (required)
   * @param restConsumerName The name of the REST Consumer. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnRestDeliveryPointRestConsumerResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnRestDeliveryPointRestConsumerResponse getMsgVpnRestDeliveryPointRestConsumer(String msgVpnName, String restDeliveryPointName, String restConsumerName, List<String> select) throws ApiException {
    return getMsgVpnRestDeliveryPointRestConsumerWithHttpInfo(msgVpnName, restDeliveryPointName, restConsumerName, select).getData();
      }

  /**
   * Get a REST Consumer object.
   * Get a REST Consumer object.  REST Consumer objects establish HTTP connectivity to REST consumer applications who wish to receive messages from a broker.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| restConsumerName|x| restDeliveryPointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param restDeliveryPointName The name of the REST Delivery Point. (required)
   * @param restConsumerName The name of the REST Consumer. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnRestDeliveryPointRestConsumerResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnRestDeliveryPointRestConsumerResponse> getMsgVpnRestDeliveryPointRestConsumerWithHttpInfo(String msgVpnName, String restDeliveryPointName, String restConsumerName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnRestDeliveryPointRestConsumer");
    }
    
    // verify the required parameter 'restDeliveryPointName' is set
    if (restDeliveryPointName == null) {
      throw new ApiException(400, "Missing the required parameter 'restDeliveryPointName' when calling getMsgVpnRestDeliveryPointRestConsumer");
    }
    
    // verify the required parameter 'restConsumerName' is set
    if (restConsumerName == null) {
      throw new ApiException(400, "Missing the required parameter 'restConsumerName' when calling getMsgVpnRestDeliveryPointRestConsumer");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/restDeliveryPoints/{restDeliveryPointName}/restConsumers/{restConsumerName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "restDeliveryPointName" + "\\}", apiClient.escapeString(restDeliveryPointName.toString()))
      .replaceAll("\\{" + "restConsumerName" + "\\}", apiClient.escapeString(restConsumerName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnRestDeliveryPointRestConsumerResponse> localVarReturnType = new GenericType<MsgVpnRestDeliveryPointRestConsumerResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of REST Consumer objects.
   * Get a list of REST Consumer objects.  REST Consumer objects establish HTTP connectivity to REST consumer applications who wish to receive messages from a broker.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| restConsumerName|x| restDeliveryPointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param restDeliveryPointName The name of the REST Delivery Point. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnRestDeliveryPointRestConsumersResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnRestDeliveryPointRestConsumersResponse getMsgVpnRestDeliveryPointRestConsumers(String msgVpnName, String restDeliveryPointName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnRestDeliveryPointRestConsumersWithHttpInfo(msgVpnName, restDeliveryPointName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of REST Consumer objects.
   * Get a list of REST Consumer objects.  REST Consumer objects establish HTTP connectivity to REST consumer applications who wish to receive messages from a broker.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| restConsumerName|x| restDeliveryPointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param restDeliveryPointName The name of the REST Delivery Point. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnRestDeliveryPointRestConsumersResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnRestDeliveryPointRestConsumersResponse> getMsgVpnRestDeliveryPointRestConsumersWithHttpInfo(String msgVpnName, String restDeliveryPointName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnRestDeliveryPointRestConsumers");
    }
    
    // verify the required parameter 'restDeliveryPointName' is set
    if (restDeliveryPointName == null) {
      throw new ApiException(400, "Missing the required parameter 'restDeliveryPointName' when calling getMsgVpnRestDeliveryPointRestConsumers");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/restDeliveryPoints/{restDeliveryPointName}/restConsumers"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "restDeliveryPointName" + "\\}", apiClient.escapeString(restDeliveryPointName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnRestDeliveryPointRestConsumersResponse> localVarReturnType = new GenericType<MsgVpnRestDeliveryPointRestConsumersResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of REST Delivery Point objects.
   * Get a list of REST Delivery Point objects.  A REST Delivery Point manages delivery of messages from queues to a named list of REST Consumers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| restDeliveryPointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnRestDeliveryPointsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnRestDeliveryPointsResponse getMsgVpnRestDeliveryPoints(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnRestDeliveryPointsWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of REST Delivery Point objects.
   * Get a list of REST Delivery Point objects.  A REST Delivery Point manages delivery of messages from queues to a named list of REST Consumers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| restDeliveryPointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnRestDeliveryPointsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnRestDeliveryPointsResponse> getMsgVpnRestDeliveryPointsWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnRestDeliveryPoints");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/restDeliveryPoints"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnRestDeliveryPointsResponse> localVarReturnType = new GenericType<MsgVpnRestDeliveryPointsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Topic Endpoint object.
   * Get a Topic Endpoint object.  A Topic Endpoint attracts messages published to a topic for which the Topic Endpoint has a matching topic subscription. The topic subscription for the Topic Endpoint is specified in the client request to bind a Flow to that Topic Endpoint. Queues are significantly more flexible than Topic Endpoints and are the recommended approach for most applications. The use of Topic Endpoints should be restricted to JMS applications.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| topicEndpointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTopicEndpointResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTopicEndpointResponse getMsgVpnTopicEndpoint(String msgVpnName, String topicEndpointName, List<String> select) throws ApiException {
    return getMsgVpnTopicEndpointWithHttpInfo(msgVpnName, topicEndpointName, select).getData();
      }

  /**
   * Get a Topic Endpoint object.
   * Get a Topic Endpoint object.  A Topic Endpoint attracts messages published to a topic for which the Topic Endpoint has a matching topic subscription. The topic subscription for the Topic Endpoint is specified in the client request to bind a Flow to that Topic Endpoint. Queues are significantly more flexible than Topic Endpoints and are the recommended approach for most applications. The use of Topic Endpoints should be restricted to JMS applications.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| topicEndpointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTopicEndpointResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTopicEndpointResponse> getMsgVpnTopicEndpointWithHttpInfo(String msgVpnName, String topicEndpointName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTopicEndpoint");
    }
    
    // verify the required parameter 'topicEndpointName' is set
    if (topicEndpointName == null) {
      throw new ApiException(400, "Missing the required parameter 'topicEndpointName' when calling getMsgVpnTopicEndpoint");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/topicEndpoints/{topicEndpointName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "topicEndpointName" + "\\}", apiClient.escapeString(topicEndpointName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTopicEndpointResponse> localVarReturnType = new GenericType<MsgVpnTopicEndpointResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Topic Endpoint Message object.
   * Get a Topic Endpoint Message object.  A Topic Endpoint Message is a packet of information sent from producers to consumers using the Topic Endpoint.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| topicEndpointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTopicEndpointMsgResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTopicEndpointMsgResponse getMsgVpnTopicEndpointMsg(String msgVpnName, String topicEndpointName, String msgId, List<String> select) throws ApiException {
    return getMsgVpnTopicEndpointMsgWithHttpInfo(msgVpnName, topicEndpointName, msgId, select).getData();
      }

  /**
   * Get a Topic Endpoint Message object.
   * Get a Topic Endpoint Message object.  A Topic Endpoint Message is a packet of information sent from producers to consumers using the Topic Endpoint.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| topicEndpointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTopicEndpointMsgResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTopicEndpointMsgResponse> getMsgVpnTopicEndpointMsgWithHttpInfo(String msgVpnName, String topicEndpointName, String msgId, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTopicEndpointMsg");
    }
    
    // verify the required parameter 'topicEndpointName' is set
    if (topicEndpointName == null) {
      throw new ApiException(400, "Missing the required parameter 'topicEndpointName' when calling getMsgVpnTopicEndpointMsg");
    }
    
    // verify the required parameter 'msgId' is set
    if (msgId == null) {
      throw new ApiException(400, "Missing the required parameter 'msgId' when calling getMsgVpnTopicEndpointMsg");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/topicEndpoints/{topicEndpointName}/msgs/{msgId}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "topicEndpointName" + "\\}", apiClient.escapeString(topicEndpointName.toString()))
      .replaceAll("\\{" + "msgId" + "\\}", apiClient.escapeString(msgId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTopicEndpointMsgResponse> localVarReturnType = new GenericType<MsgVpnTopicEndpointMsgResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Topic Endpoint Message objects.
   * Get a list of Topic Endpoint Message objects.  A Topic Endpoint Message is a packet of information sent from producers to consumers using the Topic Endpoint.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| topicEndpointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTopicEndpointMsgsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTopicEndpointMsgsResponse getMsgVpnTopicEndpointMsgs(String msgVpnName, String topicEndpointName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnTopicEndpointMsgsWithHttpInfo(msgVpnName, topicEndpointName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Topic Endpoint Message objects.
   * Get a list of Topic Endpoint Message objects.  A Topic Endpoint Message is a packet of information sent from producers to consumers using the Topic Endpoint.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| topicEndpointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointName The name of the Topic Endpoint. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTopicEndpointMsgsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTopicEndpointMsgsResponse> getMsgVpnTopicEndpointMsgsWithHttpInfo(String msgVpnName, String topicEndpointName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTopicEndpointMsgs");
    }
    
    // verify the required parameter 'topicEndpointName' is set
    if (topicEndpointName == null) {
      throw new ApiException(400, "Missing the required parameter 'topicEndpointName' when calling getMsgVpnTopicEndpointMsgs");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/topicEndpoints/{topicEndpointName}/msgs"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "topicEndpointName" + "\\}", apiClient.escapeString(topicEndpointName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTopicEndpointMsgsResponse> localVarReturnType = new GenericType<MsgVpnTopicEndpointMsgsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Topic Endpoint objects.
   * Get a list of Topic Endpoint objects.  A Topic Endpoint attracts messages published to a topic for which the Topic Endpoint has a matching topic subscription. The topic subscription for the Topic Endpoint is specified in the client request to bind a Flow to that Topic Endpoint. Queues are significantly more flexible than Topic Endpoints and are the recommended approach for most applications. The use of Topic Endpoints should be restricted to JMS applications.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| topicEndpointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTopicEndpointsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTopicEndpointsResponse getMsgVpnTopicEndpoints(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnTopicEndpointsWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Topic Endpoint objects.
   * Get a list of Topic Endpoint objects.  A Topic Endpoint attracts messages published to a topic for which the Topic Endpoint has a matching topic subscription. The topic subscription for the Topic Endpoint is specified in the client request to bind a Flow to that Topic Endpoint. Queues are significantly more flexible than Topic Endpoints and are the recommended approach for most applications. The use of Topic Endpoints should be restricted to JMS applications.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| topicEndpointName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTopicEndpointsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTopicEndpointsResponse> getMsgVpnTopicEndpointsWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTopicEndpoints");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/topicEndpoints"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTopicEndpointsResponse> localVarReturnType = new GenericType<MsgVpnTopicEndpointsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Replicated Local Transaction or XA Transaction object.
   * Get a Replicated Local Transaction or XA Transaction object.  Transactions can be used to group a set of Guaranteed messages to be published or consumed or both as an atomic unit of work.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTransactionResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTransactionResponse getMsgVpnTransaction(String msgVpnName, String xid, List<String> select) throws ApiException {
    return getMsgVpnTransactionWithHttpInfo(msgVpnName, xid, select).getData();
      }

  /**
   * Get a Replicated Local Transaction or XA Transaction object.
   * Get a Replicated Local Transaction or XA Transaction object.  Transactions can be used to group a set of Guaranteed messages to be published or consumed or both as an atomic unit of work.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTransactionResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTransactionResponse> getMsgVpnTransactionWithHttpInfo(String msgVpnName, String xid, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTransaction");
    }
    
    // verify the required parameter 'xid' is set
    if (xid == null) {
      throw new ApiException(400, "Missing the required parameter 'xid' when calling getMsgVpnTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/transactions/{xid}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "xid" + "\\}", apiClient.escapeString(xid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTransactionResponse> localVarReturnType = new GenericType<MsgVpnTransactionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Replicated Local Transaction or XA Transaction objects.
   * Get a list of Replicated Local Transaction or XA Transaction objects.  Transactions can be used to group a set of Guaranteed messages to be published or consumed or both as an atomic unit of work.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTransactionsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTransactionsResponse getMsgVpnTransactions(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnTransactionsWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Replicated Local Transaction or XA Transaction objects.
   * Get a list of Replicated Local Transaction or XA Transaction objects.  Transactions can be used to group a set of Guaranteed messages to be published or consumed or both as an atomic unit of work.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTransactionsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTransactionsResponse> getMsgVpnTransactionsWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTransactions");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/transactions"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTransactionsResponse> localVarReturnType = new GenericType<MsgVpnTransactionsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Message VPN objects.
   * Get a list of Message VPN objects.  Message VPNs (Virtual Private Networks) allow for the segregation of topic space and clients. They also group clients connecting to a network of message brokers, such that messages published within a particular group are only visible to that group&#39;s clients.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnsResponse getMsgVpns(Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnsWithHttpInfo(count, cursor, where, select).getData();
      }

  /**
   * Get a list of Message VPN objects.
   * Get a list of Message VPN objects.  Message VPNs (Virtual Private Networks) allow for the segregation of topic space and clients. They also group clients connecting to a network of message brokers, such that messages published within a particular group are only visible to that group&#39;s clients.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.11.
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnsResponse> getMsgVpnsWithHttpInfo(Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/msgVpns";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnsResponse> localVarReturnType = new GenericType<MsgVpnsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
