package com.solace.semp.v2.action.api;

import com.solace.semp.v2.action.ApiException;
import com.solace.semp.v2.action.ApiClient;
import com.solace.semp.v2.action.ApiResponse;
import com.solace.semp.v2.action.Configuration;
import com.solace.semp.v2.action.Pair;

import javax.ws.rs.core.GenericType;

import com.solace.semp.v2.action.model.MsgVpnAuthenticationOauthProviderClearStats;
import com.solace.semp.v2.action.model.MsgVpnAuthenticationOauthProviderResponse;
import com.solace.semp.v2.action.model.MsgVpnAuthenticationOauthProvidersResponse;
import com.solace.semp.v2.action.model.SempMetaOnlyResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class AuthenticationOauthProviderApi {
  private ApiClient apiClient;

  public AuthenticationOauthProviderApi() {
    this(Configuration.getDefaultApiClient());
  }

  public AuthenticationOauthProviderApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Clear the statistics for the OAuth Provider.
   * Clear the statistics for the OAuth Provider.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse doMsgVpnAuthenticationOauthProviderClearStats(String msgVpnName, String oauthProviderName, MsgVpnAuthenticationOauthProviderClearStats body) throws ApiException {
    return doMsgVpnAuthenticationOauthProviderClearStatsWithHttpInfo(msgVpnName, oauthProviderName, body).getData();
      }

  /**
   * Clear the statistics for the OAuth Provider.
   * Clear the statistics for the OAuth Provider.    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param body The Clear Stats action&#39;s attributes. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> doMsgVpnAuthenticationOauthProviderClearStatsWithHttpInfo(String msgVpnName, String oauthProviderName, MsgVpnAuthenticationOauthProviderClearStats body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling doMsgVpnAuthenticationOauthProviderClearStats");
    }
    
    // verify the required parameter 'oauthProviderName' is set
    if (oauthProviderName == null) {
      throw new ApiException(400, "Missing the required parameter 'oauthProviderName' when calling doMsgVpnAuthenticationOauthProviderClearStats");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling doMsgVpnAuthenticationOauthProviderClearStats");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders/{oauthProviderName}/clearStats"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "oauthProviderName" + "\\}", apiClient.escapeString(oauthProviderName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get an OAuth Provider object.
   * Get an OAuth Provider object.  OAuth providers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| oauthProviderName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnAuthenticationOauthProviderResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnAuthenticationOauthProviderResponse getMsgVpnAuthenticationOauthProvider(String msgVpnName, String oauthProviderName, List<String> select) throws ApiException {
    return getMsgVpnAuthenticationOauthProviderWithHttpInfo(msgVpnName, oauthProviderName, select).getData();
      }

  /**
   * Get an OAuth Provider object.
   * Get an OAuth Provider object.  OAuth providers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| oauthProviderName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnAuthenticationOauthProviderResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnAuthenticationOauthProviderResponse> getMsgVpnAuthenticationOauthProviderWithHttpInfo(String msgVpnName, String oauthProviderName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnAuthenticationOauthProvider");
    }
    
    // verify the required parameter 'oauthProviderName' is set
    if (oauthProviderName == null) {
      throw new ApiException(400, "Missing the required parameter 'oauthProviderName' when calling getMsgVpnAuthenticationOauthProvider");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders/{oauthProviderName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "oauthProviderName" + "\\}", apiClient.escapeString(oauthProviderName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnAuthenticationOauthProviderResponse> localVarReturnType = new GenericType<MsgVpnAuthenticationOauthProviderResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of OAuth Provider objects.
   * Get a list of OAuth Provider objects.  OAuth providers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| oauthProviderName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnAuthenticationOauthProvidersResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnAuthenticationOauthProvidersResponse getMsgVpnAuthenticationOauthProviders(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnAuthenticationOauthProvidersWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of OAuth Provider objects.
   * Get a list of OAuth Provider objects.  OAuth providers.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| oauthProviderName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnAuthenticationOauthProvidersResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnAuthenticationOauthProvidersResponse> getMsgVpnAuthenticationOauthProvidersWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnAuthenticationOauthProviders");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnAuthenticationOauthProvidersResponse> localVarReturnType = new GenericType<MsgVpnAuthenticationOauthProvidersResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
