package com.solace.semp.v2.config.api;

import com.solace.semp.v2.config.ApiException;
import com.solace.semp.v2.config.ApiClient;
import com.solace.semp.v2.config.ApiResponse;
import com.solace.semp.v2.config.Configuration;
import com.solace.semp.v2.config.Pair;

import javax.ws.rs.core.GenericType;

import com.solace.semp.v2.config.model.MsgVpnAuthenticationOauthProvider;
import com.solace.semp.v2.config.model.MsgVpnAuthenticationOauthProviderResponse;
import com.solace.semp.v2.config.model.MsgVpnAuthenticationOauthProvidersResponse;
import com.solace.semp.v2.config.model.SempMetaOnlyResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class AuthenticationOauthProviderApi {
  private ApiClient apiClient;

  public AuthenticationOauthProviderApi() {
    this(Configuration.getDefaultApiClient());
  }

  public AuthenticationOauthProviderApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Create an OAuth Provider object.
   * Create an OAuth Provider object. Any attribute missing from the request will be set to its default value.  OAuth providers.   Attribute|Identifying|Required|Read-Only|Write-Only|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x||x|| oauthProviderName|x|x||| tokenIntrospectionPassword||||x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The OAuth Provider object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnAuthenticationOauthProviderResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnAuthenticationOauthProviderResponse createMsgVpnAuthenticationOauthProvider(String msgVpnName, MsgVpnAuthenticationOauthProvider body, List<String> select) throws ApiException {
    return createMsgVpnAuthenticationOauthProviderWithHttpInfo(msgVpnName, body, select).getData();
      }

  /**
   * Create an OAuth Provider object.
   * Create an OAuth Provider object. Any attribute missing from the request will be set to its default value.  OAuth providers.   Attribute|Identifying|Required|Read-Only|Write-Only|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x||x|| oauthProviderName|x|x||| tokenIntrospectionPassword||||x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The OAuth Provider object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnAuthenticationOauthProviderResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnAuthenticationOauthProviderResponse> createMsgVpnAuthenticationOauthProviderWithHttpInfo(String msgVpnName, MsgVpnAuthenticationOauthProvider body, List<String> select) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling createMsgVpnAuthenticationOauthProvider");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling createMsgVpnAuthenticationOauthProvider");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnAuthenticationOauthProviderResponse> localVarReturnType = new GenericType<MsgVpnAuthenticationOauthProviderResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Delete an OAuth Provider object.
   * Delete an OAuth Provider object.  OAuth providers.  A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse deleteMsgVpnAuthenticationOauthProvider(String msgVpnName, String oauthProviderName) throws ApiException {
    return deleteMsgVpnAuthenticationOauthProviderWithHttpInfo(msgVpnName, oauthProviderName).getData();
      }

  /**
   * Delete an OAuth Provider object.
   * Delete an OAuth Provider object.  OAuth providers.  A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> deleteMsgVpnAuthenticationOauthProviderWithHttpInfo(String msgVpnName, String oauthProviderName) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling deleteMsgVpnAuthenticationOauthProvider");
    }
    
    // verify the required parameter 'oauthProviderName' is set
    if (oauthProviderName == null) {
      throw new ApiException(400, "Missing the required parameter 'oauthProviderName' when calling deleteMsgVpnAuthenticationOauthProvider");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders/{oauthProviderName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "oauthProviderName" + "\\}", apiClient.escapeString(oauthProviderName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get an OAuth Provider object.
   * Get an OAuth Provider object.  OAuth providers.   Attribute|Identifying|Write-Only|Deprecated :---|:---:|:---:|:---: msgVpnName|x|| oauthProviderName|x|| tokenIntrospectionPassword||x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnAuthenticationOauthProviderResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnAuthenticationOauthProviderResponse getMsgVpnAuthenticationOauthProvider(String msgVpnName, String oauthProviderName, List<String> select) throws ApiException {
    return getMsgVpnAuthenticationOauthProviderWithHttpInfo(msgVpnName, oauthProviderName, select).getData();
      }

  /**
   * Get an OAuth Provider object.
   * Get an OAuth Provider object.  OAuth providers.   Attribute|Identifying|Write-Only|Deprecated :---|:---:|:---:|:---: msgVpnName|x|| oauthProviderName|x|| tokenIntrospectionPassword||x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnAuthenticationOauthProviderResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnAuthenticationOauthProviderResponse> getMsgVpnAuthenticationOauthProviderWithHttpInfo(String msgVpnName, String oauthProviderName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnAuthenticationOauthProvider");
    }
    
    // verify the required parameter 'oauthProviderName' is set
    if (oauthProviderName == null) {
      throw new ApiException(400, "Missing the required parameter 'oauthProviderName' when calling getMsgVpnAuthenticationOauthProvider");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders/{oauthProviderName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "oauthProviderName" + "\\}", apiClient.escapeString(oauthProviderName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnAuthenticationOauthProviderResponse> localVarReturnType = new GenericType<MsgVpnAuthenticationOauthProviderResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of OAuth Provider objects.
   * Get a list of OAuth Provider objects.  OAuth providers.   Attribute|Identifying|Write-Only|Deprecated :---|:---:|:---:|:---: msgVpnName|x|| oauthProviderName|x|| tokenIntrospectionPassword||x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnAuthenticationOauthProvidersResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnAuthenticationOauthProvidersResponse getMsgVpnAuthenticationOauthProviders(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnAuthenticationOauthProvidersWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of OAuth Provider objects.
   * Get a list of OAuth Provider objects.  OAuth providers.   Attribute|Identifying|Write-Only|Deprecated :---|:---:|:---:|:---: msgVpnName|x|| oauthProviderName|x|| tokenIntrospectionPassword||x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnAuthenticationOauthProvidersResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnAuthenticationOauthProvidersResponse> getMsgVpnAuthenticationOauthProvidersWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnAuthenticationOauthProviders");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnAuthenticationOauthProvidersResponse> localVarReturnType = new GenericType<MsgVpnAuthenticationOauthProvidersResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Replace an OAuth Provider object.
   * Replace an OAuth Provider object. Any attribute missing from the request will be set to its default value, unless the user is not authorized to change its value or the attribute is write-only, in which case the missing attribute will be left unchanged.  OAuth providers.   Attribute|Identifying|Read-Only|Write-Only|Requires-Disable|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x|x||| oauthProviderName|x|x||| tokenIntrospectionPassword|||x||    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param body The OAuth Provider object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnAuthenticationOauthProviderResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnAuthenticationOauthProviderResponse replaceMsgVpnAuthenticationOauthProvider(String msgVpnName, String oauthProviderName, MsgVpnAuthenticationOauthProvider body, List<String> select) throws ApiException {
    return replaceMsgVpnAuthenticationOauthProviderWithHttpInfo(msgVpnName, oauthProviderName, body, select).getData();
      }

  /**
   * Replace an OAuth Provider object.
   * Replace an OAuth Provider object. Any attribute missing from the request will be set to its default value, unless the user is not authorized to change its value or the attribute is write-only, in which case the missing attribute will be left unchanged.  OAuth providers.   Attribute|Identifying|Read-Only|Write-Only|Requires-Disable|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x|x||| oauthProviderName|x|x||| tokenIntrospectionPassword|||x||    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param body The OAuth Provider object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnAuthenticationOauthProviderResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnAuthenticationOauthProviderResponse> replaceMsgVpnAuthenticationOauthProviderWithHttpInfo(String msgVpnName, String oauthProviderName, MsgVpnAuthenticationOauthProvider body, List<String> select) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling replaceMsgVpnAuthenticationOauthProvider");
    }
    
    // verify the required parameter 'oauthProviderName' is set
    if (oauthProviderName == null) {
      throw new ApiException(400, "Missing the required parameter 'oauthProviderName' when calling replaceMsgVpnAuthenticationOauthProvider");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling replaceMsgVpnAuthenticationOauthProvider");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders/{oauthProviderName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "oauthProviderName" + "\\}", apiClient.escapeString(oauthProviderName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnAuthenticationOauthProviderResponse> localVarReturnType = new GenericType<MsgVpnAuthenticationOauthProviderResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update an OAuth Provider object.
   * Update an OAuth Provider object. Any attribute missing from the request will be left unchanged.  OAuth providers.   Attribute|Identifying|Read-Only|Write-Only|Requires-Disable|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x|x||| oauthProviderName|x|x||| tokenIntrospectionPassword|||x||    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param body The OAuth Provider object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnAuthenticationOauthProviderResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnAuthenticationOauthProviderResponse updateMsgVpnAuthenticationOauthProvider(String msgVpnName, String oauthProviderName, MsgVpnAuthenticationOauthProvider body, List<String> select) throws ApiException {
    return updateMsgVpnAuthenticationOauthProviderWithHttpInfo(msgVpnName, oauthProviderName, body, select).getData();
      }

  /**
   * Update an OAuth Provider object.
   * Update an OAuth Provider object. Any attribute missing from the request will be left unchanged.  OAuth providers.   Attribute|Identifying|Read-Only|Write-Only|Requires-Disable|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x|x||| oauthProviderName|x|x||| tokenIntrospectionPassword|||x||    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.13.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param oauthProviderName The name of the OAuth Provider. (required)
   * @param body The OAuth Provider object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnAuthenticationOauthProviderResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnAuthenticationOauthProviderResponse> updateMsgVpnAuthenticationOauthProviderWithHttpInfo(String msgVpnName, String oauthProviderName, MsgVpnAuthenticationOauthProvider body, List<String> select) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling updateMsgVpnAuthenticationOauthProvider");
    }
    
    // verify the required parameter 'oauthProviderName' is set
    if (oauthProviderName == null) {
      throw new ApiException(400, "Missing the required parameter 'oauthProviderName' when calling updateMsgVpnAuthenticationOauthProvider");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling updateMsgVpnAuthenticationOauthProvider");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/authenticationOauthProviders/{oauthProviderName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "oauthProviderName" + "\\}", apiClient.escapeString(oauthProviderName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnAuthenticationOauthProviderResponse> localVarReturnType = new GenericType<MsgVpnAuthenticationOauthProviderResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
