package com.solace.semp.v2.config.api;

import com.solace.semp.v2.config.ApiException;
import com.solace.semp.v2.config.ApiClient;
import com.solace.semp.v2.config.ApiResponse;
import com.solace.semp.v2.config.Configuration;
import com.solace.semp.v2.config.Pair;

import javax.ws.rs.core.GenericType;

import com.solace.semp.v2.config.model.MsgVpnQueueTemplate;
import com.solace.semp.v2.config.model.MsgVpnQueueTemplateResponse;
import com.solace.semp.v2.config.model.MsgVpnQueueTemplatesResponse;
import com.solace.semp.v2.config.model.SempMetaOnlyResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class QueueTemplateApi {
  private ApiClient apiClient;

  public QueueTemplateApi() {
    this(Configuration.getDefaultApiClient());
  }

  public QueueTemplateApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Create a Queue Template object.
   * Create a Queue Template object. Any attribute missing from the request will be set to its default value.  A Queue Template provides a mechanism for specifying the initial state for client created queues.   Attribute|Identifying|Required|Read-Only|Write-Only|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x||x|| queueTemplateName|x|x|||    The following attributes in the request may only be provided in certain combinations with other attributes:   Class|Attribute|Requires|Conflicts :---|:---|:---|:--- EventThreshold|clearPercent|setPercent|clearValue, setValue EventThreshold|clearValue|setValue|clearPercent, setPercent EventThreshold|setPercent|clearPercent|clearValue, setValue EventThreshold|setValue|clearValue|clearPercent, setPercent    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The Queue Template object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnQueueTemplateResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnQueueTemplateResponse createMsgVpnQueueTemplate(String msgVpnName, MsgVpnQueueTemplate body, List<String> select) throws ApiException {
    return createMsgVpnQueueTemplateWithHttpInfo(msgVpnName, body, select).getData();
      }

  /**
   * Create a Queue Template object.
   * Create a Queue Template object. Any attribute missing from the request will be set to its default value.  A Queue Template provides a mechanism for specifying the initial state for client created queues.   Attribute|Identifying|Required|Read-Only|Write-Only|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x||x|| queueTemplateName|x|x|||    The following attributes in the request may only be provided in certain combinations with other attributes:   Class|Attribute|Requires|Conflicts :---|:---|:---|:--- EventThreshold|clearPercent|setPercent|clearValue, setValue EventThreshold|clearValue|setValue|clearPercent, setPercent EventThreshold|setPercent|clearPercent|clearValue, setValue EventThreshold|setValue|clearValue|clearPercent, setPercent    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param body The Queue Template object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnQueueTemplateResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnQueueTemplateResponse> createMsgVpnQueueTemplateWithHttpInfo(String msgVpnName, MsgVpnQueueTemplate body, List<String> select) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling createMsgVpnQueueTemplate");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling createMsgVpnQueueTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queueTemplates"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnQueueTemplateResponse> localVarReturnType = new GenericType<MsgVpnQueueTemplateResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Delete a Queue Template object.
   * Delete a Queue Template object.  A Queue Template provides a mechanism for specifying the initial state for client created queues.  A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueTemplateName The name of the Queue Template. (required)
   * @return SempMetaOnlyResponse
   * @throws ApiException if fails to make API call
   */
  public SempMetaOnlyResponse deleteMsgVpnQueueTemplate(String msgVpnName, String queueTemplateName) throws ApiException {
    return deleteMsgVpnQueueTemplateWithHttpInfo(msgVpnName, queueTemplateName).getData();
      }

  /**
   * Delete a Queue Template object.
   * Delete a Queue Template object.  A Queue Template provides a mechanism for specifying the initial state for client created queues.  A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueTemplateName The name of the Queue Template. (required)
   * @return ApiResponse&lt;SempMetaOnlyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<SempMetaOnlyResponse> deleteMsgVpnQueueTemplateWithHttpInfo(String msgVpnName, String queueTemplateName) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling deleteMsgVpnQueueTemplate");
    }
    
    // verify the required parameter 'queueTemplateName' is set
    if (queueTemplateName == null) {
      throw new ApiException(400, "Missing the required parameter 'queueTemplateName' when calling deleteMsgVpnQueueTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queueTemplates/{queueTemplateName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "queueTemplateName" + "\\}", apiClient.escapeString(queueTemplateName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<SempMetaOnlyResponse> localVarReturnType = new GenericType<SempMetaOnlyResponse>() {};
    return apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Queue Template object.
   * Get a Queue Template object.  A Queue Template provides a mechanism for specifying the initial state for client created queues.   Attribute|Identifying|Write-Only|Deprecated :---|:---:|:---:|:---: msgVpnName|x|| queueTemplateName|x||    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueTemplateName The name of the Queue Template. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnQueueTemplateResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnQueueTemplateResponse getMsgVpnQueueTemplate(String msgVpnName, String queueTemplateName, List<String> select) throws ApiException {
    return getMsgVpnQueueTemplateWithHttpInfo(msgVpnName, queueTemplateName, select).getData();
      }

  /**
   * Get a Queue Template object.
   * Get a Queue Template object.  A Queue Template provides a mechanism for specifying the initial state for client created queues.   Attribute|Identifying|Write-Only|Deprecated :---|:---:|:---:|:---: msgVpnName|x|| queueTemplateName|x||    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueTemplateName The name of the Queue Template. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnQueueTemplateResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnQueueTemplateResponse> getMsgVpnQueueTemplateWithHttpInfo(String msgVpnName, String queueTemplateName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnQueueTemplate");
    }
    
    // verify the required parameter 'queueTemplateName' is set
    if (queueTemplateName == null) {
      throw new ApiException(400, "Missing the required parameter 'queueTemplateName' when calling getMsgVpnQueueTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queueTemplates/{queueTemplateName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "queueTemplateName" + "\\}", apiClient.escapeString(queueTemplateName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnQueueTemplateResponse> localVarReturnType = new GenericType<MsgVpnQueueTemplateResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Queue Template objects.
   * Get a list of Queue Template objects.  A Queue Template provides a mechanism for specifying the initial state for client created queues.   Attribute|Identifying|Write-Only|Deprecated :---|:---:|:---:|:---: msgVpnName|x|| queueTemplateName|x||    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnQueueTemplatesResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnQueueTemplatesResponse getMsgVpnQueueTemplates(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnQueueTemplatesWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Queue Template objects.
   * Get a list of Queue Template objects.  A Queue Template provides a mechanism for specifying the initial state for client created queues.   Attribute|Identifying|Write-Only|Deprecated :---|:---:|:---:|:---: msgVpnName|x|| queueTemplateName|x||    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnQueueTemplatesResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnQueueTemplatesResponse> getMsgVpnQueueTemplatesWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnQueueTemplates");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queueTemplates"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnQueueTemplatesResponse> localVarReturnType = new GenericType<MsgVpnQueueTemplatesResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Replace a Queue Template object.
   * Replace a Queue Template object. Any attribute missing from the request will be set to its default value, unless the user is not authorized to change its value or the attribute is write-only, in which case the missing attribute will be left unchanged.  A Queue Template provides a mechanism for specifying the initial state for client created queues.   Attribute|Identifying|Read-Only|Write-Only|Requires-Disable|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x|x||| queueTemplateName|x|x|||    The following attributes in the request may only be provided in certain combinations with other attributes:   Class|Attribute|Requires|Conflicts :---|:---|:---|:--- EventThreshold|clearPercent|setPercent|clearValue, setValue EventThreshold|clearValue|setValue|clearPercent, setPercent EventThreshold|setPercent|clearPercent|clearValue, setValue EventThreshold|setValue|clearValue|clearPercent, setPercent    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueTemplateName The name of the Queue Template. (required)
   * @param body The Queue Template object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnQueueTemplateResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnQueueTemplateResponse replaceMsgVpnQueueTemplate(String msgVpnName, String queueTemplateName, MsgVpnQueueTemplate body, List<String> select) throws ApiException {
    return replaceMsgVpnQueueTemplateWithHttpInfo(msgVpnName, queueTemplateName, body, select).getData();
      }

  /**
   * Replace a Queue Template object.
   * Replace a Queue Template object. Any attribute missing from the request will be set to its default value, unless the user is not authorized to change its value or the attribute is write-only, in which case the missing attribute will be left unchanged.  A Queue Template provides a mechanism for specifying the initial state for client created queues.   Attribute|Identifying|Read-Only|Write-Only|Requires-Disable|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x|x||| queueTemplateName|x|x|||    The following attributes in the request may only be provided in certain combinations with other attributes:   Class|Attribute|Requires|Conflicts :---|:---|:---|:--- EventThreshold|clearPercent|setPercent|clearValue, setValue EventThreshold|clearValue|setValue|clearPercent, setPercent EventThreshold|setPercent|clearPercent|clearValue, setValue EventThreshold|setValue|clearValue|clearPercent, setPercent    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueTemplateName The name of the Queue Template. (required)
   * @param body The Queue Template object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnQueueTemplateResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnQueueTemplateResponse> replaceMsgVpnQueueTemplateWithHttpInfo(String msgVpnName, String queueTemplateName, MsgVpnQueueTemplate body, List<String> select) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling replaceMsgVpnQueueTemplate");
    }
    
    // verify the required parameter 'queueTemplateName' is set
    if (queueTemplateName == null) {
      throw new ApiException(400, "Missing the required parameter 'queueTemplateName' when calling replaceMsgVpnQueueTemplate");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling replaceMsgVpnQueueTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queueTemplates/{queueTemplateName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "queueTemplateName" + "\\}", apiClient.escapeString(queueTemplateName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnQueueTemplateResponse> localVarReturnType = new GenericType<MsgVpnQueueTemplateResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update a Queue Template object.
   * Update a Queue Template object. Any attribute missing from the request will be left unchanged.  A Queue Template provides a mechanism for specifying the initial state for client created queues.   Attribute|Identifying|Read-Only|Write-Only|Requires-Disable|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x|x||| queueTemplateName|x|x|||    The following attributes in the request may only be provided in certain combinations with other attributes:   Class|Attribute|Requires|Conflicts :---|:---|:---|:--- EventThreshold|clearPercent|setPercent|clearValue, setValue EventThreshold|clearValue|setValue|clearPercent, setPercent EventThreshold|setPercent|clearPercent|clearValue, setValue EventThreshold|setValue|clearValue|clearPercent, setPercent    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueTemplateName The name of the Queue Template. (required)
   * @param body The Queue Template object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnQueueTemplateResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnQueueTemplateResponse updateMsgVpnQueueTemplate(String msgVpnName, String queueTemplateName, MsgVpnQueueTemplate body, List<String> select) throws ApiException {
    return updateMsgVpnQueueTemplateWithHttpInfo(msgVpnName, queueTemplateName, body, select).getData();
      }

  /**
   * Update a Queue Template object.
   * Update a Queue Template object. Any attribute missing from the request will be left unchanged.  A Queue Template provides a mechanism for specifying the initial state for client created queues.   Attribute|Identifying|Read-Only|Write-Only|Requires-Disable|Deprecated :---|:---:|:---:|:---:|:---:|:---: msgVpnName|x|x||| queueTemplateName|x|x|||    The following attributes in the request may only be provided in certain combinations with other attributes:   Class|Attribute|Requires|Conflicts :---|:---|:---|:--- EventThreshold|clearPercent|setPercent|clearValue, setValue EventThreshold|clearValue|setValue|clearPercent, setPercent EventThreshold|setPercent|clearPercent|clearValue, setValue EventThreshold|setValue|clearValue|clearPercent, setPercent    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-write\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param queueTemplateName The name of the Queue Template. (required)
   * @param body The Queue Template object&#39;s attributes. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnQueueTemplateResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnQueueTemplateResponse> updateMsgVpnQueueTemplateWithHttpInfo(String msgVpnName, String queueTemplateName, MsgVpnQueueTemplate body, List<String> select) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling updateMsgVpnQueueTemplate");
    }
    
    // verify the required parameter 'queueTemplateName' is set
    if (queueTemplateName == null) {
      throw new ApiException(400, "Missing the required parameter 'queueTemplateName' when calling updateMsgVpnQueueTemplate");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling updateMsgVpnQueueTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/queueTemplates/{queueTemplateName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "queueTemplateName" + "\\}", apiClient.escapeString(queueTemplateName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnQueueTemplateResponse> localVarReturnType = new GenericType<MsgVpnQueueTemplateResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
