package com.solace.semp.v2.monitor.api;

import com.solace.semp.v2.monitor.ApiException;
import com.solace.semp.v2.monitor.ApiClient;
import com.solace.semp.v2.monitor.ApiResponse;
import com.solace.semp.v2.monitor.Configuration;
import com.solace.semp.v2.monitor.Pair;

import javax.ws.rs.core.GenericType;

import com.solace.semp.v2.monitor.model.MsgVpnClientConnectionResponse;
import com.solace.semp.v2.monitor.model.MsgVpnClientConnectionsResponse;
import com.solace.semp.v2.monitor.model.MsgVpnClientResponse;
import com.solace.semp.v2.monitor.model.MsgVpnClientRxFlowResponse;
import com.solace.semp.v2.monitor.model.MsgVpnClientRxFlowsResponse;
import com.solace.semp.v2.monitor.model.MsgVpnClientSubscriptionResponse;
import com.solace.semp.v2.monitor.model.MsgVpnClientSubscriptionsResponse;
import com.solace.semp.v2.monitor.model.MsgVpnClientTransactedSessionResponse;
import com.solace.semp.v2.monitor.model.MsgVpnClientTransactedSessionsResponse;
import com.solace.semp.v2.monitor.model.MsgVpnClientTxFlowResponse;
import com.solace.semp.v2.monitor.model.MsgVpnClientTxFlowsResponse;
import com.solace.semp.v2.monitor.model.MsgVpnClientsResponse;
import com.solace.semp.v2.monitor.model.SempMetaOnlyResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class ClientApi {
  private ApiClient apiClient;

  public ClientApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ClientApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get a Client object.
   * Get a Client object.  Applications or devices that connect to message brokers to send and/or receive messages are represented as Clients.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientResponse getMsgVpnClient(String msgVpnName, String clientName, List<String> select) throws ApiException {
    return getMsgVpnClientWithHttpInfo(msgVpnName, clientName, select).getData();
      }

  /**
   * Get a Client object.
   * Get a Client object.  Applications or devices that connect to message brokers to send and/or receive messages are represented as Clients.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientResponse> getMsgVpnClientWithHttpInfo(String msgVpnName, String clientName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClient");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClient");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientResponse> localVarReturnType = new GenericType<MsgVpnClientResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Client Connection object.
   * Get a Client Connection object.  A Client Connection represents the Transmission Control Protocol (TCP) connection the Client uses to communicate with the message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientAddress|x| clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param clientAddress The IP address and TCP port on the Client side of the Client Connection. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientConnectionResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientConnectionResponse getMsgVpnClientConnection(String msgVpnName, String clientName, String clientAddress, List<String> select) throws ApiException {
    return getMsgVpnClientConnectionWithHttpInfo(msgVpnName, clientName, clientAddress, select).getData();
      }

  /**
   * Get a Client Connection object.
   * Get a Client Connection object.  A Client Connection represents the Transmission Control Protocol (TCP) connection the Client uses to communicate with the message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientAddress|x| clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param clientAddress The IP address and TCP port on the Client side of the Client Connection. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientConnectionResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientConnectionResponse> getMsgVpnClientConnectionWithHttpInfo(String msgVpnName, String clientName, String clientAddress, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientConnection");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientConnection");
    }
    
    // verify the required parameter 'clientAddress' is set
    if (clientAddress == null) {
      throw new ApiException(400, "Missing the required parameter 'clientAddress' when calling getMsgVpnClientConnection");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/connections/{clientAddress}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()))
      .replaceAll("\\{" + "clientAddress" + "\\}", apiClient.escapeString(clientAddress.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientConnectionResponse> localVarReturnType = new GenericType<MsgVpnClientConnectionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Client Connection objects.
   * Get a list of Client Connection objects.  A Client Connection represents the Transmission Control Protocol (TCP) connection the Client uses to communicate with the message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientAddress|x| clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientConnectionsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientConnectionsResponse getMsgVpnClientConnections(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnClientConnectionsWithHttpInfo(msgVpnName, clientName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Client Connection objects.
   * Get a list of Client Connection objects.  A Client Connection represents the Transmission Control Protocol (TCP) connection the Client uses to communicate with the message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientAddress|x| clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientConnectionsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientConnectionsResponse> getMsgVpnClientConnectionsWithHttpInfo(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientConnections");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientConnections");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/connections"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientConnectionsResponse> localVarReturnType = new GenericType<MsgVpnClientConnectionsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Client Receive Flow object.
   * Get a Client Receive Flow object.  Client Receive Flows are used by clients to publish Guaranteed messages to a message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| flowId|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param flowId The identifier (ID) of the flow. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientRxFlowResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientRxFlowResponse getMsgVpnClientRxFlow(String msgVpnName, String clientName, String flowId, List<String> select) throws ApiException {
    return getMsgVpnClientRxFlowWithHttpInfo(msgVpnName, clientName, flowId, select).getData();
      }

  /**
   * Get a Client Receive Flow object.
   * Get a Client Receive Flow object.  Client Receive Flows are used by clients to publish Guaranteed messages to a message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| flowId|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param flowId The identifier (ID) of the flow. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientRxFlowResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientRxFlowResponse> getMsgVpnClientRxFlowWithHttpInfo(String msgVpnName, String clientName, String flowId, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientRxFlow");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientRxFlow");
    }
    
    // verify the required parameter 'flowId' is set
    if (flowId == null) {
      throw new ApiException(400, "Missing the required parameter 'flowId' when calling getMsgVpnClientRxFlow");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/rxFlows/{flowId}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()))
      .replaceAll("\\{" + "flowId" + "\\}", apiClient.escapeString(flowId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientRxFlowResponse> localVarReturnType = new GenericType<MsgVpnClientRxFlowResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Client Receive Flow objects.
   * Get a list of Client Receive Flow objects.  Client Receive Flows are used by clients to publish Guaranteed messages to a message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| flowId|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientRxFlowsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientRxFlowsResponse getMsgVpnClientRxFlows(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnClientRxFlowsWithHttpInfo(msgVpnName, clientName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Client Receive Flow objects.
   * Get a list of Client Receive Flow objects.  Client Receive Flows are used by clients to publish Guaranteed messages to a message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| flowId|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientRxFlowsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientRxFlowsResponse> getMsgVpnClientRxFlowsWithHttpInfo(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientRxFlows");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientRxFlows");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/rxFlows"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientRxFlowsResponse> localVarReturnType = new GenericType<MsgVpnClientRxFlowsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Client Subscription object.
   * Get a Client Subscription object.  Once clients are authenticated on the message broker they can add and remove Client Subscriptions for Direct messages published to the Message VPN to which they have connected.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| subscriptionTopic|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param subscriptionTopic The topic of the Subscription. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientSubscriptionResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientSubscriptionResponse getMsgVpnClientSubscription(String msgVpnName, String clientName, String subscriptionTopic, List<String> select) throws ApiException {
    return getMsgVpnClientSubscriptionWithHttpInfo(msgVpnName, clientName, subscriptionTopic, select).getData();
      }

  /**
   * Get a Client Subscription object.
   * Get a Client Subscription object.  Once clients are authenticated on the message broker they can add and remove Client Subscriptions for Direct messages published to the Message VPN to which they have connected.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| subscriptionTopic|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param subscriptionTopic The topic of the Subscription. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientSubscriptionResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientSubscriptionResponse> getMsgVpnClientSubscriptionWithHttpInfo(String msgVpnName, String clientName, String subscriptionTopic, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientSubscription");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientSubscription");
    }
    
    // verify the required parameter 'subscriptionTopic' is set
    if (subscriptionTopic == null) {
      throw new ApiException(400, "Missing the required parameter 'subscriptionTopic' when calling getMsgVpnClientSubscription");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/subscriptions/{subscriptionTopic}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()))
      .replaceAll("\\{" + "subscriptionTopic" + "\\}", apiClient.escapeString(subscriptionTopic.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientSubscriptionResponse> localVarReturnType = new GenericType<MsgVpnClientSubscriptionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Client Subscription objects.
   * Get a list of Client Subscription objects.  Once clients are authenticated on the message broker they can add and remove Client Subscriptions for Direct messages published to the Message VPN to which they have connected.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| subscriptionTopic|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientSubscriptionsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientSubscriptionsResponse getMsgVpnClientSubscriptions(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnClientSubscriptionsWithHttpInfo(msgVpnName, clientName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Client Subscription objects.
   * Get a list of Client Subscription objects.  Once clients are authenticated on the message broker they can add and remove Client Subscriptions for Direct messages published to the Message VPN to which they have connected.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| subscriptionTopic|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientSubscriptionsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientSubscriptionsResponse> getMsgVpnClientSubscriptionsWithHttpInfo(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientSubscriptions");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientSubscriptions");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/subscriptions"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientSubscriptionsResponse> localVarReturnType = new GenericType<MsgVpnClientSubscriptionsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Client Transacted Session object.
   * Get a Client Transacted Session object.  Transacted Sessions enable clients to group multiple message send and/or receive operations together in single, atomic units known as local transactions.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| sessionName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param sessionName The name of the Transacted Session. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientTransactedSessionResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientTransactedSessionResponse getMsgVpnClientTransactedSession(String msgVpnName, String clientName, String sessionName, List<String> select) throws ApiException {
    return getMsgVpnClientTransactedSessionWithHttpInfo(msgVpnName, clientName, sessionName, select).getData();
      }

  /**
   * Get a Client Transacted Session object.
   * Get a Client Transacted Session object.  Transacted Sessions enable clients to group multiple message send and/or receive operations together in single, atomic units known as local transactions.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| sessionName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param sessionName The name of the Transacted Session. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientTransactedSessionResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientTransactedSessionResponse> getMsgVpnClientTransactedSessionWithHttpInfo(String msgVpnName, String clientName, String sessionName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientTransactedSession");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientTransactedSession");
    }
    
    // verify the required parameter 'sessionName' is set
    if (sessionName == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionName' when calling getMsgVpnClientTransactedSession");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/transactedSessions/{sessionName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()))
      .replaceAll("\\{" + "sessionName" + "\\}", apiClient.escapeString(sessionName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientTransactedSessionResponse> localVarReturnType = new GenericType<MsgVpnClientTransactedSessionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Client Transacted Session objects.
   * Get a list of Client Transacted Session objects.  Transacted Sessions enable clients to group multiple message send and/or receive operations together in single, atomic units known as local transactions.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| sessionName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientTransactedSessionsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientTransactedSessionsResponse getMsgVpnClientTransactedSessions(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnClientTransactedSessionsWithHttpInfo(msgVpnName, clientName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Client Transacted Session objects.
   * Get a list of Client Transacted Session objects.  Transacted Sessions enable clients to group multiple message send and/or receive operations together in single, atomic units known as local transactions.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x| sessionName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientTransactedSessionsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientTransactedSessionsResponse> getMsgVpnClientTransactedSessionsWithHttpInfo(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientTransactedSessions");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientTransactedSessions");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/transactedSessions"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientTransactedSessionsResponse> localVarReturnType = new GenericType<MsgVpnClientTransactedSessionsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Client Transmit Flow object.
   * Get a Client Transmit Flow object.  Client Transmit Flows are used by clients to consume Guaranteed messages from a message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| flowId|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param flowId The identifier (ID) of the flow. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientTxFlowResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientTxFlowResponse getMsgVpnClientTxFlow(String msgVpnName, String clientName, String flowId, List<String> select) throws ApiException {
    return getMsgVpnClientTxFlowWithHttpInfo(msgVpnName, clientName, flowId, select).getData();
      }

  /**
   * Get a Client Transmit Flow object.
   * Get a Client Transmit Flow object.  Client Transmit Flows are used by clients to consume Guaranteed messages from a message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| flowId|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param flowId The identifier (ID) of the flow. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientTxFlowResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientTxFlowResponse> getMsgVpnClientTxFlowWithHttpInfo(String msgVpnName, String clientName, String flowId, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientTxFlow");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientTxFlow");
    }
    
    // verify the required parameter 'flowId' is set
    if (flowId == null) {
      throw new ApiException(400, "Missing the required parameter 'flowId' when calling getMsgVpnClientTxFlow");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/txFlows/{flowId}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()))
      .replaceAll("\\{" + "flowId" + "\\}", apiClient.escapeString(flowId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientTxFlowResponse> localVarReturnType = new GenericType<MsgVpnClientTxFlowResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Client Transmit Flow objects.
   * Get a list of Client Transmit Flow objects.  Client Transmit Flows are used by clients to consume Guaranteed messages from a message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| flowId|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientTxFlowsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientTxFlowsResponse getMsgVpnClientTxFlows(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnClientTxFlowsWithHttpInfo(msgVpnName, clientName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Client Transmit Flow objects.
   * Get a list of Client Transmit Flow objects.  Client Transmit Flows are used by clients to consume Guaranteed messages from a message broker.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| flowId|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param clientName The name of the Client. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientTxFlowsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientTxFlowsResponse> getMsgVpnClientTxFlowsWithHttpInfo(String msgVpnName, String clientName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClientTxFlows");
    }
    
    // verify the required parameter 'clientName' is set
    if (clientName == null) {
      throw new ApiException(400, "Missing the required parameter 'clientName' when calling getMsgVpnClientTxFlows");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients/{clientName}/txFlows"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "clientName" + "\\}", apiClient.escapeString(clientName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientTxFlowsResponse> localVarReturnType = new GenericType<MsgVpnClientTxFlowsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Client objects.
   * Get a list of Client objects.  Applications or devices that connect to message brokers to send and/or receive messages are represented as Clients.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnClientsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnClientsResponse getMsgVpnClients(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnClientsWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Client objects.
   * Get a list of Client objects.  Applications or devices that connect to message brokers to send and/or receive messages are represented as Clients.   Attribute|Identifying|Deprecated :---|:---:|:---: clientName|x| msgVpnName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnClientsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnClientsResponse> getMsgVpnClientsWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnClients");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/clients"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnClientsResponse> localVarReturnType = new GenericType<MsgVpnClientsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
