package com.solace.semp.v2.monitor.api;

import com.solace.semp.v2.monitor.ApiException;
import com.solace.semp.v2.monitor.ApiClient;
import com.solace.semp.v2.monitor.ApiResponse;
import com.solace.semp.v2.monitor.Configuration;
import com.solace.semp.v2.monitor.Pair;

import javax.ws.rs.core.GenericType;

import com.solace.semp.v2.monitor.model.MsgVpnTopicEndpointTemplateResponse;
import com.solace.semp.v2.monitor.model.MsgVpnTopicEndpointTemplatesResponse;
import com.solace.semp.v2.monitor.model.SempMetaOnlyResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class TopicEndpointTemplateApi {
  private ApiClient apiClient;

  public TopicEndpointTemplateApi() {
    this(Configuration.getDefaultApiClient());
  }

  public TopicEndpointTemplateApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get a Topic Endpoint Template object.
   * Get a Topic Endpoint Template object.  A Topic Endpoint Template provides a mechanism for specifying the initial state for client created topic endpoints.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| topicEndpointTemplateName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointTemplateName The name of the Topic Endpoint Template. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTopicEndpointTemplateResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTopicEndpointTemplateResponse getMsgVpnTopicEndpointTemplate(String msgVpnName, String topicEndpointTemplateName, List<String> select) throws ApiException {
    return getMsgVpnTopicEndpointTemplateWithHttpInfo(msgVpnName, topicEndpointTemplateName, select).getData();
      }

  /**
   * Get a Topic Endpoint Template object.
   * Get a Topic Endpoint Template object.  A Topic Endpoint Template provides a mechanism for specifying the initial state for client created topic endpoints.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| topicEndpointTemplateName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param topicEndpointTemplateName The name of the Topic Endpoint Template. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTopicEndpointTemplateResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTopicEndpointTemplateResponse> getMsgVpnTopicEndpointTemplateWithHttpInfo(String msgVpnName, String topicEndpointTemplateName, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTopicEndpointTemplate");
    }
    
    // verify the required parameter 'topicEndpointTemplateName' is set
    if (topicEndpointTemplateName == null) {
      throw new ApiException(400, "Missing the required parameter 'topicEndpointTemplateName' when calling getMsgVpnTopicEndpointTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/topicEndpointTemplates/{topicEndpointTemplateName}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "topicEndpointTemplateName" + "\\}", apiClient.escapeString(topicEndpointTemplateName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTopicEndpointTemplateResponse> localVarReturnType = new GenericType<MsgVpnTopicEndpointTemplateResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Topic Endpoint Template objects.
   * Get a list of Topic Endpoint Template objects.  A Topic Endpoint Template provides a mechanism for specifying the initial state for client created topic endpoints.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| topicEndpointTemplateName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTopicEndpointTemplatesResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTopicEndpointTemplatesResponse getMsgVpnTopicEndpointTemplates(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnTopicEndpointTemplatesWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Topic Endpoint Template objects.
   * Get a list of Topic Endpoint Template objects.  A Topic Endpoint Template provides a mechanism for specifying the initial state for client created topic endpoints.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| topicEndpointTemplateName|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.14.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTopicEndpointTemplatesResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTopicEndpointTemplatesResponse> getMsgVpnTopicEndpointTemplatesWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTopicEndpointTemplates");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/topicEndpointTemplates"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTopicEndpointTemplatesResponse> localVarReturnType = new GenericType<MsgVpnTopicEndpointTemplatesResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
