package com.solace.semp.v2.monitor.api;

import com.solace.semp.v2.monitor.ApiException;
import com.solace.semp.v2.monitor.ApiClient;
import com.solace.semp.v2.monitor.ApiResponse;
import com.solace.semp.v2.monitor.Configuration;
import com.solace.semp.v2.monitor.Pair;

import javax.ws.rs.core.GenericType;

import com.solace.semp.v2.monitor.model.MsgVpnTransactionConsumerMsgResponse;
import com.solace.semp.v2.monitor.model.MsgVpnTransactionConsumerMsgsResponse;
import com.solace.semp.v2.monitor.model.MsgVpnTransactionPublisherMsgResponse;
import com.solace.semp.v2.monitor.model.MsgVpnTransactionPublisherMsgsResponse;
import com.solace.semp.v2.monitor.model.MsgVpnTransactionResponse;
import com.solace.semp.v2.monitor.model.MsgVpnTransactionsResponse;
import com.solace.semp.v2.monitor.model.SempMetaOnlyResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class TransactionApi {
  private ApiClient apiClient;

  public TransactionApi() {
    this(Configuration.getDefaultApiClient());
  }

  public TransactionApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get a Replicated Local Transaction or XA Transaction object.
   * Get a Replicated Local Transaction or XA Transaction object.  Transactions can be used to group a set of Guaranteed messages to be published or consumed or both as an atomic unit of work.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTransactionResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTransactionResponse getMsgVpnTransaction(String msgVpnName, String xid, List<String> select) throws ApiException {
    return getMsgVpnTransactionWithHttpInfo(msgVpnName, xid, select).getData();
      }

  /**
   * Get a Replicated Local Transaction or XA Transaction object.
   * Get a Replicated Local Transaction or XA Transaction object.  Transactions can be used to group a set of Guaranteed messages to be published or consumed or both as an atomic unit of work.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTransactionResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTransactionResponse> getMsgVpnTransactionWithHttpInfo(String msgVpnName, String xid, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTransaction");
    }
    
    // verify the required parameter 'xid' is set
    if (xid == null) {
      throw new ApiException(400, "Missing the required parameter 'xid' when calling getMsgVpnTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/transactions/{xid}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "xid" + "\\}", apiClient.escapeString(xid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTransactionResponse> localVarReturnType = new GenericType<MsgVpnTransactionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Transaction Consumer Message object.
   * Get a Transaction Consumer Message object.  A Transaction Consumer Message is a message that will be consumed as part of this Transaction once the Transaction is committed.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTransactionConsumerMsgResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTransactionConsumerMsgResponse getMsgVpnTransactionConsumerMsg(String msgVpnName, String xid, String msgId, List<String> select) throws ApiException {
    return getMsgVpnTransactionConsumerMsgWithHttpInfo(msgVpnName, xid, msgId, select).getData();
      }

  /**
   * Get a Transaction Consumer Message object.
   * Get a Transaction Consumer Message object.  A Transaction Consumer Message is a message that will be consumed as part of this Transaction once the Transaction is committed.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTransactionConsumerMsgResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTransactionConsumerMsgResponse> getMsgVpnTransactionConsumerMsgWithHttpInfo(String msgVpnName, String xid, String msgId, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTransactionConsumerMsg");
    }
    
    // verify the required parameter 'xid' is set
    if (xid == null) {
      throw new ApiException(400, "Missing the required parameter 'xid' when calling getMsgVpnTransactionConsumerMsg");
    }
    
    // verify the required parameter 'msgId' is set
    if (msgId == null) {
      throw new ApiException(400, "Missing the required parameter 'msgId' when calling getMsgVpnTransactionConsumerMsg");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/transactions/{xid}/consumerMsgs/{msgId}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "xid" + "\\}", apiClient.escapeString(xid.toString()))
      .replaceAll("\\{" + "msgId" + "\\}", apiClient.escapeString(msgId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTransactionConsumerMsgResponse> localVarReturnType = new GenericType<MsgVpnTransactionConsumerMsgResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Transaction Consumer Message objects.
   * Get a list of Transaction Consumer Message objects.  A Transaction Consumer Message is a message that will be consumed as part of this Transaction once the Transaction is committed.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTransactionConsumerMsgsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTransactionConsumerMsgsResponse getMsgVpnTransactionConsumerMsgs(String msgVpnName, String xid, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnTransactionConsumerMsgsWithHttpInfo(msgVpnName, xid, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Transaction Consumer Message objects.
   * Get a list of Transaction Consumer Message objects.  A Transaction Consumer Message is a message that will be consumed as part of this Transaction once the Transaction is committed.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTransactionConsumerMsgsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTransactionConsumerMsgsResponse> getMsgVpnTransactionConsumerMsgsWithHttpInfo(String msgVpnName, String xid, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTransactionConsumerMsgs");
    }
    
    // verify the required parameter 'xid' is set
    if (xid == null) {
      throw new ApiException(400, "Missing the required parameter 'xid' when calling getMsgVpnTransactionConsumerMsgs");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/transactions/{xid}/consumerMsgs"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "xid" + "\\}", apiClient.escapeString(xid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTransactionConsumerMsgsResponse> localVarReturnType = new GenericType<MsgVpnTransactionConsumerMsgsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Transaction Publisher Message object.
   * Get a Transaction Publisher Message object.  A Transaction Publisher Message is a message that will be published as part of this Transaction once the Transaction is committed.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTransactionPublisherMsgResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTransactionPublisherMsgResponse getMsgVpnTransactionPublisherMsg(String msgVpnName, String xid, String msgId, List<String> select) throws ApiException {
    return getMsgVpnTransactionPublisherMsgWithHttpInfo(msgVpnName, xid, msgId, select).getData();
      }

  /**
   * Get a Transaction Publisher Message object.
   * Get a Transaction Publisher Message object.  A Transaction Publisher Message is a message that will be published as part of this Transaction once the Transaction is committed.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param msgId The identifier (ID) of the Message. (required)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTransactionPublisherMsgResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTransactionPublisherMsgResponse> getMsgVpnTransactionPublisherMsgWithHttpInfo(String msgVpnName, String xid, String msgId, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTransactionPublisherMsg");
    }
    
    // verify the required parameter 'xid' is set
    if (xid == null) {
      throw new ApiException(400, "Missing the required parameter 'xid' when calling getMsgVpnTransactionPublisherMsg");
    }
    
    // verify the required parameter 'msgId' is set
    if (msgId == null) {
      throw new ApiException(400, "Missing the required parameter 'msgId' when calling getMsgVpnTransactionPublisherMsg");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/transactions/{xid}/publisherMsgs/{msgId}"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "xid" + "\\}", apiClient.escapeString(xid.toString()))
      .replaceAll("\\{" + "msgId" + "\\}", apiClient.escapeString(msgId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTransactionPublisherMsgResponse> localVarReturnType = new GenericType<MsgVpnTransactionPublisherMsgResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Transaction Publisher Message objects.
   * Get a list of Transaction Publisher Message objects.  A Transaction Publisher Message is a message that will be published as part of this Transaction once the Transaction is committed.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTransactionPublisherMsgsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTransactionPublisherMsgsResponse getMsgVpnTransactionPublisherMsgs(String msgVpnName, String xid, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnTransactionPublisherMsgsWithHttpInfo(msgVpnName, xid, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Transaction Publisher Message objects.
   * Get a list of Transaction Publisher Message objects.  A Transaction Publisher Message is a message that will be published as part of this Transaction once the Transaction is committed.   Attribute|Identifying|Deprecated :---|:---:|:---: msgId|x| msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param xid The identifier (ID) of the Transaction. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTransactionPublisherMsgsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTransactionPublisherMsgsResponse> getMsgVpnTransactionPublisherMsgsWithHttpInfo(String msgVpnName, String xid, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTransactionPublisherMsgs");
    }
    
    // verify the required parameter 'xid' is set
    if (xid == null) {
      throw new ApiException(400, "Missing the required parameter 'xid' when calling getMsgVpnTransactionPublisherMsgs");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/transactions/{xid}/publisherMsgs"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()))
      .replaceAll("\\{" + "xid" + "\\}", apiClient.escapeString(xid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTransactionPublisherMsgsResponse> localVarReturnType = new GenericType<MsgVpnTransactionPublisherMsgsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a list of Replicated Local Transaction or XA Transaction objects.
   * Get a list of Replicated Local Transaction or XA Transaction objects.  Transactions can be used to group a set of Guaranteed messages to be published or consumed or both as an atomic unit of work.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return MsgVpnTransactionsResponse
   * @throws ApiException if fails to make API call
   */
  public MsgVpnTransactionsResponse getMsgVpnTransactions(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    return getMsgVpnTransactionsWithHttpInfo(msgVpnName, count, cursor, where, select).getData();
      }

  /**
   * Get a list of Replicated Local Transaction or XA Transaction objects.
   * Get a list of Replicated Local Transaction or XA Transaction objects.  Transactions can be used to group a set of Guaranteed messages to be published or consumed or both as an atomic unit of work.   Attribute|Identifying|Deprecated :---|:---:|:---: msgVpnName|x| xid|x|    A SEMP client authorized with a minimum access scope/level of \&quot;vpn/read-only\&quot; is required to perform this operation.  This has been available since 2.12.
   * @param msgVpnName The name of the Message VPN. (required)
   * @param count Limit the count of objects in the response. See the documentation for the &#x60;count&#x60; parameter. (optional, default to 10)
   * @param cursor The cursor, or position, for the next page of objects. See the documentation for the &#x60;cursor&#x60; parameter. (optional)
   * @param where Include in the response only objects where certain conditions are true. See the the documentation for the &#x60;where&#x60; parameter. (optional)
   * @param select Include in the response only selected attributes of the object, or exclude from the response selected attributes of the object. See the documentation for the &#x60;select&#x60; parameter. (optional)
   * @return ApiResponse&lt;MsgVpnTransactionsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<MsgVpnTransactionsResponse> getMsgVpnTransactionsWithHttpInfo(String msgVpnName, Integer count, String cursor, List<String> where, List<String> select) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'msgVpnName' is set
    if (msgVpnName == null) {
      throw new ApiException(400, "Missing the required parameter 'msgVpnName' when calling getMsgVpnTransactions");
    }
    
    // create path and map variables
    String localVarPath = "/msgVpns/{msgVpnName}/transactions"
      .replaceAll("\\{" + "msgVpnName" + "\\}", apiClient.escapeString(msgVpnName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "cursor", cursor));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "where", where));
    localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "select", select));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "basicAuth" };

    GenericType<MsgVpnTransactionsResponse> localVarReturnType = new GenericType<MsgVpnTransactionsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
