

package com.solace.connector.beam;

import com.solacesystems.jcsmp.JCSMPProperties;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SolaceIO_Read<T> extends SolaceIO.Read<T> {

  private final JCSMPProperties jcsmpProperties;

  private final List<String> queues;

  private final boolean useSenderTimestamp;

  private final int advanceTimeoutInMillis;

  private final long maxNumRecords;

  private final Duration maxReadTime;

  private final SolaceIO.InboundMessageMapper<T> inboundMessageMapper;

  private final Coder<T> coder;

  private AutoValue_SolaceIO_Read(
      JCSMPProperties jcsmpProperties,
      List<String> queues,
      boolean useSenderTimestamp,
      int advanceTimeoutInMillis,
      long maxNumRecords,
      @Nullable Duration maxReadTime,
      SolaceIO.InboundMessageMapper<T> inboundMessageMapper,
      Coder<T> coder) {
    this.jcsmpProperties = jcsmpProperties;
    this.queues = queues;
    this.useSenderTimestamp = useSenderTimestamp;
    this.advanceTimeoutInMillis = advanceTimeoutInMillis;
    this.maxNumRecords = maxNumRecords;
    this.maxReadTime = maxReadTime;
    this.inboundMessageMapper = inboundMessageMapper;
    this.coder = coder;
  }

  @Override
  JCSMPProperties jcsmpProperties() {
    return jcsmpProperties;
  }

  @Override
  List<String> queues() {
    return queues;
  }

  @Override
  boolean useSenderTimestamp() {
    return useSenderTimestamp;
  }

  @Override
  int advanceTimeoutInMillis() {
    return advanceTimeoutInMillis;
  }

  @Override
  long maxNumRecords() {
    return maxNumRecords;
  }

  @Nullable
  @Override
  Duration maxReadTime() {
    return maxReadTime;
  }

  @Override
  SolaceIO.InboundMessageMapper<T> inboundMessageMapper() {
    return inboundMessageMapper;
  }

  @Override
  Coder<T> coder() {
    return coder;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SolaceIO.Read) {
      SolaceIO.Read<?> that = (SolaceIO.Read<?>) o;
      return (this.jcsmpProperties.equals(that.jcsmpProperties()))
           && (this.queues.equals(that.queues()))
           && (this.useSenderTimestamp == that.useSenderTimestamp())
           && (this.advanceTimeoutInMillis == that.advanceTimeoutInMillis())
           && (this.maxNumRecords == that.maxNumRecords())
           && ((this.maxReadTime == null) ? (that.maxReadTime() == null) : this.maxReadTime.equals(that.maxReadTime()))
           && (this.inboundMessageMapper.equals(that.inboundMessageMapper()))
           && (this.coder.equals(that.coder()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= jcsmpProperties.hashCode();
    h$ *= 1000003;
    h$ ^= queues.hashCode();
    h$ *= 1000003;
    h$ ^= useSenderTimestamp ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= advanceTimeoutInMillis;
    h$ *= 1000003;
    h$ ^= (int) ((maxNumRecords >>> 32) ^ maxNumRecords);
    h$ *= 1000003;
    h$ ^= (maxReadTime == null) ? 0 : maxReadTime.hashCode();
    h$ *= 1000003;
    h$ ^= inboundMessageMapper.hashCode();
    h$ *= 1000003;
    h$ ^= coder.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 42L;

  @Override
  SolaceIO.Read.Builder<T> builder() {
    return new Builder<T>(this);
  }

  static final class Builder<T> extends SolaceIO.Read.Builder<T> {
    private JCSMPProperties jcsmpProperties;
    private List<String> queues;
    private Boolean useSenderTimestamp;
    private Integer advanceTimeoutInMillis;
    private Long maxNumRecords;
    private Duration maxReadTime;
    private SolaceIO.InboundMessageMapper<T> inboundMessageMapper;
    private Coder<T> coder;
    Builder() {
    }
    private Builder(SolaceIO.Read<T> source) {
      this.jcsmpProperties = source.jcsmpProperties();
      this.queues = source.queues();
      this.useSenderTimestamp = source.useSenderTimestamp();
      this.advanceTimeoutInMillis = source.advanceTimeoutInMillis();
      this.maxNumRecords = source.maxNumRecords();
      this.maxReadTime = source.maxReadTime();
      this.inboundMessageMapper = source.inboundMessageMapper();
      this.coder = source.coder();
    }
    @Override
    SolaceIO.Read.Builder<T> setJcsmpProperties(JCSMPProperties jcsmpProperties) {
      if (jcsmpProperties == null) {
        throw new NullPointerException("Null jcsmpProperties");
      }
      this.jcsmpProperties = jcsmpProperties;
      return this;
    }
    @Override
    SolaceIO.Read.Builder<T> setQueues(List<String> queues) {
      if (queues == null) {
        throw new NullPointerException("Null queues");
      }
      this.queues = queues;
      return this;
    }
    @Override
    SolaceIO.Read.Builder<T> setUseSenderTimestamp(boolean useSenderTimestamp) {
      this.useSenderTimestamp = useSenderTimestamp;
      return this;
    }
    @Override
    SolaceIO.Read.Builder<T> setAdvanceTimeoutInMillis(int advanceTimeoutInMillis) {
      this.advanceTimeoutInMillis = advanceTimeoutInMillis;
      return this;
    }
    @Override
    SolaceIO.Read.Builder<T> setMaxNumRecords(long maxNumRecords) {
      this.maxNumRecords = maxNumRecords;
      return this;
    }
    @Override
    SolaceIO.Read.Builder<T> setMaxReadTime(Duration maxReadTime) {
      this.maxReadTime = maxReadTime;
      return this;
    }
    @Override
    SolaceIO.Read.Builder<T> setInboundMessageMapper(SolaceIO.InboundMessageMapper<T> inboundMessageMapper) {
      if (inboundMessageMapper == null) {
        throw new NullPointerException("Null inboundMessageMapper");
      }
      this.inboundMessageMapper = inboundMessageMapper;
      return this;
    }
    @Override
    SolaceIO.Read.Builder<T> setCoder(Coder<T> coder) {
      if (coder == null) {
        throw new NullPointerException("Null coder");
      }
      this.coder = coder;
      return this;
    }
    @Override
    SolaceIO.Read<T> autoBuild() {
      String missing = "";
      if (this.jcsmpProperties == null) {
        missing += " jcsmpProperties";
      }
      if (this.queues == null) {
        missing += " queues";
      }
      if (this.useSenderTimestamp == null) {
        missing += " useSenderTimestamp";
      }
      if (this.advanceTimeoutInMillis == null) {
        missing += " advanceTimeoutInMillis";
      }
      if (this.maxNumRecords == null) {
        missing += " maxNumRecords";
      }
      if (this.inboundMessageMapper == null) {
        missing += " inboundMessageMapper";
      }
      if (this.coder == null) {
        missing += " coder";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SolaceIO_Read<T>(
          this.jcsmpProperties,
          this.queues,
          this.useSenderTimestamp,
          this.advanceTimeoutInMillis,
          this.maxNumRecords,
          this.maxReadTime,
          this.inboundMessageMapper,
          this.coder);
    }
  }

}
