/*
 * Decompiled with CFR 0.152.
 */
package com.solace.connector.beam;

import com.google.common.annotations.VisibleForTesting;
import com.solace.connector.beam.UnboundedSolaceReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.UnboundedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
class SolaceCheckpointMark
implements UnboundedSource.CheckpointMark,
Serializable {
    private static final long serialVersionUID = 42L;
    private static final Logger LOG = LoggerFactory.getLogger(SolaceCheckpointMark.class);
    private final transient UUID id = UUID.randomUUID();
    @Nullable
    private transient UnboundedSolaceReader<?> reader;
    private transient String clientName;
    private transient BlockingQueue<UnboundedSolaceReader.Message> ackQueue;

    public SolaceCheckpointMark(UnboundedSolaceReader<?> reader, String clientName, BlockingQueue<UnboundedSolaceReader.Message> ackQueue) {
        this.reader = reader;
        this.clientName = clientName;
        this.ackQueue = ackQueue;
        LOG.debug(String.format("Created %s %s", this.getClass().getSimpleName(), this.id));
    }

    public void finalizeCheckpoint() throws IOException {
        if (this.reader != null) {
            if (!this.reader.active.get()) {
                return;
            }
            LOG.debug(String.format("Started to finalize %s %s", this.getClass().getSimpleName(), this.id));
            int ackListSize = this.ackQueue.size();
            try {
                while (this.ackQueue.size() > 0) {
                    UnboundedSolaceReader.Message msg = this.ackQueue.poll(0L, TimeUnit.NANOSECONDS);
                    if (msg == null) continue;
                    msg.message.ackMessage();
                    this.reader.watermark.updateAndGet(min -> Math.max(message.time.getMillis(), min));
                }
                this.reader.readerStats.incrCheckpointCompleteMessages(Long.valueOf(ackListSize));
            }
            catch (Exception e) {
                LOG.error(String.format("Got exception while acknowledging %s %s: %s", this.getClass().getSimpleName(), this.id, e.toString()), (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    public boolean equals(Object other) {
        if (other instanceof SolaceCheckpointMark) {
            SolaceCheckpointMark that = (SolaceCheckpointMark)other;
            return this.clientName.equals(that.clientName) && this.reader == that.reader;
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this.clientName) * 31 + System.identityHashCode(this.reader);
    }
}

