/*
 * Decompiled with CFR 0.152.
 */
package com.solace.connector.beam;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.solace.connector.beam.AutoValue_SolaceIO_Read;
import com.solace.connector.beam.UnboundedSolaceSource;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPProperties;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SolaceIO {
    private static final int DEFAULT_ADVANCE_TIMEOUT = 500;
    private static final boolean DEFAULT_USE_SENDER_TIMESTAMP = false;

    public static <T> Read<T> read(JCSMPProperties jcsmpProperties, List<String> queues, Coder<T> coder, InboundMessageMapper<T> inboundMessageMapper) {
        return new AutoValue_SolaceIO_Read.Builder().setJcsmpProperties(jcsmpProperties).setQueues(queues).setCoder(coder).setInboundMessageMapper(inboundMessageMapper).setAdvanceTimeoutInMillis(500).setMaxNumRecords(Long.MAX_VALUE).setUseSenderTimestamp(false).build();
    }

    private SolaceIO() {
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        private static final long serialVersionUID = 42L;

        abstract Builder<T> builder();

        abstract JCSMPProperties jcsmpProperties();

        abstract List<String> queues();

        abstract boolean useSenderTimestamp();

        abstract int advanceTimeoutInMillis();

        abstract long maxNumRecords();

        @Nullable
        abstract Duration maxReadTime();

        abstract InboundMessageMapper<T> inboundMessageMapper();

        abstract Coder<T> coder();

        public Read<T> withJcsmpProperties(JCSMPProperties jcsmpProperties) {
            return this.builder().setJcsmpProperties(jcsmpProperties).build();
        }

        public Read<T> withQueues(List<String> queues) {
            return this.builder().setQueues(queues).build();
        }

        public Read<T> withUseSenderTimestamp(boolean useSenderTimestamp) {
            return this.builder().setUseSenderTimestamp(useSenderTimestamp).build();
        }

        public Read<T> withAdvanceTimeoutInMillis(int advanceTimeoutInMillis) {
            return this.builder().setAdvanceTimeoutInMillis(advanceTimeoutInMillis).build();
        }

        public Read<T> withMaxNumRecords(long maxNumRecords) {
            return this.builder().setMaxNumRecords(maxNumRecords).build();
        }

        public Read<T> withMaxReadTime(Duration maxReadTime) {
            return this.builder().setMaxReadTime(maxReadTime).build();
        }

        public Read<T> withInboundMessageMapper(InboundMessageMapper<T> inboundMessageMapper) {
            return this.builder().setInboundMessageMapper(inboundMessageMapper).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            return this.builder().setCoder(coder).build();
        }

        public PCollection<T> expand(PBegin input) {
            Read.Unbounded unbounded;
            this.validateConfig();
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from(new UnboundedSolaceSource(this));
            if (this.maxNumRecords() < Long.MAX_VALUE || this.maxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.maxReadTime()).withMaxNumRecords(this.maxNumRecords());
            }
            return (PCollection)input.getPipeline().apply((PTransform)transform);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"queues", (String)String.join((CharSequence)"\n", this.queues())));
            builder.add(DisplayData.item((String)"useSenderTimestamp", (Boolean)this.useSenderTimestamp()));
            builder.add(DisplayData.item((String)"advanceTimeoutInMillis", (Integer)this.advanceTimeoutInMillis()));
            builder.addIfNotDefault(DisplayData.item((String)"maxNumRecords", (Long)this.maxNumRecords()), (Object)Long.MAX_VALUE);
            builder.addIfNotNull(DisplayData.item((String)"maxReadTime", (Duration)this.maxReadTime()));
            for (String propertyName : this.jcsmpProperties().propertyNames()) {
                Object propertyValue;
                HashSet<String> hiddenProperties = new HashSet<String>();
                hiddenProperties.add("password");
                hiddenProperties.add("SSL_KEY_STORE_PASSWORD");
                hiddenProperties.add("SSL_PRIVATE_KEY_PASSWORD");
                hiddenProperties.add("SSL_TRUST_STORE_PASSWORD");
                if (hiddenProperties.contains(propertyName) || propertyName.toLowerCase().contains("password") || (propertyValue = this.jcsmpProperties().getProperty(propertyName)) == null) continue;
                Optional<DisplayData.Type> type = Optional.ofNullable(DisplayData.inferType((Object)propertyValue));
                if (!type.isPresent()) {
                    type = Optional.of(DisplayData.Type.STRING);
                    propertyValue = propertyValue.toString();
                }
                builder.addIfNotNull(DisplayData.item((String)("jcsmpProperties." + propertyName), (DisplayData.Type)type.get(), (Object)propertyValue));
            }
        }

        private void validateConfig() {
            Preconditions.checkArgument((this.jcsmpProperties() != null ? 1 : 0) != 0, (Object)"jcsmpProperties cannot be null");
            Preconditions.checkArgument((this.jcsmpProperties().getStringProperty("client_name") == null ? 1 : 0) != 0, (Object)String.format("jcmspProperties property %s must be null", "client_name"));
            for (String propertyName : new String[]{"host", "username", "password", "vpn_name"}) {
                Preconditions.checkArgument((this.jcsmpProperties().getStringProperty(propertyName) != null && !this.jcsmpProperties().getStringProperty(propertyName).isEmpty() ? 1 : 0) != 0, (Object)String.format("jcsmpProperties property %s cannot be null", propertyName));
            }
            Preconditions.checkArgument((this.queues() != null && !this.queues().isEmpty() ? 1 : 0) != 0, (Object)"queues cannot be null or empty");
            Preconditions.checkArgument((this.inboundMessageMapper() != null ? 1 : 0) != 0, (Object)"inboundMessageMapper cannot be null");
            Preconditions.checkArgument((this.coder() != null ? 1 : 0) != 0, (Object)"coder cannot be null");
            Preconditions.checkArgument((this.advanceTimeoutInMillis() > 0 ? 1 : 0) != 0, (Object)"advanceTimeoutInMillis must be greater than 0");
            Preconditions.checkArgument((this.maxNumRecords() > 0L ? 1 : 0) != 0, (Object)"maxNumRecords must be greater than 0");
            if (this.maxReadTime() != null) {
                Preconditions.checkArgument((boolean)this.maxReadTime().isLongerThan((ReadableDuration)Duration.ZERO), (Object)"maxReadTime must be greater than 0");
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setJcsmpProperties(JCSMPProperties var1);

            abstract Builder<T> setQueues(List<String> var1);

            abstract Builder<T> setUseSenderTimestamp(boolean var1);

            abstract Builder<T> setAdvanceTimeoutInMillis(int var1);

            abstract Builder<T> setMaxNumRecords(long var1);

            abstract Builder<T> setMaxReadTime(Duration var1);

            abstract Builder<T> setInboundMessageMapper(InboundMessageMapper<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Read<T> autoBuild();

            public Read<T> build() {
                Read<T> read = this.autoBuild();
                ((Read)read).validateConfig();
                return read;
            }
        }
    }

    @FunctionalInterface
    public static interface InboundMessageMapper<T>
    extends Serializable {
        public T map(BytesXMLMessage var1) throws Exception;
    }
}

