/*
 * Decompiled with CFR 0.152.
 */
package com.solace.connector.beam;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
class SolaceReaderStats
implements Serializable {
    private static final long serialVersionUID = 42L;
    private static final Logger LOG = LoggerFactory.getLogger(SolaceReaderStats.class);
    private Long emptyPoll;
    private Long msgRecieved;
    private Instant currentAdvanceTime;
    private Instant currentCheckpointTime;
    private Instant lastReportTime;
    private Long currentBacklogBytes;
    private Long checkpointReadyMessages;
    private Long checkpointCompleteMessages;
    private Long pollFlowRebind;
    private Long messagesRemovedFromCheckpointQueue;
    private Long monitorChecks;
    private Long monitorFlowClose;

    public SolaceReaderStats() {
        this.zeroStats();
    }

    private void zeroStats() {
        this.emptyPoll = 0L;
        this.msgRecieved = 0L;
        this.currentBacklogBytes = 0L;
        this.checkpointReadyMessages = 0L;
        this.checkpointCompleteMessages = 0L;
        this.pollFlowRebind = 0L;
        this.messagesRemovedFromCheckpointQueue = 0L;
        this.monitorChecks = 0L;
        this.monitorFlowClose = 0L;
    }

    public void incrementEmptyPoll() {
        Long l = this.emptyPoll;
        Long l2 = this.emptyPoll = Long.valueOf(this.emptyPoll + 1L);
    }

    public void incrementMessageReceived() {
        Long l = this.msgRecieved;
        Long l2 = this.msgRecieved = Long.valueOf(this.msgRecieved + 1L);
    }

    public void incrementPollFlowRebind() {
        Long l = this.pollFlowRebind;
        Long l2 = this.pollFlowRebind = Long.valueOf(this.pollFlowRebind + 1L);
    }

    public void incrementMessagesRemovedFromCheckpointQueue(long count) {
        this.messagesRemovedFromCheckpointQueue = this.messagesRemovedFromCheckpointQueue + count;
    }

    public void incrementMonitorChecks() {
        Long l = this.monitorChecks;
        Long l2 = this.monitorChecks = Long.valueOf(this.monitorChecks + 1L);
    }

    public void incrementMonitorFlowClose() {
        Long l = this.monitorFlowClose;
        Long l2 = this.monitorFlowClose = Long.valueOf(this.monitorFlowClose + 1L);
    }

    public void setLastReportTime(Instant time) {
        this.lastReportTime = time;
    }

    public Instant getLastReportTime() {
        return this.lastReportTime;
    }

    public void setCurrentAdvanceTime(Instant time) {
        this.currentAdvanceTime = time;
    }

    public void setCurrentCheckpointTime(Instant time) {
        this.currentCheckpointTime = time;
    }

    public void setCurrentBacklog(Long bytes) {
        this.currentBacklogBytes = bytes;
    }

    public void incrCheckpointReadyMessages(Long count) {
        this.checkpointReadyMessages = this.checkpointReadyMessages + count;
    }

    public void incrCheckpointCompleteMessages(Long count) {
        this.checkpointCompleteMessages = this.checkpointCompleteMessages + count;
    }

    public Long getEmptyPoll() {
        return this.emptyPoll;
    }

    public Long getMsgRecieved() {
        return this.msgRecieved;
    }

    public Long getCurrentBacklogBytes() {
        return this.currentBacklogBytes;
    }

    public Long getCheckpointReadyMessages() {
        return this.checkpointReadyMessages;
    }

    public Long getCheckpointCompleteMessages() {
        return this.checkpointCompleteMessages;
    }

    public Long getPollFlowRebind() {
        return this.pollFlowRebind;
    }

    public Long getMessagesRemovedFromCheckpointQueue() {
        return this.messagesRemovedFromCheckpointQueue;
    }

    public Long getMonitorChecks() {
        return this.monitorChecks;
    }

    public Long getMonitorFlowClose() {
        return this.monitorFlowClose;
    }

    public String dumpStatsAndClear(Boolean verbose) {
        String results = this.dumpStats(verbose);
        this.zeroStats();
        return results;
    }

    public String dumpStats(Boolean verbose) {
        String results = "{";
        results = results + "\"queueBacklog\":" + this.currentBacklogBytes + ",";
        results = results + "\"emptyPolls\":" + this.emptyPoll + ",";
        results = results + "\"messagesReceived\":" + this.msgRecieved + ",";
        results = results + "\"messagesCheckpointReady\":" + this.checkpointReadyMessages + ",";
        results = results + "\"messagesCheckpointComplete\":" + this.checkpointCompleteMessages + ",";
        results = results + "\"pollFlowRebind\":" + this.pollFlowRebind + ",";
        results = results + "\"messagesRemovedFromCheckpointQueue\":" + this.messagesRemovedFromCheckpointQueue + ",";
        results = results + "\"monitorChecks\":" + this.monitorChecks + ",";
        results = results + "\"monitorFlowClose\":" + this.monitorFlowClose + "}";
        return results;
    }
}

