/*
 * Decompiled with CFR 0.152.
 */
package com.solace.connector.beam;

import com.google.common.annotations.VisibleForTesting;
import com.solace.connector.beam.SolaceCheckpointMark;
import com.solace.connector.beam.SolaceIO;
import com.solace.connector.beam.UnboundedSolaceReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
class UnboundedSolaceSource<T>
extends UnboundedSource<T, SolaceCheckpointMark> {
    private static final long serialVersionUID = 42L;
    private static final Logger LOG = LoggerFactory.getLogger(UnboundedSolaceSource.class);
    private final SolaceIO.Read<T> spec;
    private String queueName;

    public SolaceIO.Read<T> getSpec() {
        return this.spec;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public UnboundedSolaceSource(SolaceIO.Read<T> spec) {
        this.spec = spec;
    }

    public UnboundedSource.UnboundedReader<T> createReader(PipelineOptions options, @Nullable SolaceCheckpointMark checkpointMark) {
        LOG.debug("createReader() is called.");
        return new UnboundedSolaceReader(this);
    }

    public List<UnboundedSolaceSource<T>> split(int desiredNumSplits, PipelineOptions options) {
        LOG.info("Queue Numbers: {}, desiredNumSplits: {}, PipelineOptions: {}", new Object[]{this.spec.queues().size(), desiredNumSplits, options});
        ArrayList<UnboundedSolaceSource<T>> sourceList = new ArrayList<UnboundedSolaceSource<T>>();
        for (String queueName : this.spec.queues()) {
            UnboundedSolaceSource<T> source = new UnboundedSolaceSource<T>(this.spec);
            source.queueName = queueName;
            sourceList.add(source);
        }
        return sourceList;
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        this.spec.populateDisplayData(builder);
    }

    public Coder<SolaceCheckpointMark> getCheckpointMarkCoder() {
        return SerializableCoder.of(SolaceCheckpointMark.class);
    }

    public Coder<T> getOutputCoder() {
        return this.spec.coder();
    }
}

